package com.digiwin.athena.km_deployer_service.thread;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.digiwin.athena.km_deployer_service.base.SceneType;
import com.digiwin.athena.km_deployer_service.base.SynonymEntityType;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.TenantUser;
import com.digiwin.athena.km_deployer_service.domain.asa.deploy.DeployDetail;
import com.digiwin.athena.km_deployer_service.domain.asa.enent.DeployEvent;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployParam;
import com.digiwin.athena.km_deployer_service.domain.system.AthenaUser;
import com.digiwin.athena.km_deployer_service.helper.AniaHelper;
import com.digiwin.athena.km_deployer_service.helper.AssistantRhApiHelper;
import com.digiwin.athena.km_deployer_service.helper.IMApiHelper;
import com.digiwin.athena.km_deployer_service.service.km.CacheService;
import com.digiwin.athena.km_deployer_service.service.km.TenantService;
import com.digiwin.athena.km_deployer_service.service.page.PageService;
import com.digiwin.athena.km_deployer_service.spi.AtmcService;
import com.digiwin.athena.km_deployer_service.spi.KgService;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.core.MongoTemplate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;


@Slf4j
@Data
public abstract class AbstructVersionThread extends Thread {
    protected static final String MONGODB_NAME_ASA = "asa";

    protected static final String MONGODB_NAME_DATAMAP = "datamap";

    protected static final String MONGODB_NAME_KGSYS = "knowledgegraphSystem";

    protected static final String MONGODB_NAME_DESGINER = "athenadesginer";

    protected static final String MONGODB_NAME_PRESET = "preset";

    protected static final String MONGODB_NAME_AGILEDATA = "designer";

    protected static final Integer ASSISTANT_SUB_TYPE_COMPOSITE = 4;

    protected static final Integer ASSISTANT_SUB_TYPE_BUSINESS = 3;

    protected static final Integer ASSISTANT_SUB_TYPE_KNOWLEDGE = 2;

    protected static final Integer ASSISTANT_SUB_TYPE_DATA = 1;

    protected static final String KNOWLEDGE_TYPE_PRIVATE = "private";

    protected static final String KNOWLEDGE_TYPE_PUBLIC = "public";

    protected static final Integer MODEL_TYPE_LLM = 1;

    protected static final Integer MODEL_TYPE_NLU = 2;

    protected static final Integer MODEL_TYPE_ES = 3;

    protected static final String AI_DEPLOY_MODE_DESIGN = "design";

    protected static final String AI_DEPLOY_MODE_TEST = "test";

    protected static final String AI_DEPLOY_MODE_PROD = "prod";

    protected static final String AI_DEPLOY_MODE_TP = "test&prod";

    protected static final Map<String, List<String>> DB_COLLECTION = new HashMap<>();

    static {
        DB_COLLECTION.put(MONGODB_NAME_ASA, Stream.of(AsaConstant.COLLECTION_NAME_ASSISTANT, AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE, AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE_ITEM_STEP,
                AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_MODEL, AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_PROJECT, AsaConstant.COLLECTION_NAME_ASA_MODEL_CORPUS
        ,AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_URGE).collect(Collectors.toList()));
        DB_COLLECTION.put(MONGODB_NAME_DATAMAP, Stream.of(AsaConstant.COLLECTION_NAME_PROJECT, AsaConstant.COLLECTION_NAME_ACTIVITY, AsaConstant.COLLECTION_NAME_DATASTATE,
                AsaConstant.COLLECTION_NAME_DATADESCRIPTION, AsaConstant.COLLECTION_NAME_DATAFEATURESET, AsaConstant.COLLECTION_NAME_FLOWGRAPH, AsaConstant.COLLECTION_NAME_PAGEVIEW,
                AsaConstant.COLLECTION_NAME_TASK, AsaConstant.COLLECTION_NAME_PAGE_UI_ELEMENT).collect(Collectors.toList()));
        DB_COLLECTION.put(MONGODB_NAME_KGSYS, Stream.of(AsaConstant.COLLECTION_NAME_APPLICATION, AsaConstant.COLLECTION_NAME_APPLICATION_RELATION, AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS,AsaConstant.APPLICATION_CUSTOMIZED_CONFIG).collect(Collectors.toList()));
        DB_COLLECTION.put(MONGODB_NAME_PRESET, Stream.of(AsaConstant.COLLECTION_NAME_TASK_RULES).collect(Collectors.toList()));
        DB_COLLECTION.put(MONGODB_NAME_AGILEDATA, Stream.of(AsaConstant.COLLECTION_NAME_AGILEDATA_SYNONYM).collect(Collectors.toList()));
    }

    protected String deployNo;

    protected long parentThreadId;

    protected String routerKey;

    protected String application;

    protected String assistantCode;

    protected Integer assistatnSubType;

    protected List<JSONObject> assistantSceneList = new ArrayList<>();

    protected List<String> tenantIdList;

    protected AthenaUser currentUser;

    protected String currentTenantId;

    // 是否是C娜部署，同时部署的多个助理，要么都是C娜，要么都是B娜，因此可以用全局变量来定义
    protected boolean isCNaDeploy = false;

    protected boolean isSkipTemplate = false;

    protected boolean isSkipGPT = false;

    protected String datamapDBName;

    protected String kgsysDBName;

    protected String presetDBName;

    protected ApplicationContext applicationContext;

    protected CacheService cacheService;

    protected MongoTemplate mongoTemplate;

    protected MongoTemplate kmMongoTemplate;

    protected MongoTemplate kgsysMongoTemplate;

    protected MongoTemplate presetMongoTemplate;

    protected TenantService tenantService;

    protected PageService pageService;

    protected IMApiHelper imApiHelper;

    protected KgService kgService;

    protected AtmcService atmcService;

    protected AssistantRhApiHelper assistantRhApiHelper;

    protected AniaHelper aniaHelper;

    @Override
    public void run() {

    }

    protected abstract void doAfterDataProcess();

    protected abstract void doProcess4ProdAndAuth();

    protected void iamAuthorizationInSwitch(DeployParam deployParam) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("授权用户..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            List<TenantUser> tenantUserList = deployParam.getTenantUsers();

            if (null != tenantUserList) {
                for (TenantUser tenantUser : tenantUserList) {
                    String tenantId = tenantUser.getTenantId();
                    String curToken = tenantService.getRealTimeTenantToken(tenantId);

                    Integer option = tenantUser.getOption();
                    List<String> userIdList = tenantUser.getUserIdList();
                    if (option == null || option == 1) {
                        List<JSONObject> userJson = tenantService.queryAllUserInTenant(tenantId, curToken);
                        userIdList = getUserIdList(userJson);
                    } else if (option == 3) {
                        userIdList = new ArrayList<>();
                        userIdList.add(tenantUser.getCurrentUserId());
                    }

                    if (userIdList.size() > 500) {
                        Integer size = userIdList.size() / 500;
                        if (userIdList.size() % 500 != 0) {
                            size++;
                        }

                        List<String> batchUserIdList;
                        for (int i = 0; i < size; i++) {
                            if (i != size - 1) {
                                batchUserIdList = userIdList.subList(i * 500, (i + 1) * 500);
                            } else {
                                batchUserIdList = userIdList.subList(i * 500, userIdList.size());
                            }

                            tenantUser.setUserIdList(batchUserIdList);
                            tenantService.grantUserAuth(tenantUser, application, application + "_daplcdp_default", curToken);

                            if (ASSISTANT_SUB_TYPE_KNOWLEDGE.equals(assistatnSubType)) {
                                for (JSONObject assistantScene : assistantSceneList) {
                                    String assistantSceneCode = assistantScene.getString("code");
                                    tenantService.grantUserAuth(tenantUser, assistantSceneCode, assistantSceneCode + "_daplcdp_default", curToken);
                                }
                            } else if (ASSISTANT_SUB_TYPE_COMPOSITE.equals(assistatnSubType)) {
                                for (JSONObject assistantScene : assistantSceneList) {
                                    if (SceneType.KNOWLEDGE.getType().equals(assistantScene.getInteger("type"))
                                            && KNOWLEDGE_TYPE_PUBLIC.equals(Objects.isNull((List<JSONObject>)assistantScene.get("knowledgeBases")) ? "private" : ((List<JSONObject>)assistantScene.get("knowledgeBases")).get(0).getString("type"))) {
                                        String assistantSceneCode = assistantScene.getString("code");
                                        tenantService.grantUserAuth(tenantUser, assistantSceneCode, assistantSceneCode + "_daplcdp_default", curToken);
                                    }
                                }
                            }
                        }
                    } else {
                        tenantUser.setUserIdList(userIdList);
                        tenantService.grantUserAuth(tenantUser, application, application + "_daplcdp_default", curToken);

                        if (ASSISTANT_SUB_TYPE_KNOWLEDGE.equals(assistatnSubType)) {
                            for (JSONObject assistantScene : assistantSceneList) {
                                String assistantSceneCode = assistantScene.getString("code");
                                tenantService.grantUserAuth(tenantUser, assistantSceneCode, assistantSceneCode + "_daplcdp_default", curToken);
                            }
                        } else if (ASSISTANT_SUB_TYPE_COMPOSITE.equals(assistatnSubType)) {
                            for (JSONObject assistantScene : assistantSceneList) {
                                if (SceneType.KNOWLEDGE.getType().equals(assistantScene.getInteger("type"))
                                        && KNOWLEDGE_TYPE_PUBLIC.equals(Objects.isNull((List<JSONObject>)assistantScene.get("knowledgeBases"))? "private" : ((List<JSONObject>)assistantScene.get("knowledgeBases")).get(0).getString("type"))) {
                                    String assistantSceneCode = assistantScene.getString("code");
                                    tenantService.grantUserAuth(tenantUser, assistantSceneCode, assistantSceneCode + "_daplcdp_default", curToken);
                                }
                            }
                        }
                    }
                }
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Grant application auth to tenant user error. ", e);
            this.setWarnDeployDetail(deployDetail, e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    protected void resetCache(String curTenantToken) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("重置KM/ATMC缓存..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            kgService.cacheResetToKm();
            atmcService.cacheResetToAtmc(curTenantToken);
            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Update version 2.0 to 0.0 error. ", e);
            this.setWarnDeployDetail(deployDetail, e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private List<String> getUserIdList(List<JSONObject> userJson) {
        List<String> userIdList = new ArrayList<>();
        userJson.forEach(user -> userIdList.add(user.getString("id")));
        return userIdList;
    }

    protected long calculateExecuteMills(Date time) {
        Date now = new Date();
        return now.getTime() - time.getTime();
    }

    protected void sendDeployDetailMsg(String msg, DeployDetail deployDetail, DeployEvent deployEvent) {
        deployDetail.setContent(msg);
        deployDetail.setTime(new Date());
        deployEvent.setMsg("process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);
    }

    protected void setFailDeployDetail(DeployDetail deployDetail, Exception exception, DeployEvent deployEvent) {
        deployDetail.setResult(AsaConstant.DEPLOY_FAIL);
        deployDetail.setErrorStack(JSON.parseArray(JSON.toJSONString(exception.getStackTrace())));
        deployDetail.setCause(exception.toString());
        deployDetail.setErrorMessage(exception.getMessage());

        deployEvent.setComplete(true);
    }

    protected void setWarnDeployDetail(DeployDetail deployDetail, Exception exception) {
        deployDetail.setResult(AsaConstant.DEPLOY_WARN);
        deployDetail.setErrorStack(JSON.parseArray(JSON.toJSONString(exception.getStackTrace())));
        deployDetail.setCause(exception.toString());
        deployDetail.setErrorMessage(exception.getMessage());
    }

    protected void sendDeployDetailWithExeTime(DeployDetail deployDetail, DeployEvent deployEvent) {
        long mills = calculateExecuteMills(deployDetail.getTime());
        deployDetail.setTime(new Date()).setExecuteTimeMills(mills);
        deployEvent.setMsg("process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);
    }

    protected void sendDeployDetailResult(String result, DeployDetail deployDetail, DeployEvent deployEvent) {
        deployDetail.setResult(result);
        deployEvent.setMsg("process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);
    }

    /**
     * 助理相关缓存【asa项目使用】
     *
     * @param assistantDoc 助理数据
     */
//    public void cacheAssistant(Document assistantDoc) {
//        String accId = assistantDoc.getString("accid");
//        String assistanceCode = assistantDoc.getString("assistantCode");
//        cacheService.set("ASSISTANT", "ASA_ASSISTANT_ACCOUNT_" + assistanceCode, accId);
//        cacheService.set("ASSISTANT", "ASA_ACCOUNT_ASSISTANT_" + accId, assistanceCode);
//        if (isCNaDeploy) {
//            cacheService.set("ASSISTANT", assistantDoc.getString("assistantCode"), JSON.toJSONString(assistantDoc));
//        } else {
//            cacheService.set("ASSISTANT", assistantDoc.getString("version") + assistantDoc.getString("assistantCode"), JSON.toJSONString(assistantDoc));
//        }
//    }

//    public void cacheAssistantAccid () {
//        FindIterable<Document> documents = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(
//                AsaConstant.COLLECTION_NAME_ASSISTANT).find();
//
//        List<String> accidList = new ArrayList<>();
//
//        if (Objects.nonNull(documents)) {
//            for (Document document : documents) {
//                accidList.add(document.getString("accid"));
//            }
//
//            // 缓存所有的助理账号
//            cacheService.set("ASSISTANT", "ALL:ACCID", JSON.toJSONString(accidList));
//            log.info("刷新缓存成功，缓存key:ASSISTANT:ALL:ACCID");
//        }
//    }

    /**
     * mongo
     *
     * @param collection
     * @param templateDocs
     */
    public void mongoInsertMany(String collection, List<Document> templateDocs) {
        if (CollUtil.isNotEmpty(templateDocs)) {
            if (collection.equals(AsaConstant.COLLECTION_NAME_TASK_RULES)) {
                presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(collection).insertMany(templateDocs);
            } else {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(collection).insertMany(templateDocs);
            }
        }
    }

    protected void executeEsDelete(String applicationCode, String entityTypeName, String deployMode, String curTenantToken) {
        JSONObject requestParam = new JSONObject();

        if (SynonymEntityType.TARGET.getName().equals(entityTypeName)) {
            requestParam.put("index_name", "clu_ie_keywords");
        } else {
            requestParam.put("index_name", "clu_ie_app_words");
        }

        requestParam.put("deploy_mode", deployMode);

        List<JSONObject> deleteDatas = new ArrayList<>();
        JSONObject deleteData = new JSONObject();
        deleteData.put("assistant_id", applicationCode);
        deleteDatas.add(deleteData);

        requestParam.put("delete_data", deleteDatas);

        assistantRhApiHelper.writeEsDeleteData(requestParam, curTenantToken);
    }

    protected void executeEsUpsert(String applicationCode, String entityTypeName, List<JSONObject> synonymList, String deployMode, String curTenantToken) {
        JSONObject requestParam = new JSONObject();

        if (SynonymEntityType.TARGET.getName().equals(entityTypeName)) {
            requestParam.put("index_name", "clu_ie_keywords");
        } else {
            requestParam.put("index_name", "clu_ie_app_words");
        }

        requestParam.put("deploy_mode", deployMode);

        List<JSONObject> updateDatas = new ArrayList<>();
        for (JSONObject synonym : synonymList) {
            JSONObject updateData = new JSONObject();
            updateData.put("assistant_id", applicationCode);

            String words = synonym.getString("zh_CN_Str");

            if (SynonymEntityType.TARGET.getName().equals(entityTypeName)) {
                //关键词
                updateData.put("intent", synonym.getString("properNoun"));
                updateData.put("keyword", Arrays.asList(words.split("/")));
            } else {
                //同义词
                updateData.put("standard_name", synonym.getString("properNoun"));
                updateData.put("synonyms", Arrays.asList(words.split("/")));
            }

            updateData.put("description", synonym.getString("description"));
            updateData.put("entity_type", SynonymEntityType.TARGET.getName().equals(entityTypeName) ? SynonymEntityType.TARGET.getName() : SynonymEntityType.DIMENSION.getName());

            updateDatas.add(updateData);
        }
        requestParam.put("upsert_data", updateDatas);

        assistantRhApiHelper.writeEsUpdateData(requestParam, curTenantToken);
    }
}
