package com.digiwin.athena.km_deployer_service.thread;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.base.AbilityEnum;
import com.digiwin.athena.km_deployer_service.base.SceneType;
import com.digiwin.athena.km_deployer_service.base.SynonymEntityType;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.deploy.DeployDetail;
import com.digiwin.athena.km_deployer_service.domain.asa.deploy.DeployProcess;
import com.digiwin.athena.km_deployer_service.domain.asa.enent.DeployEvent;
import com.digiwin.athena.km_deployer_service.domain.asa.model.CollectionModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.AssistantModelCorpus;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.AssistantProjectModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployVersionParam;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.povo.asa.BasicInfoDto;
import com.digiwin.athena.km_deployer_service.service.appEntity.AppEntityService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.template.ITemplate;
import static com.digiwin.athena.km_deployer_service.template.ITemplate.ASSISTANT_SCENE_TEMPLATE;
import com.digiwin.athena.km_deployer_service.template.model.IGenerateModel;
import com.digiwin.athena.km_deployer_service.util.CurThreadInfoUtils;
import com.digiwin.athena.km_deployer_service.util.IdSnowflake;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 部署线程
 */
@Slf4j
@Data
public class DeployThread extends AbstructVersionThread {
    private static final List<String> ANALYZE_MONGODB_LIST = new ArrayList<>();

    static {
        ANALYZE_MONGODB_LIST.add(MONGODB_NAME_ASA);
        ANALYZE_MONGODB_LIST.add(MONGODB_NAME_KGSYS);
        ANALYZE_MONGODB_LIST.add(MONGODB_NAME_AGILEDATA);
    }

    private static final List<String> ANALYZE_COLLECTION_LIST = new ArrayList<>();

    static {
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_ACTIVITY);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_DATASTATE);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_DATADESCRIPTION);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_DATAFEATURESET);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_FLOWGRAPH);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_PAGEVIEW);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_TASK);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_APPLICATION);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_PROJECT);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_MODEL);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_ASA_MODEL_CORPUS);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_PAGE_UI_ELEMENT);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_TASK_RULES);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_AGILEDATA_SYNONYM);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.APPLICATION_CUSTOMIZED_CONFIG);
        ANALYZE_COLLECTION_LIST.add(AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_URGE);
    }

    private static final List<String> ANALYZE_NEO4J_NODE_LIST = new ArrayList<>();

    static {
        ANALYZE_NEO4J_NODE_LIST.add(AsaConstant.NEO4J_NODE_ACTIVITY);
    }


    /**
     * 场景的步骤节点类型：结束节点
     */
    private static final String STEP_TYPE_END = "end";

    private static final String PARTITION = "DEPLOY_PROCESS";

    private static final String FILE_FOLDER_CYPHER = "cypher";

    private DeployVersionParam deployVersionParam;

    private String compileZipPath;

    private String compileDataPath;

    private DmcService dmcService;

    private AppEntityService appEntityService;

    private Map<String, ITemplate> templateMap;

    private JSONObject compiledData;

    private String assistantName;

    private String curTenantToken;

    private JSONObject originalCodeRelationShip = new JSONObject();

    public DeployThread(DeployVersionParam deployVersionParam) {
        this.deployVersionParam = deployVersionParam;
        this.parentThreadId = deployVersionParam.getThreadId();
        this.deployNo = deployVersionParam.getDeployNo();
    }

    @Override
    public void run() {
        CurThreadInfoUtils.setRouterKey(routerKey);

        //查询编译包
        application = deployVersionParam.getApplication();
        compiledData = deployVersionParam.getCompiledData();
        tenantIdList = deployVersionParam.getTenantIdList().toJavaList(String.class);
        currentUser = deployVersionParam.getCurrentUser();
        currentTenantId = currentUser.getTenantId();
        String env = deployVersionParam.getEnv();
        log.info("开始部署{}:{}", deployVersionParam.getApplication(), parentThreadId);

        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("在娜娜后台部署..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        curTenantToken = tenantService.getRealTimeTenantToken(currentTenantId);

        //获取编译包里的运行态数据
        File compiledDataFilesDirectory = this.getCompiledDataFiles(compiledData);

        // 从文件解析应用数据
        JSONObject analysedDatas = this.analyseDataFromFile(compiledDataFilesDirectory);

        // 将旧有版本数据清除
        this.cleanMongoData();

        if (!isSkipTemplate) {
            // 通过应用数据实例化模板数据，并入库
            this.instantiateTemplateData(analysedDatas);
        }

        if (!isSkipGPT) {
            // RH大模型+小模型部署
            this.doGPTDeploy(analysedDatas);
        }

        this.doUrgeRuleDeploy(analysedDatas);

        // 将数据入库
        this.putData2Mongo(analysedDatas,env);

        try {
            aniaHelper.deployerCache(curTenantToken, isCNaDeploy, true, assistantCode);
        } catch (Exception e) {
            log.error("更新助理缓存error. ", e);
        }

        // 部署后的关系数据处理
        this.doAfterDataProcess();

        this.doProcess4ProdAndAuth();

        // 重置km/atmc缓存
        this.resetCache(curTenantToken);

        DeployProcess deployProcess = cacheService.get(PARTITION, application, DeployProcess.class);
        if (deployProcess != null) {
            deployProcess.setDeployedNum(deployProcess.getTotal());
        }

        log.info("部署完成:{}", parentThreadId);

        deployDetail.setResult(AsaConstant.DEPLOY_FINISH);
        long mills = calculateExecuteMills(deployDetail.getTime());
        deployDetail.setTime(new Date()).setExecuteTimeMills(mills);
        deployEvent.setMsg("process:" + JSON.toJSONString(deployDetail));
        deployEvent.setComplete(true);
        applicationContext.publishEvent(deployEvent);
    }

    /**
     * 将催办规则更新到助理中
     * @param analysedDatas
     */
    private void doUrgeRuleDeploy(JSONObject analysedDatas) {
        List<JSONObject> assistantDataList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get("assistant");
        List<JSONObject> assistantUrgeList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get(AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_URGE);
        this.updateAsssitant(assistantDataList, assistantUrgeList);
    }

    private void doGPTDeploy(JSONObject analysedDatas) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("GPT部署..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            List<JSONObject> assistantDataList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get("assistant");
            List<JSONObject> projectDataList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get(AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_PROJECT);
            List<JSONObject> modelDataList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get(AsaConstant.COLLECTION_NAME_ASA_ASSISTANT_MODEL);
            List<JSONObject> utterancesDataList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get(AsaConstant.COLLECTION_NAME_ASA_MODEL_CORPUS);

            List<JSONObject> synonymDataList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_AGILEDATA).get(AsaConstant.COLLECTION_NAME_AGILEDATA_SYNONYM);
            List<JSONObject> keywordList = new ArrayList<>();
            List<JSONObject> synonymList = new ArrayList<>();

            for (JSONObject synonymData : synonymDataList) {
                if ("目标".equals(synonymData.getString("entityTypeName"))) {
                    keywordList.add(synonymData);
                } else {
                    synonymList.add(synonymData);
                }
            }

            if (!synonymList.isEmpty()) {
                this.executeEsDelete(application, SynonymEntityType.SYNONYM.getName(), AI_DEPLOY_MODE_TEST, curTenantToken);
                this.executeEsUpsert(application, SynonymEntityType.SYNONYM.getName(), synonymList, AI_DEPLOY_MODE_TEST, curTenantToken);
            }

            String llmPromptId = null;
            if (!CollectionUtils.isEmpty(projectDataList)
                    && !CollectionUtils.isEmpty(modelDataList) && !CollectionUtils.isEmpty(utterancesDataList)
                    && Objects.nonNull(deployVersionParam.getModelInfo())
                    && StringUtils.isNotBlank(deployVersionParam.getModelInfo().getString("projectCode"))
                    && Objects.nonNull(deployVersionParam.getModelInfo().getObject("modelTypes", List.class))
                    && StringUtils.isNotBlank(deployVersionParam.getModelInfo().getString("modelCode"))
                    && StringUtils.isNotBlank(deployVersionParam.getCurrentEnv())
                    && StringUtils.isNotBlank(deployVersionParam.getEnv())) {

                String modelCode = deployVersionParam.getModelInfo().getString("modelCode");
                List<Integer> modelTypes = deployVersionParam.getModelInfo().getObject("modelTypes", List.class);

                List<JSONObject> assistantProjectModel = modelDataList.stream().filter(item -> Objects.equals(modelCode, item.getString("modelCode"))).collect(Collectors.toList());

                String deployMode = AI_DEPLOY_MODE_TEST;

                Bson filterFind = Filters.eq("assistantCode", assistantCode);
                FindIterable<Document> documents = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(AsaConstant.COLLECTION_NAME_ASSISTANT).find(filterFind);
                Document assistant = documents.first();

                // assistantCode对应的助理不存在，说明是首次部署
                if (Objects.isNull(assistant)) {
                    if (!Objects.equals(deployVersionParam.getCurrentEnv(), deployVersionParam.getEnv())) {
                        // 调用“创建提示词”接口，创建大模型提示词
                        llmPromptId = this.addLlmPrompt(projectDataList, deployVersionParam, modelDataList, utterancesDataList);

                        if (StringUtils.isNotBlank(assistantProjectModel.get(0).getString("llmPromptId"))) {
                            assistantRhApiHelper.modifyLLMPrompt(llmPromptId, assistantProjectModel.get(0).getString("llmMode"), assistantProjectModel.get(0).getString("llmPrompt"), "", curTenantToken);
                        }

                        // 调用“大模型部署”
                        this.deployllm(deployVersionParam.getModelInfo().getString("projectCode"), llmPromptId, deployMode);
                    }
                } else {
                    JSONObject aiProject = Objects.isNull(JSON.parseObject(JSON.toJSONString(assistant.get("aiProject")))) ? new JSONObject() : JSON.parseObject(JSON.toJSONString(assistant.get("aiProject")));
                    if (!Objects.equals(deployVersionParam.getModelInfo().getString("modelCode"), aiProject.getString("modelCode"))) {
                        if (!Objects.equals(deployVersionParam.getCurrentEnv(), deployVersionParam.getEnv())) {
                            // 调用“创建提示词”接口，创建大模型提示词
                            llmPromptId = this.addLlmPrompt(projectDataList, deployVersionParam, modelDataList, utterancesDataList);

                            if (StringUtils.isNotBlank(assistantProjectModel.get(0).getString("llmPromptId"))) {
                                assistantRhApiHelper.modifyLLMPrompt(llmPromptId, assistantProjectModel.get(0).getString("llmMode"), assistantProjectModel.get(0).getString("llmPrompt"), "", curTenantToken);
                            }

                            // 调用“大模型部署”
                            this.deployllm(deployVersionParam.getModelInfo().getString("projectCode"), llmPromptId, deployMode);
                        }
                    }
                }

                if (Objects.equals(deployVersionParam.getCurrentEnv(), deployVersionParam.getEnv())) {
                    if (!CollectionUtils.isEmpty(modelDataList)) {
                        log.info("模型数：{}", modelDataList.size());
                        log.info(modelCode);
                        log.info(JSONObject.toJSONString(modelDataList));
                    }

                    //同区不包含编译数据
                    if (StringUtils.isBlank(assistantProjectModel.get(0).getString("llmPromptId"))) {
                        // 调用“创建提示词”接口，创建大模型提示词
                        llmPromptId = this.addLlmPrompt(projectDataList, deployVersionParam, modelDataList, utterancesDataList);
                        // 调用“大模型部署”
                        this.deployllm(deployVersionParam.getModelInfo().getString("projectCode"), llmPromptId, deployMode);
                    } else {
                        llmPromptId = assistantProjectModel.get(0).getString("llmPromptId");

                        Bson assistantFindFilterBson = Filters.and(Filters.eq("assistantCode", assistantCode), Filters.eq("version", AsaConstant.COMMERCIAL_VERSION));
                        FindIterable<Document> assistantDoc = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(("assistant")).find(assistantFindFilterBson);
                        Document commercialAssistant = assistantDoc.first();

                        if (Objects.nonNull(commercialAssistant) && Objects.nonNull(commercialAssistant.get("aiProject"))) {
                            JSONObject aiProject = JSON.parseObject(JSON.toJSONString(commercialAssistant.get("aiProject")), JSONObject.class);

                            String prodLlmPromptId = aiProject.getString("llmPromptId");
                            String prodModelCode = aiProject.getString("modelCode");

                            if (llmPromptId.equals(prodLlmPromptId)) {
                                deployMode = AI_DEPLOY_MODE_TP;
                            }

                            this.deployllm(deployVersionParam.getModelInfo().getString("projectCode"), assistantProjectModel.get(0).getString("llmPromptId"), deployMode);

                            if (modelTypes.contains(MODEL_TYPE_NLU)) {
                                // 调用小模型指定部署接口
                                if (modelCode.equals(prodModelCode)) {
                                    deployMode = AI_DEPLOY_MODE_TP;
                                } else {
                                    deployMode = AI_DEPLOY_MODE_TEST;
                                }

                                this.nluTagDeployer(deployVersionParam, deployMode);
                            }
                        } else {
                            this.deployllm(deployVersionParam.getModelInfo().getString("projectCode"), assistantProjectModel.get(0).getString("llmPromptId"), deployMode);

                            if (modelTypes.contains(MODEL_TYPE_NLU)) {
                                // 调用小模型指定部署接口
                                this.nluTagDeployer(deployVersionParam, deployMode);
                            }
                        }
                    }
                }
                if (modelTypes.contains(MODEL_TYPE_ES)) {
                    if (!keywordList.isEmpty()) {
                        this.executeEsDelete(application, SynonymEntityType.TARGET.getName(), AI_DEPLOY_MODE_TEST, curTenantToken);
                        this.executeEsUpsert(application, SynonymEntityType.TARGET.getName(), keywordList, AI_DEPLOY_MODE_TEST, curTenantToken);
                    }
                }

                // 在assistant信息上记录projectCode、modelTypes、modelVersion、llmFoundationModel
                this.updateAsssitant(assistantDataList, modelDataList, deployVersionParam, llmPromptId);
            } else {
                List<JSONObject> assistantSceneList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get(AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE);
                // 调用“创建提示词”接口，创建大模型提示词
                llmPromptId = this.addLlmPromptWithoutModel(assistantSceneList, curTenantToken, assistantDataList.get(0));
                // 调用“大模型部署”
                this.deployllm(application, llmPromptId, AI_DEPLOY_MODE_TEST);

                this.updateAsssitant(assistantDataList, new ArrayList<>(), deployVersionParam, llmPromptId);
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("GPT部署异常:", e);
            this.setWarnDeployDetail(deployDetail, e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void updateAsssitant(List<JSONObject> assistantDataList, List<JSONObject> modelDataList, DeployVersionParam deployVersionParam, String llmPromptId) {
        Document assistantProjectModel = null;
        for (JSONObject modelData : modelDataList) {
            Document modelDoc = Document.parse(modelData.toJSONString());
            if (modelDoc.getString("modelCode").equals(deployVersionParam.getModelInfo().getString("modelCode"))) {
                assistantProjectModel = modelDoc;
                break;
            }
        }
        if (Objects.nonNull(assistantProjectModel)) {
            AssistantProjectModel assistantProjectModel1 = JSON.parseObject(JSON.toJSONString(assistantProjectModel), AssistantProjectModel.class);
            for (JSONObject assistantData : assistantDataList) {
                JSONObject jsonObjectAiProject = Objects.isNull(JSON.parseObject(JSON.toJSONString(assistantData.getString("aiProject")), JSONObject.class)) ? new JSONObject() : JSON.parseObject(JSON.toJSONString(assistantData.getString("aiProject")), JSONObject.class);
                jsonObjectAiProject.fluentPut("projectCode", deployVersionParam.getModelInfo().getString("projectCode"));
                jsonObjectAiProject.fluentPut("modelTypes", deployVersionParam.getModelInfo().getObject("modelTypes", List.class));
                jsonObjectAiProject.fluentPut("llmFoundationModel", assistantProjectModel1.getLlmModel()).fluentPut("modelCode", deployVersionParam.getModelInfo().getString("modelCode"));
                jsonObjectAiProject.fluentPut("llmPromptId", llmPromptId);
                jsonObjectAiProject.fluentPut("modelTag", AI_DEPLOY_MODE_TEST);
                assistantData.put("aiProject", jsonObjectAiProject);
            }
        } else {
            for (JSONObject assistantData : assistantDataList) {
                JSONObject jsonObjectAiProject = Objects.isNull(JSON.parseObject(JSON.toJSONString(assistantData.getString("aiProject")), JSONObject.class)) ? new JSONObject() : JSON.parseObject(JSON.toJSONString(assistantData.getString("aiProject")), JSONObject.class);
                jsonObjectAiProject.fluentPut("projectCode", application);
                jsonObjectAiProject.fluentPut("modelTypes", Arrays.asList(MODEL_TYPE_LLM));
                jsonObjectAiProject.fluentPut("llmFoundationModel", "ChatGPT").fluentPut("modelCode", null);
                jsonObjectAiProject.fluentPut("llmPromptId", llmPromptId);
                jsonObjectAiProject.fluentPut("modelTag", AI_DEPLOY_MODE_TEST);
                assistantData.put("aiProject", jsonObjectAiProject);
            }
        }
    }

    /**
     * 更新催办规则到助理数据
     * @param assistantDataList
     * @param assistantUrgeList
     */
    private void updateAsssitant(List<JSONObject> assistantDataList, List<JSONObject> assistantUrgeList) {
        for (JSONObject urgeData : assistantUrgeList){
            Document urgeDoc = Document.parse(urgeData.toJSONString());
            String application = urgeDoc.getString("application");
            for (JSONObject assistantData : assistantDataList){
                String assistantCode = assistantData.getString("assistantCode");
                if (assistantCode.equals(application)){
                    JSONObject jsonObjectUrge = new JSONObject();
                    jsonObjectUrge.fluentPut("count",urgeDoc.getInteger("count")).fluentPut("intervalInMinutes",urgeDoc.getInteger("intervalInMinutes")
                    ).fluentPut("startAfter",urgeDoc.getInteger("startAfter")).fluentPut("effectiveStatus",urgeDoc.getBoolean("effectiveStatus"))
                            .fluentPut("urgeWayShow",urgeDoc.getInteger("urgeWayShow")).fluentPut("urgeTypes",urgeDoc.getList("urgeTypes",Map.class));
                    assistantData.fluentPut("urge",jsonObjectUrge);
                }else{
                    continue;
                }
            }
        }
    }

    private void nluTagDeployer(DeployVersionParam deployVersionParam, String deployMode) {
        Map projectName = new HashMap();
        projectName.put("project_name", deployVersionParam.getModelInfo().getString("projectCode"));
        StringBuffer stringBuffer = new StringBuffer("deploy_");
        String create_mode = "model_1";
        stringBuffer.append(create_mode.replace("_", "")).append("_").append(deployVersionParam.getModelInfo().getString("modelCode"));
        assistantRhApiHelper.tagDeployer(create_mode, projectName, deployMode, stringBuffer.toString(), curTenantToken);
        create_mode = "model_2";
        assistantRhApiHelper.tagDeployer(create_mode, projectName, deployMode, stringBuffer.toString().replaceFirst("model1", "model2"), curTenantToken);
    }

    /**
     * 获取DMC上编译数据文件
     */
    private File getCompiledDataFiles(JSONObject compiledData) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("从DMC下载数据文件..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        File compileZipFile = null;
        File compileDataDirectory = null;

        try {
            //解压运行态数据
            String randomPath = IdUtil.fastSimpleUUID();
            String applicationCompileZipPath = compileZipPath + File.separator + randomPath + File.separator + FilenameUtils.getName(application) + File.separator;
            String applicationCompileDataPath = compileDataPath + File.separator + randomPath + File.separator + FilenameUtils.getName(application) + File.separator;

            String shareUrl = compiledData.getString("compiledDataShareUrl");
            log.info("DMC共享编译数据文件路径：{}", shareUrl);
            String compileDataZipFile = StrUtil.format(application + "_{}.zip", compiledData.getString("version"));
            compileZipFile = FileUtil.file(applicationCompileZipPath, FilenameUtils.getName(compileDataZipFile));
            this.downloadFileFromDmc(shareUrl, compileZipFile);

            compileDataDirectory = FileUtil.file(applicationCompileDataPath);
            ZipUtil.unzip(compileZipFile, compileDataDirectory);

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Download data file from DMC error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);

            try {
                if (null != compileZipFile) {
                    FileUtil.del(compileZipFile.getParentFile().getParentFile());
                }
            } catch (IORuntimeException iore) {
                log.error("Clean compile zip file error.", iore);
            }
        }

        return compileDataDirectory;
    }

    /**
     * 从数据文件中解析数据
     * key：assistant/assistantScene
     *
     * @param compiledDataFilesDirectory 已编译数据文件
     * @return 解构后的结构化数据
     */
    private JSONObject analyseDataFromFile(File compiledDataFilesDirectory) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("解析数据文件..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        JSONObject analysedDatas = new JSONObject();
        for (String dbName : DB_COLLECTION.keySet()) {
            JSONObject collectionDatas = new JSONObject();
            List<String> collectionList = DB_COLLECTION.get(dbName);
            for (String collectionName : collectionList) {
                collectionDatas.put(collectionName, new ArrayList<>());
            }

            analysedDatas.put(dbName, collectionDatas);
        }

        try {
            //统计文件总数
            NameFileFilter nameFileFilter = new NameFileFilter(".DS_Store");
            NotFileFilter notFileFilter = new NotFileFilter(nameFileFilter);
            List<File> files = FileUtil.loopFiles(compiledDataFilesDirectory, notFileFilter);
            //初始化部署进度
            int total = files.stream().mapToInt(file -> FileUtil.readLines(file, "utf-8").size()).sum();
            DeployProcess deployProcess = new DeployProcess().setTotal(total).setLeft(total);
            cacheService.set(PARTITION, application, deployProcess);

            File[] compiledDataFiles = compiledDataFilesDirectory.listFiles();

            // 必须先解析助理数据
            for (File compileDataFile : compiledDataFiles) {
                if (!compileDataFile.isDirectory() || !MONGODB_NAME_ASA.equals(compileDataFile.getName())) {
                    continue;
                }
                File[] collectionFiles = compileDataFile.listFiles();
                for (File collectionFile : collectionFiles) {
                    if (!collectionFile.isDirectory()) {
                        continue;
                    }
                    String collectionName = collectionFile.getName();

                    if (AsaConstant.COLLECTION_NAME_ASSISTANT.equals(collectionName)) {
                        File[] collectionDataFiles = collectionFile.listFiles();

                        this.sendDeployDetailMsg(String.format("解析%s集合的数据..", AsaConstant.COLLECTION_NAME_ASSISTANT), deployDetail, deployEvent);

                        this.sendDeployDetailMsg(String.format("异构%s数据..", AsaConstant.COLLECTION_NAME_ASSISTANT), deployDetail, deployEvent);

                        //插入新版本数据
                        for (File dataFile : collectionDataFiles) {
                            if (".DS_Store".equals(dataFile.getName())) {
                                continue;
                            }

                            List<String> datas = FileUtil.readLines(dataFile, StandardCharsets.UTF_8);
                            for (String dataLine : datas) {
                                deployProcess = cacheService.get(PARTITION, application, DeployProcess.class);
                                if (deployProcess != null) {
                                    deployProcess.deployedNumIncrease();
                                    deployProcess.setType(MONGODB_NAME_ASA + "." + AsaConstant.COLLECTION_NAME_ASSISTANT);
                                }

                                JSONObject assistantData = this.transferAssistantData(dataLine);
                                if (assistantData != null) {
                                    analysedDatas.getJSONObject(MONGODB_NAME_ASA).getJSONArray(collectionName).add(assistantData);
                                }
                            }
                        }

                        this.sendDeployDetailResult(AsaConstant.DEPLOY_SUCCESS, deployDetail, deployEvent);
                    }
                }
            }

            for (File compileDataFile : compiledDataFiles) {
                String dbName = compileDataFile.getName();

                if (!compileDataFile.isDirectory() || !(ANALYZE_MONGODB_LIST.contains(dbName) || FILE_FOLDER_CYPHER.equals(dbName))) {
                    continue;
                }

                if (FILE_FOLDER_CYPHER.equals(dbName)) {
                    File[] cypherFiles = compileDataFile.listFiles();

                    for (File cypherFile :cypherFiles) {
                        if (cypherFile.isDirectory()) {
                            continue;
                        }

                        List<String> cypherDatas = FileUtil.readLines(cypherFile, StandardCharsets.UTF_8);

                        /**
                         * 解析后的cypherdata结构
                         * {
                         *     skillcode:
                         *     {
                         *         nodetype:
                         *         [
                         *             data1,
                         *             data2
                         *         ]
                         *     }
                         * }
                         */
                        JSONObject cypherDataInfo = new JSONObject();
                        for (String cypherData : cypherDatas) {
                            String cypherNode = this.getCypherNode(cypherData);
                            String cypherSkillCode = this.getCypherSkillCode(cypherData);

                            if (cypherDataInfo.get(cypherSkillCode) == null) {
                                JSONObject skillCypherData = new JSONObject();
                                cypherDataInfo.put(cypherSkillCode, skillCypherData);
                            }

                            JSONObject skillCypherData = cypherDataInfo.getJSONObject(cypherSkillCode);
                            if (skillCypherData.get(cypherNode) == null) {
                                List<String> nodeCypherDatas = new ArrayList<>();
                                skillCypherData.put(cypherNode, nodeCypherDatas);
                            }

                            List<String> nodeCypherDatas = (List<String>) skillCypherData.get(cypherNode);
                            nodeCypherDatas.add(cypherData.replaceAll(",?\\s*skillCode:'[A-Za-z0-9]+'", ""));
                        }

                        analysedDatas.put(FILE_FOLDER_CYPHER, cypherDataInfo);
                    }
                } else {
                    File[] collectionFiles = compileDataFile.listFiles();
                    for (File collectionFile : collectionFiles) {
                        if (!collectionFile.isDirectory()) {
                            continue;
                        }
                        String collectionName = collectionFile.getName();

                        if (ANALYZE_COLLECTION_LIST.contains(collectionName)) {
                            File[] collectionDataFiles = collectionFile.listFiles();

                            this.sendDeployDetailMsg(String.format("解析%s集合的数据..", collectionName), deployDetail, deployEvent);

                            this.sendDeployDetailMsg(String.format("异构%s数据..", collectionName), deployDetail, deployEvent);

                            //插入新版本数据
                            for (File dataFile : collectionDataFiles) {
                                if (".DS_Store".equals(dataFile.getName())) {
                                    continue;
                                }

                                List<String> datas = FileUtil.readLines(dataFile, StandardCharsets.UTF_8);
                                for (String dataLine : datas) {
                                    deployProcess = cacheService.get(PARTITION, application, DeployProcess.class);
                                    if (deployProcess != null) {
                                        deployProcess.deployedNumIncrease();
                                        deployProcess.setType(MONGODB_NAME_ASA + "." + collectionName);
                                    }

                                    Object applicationData = this.transferData(collectionName, dataLine);
                                    if (applicationData != null) {
                                        if (DB_COLLECTION.get(MONGODB_NAME_DATAMAP).contains(collectionName)) {
                                            analysedDatas.getJSONObject(MONGODB_NAME_DATAMAP).getJSONArray(collectionName).add(applicationData);
                                        } else if (DB_COLLECTION.get(MONGODB_NAME_PRESET).contains(collectionName)) {
                                            analysedDatas.getJSONObject(MONGODB_NAME_PRESET).getJSONArray(collectionName).add(applicationData);
                                        } else {
                                            analysedDatas.getJSONObject(dbName).getJSONArray(collectionName).add(applicationData);
                                        }
                                    }
                                }
                            }

                            this.sendDeployDetailResult(AsaConstant.DEPLOY_SUCCESS, deployDetail, deployEvent);
                        }
                    }
                }
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("从文件中解析数据失败:", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException("Deployment failed, please contact the developer", e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);

            try {
                FileUtil.del(compiledDataFilesDirectory.getParentFile());
            } catch (IORuntimeException iore) {
                log.error("Clean compile data file error.", iore);
            }
        }

        return analysedDatas;
    }

    private String getCypherNode(String cypherData) {
        Pattern patternNode = Pattern.compile("\\(node:([A-Za-z]+)");
        Matcher matcherNode = patternNode.matcher(cypherData);

        if (matcherNode.find()) {
            String node = matcherNode.group(1);
            return node;
        }

        return null;
    }

    private String getCypherSkillCode(String cypherData) {
        Pattern patternSkillCode = Pattern.compile("skillCode:'([A-Za-z0-9]+)'");
        Matcher matcherSkillCode = patternSkillCode.matcher(cypherData);

        if (matcherSkillCode.find()) {
            String skillCode = matcherSkillCode.group(1);
            return skillCode;
        }

        return null;
    }

    private JSONObject transferData(String collectionName, String dataLine) {
        if (AsaConstant.COLLECTION_NAME_ASSISTANT.equals(collectionName)) {
            return this.transferAssistantData(dataLine);
        } else if (AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE.equals(collectionName)) {
            return this.transferAssistantSceneData(dataLine);
        } else {
            return JSON.parseObject(dataLine);
        }
    }

    private JSONObject transferAssistantData(String dataLine) {
        JSONObject designerAssistantData = JSON.parseObject(dataLine);
        Integer appChannel = designerAssistantData.getInteger("appChannel");

        if (appChannel == null || appChannel.intValue() == 0) {
            isCNaDeploy = true;
            appChannel = 0;
        }

        JSONObject assistant = new JSONObject();
        assistatnSubType = designerAssistantData.getInteger("appSubType");

        if (ASSISTANT_SUB_TYPE_KNOWLEDGE.equals(assistatnSubType)) {
            String knowledgeType = designerAssistantData.getString("knowledgeType");
            isSkipTemplate = true;
            isSkipGPT = true;
            assistant.put("knowledgeType", knowledgeType);
        }

        assistantCode = designerAssistantData.getString("code");
        assistantName = designerAssistantData.getString("name");

        // C娜1.0版本与2.0版本需要使用不同的accid，因此助理code添加beta后缀
        if (isCNaDeploy) {
            assistantCode = assistantCode + "_beta";
        }

        String accId = imApiHelper.queryAccId(assistantCode, curTenantToken).getString("accid");

        assistant.put("assistantCode", assistantCode);
        assistant.put("name", designerAssistantData.getString("name"));
        assistant.put("description", designerAssistantData.getString("description"));
        assistant.put("sourceCustom", false);
        assistant.put("category", designerAssistantData.getString("category"));
        // 发版时，版本号固定1.0，切版时，固定2.0
        assistant.put("version", AsaConstant.DEPLOY_VERSION);
        assistant.put("status", AsaConstant.ASSISTANT_STATUS_OPEN);
        assistant.put("lang", designerAssistantData.get("lang"));
        assistant.put("searchKeywords", designerAssistantData.get("searchKeywords"));
        assistant.put("assistantAvatar", designerAssistantData.getString("iconUrl"));
        assistant.put("avatarType", designerAssistantData.getString("iconType"));
        assistant.put("tenantId", currentTenantId);
        assistant.put("appointTenants", tenantIdList);
        assistant.put("clientType", designerAssistantData.getJSONArray("clientType"));
        assistant.put("assistantType", appChannel);
        assistant.put("assistantSubType", assistatnSubType);
        assistant.put("accid", accId);
        //开场白
        assistant.put("prologue", designerAssistantData.getString("prologue"));

        return assistant;
    }

    private JSONObject transferAssistantSceneData(String dataLine) {
        JSONObject assistantScene = new JSONObject();
        JSONObject designerAssistantSceneData = JSON.parseObject(dataLine);

        String assistantSceneCode = designerAssistantSceneData.getString("code");

        assistantSceneList.add(designerAssistantSceneData);

        assistantScene.put("assistantCode", assistantCode);
        assistantScene.put("code", assistantSceneCode);
        assistantScene.put("name", designerAssistantSceneData.get("name"));
        assistantScene.put("description", designerAssistantSceneData.get("description"));
        assistantScene.put("knowledgeBase", designerAssistantSceneData.get("knowledgeBase"));
        assistantScene.put("knowledgeBases", designerAssistantSceneData.get("knowledgeBases"));
        assistantScene.put("publicIdentity", designerAssistantSceneData.get("publicIdentity"));
        assistantScene.put("inspirationPhrase", designerAssistantSceneData.get("inspirationPhrase"));
        assistantScene.put("type", designerAssistantSceneData.get("type"));
        assistantScene.put("dataMetric", designerAssistantSceneData.get("dataMetric"));
        assistantScene.put("lang", designerAssistantSceneData.get("lang"));
        assistantScene.put("version", AsaConstant.DEPLOY_VERSION);
        if (Objects.nonNull(designerAssistantSceneData.get("sort"))) {
            assistantScene.put("sort", designerAssistantSceneData.get("sort"));
        }
        List<JSONObject> assistantSceneSteps = new ArrayList<>();
        JSONArray assistantSceneElementMetadatas = new JSONArray();
        JSONArray desingerAssistantSceneSteps = designerAssistantSceneData.getJSONArray("itemSteps");

        if (desingerAssistantSceneSteps != null) {
            int order = 0;
            // 异构编译数据的结构，将element_metadata提到顶层，并用end节点的config构建event节点
            for (int i = 0; i < desingerAssistantSceneSteps.size(); i++) {
                JSONObject assistantSceneStep = new JSONObject();
                JSONObject desingerAssistantSceneStep = desingerAssistantSceneSteps.getJSONObject(i);

                String abilityType = desingerAssistantSceneStep.getString("abilityType");

                JSONObject designerAssistantSceneStepConfig = desingerAssistantSceneStep.getJSONObject("config");
                if (null != designerAssistantSceneStepConfig) {
                    JSONArray elementMetadatas = designerAssistantSceneStepConfig.getJSONArray("element_metadata");
                    if (null != elementMetadatas) {
                        assistantSceneElementMetadatas.addAll(elementMetadatas);
                        designerAssistantSceneStepConfig.remove("element_metadata");
                    }

                    if (STEP_TYPE_END.equals(abilityType)) {
                        JSONObject endEvent = designerAssistantSceneStepConfig;
                        JSONObject assistantEvent = new JSONObject();
                        assistantEvent.put("endEvent", endEvent);
                        assistantScene.put("assistantEvent", assistantEvent);
                    }
                }

                if (AsaConstant.ABILITY_TYPE_PLATFORM.equalsIgnoreCase(abilityType)) {
                    assistantSceneStep.put("assistantCode", assistantCode);
                    assistantSceneStep.put("assistantSceneCode", designerAssistantSceneData.get("code"));
                    assistantSceneStep.put("code", desingerAssistantSceneStep.get("code"));
                    assistantSceneStep.put("name", desingerAssistantSceneStep.get("name"));
                    assistantSceneStep.put("abilityType", abilityType);
                    assistantSceneStep.put("abilityCode", desingerAssistantSceneStep.get("abilityCode"));
                    assistantSceneStep.put("lang", desingerAssistantSceneStep.get("lang"));
                    assistantSceneStep.put("order", order);
                    assistantSceneStep.put("version", AsaConstant.DEPLOY_VERSION);
                    assistantSceneStep.put("config", designerAssistantSceneStepConfig);
                    assistantSceneSteps.add(assistantSceneStep);
                    order++;
                } else if (AsaConstant.ABILITY_TYPE_PRIVATE.equalsIgnoreCase(abilityType)) {
                    assistantSceneStep.put("assistantCode", assistantCode);
                    assistantSceneStep.put("assistantSceneCode", designerAssistantSceneData.get("code"));
                    assistantSceneStep.put("code", desingerAssistantSceneStep.get("code"));
                    assistantSceneStep.put("name", desingerAssistantSceneStep.get("name"));
                    assistantSceneStep.put("abilityType", abilityType);
                    assistantSceneStep.put("abilityCode", desingerAssistantSceneStep.get("abilityCode"));
                    assistantSceneStep.put("lang", desingerAssistantSceneStep.get("lang"));
                    assistantSceneStep.put("order", order);
                    assistantSceneStep.put("version", AsaConstant.DEPLOY_VERSION);

                    assistantSceneSteps.add(assistantSceneStep);
                    order++;
                } else if (AsaConstant.ABILITY_TYPE_PRIVATE_INTERFACE.equalsIgnoreCase(abilityType)) { //界面设计
                    assistantSceneStep.put("assistantCode", assistantCode);
                    assistantSceneStep.put("assistantSceneCode", designerAssistantSceneData.get("code"));
                    assistantSceneStep.put("code", desingerAssistantSceneStep.get("code"));
                    assistantSceneStep.put("name", desingerAssistantSceneStep.get("name"));
                    assistantSceneStep.put("abilityType", abilityType);
                    assistantSceneStep.put("abilityCode", desingerAssistantSceneStep.get("abilityCode"));
                    assistantSceneStep.put("lang", desingerAssistantSceneStep.get("lang"));
                    assistantSceneStep.put("order", order);
                    assistantSceneStep.put("version", AsaConstant.DEPLOY_VERSION);

                    assistantSceneSteps.add(assistantSceneStep);
                    order++;
                }
            }
        }

        assistantScene.put("element_metadata", assistantSceneElementMetadatas);
        assistantScene.put("assistantSceneItemStep", assistantSceneSteps);

        return assistantScene;
    }

    private void instantiateTemplateData(JSONObject analysedDatas) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("实例化模板数据..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            this.processKMDatas(analysedDatas);

            List<JSONObject> assistantScenes = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get(AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE);

            CustomConfigModel defConfigModel = new CustomConfigModel();
            defConfigModel.setAssistantCode(application);
            defConfigModel.setAssistantName(assistantName);
            defConfigModel.setVersion(AsaConstant.DEPLOY_VERSION);

            for (JSONObject assistantScene : assistantScenes) {
                if (!SceneType.KNOWLEDGE.getType().equals(assistantScene.getInteger("type"))
                        && !SceneType.DATA.getType().equals(assistantScene.getInteger("type"))) {

                    List<JSONObject> assistantSceneItemSteps = (List<JSONObject>) assistantScene.get("assistantSceneItemStep");

                    String assistantSceneCode = assistantScene.getString("code");

                    this.sendDeployDetailMsg(String.format("实例化场景%s的数据..", assistantSceneCode), deployDetail, deployEvent);

                    DeployProcess deployProcess = cacheService.get(PARTITION, application, DeployProcess.class);
                    if (deployProcess != null) {
                        deployProcess.deployedNumIncrease();
                        deployProcess.setType(MONGODB_NAME_ASA + ".assistantScene");
                    }

                    defConfigModel.setSceneCode(assistantSceneCode);
                    defConfigModel.setSceneName(assistantScene.getString("name"));
                    defConfigModel.setItemStepsLength(assistantSceneItemSteps.size());
                    defConfigModel.setSceneLang(assistantScene.getJSONObject("lang"));

                    // 模板实例化数据的数据量较大，生成后直接入库，减小内存压力
                    // assistant_scene_template
                    defConfigModel.setTemplateType(ASSISTANT_SCENE_TEMPLATE);
                    List<Document> templateDocs = processModel(defConfigModel, model -> templateMap.get("projectTemplate").generate(model));
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_PROJECT).insertMany(templateDocs);

                    templateDocs = processModel(defConfigModel, model -> templateMap.get("activityTemplate").generate(model));
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_ACTIVITY).insertMany(templateDocs);

                    templateDocs = processModel(defConfigModel, model -> templateMap.get("dataDescriptionTemplate").generate(model));
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_DATADESCRIPTION).insertMany(templateDocs);

                    templateDocs = processModel(defConfigModel, model -> templateMap.get("dataStateTemplate").generate(model));
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_DATASTATE).insertMany(templateDocs);

                    templateDocs = processModel(defConfigModel, model -> templateMap.get("flowGraphTemplate").generate(model));
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_FLOWGRAPH).insertMany(templateDocs);

                    templateDocs = processModel(defConfigModel, model -> templateMap.get("taskTemplate").generate(model));
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_TASK).insertMany(templateDocs);

                    // knowledgegraphSystem
                    templateDocs = processModel(defConfigModel, model -> templateMap.get("appRelationTemplate").generate(model));
                    kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(AsaConstant.COLLECTION_NAME_APPLICATION_RELATION).insertMany(templateDocs);

                    for (JSONObject assistantSceneItemStep : assistantSceneItemSteps) {
                        String itemStepCode = assistantSceneItemStep.getString("code");
                        int itemStepNum = assistantSceneItemStep.getIntValue("order");
                        String abilityType = assistantSceneItemStep.getString("abilityType");
                        String abilityCode = assistantSceneItemStep.getString("abilityCode");

                        defConfigModel.setItemStepCode(itemStepCode);
                        defConfigModel.setItemStepName(assistantSceneItemStep.getString("name"));
                        defConfigModel.setItemStepNum(itemStepNum);
                        defConfigModel.setItemStepLang(assistantSceneItemStep.getJSONObject("lang"));
                        defConfigModel.setAbilityCode(abilityCode);
                        defConfigModel.setAbilityType(abilityType);
                        defConfigModel.setAssistantSceneItemStep(assistantSceneItemStep);
                        //场景设计技能处理|能力设计技能处理
                        if (AsaConstant.ABILITY_TYPE_PLATFORM.equalsIgnoreCase(abilityType)) {
                            AbilityEnum abilityEnum = AbilityEnum.getAbilityByCode(abilityCode);
                            if (null != abilityEnum) {
                                defConfigModel.setTemplateType(abilityEnum.getTemplateType());
                                for (String key : templateMap.keySet()) {
                                    ITemplate iTemplate = templateMap.get(key);
                                    iTemplate.fillCustomConfigModel(defConfigModel, assistantSceneItemStep);
                                    templateDocs = processModel(defConfigModel, model -> iTemplate.generate(model));
                                    mongoInsertMany(iTemplate.getCollectName(), templateDocs);
                                }
                                if (abilityCode.equals(AbilityEnum.FORMTASK.getAbilityCode())) {
                                    JSONObject config = assistantSceneItemStep.getJSONObject("config");
                                    //暂定taskCode
                                    String taskCode = config.getString("taskCode");
                                    JSONObject dataMapCollectionDatas = analysedDatas.getJSONObject(MONGODB_NAME_DATAMAP);
                                    JSONObject presetCollectionDatas = analysedDatas.getJSONObject(MONGODB_NAME_PRESET);
                                    List<JSONObject> ruleList = getAnalysedDataClone(presetCollectionDatas, AsaConstant.COLLECTION_NAME_TASK_RULES);
                                    List<JSONObject> newRules = new ArrayList<>();
                                    for (JSONObject rule : ruleList) {
                                        if (taskCode.equals(rule.getString("domainId"))) {
                                            newRules.add(rule);
                                        }
                                    }
                                    List<JSONObject> pageUIElementList = getAnalysedDataClone(dataMapCollectionDatas, AsaConstant.COLLECTION_NAME_PAGE_UI_ELEMENT);
                                    List<JSONObject> newPageUIElements = new ArrayList<>();
                                    for (JSONObject pageUIElement : pageUIElementList) {
                                        //暂定code
                                        if (taskCode.equals(pageUIElement.getString("code"))) {
                                            newPageUIElements.add(pageUIElement);
                                        }
                                    }

                                    List<JSONObject> pageViewList = getAnalysedDataClone(dataMapCollectionDatas, AsaConstant.COLLECTION_NAME_PAGEVIEW);
                                    List<JSONObject> newPageViewList = new ArrayList<>();
                                    for (JSONObject pageView : pageViewList) {
                                        if (taskCode.equals(pageView.getString("code"))) {
                                            newPageViewList.add(pageView);
                                        }
                                    }
                                    this.processGeneralFormPageUIElement(newPageUIElements, itemStepCode);
                                    this.processGeneralFormRules(newRules, itemStepCode);
                                    this.processGeneralFormPageView(newPageViewList, itemStepCode);
                                }
                            }
                        } else if (AsaConstant.ABILITY_TYPE_PRIVATE.equalsIgnoreCase(abilityType)) {
                            JSONObject dataMapCollectionDatas = analysedDatas.getJSONObject(MONGODB_NAME_DATAMAP);
                            customSkill(dataMapCollectionDatas, assistantSceneCode, itemStepCode, abilityCode, itemStepNum, defConfigModel);
                            JSONObject kmDatas = analysedDatas.getJSONObject(MONGODB_NAME_KGSYS);
                            this.processPrivateDataActivityConfig(kmDatas, application, itemStepCode, abilityCode);
                        } else if (AsaConstant.ABILITY_TYPE_PRIVATE_INTERFACE.equalsIgnoreCase(abilityType)) {
                            JSONObject dataMapCollectionDatas = analysedDatas.getJSONObject(MONGODB_NAME_DATAMAP);
                            JSONObject presetCollectionDatas = analysedDatas.getJSONObject(MONGODB_NAME_PRESET);
                            customSkill(dataMapCollectionDatas, assistantSceneCode, itemStepCode, abilityCode, itemStepNum, defConfigModel);

                            JSONObject kmDatas = analysedDatas.getJSONObject(MONGODB_NAME_KGSYS);
                            this.processPrivateDataActivityConfig(kmDatas, application, itemStepCode, abilityCode);

                            this.processPrivateInterfaceTaskRule(presetCollectionDatas, application, itemStepCode, abilityCode);
                            this.processPrivateInterfaceTaskPageUIElement(dataMapCollectionDatas, application, itemStepCode, abilityCode);
                        }

                        this.processNeo4jData(analysedDatas, abilityCode);
                    }
                }
            }
            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("实例化模板数据异常:", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException("Deployment failed, please contact the developer", e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    /**
     * 通用表单的pageUIElement处理入库
     */
    private void processGeneralFormPageUIElement(List<JSONObject> pageUIElements, String itemStepCode) {
        if (null != pageUIElements && !pageUIElements.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject pageUIElement : pageUIElements) {
                String taskCode = itemStepCode + "_GeneralForm_Filling";
                pageUIElement.put("code", taskCode);
                pageUIElement.put("activityId", taskCode);
                pageUIElement.put("pageCode", "task-card");
                Document doc = this.processPrivateModel(pageUIElement, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_PAGE_UI_ELEMENT).insertMany(insertDocs);
            }
        }
    }

    /**
     * 通用表单的pageView处理入库
     */
    private void processGeneralFormPageView(List<JSONObject> pageViewList, String itemStepCode) {
        if (null != pageViewList && !pageViewList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject pageView : pageViewList) {
                pageView.put("code", itemStepCode + "_GeneralForm_Filling");
                Document doc = this.processPrivateModel(pageView, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_PAGEVIEW).insertMany(insertDocs);
            }
        }
    }

    /**
     * 通用表单的rule处理入库
     */
    private void processGeneralFormRules(List<JSONObject> rules, String itemStepCode) {
        if (null != rules && !rules.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject rule : rules) {
                String taskCode = itemStepCode + "_GeneralForm_Filling";
                rule.put("domainId", taskCode);
                rule.put("taskCode", taskCode);
                rule.put("key", rule.getString("key") + "_" + IdSnowflake.snowflakeIdStr());
                Document doc = processPrivateModel(rule, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(AsaConstant.COLLECTION_NAME_TASK_RULES).insertMany(insertDocs);
            }
        }
    }

    private void customSkill(JSONObject dataMapCollectionDatas, String assistantSceneCode, String itemStepCode, String abilityCode, int itemStepNum, CustomConfigModel defConfigModel) {
        this.processPrivateActivity(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateDataState(dataMapCollectionDatas, application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode);
        this.processPrivateDataDescription(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateDataFeatureSet(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateFlowGraph(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivatePageView(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateTask(dataMapCollectionDatas, application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode, defConfigModel);
    }

    private void kmCustomSkill(JSONObject dataMapCollectionDatas, String assistantSceneCode, String itemStepCode, String abilityCode, int itemStepNum, CustomConfigModel defConfigModel) {
        this.processPrivateActivity(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateDataState(dataMapCollectionDatas, application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode);
        this.processPrivateDataDescription(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateDataFeatureSet(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateFlowGraph(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivatePageView(dataMapCollectionDatas, application, itemStepCode, abilityCode);
        this.processPrivateTask(dataMapCollectionDatas, application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode, defConfigModel);
    }


    private void processPrivateActivity(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List<JSONObject> activityList = getAnalysedDataClone(analysedDatas, AsaConstant.COLLECTION_NAME_ACTIVITY);

        if (null != activityList && !activityList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject activity : activityList) {
                String activitySkillCode = activity.getString("skillCode");

                if (skillCode.equals(activitySkillCode)) {
                    String activityCode = activity.getString("code");
                    activity.put("code", itemStepCode + activityCode);

                    List<JSONObject> events = activity.getObject("events", List.class);
                    if (null != events) {
                        for (JSONObject event : events) {
                            String flowCode = event.getString("flowCode");
                            if (!StringUtils.isEmpty(flowCode)) {
                                event.put("flowCode", itemStepCode + flowCode);
                            }
                        }
                    }

                    Document doc = this.processPrivateModel(activity, assistantCode);
                    insertDocs.add(doc);
                }
            }

            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_ACTIVITY).insertMany(insertDocs);
            }
        }
    }

    public List<JSONObject> getAnalysedDataClone(JSONObject analysedDatas, String key) {
        List<JSONObject> analysedDataList = (List<JSONObject>) analysedDatas.get(key);

        return JSON.parseObject(JSON.toJSONString(analysedDataList), List.class);
    }

    private void processPrivateDataState(JSONObject analysedDatas, String assistantCode, String sceneCode, String itemStepCode, int itemStepNum, String skillCode) {
        List<JSONObject> dataStateList = getAnalysedDataClone(analysedDatas, AsaConstant.COLLECTION_NAME_DATASTATE);

        if (null != dataStateList && !dataStateList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject dataState : dataStateList) {
                String dataStateSkillCode = dataState.getString("skillCode");

                if (skillCode.equals(dataStateSkillCode)) {
                    String dataStateCode = dataState.getString("code");
                    if (dataStateCode.equals(skillCode + "_start")) {
                        dataState.put("code", sceneCode + "_" + itemStepNum);
                    } else {
                        dataState.put("code", itemStepCode + dataStateCode);
                    }

                    String dataCode = dataState.getString("dataCode");
                    if (!StringUtils.isEmpty(dataCode)) {
                        dataState.put("dataCode", itemStepCode + dataCode);
                    }

                    Document doc = this.processPrivateModel(dataState, assistantCode);
                    insertDocs.add(doc);
                }
            }

            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_DATASTATE).insertMany(insertDocs);
            }
        }
    }

    private void processPrivateDataDescription(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List<JSONObject> dataDescriptionList = getAnalysedDataClone(analysedDatas, AsaConstant.COLLECTION_NAME_DATADESCRIPTION);

        if (null != dataDescriptionList && !dataDescriptionList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject dataDescription : dataDescriptionList) {
                String dataDescriptionSkillCode = dataDescription.getString("skillCode");

                if (skillCode.equals(dataDescriptionSkillCode)) {
                    String dataDescriptionCode = dataDescription.getString("code");
                    dataDescription.put("code", itemStepCode + dataDescriptionCode);

                    Document doc = this.processPrivateModel(dataDescription, assistantCode);
                    insertDocs.add(doc);
                }
            }

            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_DATADESCRIPTION).insertMany(insertDocs);
            }
        }
    }

    private void processPrivateDataActivityConfig(JSONObject kmDatas, String assistantCode, String itemStepCode, String skillCode) {
        List<JSONObject> activityConfigList = getAnalysedDataClone(kmDatas, AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS);

        if (null != activityConfigList && !activityConfigList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject activityConfig : activityConfigList) {
                String activityConfigSkillCode = activityConfig.getString("skillCode");

                if (skillCode.equals(activityConfigSkillCode)) {
                    String activityConfigCode = activityConfig.getString("code");
                    activityConfig.put("code", itemStepCode + activityConfigCode);

                    JSONObject dataSources = activityConfig.getJSONObject("dataSources");
                    if (null != dataSources) {
                        for (String dataSourceName : dataSources.keySet()) {
                            JSONObject dataSource = dataSources.getJSONObject(dataSourceName);
                            String viewCode = dataSource.getString("viewCode");
                            dataSource.put("viewCode", itemStepCode + viewCode);
                            dataSource.getJSONObject("dataViewQuery").put("code", itemStepCode + viewCode);
                        }

                        Document doc = this.processPrivateModel(activityConfig, assistantCode);
                        insertDocs.add(doc);
                    }
                    this.getDataRelaItemStep(AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS, activityConfigCode, itemStepCode);
                }
            }

            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS).insertMany(insertDocs);
            }
        }
    }

    private void getDataRelaItemStep(String dataType, String dataCode, String itemStepCode) {
        if (originalCodeRelationShip.get(dataType) == null) {
            JSONObject activityConfigsRelation = new JSONObject();
            originalCodeRelationShip.put(AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS, activityConfigsRelation);
        }

        JSONObject activityConfigsRelation = originalCodeRelationShip.getJSONObject(AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS);
        if (activityConfigsRelation.get(dataCode) == null) {
            List<String> activityConfigsRelaItemStepCodes = new ArrayList<>();
            activityConfigsRelation.put(dataCode, activityConfigsRelaItemStepCodes);
        }

        List<String> activityConfigsRelaItemStepCodes = (List<String>) activityConfigsRelation.get(dataCode);
        activityConfigsRelaItemStepCodes.add(itemStepCode);
    }


    private void processPrivateDataFeatureSet(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List<JSONObject> dataFeatureSetList = getAnalysedDataClone(analysedDatas, AsaConstant.COLLECTION_NAME_DATAFEATURESET);

        if (null != dataFeatureSetList && !dataFeatureSetList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject dataFeatureSet : dataFeatureSetList) {
                String dataFeatureSetSkillCode = dataFeatureSet.getString("skillCode");

                if (skillCode.equals(dataFeatureSetSkillCode)) {
                    String dataFeatureSetCode = dataFeatureSet.getString("code");
                    dataFeatureSet.put("code", itemStepCode + dataFeatureSetCode);

                    String dataCode = dataFeatureSet.getString("dataCode");
                    if (!StringUtils.isEmpty(dataCode)) {
                        dataFeatureSet.put("dataCode", itemStepCode + dataCode);
                    }

                    Document doc = this.processPrivateModel(dataFeatureSet, assistantCode);
                    insertDocs.add(doc);
                }
            }

            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_DATAFEATURESET).insertMany(insertDocs);
            }
        }
    }

    private void processPrivateFlowGraph(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List<JSONObject> flowGraphList = getAnalysedDataClone(analysedDatas, AsaConstant.COLLECTION_NAME_FLOWGRAPH);

        if (null != flowGraphList && !flowGraphList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject flowGraph : flowGraphList) {
                String flowGraphSkillCode = flowGraph.getString("skillCode");

                if (skillCode.equals(flowGraphSkillCode)) {
                    String flowGraphCode = flowGraph.getString("code");
                    flowGraph.put("code", itemStepCode + flowGraphCode);

                    List<Map<String, String>> nodes = flowGraph.getObject("nodes", List.class);
                    if (null != nodes) {
                        for (Map<String, String> node : nodes) {
                            if ("activity".equals(node.get("type"))) {
                                String activityCode = node.get("activityCode");
                                node.put("activityCode", itemStepCode + activityCode);
                            }
                        }
                    }

                    Document doc = this.processPrivateModel(flowGraph, assistantCode);
                    insertDocs.add(doc);
                }
            }

            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_FLOWGRAPH).insertMany(insertDocs);
            }
        }
    }

    private void processPrivatePageView(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List<JSONObject> pageViewList = getAnalysedDataClone(analysedDatas, AsaConstant.COLLECTION_NAME_PAGEVIEW);

        if (null != pageViewList && !pageViewList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject pageView : pageViewList) {
                String pageViewSkillCode = pageView.getString("skillCode");

                if (skillCode.equals(pageViewSkillCode)) {
                    String pageViewCode = pageView.getString("code");
                    pageView.put("code", itemStepCode + pageViewCode);

                    String pageViewString = pageView.toJSONString().replaceAll("\\bSP_[a-zA-Z0-9_]+", itemStepCode + "$0");

                    Document doc = this.processPrivateModel(pageViewString, assistantCode);
                    insertDocs.add(doc);
                }
            }

            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_PAGEVIEW).insertMany(insertDocs);
            }
        }
    }

    private void processPrivateInterfaceTaskPageUIElement(JSONObject dataMapCollectionDatas, String assistantCode, String itemStepCode, String abilityCode) {
        List<JSONObject> pageUIElementList = getAnalysedDataClone(dataMapCollectionDatas, AsaConstant.COLLECTION_NAME_PAGE_UI_ELEMENT);
        if (null != pageUIElementList && !pageUIElementList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject pageUIElement : pageUIElementList) {
                if (abilityCode.equals(pageUIElement.getString("skillCode"))) {
                    String taskCode = itemStepCode + pageUIElement.getString("code");
                    String activityId = itemStepCode + pageUIElement.getString("activityId");
                    pageUIElement.put("code", taskCode);
                    pageUIElement.put("activityId", activityId);
                    pageUIElement.put("version", AsaConstant.DEPLOY_VERSION);
                    Document doc = this.processPrivateModel(pageUIElement, assistantCode);
                    insertDocs.add(doc);
                }
            }
            if (!insertDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_PAGE_UI_ELEMENT).insertMany(insertDocs);
            }
        }
    }

    private void processPrivateInterfaceTaskRule(JSONObject dataMapCollectionDatas, String assistantCode, String itemStepCode, String abilityCode) {
        List<JSONObject> ruleList = getAnalysedDataClone(dataMapCollectionDatas, AsaConstant.COLLECTION_NAME_TASK_RULES);

        if (null != ruleList && !ruleList.isEmpty()) {
            List<Document> insertDocs = new ArrayList<>();
            for (JSONObject rule : ruleList) {
                if (abilityCode.equals(rule.getString("skillCode"))) {
                    String taskCode = itemStepCode + rule.getString("taskCode");
                    rule.put("domainId", taskCode);
                    rule.put("taskCode", taskCode);
                    rule.put("key", rule.getString("key") + "_" + IdSnowflake.snowflakeIdStr());
                    rule.put("version", AsaConstant.DEPLOY_VERSION);
                    Document doc = processPrivateModel(rule, assistantCode);
                    insertDocs.add(doc);
                }
            }
            //规则
            if (!insertDocs.isEmpty()) {
                List<Document> rules = insertDocs.stream().filter(rule -> rule.getString("tenantId").equals("SYSTEM")).collect(Collectors.toList());
                List<Document> tenantRules = insertDocs.stream().filter(rule -> !rule.getString("tenantId").equals("SYSTEM")).collect(Collectors.toList());

                if (!rules.isEmpty()) {
                    presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(AsaConstant.COLLECTION_NAME_TASK_RULES).insertMany(rules);
                }
                if (!tenantRules.isEmpty()) {
                    presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(AsaConstant.COLLECTION_NAME_TASK_TENANT_RULES).insertMany(rules);
                }
            }
        }
    }

    private void processPrivateTask(JSONObject analysedDatas, String assistantCode, String sceneCode, String itemStepCode, int itemStepNum, String skillCode, CustomConfigModel defConfigModel) {
        List<JSONObject> taskList = getAnalysedDataClone(analysedDatas, AsaConstant.COLLECTION_NAME_TASK);

        if (null != taskList && !taskList.isEmpty()) {
            List<Document> taskDocs = new ArrayList<>();
            for (JSONObject task : taskList) {
                String taskSkillCode = task.getString("skillCode");
                task.put("daemon", true);
                if (skillCode.equals(taskSkillCode)) {
                    String taskCode = task.getString("code");
                    task.put("code", itemStepCode + taskCode);

                    String flowCode = task.getString("flowCode");
                    task.put("flowCode", itemStepCode + flowCode);

                    String pageCode = task.getString("pageCode");
                    task.put("pageCode", itemStepCode + pageCode);

                    List<String> fromList = task.getObject("from", List.class);
                    if (null != fromList) {
                        List<String> newFromList = new ArrayList<>();
                        for (String from : fromList) {
                            if (from.equals(skillCode + "_start")) {
                                newFromList.add(sceneCode + "_" + itemStepNum);
                            } else {
                                newFromList.add(itemStepCode + from);
                            }
                        }

                        task.put("from", newFromList);
                    }

                    List<String> toList = task.getObject("to", List.class);
                    if (null != toList) {
                        List<String> newToList = new ArrayList<>();
                        for (String to : toList) {
                            if (to.equals(skillCode + "_end")) {
                                newToList.add(sceneCode.concat("_").concat(String.valueOf(itemStepNum + 1)));
                            } else {
                                newToList.add(itemStepCode + to);
                            }
                        }

                        task.put("to", newToList);
                    }

                    List<JSONObject> stateMapList = task.getObject("stateMaps", List.class);
                    if (null != stateMapList) {
                        for (JSONObject stateMap : stateMapList) {
                            String input = stateMap.getString("input");
                            if (!StringUtils.isEmpty(input)) {
                                if (input.equals(skillCode + "_start")) {
                                    stateMap.put("input", sceneCode + "_" + itemStepNum);
                                } else {
                                    stateMap.put("input", itemStepCode + input);
                                }
                            }

                            JSONObject output = stateMap.getJSONObject("output");
                            if (null != output) {
                                for (String outputKey : output.keySet()) {
                                    String outputValue = output.getString(outputKey);

                                    if (outputValue.equals(skillCode + "_end")) {
                                        output.put(outputKey, sceneCode.concat("_").concat(String.valueOf(itemStepNum + 1)));
                                    } else {
                                        output.put(outputKey, itemStepCode + outputValue);
                                    }
                                }
                            }
                        }
                    }

                    List<JSONObject> dataFeatureList = task.getObject("dataFeatures", List.class);
                    if (null != dataFeatureList) {
                        for (JSONObject dataFeature : dataFeatureList) {
                            String dataFeaturesCode = dataFeature.getString("code");
                            dataFeature.put("code", itemStepCode + dataFeaturesCode);
                        }
                    }

                    List<JSONObject> atmcDataList = task.getObject("atmcDatas", List.class);
                    JSONObject sourceTypeData = new JSONObject();
                    sourceTypeData.put("proVarKey", "sourceType");
                    sourceTypeData.put("athenaKey", "sourceType");
                    if (null == atmcDataList) {
                        atmcDataList = new ArrayList<>();
                    }
                    atmcDataList.add(sourceTypeData);
                    task.put("atmcDatas", atmcDataList);
                    JSONObject config = task.getJSONObject("config");
                    if (Objects.isNull(config)) {
                        config = new JSONObject();
                    }
                    config.put("asaAbilityCode", defConfigModel.getAbilityCode());
                    config.put("asaAbilityType", defConfigModel.getAbilityType());
                    config.put("asaSceneItemStepCode", defConfigModel.getItemStepCode());
                    task.put("config", config);
                    Document doc = this.processPrivateModel(task, assistantCode);
                    taskDocs.add(doc);
                }
            }

            //任务
            if (!taskDocs.isEmpty()) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(AsaConstant.COLLECTION_NAME_TASK).insertMany(taskDocs);
            }
        }
    }

    private void processKMDatas(JSONObject analysedDatas) {
        JSONObject kmDatas = analysedDatas.getJSONObject(MONGODB_NAME_KGSYS);

        for (String kmCollectionName : kmDatas.keySet()) {
            if (kmCollectionName.equals(AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS)) {
                continue;
            }
            List<JSONObject> collectionDatas = (List<JSONObject>) kmDatas.get(kmCollectionName);

            if (null != collectionDatas && !collectionDatas.isEmpty()) {
                List<Document> insertDocs = new ArrayList<>();
                for (JSONObject appRelation : collectionDatas) {
                    Document doc = Document.parse(appRelation.toJSONString());
                    doc.put("version", AsaConstant.DEPLOY_VERSION);
                    doc.put("application", application);
                    insertDocs.add(doc);
                }

                if (!insertDocs.isEmpty()) {
                    kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(kmCollectionName).insertMany(insertDocs);
                }
            }
        }
    }

    private Document processPrivateModel(String dataString, String assistantCode) {
        Document doc = Document.parse(dataString);
        doc.remove("_id");
        doc.put("application", assistantCode);
        doc.put("groupCode", assistantCode);
        doc.put("version", AsaConstant.DEPLOY_VERSION);
        doc.put("athena_namespace", assistantCode);
        doc.put("tenantId", "SYSTEM");
        return doc;
    }

    private Document processPrivateModel(JSONObject privateData, String assistantCode) {
        Document doc = Document.parse(privateData.toJSONString());
        doc.remove("_id");
        doc.put("application", assistantCode);
        doc.put("groupCode", assistantCode);
        doc.put("version", AsaConstant.DEPLOY_VERSION);
        doc.put("athena_namespace", assistantCode);
        doc.put("tenantId", "SYSTEM");
        return doc;
    }

    private <T> List<Document> processModel(CustomConfigModel defConfigModel, IGenerateModel<T> generateModel) {
        List<Document> modelDocs = new ArrayList<>();
        List<T> models = generateModel.generate(defConfigModel);
        for (T model : models) {
            if (model instanceof CollectionModel) {
                CollectionModel collectionModel = (CollectionModel) model;
                List<?> collections = collectionModel.getCollection();
                CollUtil.emptyIfNull(collections).forEach(collection -> {
                    Document modelDocument = createDocument(JSON.toJSONString(collection), defConfigModel);
                    modelDocs.add(modelDocument);
                });
            } else {
                Document modelDocument = createDocument(JSON.toJSONString(model), defConfigModel);
                modelDocs.add(modelDocument);
            }
        }
        return modelDocs;
    }

    private Document createDocument(String jsonString, CustomConfigModel defConfigModel) {
        Document doc = Document.parse(jsonString);
        doc.remove("_id");
        doc.put("application", defConfigModel.getAssistantCode());
        doc.put("version", defConfigModel.getVersion());
        doc.put("athena_namespace", defConfigModel.getAssistantCode());
        return doc;
    }

    private void processNeo4jData(JSONObject analysedDatas, String skillCode) {
        Object cypher = analysedDatas.getJSONObject(FILE_FOLDER_CYPHER);

        if (cypher != null) {
            JSONObject cypherData = (JSONObject) cypher;
            if (cypherData.get(skillCode) != null) {
                JSONObject skillCypherData = cypherData.getJSONObject(skillCode);

                pageService.pagePublish2KM(skillCypherData, originalCodeRelationShip, AsaConstant.DEPLOY_VERSION);
            }
        }
    }

    /**
     * 从mongodb清除原部署版本的数据
     */
    private void cleanMongoData() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("清理旧1.0版本的数据..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            // 先删除应用数据，如果先删除模板实例化数据，则此时应用可见但不可用
            Bson assistantFilter = Filters.and(Filters.eq("assistantCode", assistantCode), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
            for (String collectionName : DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(collectionName).deleteMany(assistantFilter);
            }

            Bson templateFilter = Filters.and(Filters.eq("application", application), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
            for (String collectionName : DB_COLLECTION.get(MONGODB_NAME_DATAMAP)) {
                kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(collectionName).deleteMany(templateFilter);
            }

            // knowledgegraphSystem.
            Bson kmAppFilter = Filters.and(Filters.eq("application", application), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
            for (String collectionName : DB_COLLECTION.get(MONGODB_NAME_KGSYS)) {
                kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(collectionName).deleteMany(kmAppFilter);
            }

            // preset
            Bson presetAppFilter = Filters.and(Filters.eq("application", application), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
            for (String collectionName : DB_COLLECTION.get(MONGODB_NAME_PRESET)) {
                presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(collectionName).deleteMany(presetAppFilter);
            }

            // Neo4j数据清理
            pageService.cleanPageDataFromKM(application, AsaConstant.DEPLOY_VERSION);

            try {
                // 纠正之前的错误数据，将冗余的数据删除
                List<ObjectId> cleanDocList = new ArrayList<>();

                Bson kmAppCleanFilter = Filters.and(Filters.eq("code", application));
                FindIterable<Document> applicationDocs = kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(AsaConstant.COLLECTION_NAME_APPLICATION).find(kmAppCleanFilter);
                applicationDocs.forEach((Consumer<? super Document>) doc -> {
                    if (StringUtils.isEmpty(doc.getString("version"))) {
                        cleanDocList.add((ObjectId) doc.get("_id"));
                    }
                });

                if (!cleanDocList.isEmpty()) {
                    Bson cleanFilter = Filters.and(Filters.in("_id", cleanDocList.toArray()));
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(AsaConstant.COLLECTION_NAME_APPLICATION).deleteMany(cleanFilter);
                }
            } catch (Exception ex) {
                log.error("clean redundancy data error.", ex);
            }

//            if (isCNaDeploy) {
//                cacheService.delete("ASSISTANT", assistantCode);
//            } else {
//                cacheService.delete("ASSISTANT", AsaConstant.DEPLOY_VERSION + assistantCode);
//            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Clean version 1.0 data error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void putData2Mongo(JSONObject analysedDatas,String env) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("应用数据入库..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            List<JSONObject> assistantDataList = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get("assistant");
            for (JSONObject assistantData : assistantDataList) {
                Document assistantDoc = Document.parse(assistantData.toJSONString());
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(AsaConstant.COLLECTION_NAME_ASSISTANT).insertOne(assistantDoc);
//                cacheAssistant(assistantDoc);
            }

            // 缓存所有的助理的accid
            // cacheAssistantAccid();

            List<JSONObject> assistantScenes = (List<JSONObject>) analysedDatas.getJSONObject(MONGODB_NAME_ASA).get("assistantScene");
            for (JSONObject assistantScene : assistantScenes) {
                String assistantCode = assistantScene.getString("assistantCode");
                //获取场景所属助理
                List<JSONObject> assistantCode1 = assistantDataList.stream().filter(item -> Objects.equals(assistantCode, item.getString("assistantCode"))).collect(Collectors.toList());
                //获取助理类型
                Integer assistantSubType = assistantCode1.get(0).getInteger("assistantSubType");
                String knowledgeType = assistantCode1.get(0).getString("knowledgeType");
                //知识类助理公有知识库 或者 综合类助理场景是知识类且是共有类知识库
                if ((Objects.equals(2,assistantSubType) && "public".equals(knowledgeType)) || (Objects.equals(2,assistantSubType) && Objects.equals("public",Objects.isNull(assistantScene.get("knowledgeBases")) ? "private" : ((List<JSONObject>) assistantScene.get("knowledgeBases")).get(0).getString("type"))) || (Objects.equals(4,assistantSubType) && Objects.equals(2,assistantScene.getInteger("type")) && Objects.equals("public",Objects.isNull(assistantScene.get("knowledgeBases")) ? "private" : ((List<JSONObject>) assistantScene.get("knowledgeBases")).get(0).getString("type")))){
                    List<JSONObject> knowledgeBases = (List<JSONObject>) assistantScene.get("knowledgeBases");
                    if (CollectionUtils.isEmpty(knowledgeBases)){
                        log.error("符合发布环境的知识库配置为空，请重新配置");
                        deployDetail.setResult(AsaConstant.DEPLOY_FAIL);
                        throw new BusinessException("符合发布环境的知识库配置为空，请重新配置");
                    }
                    //获取所属环境的知识库配置
                    List<JSONObject> knowledgeBasesAccordingEnv = knowledgeBases.stream().filter(item -> env.equals(item.getString("env"))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(knowledgeBasesAccordingEnv)) {
                        log.error("符合发布环境的知识库配置为空，请重新配置");
                        deployDetail.setResult(AsaConstant.DEPLOY_FAIL);
                        throw new BusinessException("符合发布环境的知识库配置为空，请重新配置");
                    }
                    JSONObject jsonObject = knowledgeBasesAccordingEnv.get(0);
                    assistantScene.remove("knowledgeBase");
                    assistantScene.remove("publicIdentity");
                    JSONObject knowledgeBaseForAsa = new JSONObject();
                    knowledgeBaseForAsa.fluentPut("historyNum",jsonObject.getInteger("historyNum"));
                    knowledgeBaseForAsa.fluentPut("type",jsonObject.getString("type"));
                    knowledgeBaseForAsa.fluentPut("assistantCode",jsonObject.getString("assistantCode"));
                    knowledgeBaseForAsa.fluentPut("defaultKBS",Objects.isNull(jsonObject.getBooleanValue("defaultKBS")) ? false : jsonObject.getBooleanValue("defaultKBS"));
                    assistantScene.fluentPut("knowledgeBase",knowledgeBaseForAsa);
                    JSONObject publicIdentityForAsa = new JSONObject();
                    publicIdentityForAsa.fluentPut("tenantId",jsonObject.getString("tenantId"));
                    assistantScene.fluentPut("publicIdentity",publicIdentityForAsa);
                    assistantScene.remove("knowledgeBases");
                }
                List<JSONObject> assistantSceneItemSteps = (List<JSONObject>) assistantScene.get("assistantSceneItemStep");
                // 开发态和运行态Scene数据结构不同，运行态结构中不包含ItemStep数据
                assistantScene.remove("assistantSceneItemStep");
                Document assistantSceneDoc = Document.parse(assistantScene.toJSONString());
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE).insertOne(assistantSceneDoc);

                for (JSONObject assistantSceneItemStep : assistantSceneItemSteps) {
                    Document assistantSceneItemStepDoc = Document.parse(assistantSceneItemStep.toJSONString());
                    mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(AsaConstant.COLLECTION_NAME_ASSISTANT_SCENE_ITEM_STEP).insertOne(assistantSceneItemStepDoc);
                }
            }
            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Put deploy data to db error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    /**
     * 从DMC下载编译后的文件
     *
     * @param shareUrl 共享地址（支持跨区访问）
     * @param destFile 本地文件
     */
    private void downloadFileFromDmc(String shareUrl, File destFile) {
        InputStream inputStream = dmcService.downloadByUrl(shareUrl);
        FileUtil.writeFromStream(inputStream, destFile);
    }

    /**
     * 应用部署之后的关系数据处理
     */
    protected void doAfterDataProcess() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("处理关系数据..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            //初始化AppEntity的version字段
            appEntityService.initAppEntityVersion(application, AsaConstant.DEPLOY_VERSION);

            if (!isCNaDeploy) {
                this.switchVersion();
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Do after deploy error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    /**
     * @description: 切换租户和应用数据之间的version
     * @author lixy
     * @date 2024/06/12 16:29
     */
    private void switchVersion() {
        //查询发版前租户版本，供后续判断版本是否有变更
        Map<String, String> deployTenantVersion = tenantService.getTenantVersion(tenantIdList);
        //租户不存在则创建
        tenantService.createTenants(tenantIdList, AsaConstant.DEPLOY_VERSION);

        //找出与当前发布的应用有关联关系的非发布租户的测试版本租户id，这些租户需重新关联与1.0开发成果的关系
        List<String> authAppTenantIdList = tenantService.getAuthAppTenantIdList(application, AsaConstant.DEPLOY_VERSION, tenantIdList);
        //更新发布租户版本及租户与1.0开发成果的关系
        tenantService.updateTenantVersion(tenantIdList, application, AsaConstant.DEPLOY_VERSION);

        //非发布且已关联的测试版本租户和发布应用数据建立relation
        tenantService.createRelation(application, AsaConstant.DEPLOY_VERSION, AsaConstant.DEPLOY_VERSION, authAppTenantIdList);

        List<String> vChangeTenantIdList = new ArrayList<>();
        // 处理发版时租户版本变更与应用数据关系的变更
        for (String tenantId : tenantIdList) {
            if (StringUtils.isEmpty(deployTenantVersion.get(tenantId))) {
                // 没有对应的version说明租户是在发版时新加的租户,跳过
                continue;
            }
            if (!AsaConstant.DEPLOY_VERSION.equals(deployTenantVersion.get(tenantId))) {
                vChangeTenantIdList.add(tenantId);
                // 查询租户相关的非公共类型应用的code
                Set<String> appCodeList = tenantService.getNotCommonAppCodeRelaToTenantId(tenantId);
                // 租户变更版本后需要重新关联租户和除当前发布应用外的其他应用的数据关系
                appCodeList.remove(application);
                tenantService.createOneTenantAndMoreAppRelation(appCodeList, AsaConstant.DEPLOY_VERSION, AsaConstant.DEPLOY_VERSION, tenantId);
            }
        }
        if (!vChangeTenantIdList.isEmpty()) {
            tenantService.modifyTenantRelaWithNotMatchAppDataInPublish(AsaConstant.DEPLOY_VERSION, AsaConstant.COMMERCIAL_VERSION, vChangeTenantIdList);
        }
    }

    protected void doProcess4ProdAndAuth() {
        if (!isCNaDeploy) {
            super.iamAuthorizationInSwitch(deployVersionParam);
        }
    }

    private void deployllm(String projectCode, String llmPromptId, String deployMode) {
        Map map = new HashMap();
        map.put("project_name", projectCode);
        map.put("mode", "intent");
        assistantRhApiHelper.llmDeployer(map, llmPromptId, deployMode, curTenantToken);
    }

    private List<Map> constructRh(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            Map map = new HashMap();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            return map;
        }).collect(Collectors.toList());
    }

    private String addLlmPrompt(List<JSONObject> projectDataList, DeployVersionParam deployVersionParam, List<JSONObject> modelDataList, List<JSONObject> utterancesDataList) {
        Document assistantProject = null;
        for (JSONObject projectData : projectDataList) {
            Document projectDoc = Document.parse(projectData.toJSONString());
            if (projectDoc.getString("projectCode").equals(deployVersionParam.getModelInfo().getString("projectCode"))) {
                assistantProject = projectDoc;
                break;
            }
        }

        if (assistantProject == null) {
            throw new BusinessException("创建提示词失败");
        }

        BasicInfoDto basicInfoDto = new BasicInfoDto();
        basicInfoDto.setNickname(assistantProject.getList("nickname", String.class));
        basicInfoDto.setProject_name(assistantProject.getString("projectCode"));
        basicInfoDto.setAssistant_id(assistantProject.getString("assistantCode"));
        Document assistantProjectModel = null;
        for (JSONObject modelData : modelDataList) {
            Document modelDoc = Document.parse(modelData.toJSONString());
            if (modelDoc.getString("modelCode").equals(deployVersionParam.getModelInfo().getString("modelCode"))) {
                assistantProjectModel = modelDoc;
                break;
            }
        }
        AssistantProjectModel assistantProjectModel1 = JSON.parseObject(JSON.toJSONString(assistantProjectModel), AssistantProjectModel.class);
        List<Map> intent_definition = assistantProjectModel1.constructIntentDefinition();
        List<AssistantModelCorpus> assistantModelCorpuses = JSON.parseArray(JSON.toJSONString(utterancesDataList), AssistantModelCorpus.class);
        List<AssistantModelCorpus> example = assistantModelCorpuses.stream().filter(item -> Objects.equals(1, item.getCorpusType())).collect(Collectors.toList());
        List<AssistantModelCorpus> ng = assistantModelCorpuses.stream().filter(item -> Objects.equals(5, item.getCorpusType())).collect(Collectors.toList());
        JSONObject result = assistantRhApiHelper.addLlmPrompt(basicInfoDto, intent_definition, constructRh(example), curTenantToken, constructRh(ng), assistantProjectModel1.getIntroduction());
        String llmPromptId = result.getOrDefault("llm_prompt_id", "").toString();
        return llmPromptId;
    }

    private String addLlmPromptWithoutModel(List<JSONObject> assistantSceneList, String curTenantToken, JSONObject assistantData) {
        BasicInfoDto basicInfoDto = new BasicInfoDto();
        basicInfoDto.setNickname(ListUtil.toList("娜娜", "AI助理", assistantData.getString("name")));
        basicInfoDto.setProject_name(application);
        basicInfoDto.setAssistant_id(application);
        List<Map> intent_definition = new ArrayList<>();
        List<Map> mapExample = new ArrayList<>();

        for (JSONObject assistantScene : assistantSceneList) {
            Map intentDef = new HashMap();
            intentDef.put("intent", assistantScene.getString("name"));
            intentDef.put("definition", assistantScene.getString("description"));
            intentDef.put("create", "O");
            intentDef.put("read", "X");
            intentDef.put("update", "X");
            intentDef.put("delete", "X");
            intent_definition.add(intentDef);

            if (null != assistantScene.get("inspirationPhrase")) {
                for (String string : JSON.parseArray(JSON.toJSONString(assistantScene.get("inspirationPhrase")), String.class)) {
                    Map exampleMap = new HashMap();
                    exampleMap.put("intent", assistantScene.getString("name"));
                    exampleMap.put("utterances", string);
                    mapExample.add(exampleMap);
                }
            } else {
                Map exampleMap = new HashMap();
                exampleMap.put("intent", assistantScene.getString("name"));
                exampleMap.put("utterances", assistantScene.getString("description"));
                mapExample.add(exampleMap);
            }
        }

        JSONObject result = assistantRhApiHelper.addLlmPrompt(basicInfoDto, intent_definition, mapExample, curTenantToken, new ArrayList<>(), assistantData.getString("description"));
        String llmPromptId = result.getOrDefault("llm_prompt_id", "").toString();
        return llmPromptId;
    }
}
