package com.digiwin.athena.km_deployer_service.thread;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.deploy.DeployDetail;
import com.digiwin.athena.km_deployer_service.domain.asa.enent.DeployEvent;
import com.digiwin.athena.km_deployer_service.domain.asa.param.SwitchVersionParam;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.util.CurThreadInfoUtils;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

/**
 * 切版线程
 */
@Slf4j
@Data
public class SwitchVersionThread extends AbstructVersionThread {
    private static final String MONGODB_NAME_ASA = "asa";

    // 废弃版本
    private static final String ABANDON_VERSION = "0.0";

    private SwitchVersionParam switchVersionParam;

    private String betaAssistantCode;

    private String curTenantToken;

    private JSONObject aiProject;

    public SwitchVersionThread(SwitchVersionParam switchVersionParam) {
        this.switchVersionParam = switchVersionParam;
        this.parentThreadId = switchVersionParam.getThreadId();
        this.deployNo = switchVersionParam.getDeployNo();
    }

    @Override
    public void run() {
        CurThreadInfoUtils.setRouterKey(routerKey);

        application = switchVersionParam.getApplication();
        tenantIdList = switchVersionParam.getTenantIdList().toJavaList(String.class);
        currentUser = switchVersionParam.getCurrentUser();
        currentTenantId = currentUser.getTenantId();

        log.info("开始切版{}:{}", application, parentThreadId);

        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("切换娜娜版本..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        curTenantToken = tenantService.getRealTimeTenantToken(currentTenantId);

        // 初始化额外变量
        this.initExtraVariable();

        // 将已有的2.0版本数据废弃
        this.switchCommercial2Abandon();

        if (!isSkipGPT) {
            this.doGPTDeploy();
        }

        // 将1.0版本更新成2.0版本
        this.switchBeta2Publish();

        // 通过2.0版本构建新的1.0版本
        this.constructBetaFromPublish();

        try {
            aniaHelper.deployerCache(curTenantToken, isCNaDeploy, false, assistantCode);
        } catch (Exception e) {
            log.error("更新助理缓存error. ", e);
        }

        // 删除废弃的0.0版本数据，0.0版本用于异常回滚备用，保证助理一旦上线有，之后始终处于可用状态，目前尚未设计支持回滚
        this.cleanAbandon();

        this.doAfterDataProcess();

        this.doProcess4ProdAndAuth();

        // 重置km/atmc缓存
        this.resetCache(curTenantToken);

        log.info("切版完成:{}", parentThreadId);

        deployDetail.setResult(AsaConstant.DEPLOY_FINISH);
        long mills = calculateExecuteMills(deployDetail.getTime());
        deployDetail.setTime(new Date()).setExecuteTimeMills(mills);
        deployEvent.setMsg("process:" + JSON.toJSONString(deployDetail));
        deployEvent.setComplete(true);
        applicationContext.publishEvent(deployEvent);
    }

    private void doGPTDeploy() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("GPT部署..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            Bson assistantFindFilterBson = Filters.and(Filters.eq("assistantCode", betaAssistantCode), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
            FindIterable<Document> assistantDoc = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(("assistant")).find(assistantFindFilterBson);
            Document assistant = assistantDoc.first();

            aiProject = Objects.isNull(assistant.get("aiProject")) ? null : JSON.parseObject(JSON.toJSONString(assistant.get("aiProject")), JSONObject.class);

            if (aiProject != null) {
                this.deployllm(application, aiProject.getString("llmPromptId"));

                //是否需要调用小模型
                List<Integer> modelTypes = aiProject.getObject("modelTypes", List.class);
                if (modelTypes.contains(MODEL_TYPE_NLU)) {
                    this.tagDeployer(application, aiProject.getString("modelCode"));
                }

                if (modelTypes.contains(MODEL_TYPE_ES)) {
                    this.esDeployer();
                }
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("GPT部署异常:", e);
            this.setWarnDeployDetail(deployDetail, e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    /**
     * 调用小模型
     */
    private void tagDeployer(String projectCode, String modelCode) {
        Map projectName = new HashMap();
        projectName.put("project_name", projectCode);
        StringBuilder stringBuilder = new StringBuilder("deploy_");
        String createMode = "model_1";
        stringBuilder.append(createMode.replace("_", "")).append("_").append(modelCode);
        assistantRhApiHelper.tagDeployer(createMode, projectName, AI_DEPLOY_MODE_PROD, stringBuilder.toString(), curTenantToken);
        createMode = "model_2";
        assistantRhApiHelper.tagDeployer(createMode, projectName, AI_DEPLOY_MODE_PROD, stringBuilder.toString().replaceFirst("model1", "model2"), curTenantToken);
    }

    private void esDeployer() {
        assistantRhApiHelper.esDeployer(application, AI_DEPLOY_MODE_TEST, AI_DEPLOY_MODE_PROD, curTenantToken);
    }

    private void deployllm(String projectCode, String llmPromptId) {
        Map map = new HashMap();
        map.put("project_name", projectCode);
        map.put("mode", "intent");
        assistantRhApiHelper.llmDeployer(map, llmPromptId, AI_DEPLOY_MODE_PROD, curTenantToken);
    }

    private void initExtraVariable() {
        Bson assistantFindFilterBson = Filters.and(Filters.eq("assistantCode", application), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
        FindIterable<Document> assistantDoc = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(("assistant")).find(assistantFindFilterBson);
        Document assistant = assistantDoc.first();

        // C娜助理的1.0版本Code有beta后缀，如果用application直接查询不到，则执行切版的必然是C娜助理
        if (assistant == null) {
            isCNaDeploy = true;
            betaAssistantCode = application + "_beta";
        } else {
            // B娜助理
            betaAssistantCode = application;

            assistatnSubType = assistant.getInteger("appSubType");
            if (ASSISTANT_SUB_TYPE_KNOWLEDGE.equals(assistatnSubType)) {
                isSkipTemplate = true;
                isSkipGPT = true;
            }
        }
    }

    private void switchCommercial2Abandon() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("将2.0应用数据废弃..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            // 先废弃应用数据
            Bson assistantFilterBson = Filters.and(Filters.eq("assistantCode", application), Filters.eq("version", AsaConstant.COMMERCIAL_VERSION));
            Bson assistantUpdateBson = new Document("$set", new Document().append("version", ABANDON_VERSION));
            for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).updateMany(assistantFilterBson, assistantUpdateBson);
            }

            if (!isSkipTemplate) {
                // 再废弃模板实例化数据
                Bson templateFilterBson = Filters.and(Filters.eq("application", application), Filters.eq("version", AsaConstant.COMMERCIAL_VERSION));
                Bson templateUpdateBson = new Document("$set", new Document().append("version", ABANDON_VERSION));
                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_DATAMAP)) {
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(colllectionName).updateMany(templateFilterBson, templateUpdateBson);
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_PRESET)) {
                    presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(colllectionName).updateMany(templateFilterBson, templateUpdateBson);
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_KGSYS)) {
                    kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(colllectionName).updateMany(templateFilterBson, templateUpdateBson);
                }

                // neo4j的数据，暂时不做abandon的处理，直接删除
                pageService.cleanPageDataFromKM(application, AsaConstant.COMMERCIAL_VERSION);
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Update version 2.0 to 0.0 error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void switchBeta2Publish() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("更新2.0应用数据..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            // 1.0版本发布成2.0版本后
            if (!isSkipTemplate) {
                // 先切换模板实例化数据
                Bson templateFilterBson = Filters.and(Filters.eq("application", application), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
                Bson templateUpdateBson = new Document("$set", new Document().append("version", AsaConstant.COMMERCIAL_VERSION));
                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_DATAMAP)) {
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(colllectionName).updateMany(templateFilterBson, templateUpdateBson);
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_PRESET)) {
                    presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(colllectionName).updateMany(templateFilterBson, templateUpdateBson);
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_KGSYS)) {
                    kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(colllectionName).updateMany(templateFilterBson, templateUpdateBson);
                }

                this.pageService.updatePageDataVersion(application, AsaConstant.DEPLOY_VERSION, AsaConstant.COMMERCIAL_VERSION);
            }

            // 再切换应用数据
            Bson assistantFilterBson = Filters.and(Filters.eq("assistantCode", betaAssistantCode), Filters.eq("version", AsaConstant.DEPLOY_VERSION));
            String accId = imApiHelper.queryAccId(application, curTenantToken).getString("accid");
            Bson assistantUpdateBson = new Document("$set", new Document().append("version", AsaConstant.COMMERCIAL_VERSION).append("assistantCode", application));
            for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                if (AsaConstant.COLLECTION_NAME_ASSISTANT.equals(colllectionName)) {
                    if (isCNaDeploy) {
                        if (aiProject != null) {
                            assistantUpdateBson = new Document("$set", new Document().append("version", AsaConstant.COMMERCIAL_VERSION).append("assistantCode", application).append("accid", accId).append("aiProject.modelTag", "prod").append("tenantId", "asa"));
                        } else {
                            assistantUpdateBson = new Document("$set", new Document().append("version", AsaConstant.COMMERCIAL_VERSION).append("assistantCode", application).append("accid", accId).append("tenantId", "asa"));
                        }
                    } else {
                        if (aiProject != null) {
                            assistantUpdateBson = new Document("$set", new Document().append("version", AsaConstant.COMMERCIAL_VERSION).append("assistantCode", application).append("accid", accId).append("aiProject.modelTag", "prod"));
                        } else {
                            assistantUpdateBson = new Document("$set", new Document().append("version", AsaConstant.COMMERCIAL_VERSION).append("assistantCode", application).append("accid", accId));
                        }
                    }
                }

                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).updateMany(assistantFilterBson, assistantUpdateBson);

//                if (AsaConstant.COLLECTION_NAME_ASSISTANT.equals(colllectionName)) {
//                    Bson assistantFindFilterBson = Filters.and(Filters.eq("assistantCode", application), Filters.eq("version", AsaConstant.COMMERCIAL_VERSION));
//                    FindIterable<Document> assistantDocs = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).find(assistantFindFilterBson);
//                    cacheAssistant(assistantDocs.first());
//                }

                // 缓存所有的助理的accid
                // cacheAssistantAccid();
            }

            Bson assistantSceneFilterBson = Filters.and(Filters.eq("assistantCode", application), Filters.eq("version", AsaConstant.COMMERCIAL_VERSION));
            FindIterable<Document> assistantSceneDocs = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection("assistantScene").find(assistantSceneFilterBson);

            assistantSceneDocs.forEach((Consumer<? super Document>) doc -> {
                assistantSceneList.add(JSON.parseObject(JSON.toJSONString(doc), JSONObject.class));
            });

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Update version 1.0 to 2.0 error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void constructBetaFromPublish() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("恢复1.0应用数据..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);
        try {
            if (!isSkipTemplate) {
                // 先构建模板实例化数据
                FindIterable<Document> templateDoc;
                Bson templateFilterBson = Filters.and(Filters.eq("application", application), Filters.eq("version", AsaConstant.COMMERCIAL_VERSION));
                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_DATAMAP)) {
                    List<Document> tempalteDocList = new ArrayList<>();
                    templateDoc = kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(colllectionName).find(templateFilterBson);
                    templateDoc.forEach((Consumer<? super Document>) doc -> {
                        doc.remove("_id");
                        doc.put("version", AsaConstant.DEPLOY_VERSION);
                        tempalteDocList.add(doc);
                    });
                    if (!tempalteDocList.isEmpty()) {
                        kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(colllectionName).insertMany(tempalteDocList);
                    }
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_PRESET)) {
                    List<Document> tempalteDocList = new ArrayList<>();
                    templateDoc = presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(colllectionName).find(templateFilterBson);
                    templateDoc.forEach((Consumer<? super Document>) doc -> {
                        doc.remove("_id");
                        doc.put("version", AsaConstant.DEPLOY_VERSION);
                        tempalteDocList.add(doc);
                    });
                    if (!tempalteDocList.isEmpty()) {
                        presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(colllectionName).insertMany(tempalteDocList);
                    }
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_KGSYS)) {
                    List<Document> tempalteDocList = new ArrayList<>();
                    templateDoc = kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(colllectionName).find(templateFilterBson);
                    templateDoc.forEach((Consumer<? super Document>) doc -> {
                        doc.remove("_id");
                        doc.put("version", AsaConstant.DEPLOY_VERSION);
                        tempalteDocList.add(doc);
                    });
                    if (!tempalteDocList.isEmpty()) {
                        kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(colllectionName).insertMany(tempalteDocList);
                    }
                }

                this.pageService.createNewPageData(application, AsaConstant.COMMERCIAL_VERSION, AsaConstant.DEPLOY_VERSION);
            }

            // 再构建助理应用的数据
            FindIterable<Document> assistantDocs;
            Bson assistantFilterBson = Filters.and(Filters.eq("assistantCode", application), Filters.eq("version", AsaConstant.COMMERCIAL_VERSION));
            for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                List<Document> assistantDocList = new ArrayList<>();
                assistantDocs = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).find(assistantFilterBson);
                assistantDocs.forEach((Consumer<? super Document>) doc -> {
                    doc.remove("_id");
                    doc.put("version", AsaConstant.DEPLOY_VERSION);
                    doc.put("assistantCode", betaAssistantCode);

                    if ("assistant".equalsIgnoreCase(colllectionName)) {
                        doc.put("tenantId", currentTenantId);
                        String accId = imApiHelper.queryAccId(betaAssistantCode, curTenantToken).getString("accid");
                        doc.put("accid", accId);
                    }

                    assistantDocList.add(doc);
                });

                if (!assistantDocList.isEmpty()) {
                    mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).insertMany(assistantDocList);

//                    if ("assistant".equals(colllectionName)) {
//                        cacheAssistant(assistantDocList.get(0));
//                    }
                }
            }
            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Insert version 1.0 from 2.0 error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void cleanAbandon() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("清理0.0应用数据..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            // 先清理助理应用的数据
            Bson assistantFilterBson = Filters.and(Filters.eq("assistantCode", application), Filters.eq("version", ABANDON_VERSION));
            for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).deleteMany(assistantFilterBson);
            }

            if (!isSkipTemplate) {
                // 再清理模板实例化的数据
                Bson templateFilterBson = Filters.and(Filters.eq("application", application), Filters.eq("version", ABANDON_VERSION));
                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_DATAMAP)) {
                    kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(datamapDBName).getCollection(colllectionName).deleteMany(templateFilterBson);
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_PRESET)) {
                    presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(presetDBName).getCollection(colllectionName).deleteMany(templateFilterBson);
                }

                for (String colllectionName : DB_COLLECTION.get(MONGODB_NAME_KGSYS)) {
                    kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(kgsysDBName).getCollection(colllectionName).deleteMany(templateFilterBson);
                }
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Clean version 0.0 data error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    protected void doAfterDataProcess() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(deployNo).setTime(new Date()).setContent("处理关系数据..").setResult(AsaConstant.DEPLOY_START).setApplication(application);
        DeployEvent deployEvent = new DeployEvent(this, parentThreadId, "process:" + JSON.toJSONString(deployDetail));
        applicationContext.publishEvent(deployEvent);

        try {
            if (!isCNaDeploy) {
                Map<String, String> tenantVersionMap = tenantService.getTenantVersion(tenantIdList);

                //租户不存在则创建
                tenantService.createTenants(tenantIdList, AsaConstant.COMMERCIAL_VERSION);

                //找出与当前切板的应用有关联关系的非发布租户的正式版本租户id，这些租户需关联与1.0开发成果的关系，供后续切换时不断开
                List<String> authAppTenantIdList = tenantService.getAuthAppTenantIdList(application, AsaConstant.COMMERCIAL_VERSION, new ArrayList<>());
                //非发布且已关联的正式版本租户和发布应用测试数据建立relation
                tenantService.createRelation(application, AsaConstant.COMMERCIAL_VERSION, AsaConstant.COMMERCIAL_VERSION, authAppTenantIdList);

                //更新应用成果至2.0
                tenantService.updateAppDataVersion(application, AsaConstant.DEPLOY_VERSION, AsaConstant.COMMERCIAL_VERSION, tenantIdList);

                //复制应用成果至1.0
                tenantService.copyAppVersionData(application, AsaConstant.COMMERCIAL_VERSION, AsaConstant.DEPLOY_VERSION);

                //找出与当前切板的应用有关联关系的非发布租户的正式版本租户id，这些租户需关联与1.0开发成果的关系，供后续切换时不断开
                List<String> authAppTestTenantIdList = tenantService.getAuthAppTenantIdList(application, AsaConstant.DEPLOY_VERSION, tenantIdList);
                //非发布且已关联的正式版本租户和发布应用测试数据建立relation
                tenantService.createRelation(application, AsaConstant.DEPLOY_VERSION, AsaConstant.DEPLOY_VERSION, authAppTestTenantIdList);

                List<String> vChangeTenantIdList = new ArrayList<>();
                // 处理切版时租户版本变更与应用数据关系的变更
                for (String tenantId : tenantIdList) {
                    if (StringUtils.isEmpty(tenantVersionMap.get(tenantId))) {
                        // 没有对应的version说明租户是在发版时新加的租户,跳过
                        continue;
                    }
                    if (!AsaConstant.COMMERCIAL_VERSION.equals(tenantVersionMap.get(tenantId))) {
                        vChangeTenantIdList.add(tenantId);
                        // 查询租户相关的非公共类型应用的code
                        Set<String> appCodeList = tenantService.getNotCommonAppCodeRelaToTenantId(tenantId);
                        // 租户变更版本后需要重新关联租户和除当前发布应用外的其他应用的数据关系
                        appCodeList.remove(application);
                        tenantService.createOneTenantAndMoreAppRelation(appCodeList, AsaConstant.COMMERCIAL_VERSION, AsaConstant.COMMERCIAL_VERSION, tenantId);
                    }
                }

                if (!vChangeTenantIdList.isEmpty()) {
                    tenantService.modifyTenantRelaWithNotMatchAppDataInPublish(AsaConstant.COMMERCIAL_VERSION, AsaConstant.DEPLOY_VERSION, vChangeTenantIdList);
                }
            }

            deployDetail.setResult(AsaConstant.DEPLOY_SUCCESS);
        } catch (Exception e) {
            log.error("Do after switch error. ", e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException(e);
        } finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    protected void doProcess4ProdAndAuth() {
        if (!isCNaDeploy) {
            super.iamAuthorizationInSwitch(switchVersionParam);
        }
    }
}
