package com.digiwin.athena.km_deployer_service.util;

import com.alibaba.fastjson.JSON;
import lombok.extern.log4j.Log4j2;
import sun.misc.IOUtils;

import java.io.IOException;
import java.io.InputStream;

@Log4j2
public class FileUtils {
    public static <T> T readObjectFromFilePath(String filePath, Class<T> clazz) {
        byte[] bytes = new byte[0];
        try (InputStream in = FileUtils.class.getClassLoader().getResourceAsStream(filePath)) {
            bytes = IOUtils.readFully(in, -1, false);
        } catch (IOException e) {
            log.error("获取{}数据失败 fail.msg = {}", filePath, e.getMessage());
        }
        return JSON.parseObject(new String(bytes), clazz);
    }
}
