package com.digiwin.athena.km_deployer_service.util;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description
 * @Author cai chao
 * @Date 2024/11/1 09:01
 */
@Slf4j
@UtilityClass
public class IdSnowflake {
    private static String workerId = NetUtil.getLocalhostStr().substring(NetUtil.getLocalhostStr().length() - 1);
    private static Snowflake snowflake;

    static {
        snowflake = IdUtil.getSnowflake(Long.parseLong(workerId), Long.parseLong(workerId));
    }

    public synchronized long snowflakeId() {
        return snowflake.nextId();
    }

    public synchronized String snowflakeIdStr() {
        return snowflake.nextIdStr();
    }

    public synchronized String snowflakeIdStr(String prefix) {
        return prefix + snowflake.nextIdStr();
    }
}

