package com.digiwin.athena.km_deployer_service.util;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author liyuetao
 * @title: MongoHelper
 * @projectName athena_deployer_service
 * @description: TODO
 * @date 2022/11/216:10
 */
@Component
@Slf4j
public class MongoHelper {

    @Autowired
    private MongoTemplate mongoTemplate;

    /**
     * 　@description: 先删除再更新，应用场景：先删除老的2.0版本的数据，再将1.0版本的数据更新成新的2.0版本的数据
     * 　@author liyuetao
     * 　@date 2022/11/2 16:13
     */
    public void deleteAndUpdate(List<JSONObject> dbAndCollectionList, Bson findFilter, Bson deleteFilter, Bson update) {
        for (JSONObject dbAndCollection : dbAndCollectionList) {
            ((List<String>) dbAndCollection.get("collectionName")).forEach(collection -> {
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String) dbAndCollection.get("dbName")).getCollection(collection).deleteMany(deleteFilter);
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase((String) dbAndCollection.get("dbName")).getCollection(collection).updateMany(findFilter, update);
            });
        }
    }
}
