package com.digiwin.athena.km_deployer_service.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.digiwin.athena.deploy.DeployReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyPair;

public class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);


    /*
MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAIU7AmMZ/Lc8Dtp4cqwN+dyiA2mE4J+LKvDbBr/QdtN5b0s/U5I0i8jKLCPZmOSKaB/XFBM+5Vzy0UljurMKzrfFehFqPnDMb9tdgwSJ1m6M7xRTZi+V/KSY+AXInNqElORreM/VK8mHgx3sXsPAJzu/3e7Jki9ihEkEXhvt8NbzAgMBAAECgYABnbyirR8GrgDUH5/sfGLqjUCTWBxNcye7Mjz7uLCoUhHKjOMbo+2KKwGsEaisJQ2sTTSeIyYvIXbud/o8z8XAKncC0c3fXODqSyFeq16SR3Wp7WV75Qw2MO7GKVuXXP6nnCEHAMBj1Q6E6ubgxoZk+pLYkmCxqqoBa4FL+b8ReQJBALo7awviptMck/zHUyrp8J/Mx6H9nElLOKDzvvTd5pFMALd/qbyyJWsh5ilC8XHk+FwmaCvAE4jAe/MoZeOCGA0CQQC3JHmrGMGuh2OzRt3ke0GzMKphGEzt/LIe/c5aGtD7+ShcgKxyMK2gnR7U4ptvDKWdF3BTWalrvfpOe8FMG+r/AkA5cZCAVwYsQjlnlDgUGZruP6UoU2j8tqYeB3FUaInxMWdbMpaxrKWcGRW8jniZMA5npjUloZak7PKOu1xKQ9uVAkB+M7Nn1Mp6oy9v9dCoRstyWIHAIMe6Y5y2wH03GC2UxRAsFjs/AQ5UlJEPcAxeDN//DYzI0wtthF99P8hm0wIvAkEAlBEvS2hZw8vlmw0bJ6IrHhulNq8g0C8F64Jg164fWsuvRFFqkchwBephrzuFq23w4Sm/P0UgnV1XvCRrClcVug==
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCFOwJjGfy3PA7aeHKsDfncogNphOCfiyrw2wa/0HbTeW9LP1OSNIvIyiwj2Zjkimgf1xQTPuVc8tFJY7qzCs63xXoRaj5wzG/bXYMEidZujO8UU2YvlfykmPgFyJzahJTka3jP1SvJh4Md7F7DwCc7v93uyZIvYoRJBF4b7fDW8wIDAQAB

     */

    public static void genKeyPair(){
        KeyPair keyPair = KeyUtil.generateKeyPair("RSA");
        String privateKey = Base64.encode(keyPair.getPrivate().getEncoded());
        String publicKey = Base64.encode(keyPair.getPublic().getEncoded());
        System.out.println(privateKey);
        System.out.println(publicKey);
    }


    public static String sign(DeployReq request,String publicKey){
        String content = request.getDeployId()+request.getNonce()+request.getTimestamp();
        String sign =sign(content,publicKey);
        request.setSignature(sign);
        return sign;
    }
    public static boolean checkSign(DeployReq request, String privateKey){
        try {
            String content1 = request.getDeployId()+request.getNonce()+request.getTimestamp();
            String content2 = checkSign(request.getSignature(),privateKey);
            if(content1.equals(content2) && System.currentTimeMillis() <= request.getTimestamp() ){
                return true;
            }
        }catch (Exception e){
            log.error("check sign error",e);
        }
        //todo 临时返回tue
        return true;
    }

    public static String sign(String content,String publicKey){
        RSA rsa = SecureUtil.rsa(null,publicKey);
        String kmsign =rsa.encryptBase64(content, KeyType.PublicKey);
        return kmsign;
    }

    public static String checkSign(String sign,String privateKey){
        RSA rsa2 = SecureUtil.rsa(privateKey,null);
        String content =rsa2.decryptStr(sign,KeyType.PrivateKey);
        return content;
    }


    public static void main(String[] args) {
      //  genKeyPair();
        String privateKey="MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAIU7AmMZ/Lc8Dtp4cqwN+dyiA2mE4J+LKvDbBr/QdtN5b0s/U5I0i8jKLCPZmOSKaB/XFBM+5Vzy0UljurMKzrfFehFqPnDMb9tdgwSJ1m6M7xRTZi+V/KSY+AXInNqElORreM/VK8mHgx3sXsPAJzu/3e7Jki9ihEkEXhvt8NbzAgMBAAECgYABnbyirR8GrgDUH5/sfGLqjUCTWBxNcye7Mjz7uLCoUhHKjOMbo+2KKwGsEaisJQ2sTTSeIyYvIXbud/o8z8XAKncC0c3fXODqSyFeq16SR3Wp7WV75Qw2MO7GKVuXXP6nnCEHAMBj1Q6E6ubgxoZk+pLYkmCxqqoBa4FL+b8ReQJBALo7awviptMck/zHUyrp8J/Mx6H9nElLOKDzvvTd5pFMALd/qbyyJWsh5ilC8XHk+FwmaCvAE4jAe/MoZeOCGA0CQQC3JHmrGMGuh2OzRt3ke0GzMKphGEzt/LIe/c5aGtD7+ShcgKxyMK2gnR7U4ptvDKWdF3BTWalrvfpOe8FMG+r/AkA5cZCAVwYsQjlnlDgUGZruP6UoU2j8tqYeB3FUaInxMWdbMpaxrKWcGRW8jniZMA5npjUloZak7PKOu1xKQ9uVAkB+M7Nn1Mp6oy9v9dCoRstyWIHAIMe6Y5y2wH03GC2UxRAsFjs/AQ5UlJEPcAxeDN//DYzI0wtthF99P8hm0wIvAkEAlBEvS2hZw8vlmw0bJ6IrHhulNq8g0C8F64Jg164fWsuvRFFqkchwBephrzuFq23w4Sm/P0UgnV1XvCRrClcVug==";
        String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCFOwJjGfy3PA7aeHKsDfncogNphOCfiyrw2wa/0HbTeW9LP1OSNIvIyiwj2Zjkimgf1xQTPuVc8tFJY7qzCs63xXoRaj5wzG/bXYMEidZujO8UU2YvlfykmPgFyJzahJTka3jP1SvJh4Md7F7DwCc7v93uyZIvYoRJBF4b7fDW8wIDAQAB";


        DeployReq request = new DeployReq();
        request.setDeployId("Mf344-7e2e_813fca3a68cb404f8733ce8606beae98");
        request.setNonce("1234");
        request.setTimestamp(System.currentTimeMillis()+365*24*60*60*1000L);
        String sign =sign(request,publicKey);
        System.out.println(request.getTimestamp());
        System.out.println(sign);

        boolean check = checkSign(request,privateKey);
        System.out.println(check);



//        DeployReq req2 = new DeployReq();
//        req2.setSignature("grhCXCvkdEEUnEWj9y9TIGKeOOOAuE5CrxKCI3zZmyJmdkNSkHLq2AE0o4mpVkXLsay4davjBgdWFlSMshtn9KGdE5+GjKrnO9xy3Q1Gqy7yU3PLEpck+WeOP471g17PB+RtbdyU71U+Ox9z7iIV7tUwVAwPN8mdbLphbsSPpsE=");
//        req2.setNonce("1234");
//        req2.setDeployId("deploy01");
//        req2.setTimestamp(1727350593623L);
//        boolean check2 = checkSign(req2,privateKey);
//        System.out.println(check2);


        String str = "create (node:Action{athena_namespace:'A20240109084537-athenaPaaSDesigner',subject:'b',commonApp:false,emergency:50,label:'Action',compileVersion:'1.0.0.0111',request_parameters:'[{\"data_name\":\"key1\",\"data_type\":\"string\",\"description\":{\"en_US\":\"\",\"zh_CN\":\"\",\"zh_TW\":\"\"},\"fullPath\":\"key1\",\"id\":\"a__request__key1\",\"is_array\":false,\"is_businesskey\":false,\"is_datakey\":\"false\",\"labels\":[\"DataField\"],\"relationTable\":[{\"targetId\":\"esp_view.detail.info.get__response__view_info.view_name\",\"targetLabel\":\"DataField\",\"type\":\"MapsTo\"},{\"targetId\":\"A202411224567_lcdp_null__response__data.id\",\"targetLabel\":\"DataField\",\"type\":\"MapsTo\"}],\"required\":\"false\"}]',version:'{athena_version}',tenantId:'SYSTEM',actionId:'a',response_object:'',id:'666005a23da18f0a7d5af109',nameSpace:'A20240109084537-athenaPaaSDesigner',`lang.actionName.zh_TW`:'b',`lang.actionName.en_US`:'b',`lang.actionName.zh_CN`:'b',actionName:'b'})";




    }
}
