package com.digiwin.athena.km_deployer_service.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.deploy.BasicQuery;
import com.digiwin.athena.deploy.SortField;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.povo.CypherDto;
import com.digiwin.athena.km_deployer_service.povo.DapResponse;
import com.digiwin.athena.km_deployer_service.support.SkillParseContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;

public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);
    static String db_datamap = "datamap";
    static String db_kg_sys = "knowledgegraphSystem";


    public static HttpClient httpclient = null;

    public static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)
            .setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();



    @PostConstruct
    public void init() {

    }



    public static DapResponse request(String url, String httpMethod, Map<String,Object> params){
        DapResponse result = new DapResponse();
        String json = requestString(url,httpMethod,params);
        if(null!=json){
            result = JSON.parseObject(json,DapResponse.class);
        }
        return result;
    }


    public static String requestString(String url, String httpMethod, Map<String,Object> params){

        String result = null;
        try {

            Map<String,String> headers = new HashMap<>();
            try {
                URL u = new URL(url);
                String kghost = u.getHost();
                headers.put("Host",kghost);
            } catch (MalformedURLException e) {
                logger.error("requestString error",e);
            }

            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            if (null!=routerKey) {
                headers.put("routerKey", routerKey);
            }
            if(null!=token){
                headers.put("token", token);
                headers.put("digi-middleware-auth-user", token);
            }
            if(null!=locale){
                headers.put("locale", locale);
            }


            //headers.put("digi-middleware-auth-app", appToken);
            if("post".equalsIgnoreCase(httpMethod)){
                result= Utils.postJson(url,headers,params);
            }else{
                result= Utils.get(url,headers,params);
            }
        }catch (Exception e){
            //安静的吃掉异常
            logger.error("request to {} failed,"+e.getMessage(),url);
        }

        return result;

    }

    private static Header[] toHeader(Map<String,String> headers){


        if(null!=headers){
            ArrayList<Header> hs = new ArrayList<>();
            headers.forEach((k,v)->{
                hs.add(new BasicHeader(k,v));
            });
            return hs.toArray(new Header[]{});
        }

        return null;
    }

    public static String get(String url, Map<String,String> headers, Map<String, Object> params) {
        String result = null;

        HttpResponse response = get0(url,toHeader(headers),params);
        HttpEntity entity = response.getEntity();
        try {
            result = EntityUtils.toString(entity, "UTF-8");
            if (logger.isInfoEnabled()) {
                logger.info("get result=" + result);
            }
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        HttpClientUtils.closeQuietly(response);

        return result;
    }


    public static HttpResponse get0(String url, Header[] headers, Map<String, Object> params) {

        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    String sv = v.toString();
                    sb.append(k).append("=").append(URLEncoder.encode(sv, "UTF-8")).append("&");
                } catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), e);
                }
            });
            url = url + sb.substring(0, sb.length() - 1).toString();
        }
        HttpGet get = new HttpGet(url);//NOSONAR
        get.setHeaders(headers);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("get url=" + url + ",headers=" + JSON.toJSONString(headers) + ",params=" + params);
        }
        try {
            response = getHttpClient().execute(get);
            return response;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T get(String url,Map<String,String> headers, Map<String, Object> params, Class<T> c) {
        T result = null;
        try {
            result = JSON.parseObject(get(url, headers, params), c);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }

        return result;
    }


    public static String postJson(String url, Map<String,String> headers,Map<String,Object> params) {
        String result = null;

        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(toHeader(headers));
        String jsonbody = JSON.toJSONString(params);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity(myEntity);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + jsonbody +" and header="+headers);//NOSONAR 这里params 如果做\r\n 的替换有性能消耗，没有太大必要，目前并不会引入该sonar 问题
        }
        try {
            response = getHttpClient().execute(httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
        } finally {
            HttpClientUtils.closeQuietly(response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);//NOSONAR 这里params 如果做\r\n 的替换有性能消耗，没有太大必要，目前并不会引入该sonar 问题
        }

        return result;
    }




    public static HttpClient getHttpClient() {
        if (null == httpclient) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager() {
                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType)//NOSONAR 暂时未提供校验方法
                            throws CertificateException {
                    }//NOSONAR 暂时未提供校验方法

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType)//NOSONAR 暂时未提供校验方法
                            throws CertificateException {
                    }//NOSONAR 暂时未提供校验方法

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;//NOSONAR 暂时未提供校验方法
                    }
                };

                sslContext.init(null, new TrustManager[] { tm }, null);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                logger.error(e.getMessage(), e);
            }

            httpclient = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext)
                    // .disableAutomaticRetries()
                    .build();
        }
        return httpclient;
    }


    public static String uid(){
        return UUID.randomUUID().toString().replaceAll("-","");
    }

    public static  <T> T objToClz(Object obj,Class<T> clz){
        return JSON.parseObject(JSON.toJSONString(obj),clz);
    }
    public static  <T> List<T> objToArray(Object obj, Class<T> clz){
        return JSON.parseArray(JSON.toJSONString(obj),clz);
    }


    public static Document objToDoc( Object obj){
        return Document.parse(JSON.toJSONString(obj));
    }



    public static ApplicationMongoData objToMongoData(Object obj,String db,String col){
        ApplicationMongoData data = new ApplicationMongoData();
        data.getDocs().add(objToDoc(obj));
        data.setDb(db);
        data.setCol(col);
        return data;
    }

    //仅能处理常用的转换，有特殊形式需要自己写
    public static CypherDto objToCypher(Object obj,List<String> labels,String version){
        CypherDto dto = new CypherDto();
        String nodeId = "node_"+uid();
        StringBuilder sb = new StringBuilder();
        Map<String,Object> map = JSON.parseObject(JSON.toJSONString(obj));
        sb.append("create (").append(nodeId).append("");
        for(String label:labels){
            sb.append(":").append(label);
        }
        sb.append("{");

        map.forEach((k,v)->{
            sb.append(k).append(":");
            if(v instanceof String){
                sb.append("'").append(v).append("'");
            }else if(isPrimitive(obj.getClass())){
                sb.append(v);
            }else{
                sb.append("'").append(JSON.toJSONString(v)).append("'");
            }

            sb.append(",");
        });
        sb.append("version:'").append(version).append("'");
        sb.append("})");

        dto.setNodeId(nodeId);
        dto.setCypher(sb.toString());

        return dto;
    }


    public static boolean isPrimitive(Class<?> c) {
        if (c != null) {
            if (c.isPrimitive()  || Number.class.isAssignableFrom(c) || Boolean.class.equals(c)) {
                return true;
            }
        }
        return false;
    }



    public static String loadTemplate(String fileName)  {
        try {
            //String text = FileUtils.readFileToString(ResourceUtils.getFile(Utils.class.getResource(fileName)),"utf-8");
            String text =  IoUtil.read(Utils.class.getResource(fileName).openStream(),"utf-8");
            return text;
        } catch (IOException e) {
            logger.error("load template error",e);
        }
        return null;
    }

    public static <T> T loadObject(String fileName,Class<T> c){
        String text = loadTemplate(fileName);
        if(null!=text){
            return JSON.parseObject(text,c);
        }
        return null;
    }
    public static <T> List<T> loadObjects(String fileName,Class<T> c){
        String text = loadTemplate(fileName);
        if(null!=text){
            return JSON.parseArray(text,c);
        }
        return null;
    }


    public static void addObject(Object obj, SkillParseContext context, ApplicationData data){

        if(null==obj){return;}

        if(obj instanceof TenantObject){
            TenantObject tenantObject = (TenantObject) obj;
            tenantObject.setTenantId("SYSTEM");
            tenantObject.setVersion(context.getVersion());
        }


        if(obj instanceof Project){
            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_datamap,"project"));
        }
        if(obj instanceof Task){
            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_datamap,"task"));
        }
        else if(obj instanceof PageView){
            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_datamap,"pageView"));
        }
        else if(obj instanceof FlowGraph){
            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_datamap,"flowGraph"));
        }
        else if(obj instanceof Activity){
            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_datamap,"activity"));
        }
        else if(obj instanceof DataDescription){
            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_datamap,"dataDescription"));
        }
        else if(obj instanceof DataState){
            DataState lastState = (DataState) obj;
          //  data.setLastState(lastState);
            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_datamap,"dataState"));
        }
//        else if(obj instanceof MonitorRuleProductConfig){
//            MonitorRuleProductConfig monitorRuleProductConfig = (MonitorRuleProductConfig) obj;
//            monitorRuleProductConfig.setVersion(context.getVersion());
//            data.getMongoData().add(Utils.objToMongoData(obj, Constant.db_kg_sys,"monitorRuleProductConfig"));
//        }
        else if(obj instanceof MonitorRule){
            CypherDto dto =Utils.objToCypher(obj, ListUtil.of("MonitorRule"),context.getVersion());
            data.getCyphers().add(dto.getCypher());
        }
    }


    public static Query buildQuery(BasicQuery request){
        Query query =new Query();
        if(null!=request.getCondition()){
            request.getCondition().forEach((k,v)->{
                if(v instanceof Collection){
                    Collection collection = (Collection) v;
                    query.addCriteria(Criteria.where(k).in(collection));
                }else{
                    query.addCriteria(Criteria.where(k).is(v));
                }
            });
        }
        if(null!=request.getPage() && null!=request.getPageSize()){
            query.with(PageRequest.of(request.getPage(), request.getPageSize()));
        }
        if(CollectionUtil.isNotEmpty(request.getSortFields())){
            List<Sort.Order> orders = new ArrayList<>();
            for(SortField field: request.getSortFields()){
                Sort.Direction direction = "desc".equalsIgnoreCase(field.getDirection())?Sort.Direction.DESC:Sort.Direction.ASC;
                Sort.Order order = new Sort.Order(direction, field.getField());
                orders.add(order);
            }
            query.with(Sort.by(orders));
        }
        if(CollectionUtil.isNotEmpty(request.getReturnFields())){
            for(String field : request.getReturnFields()){
                query.fields().include(field);
            }
        }
        return query;
    }

    public static void main(String[] args) {
        System.out.println(loadTemplate("purchaseApproval/Task.json"));
    }

}
