/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config.mongodb;

import com.digiwin.athena.km_deployer_service.config.mongodb.ExtendSimpleMongoRepository;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"com.digiwin.athena.mongodb.datamap.repository"}, repositoryBaseClass=ExtendSimpleMongoRepository.class)
@ConditionalOnProperty(prefix="spring.data.mongo-datamap", name={"database"})
public class DataMapMongodbConfig
extends MongoConfigurationSupport {
    public static final String BASE_PACKAGE = "com.digiwin.athena.mongodb.datamap.repository";
    public static final String MONGO_TEMPLATE_REF = "mongoDatamapTemplate";
    @Value(value="${spring.data.mongodb.uri}")
    private String uri;
    @Value(value="${spring.data.mongo-datamap.database}")
    private String databaseDatamap;

    @Bean(value={"datamapMongoClient"})
    public MongoClient mongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.uri)).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxWaitQueueSize(300).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Bean(value={"datamapMongoMappingContext"})
    public MongoMappingContext mongoMappingContext() {
        MongoMappingContext mappingContext = new MongoMappingContext();
        return mappingContext;
    }

    @Bean(value={"datamapMongoDbFactory"})
    public MongoDbFactory mongoDbFactory() {
        return new SimpleMongoClientDbFactory(this.mongoClient(), this.getDatabaseName());
    }

    @Bean(name={"mongoDatamapTemplate"})
    public MongoTemplate mongoTemplate(@Qualifier(value="datamapMongoDbFactory") MongoDbFactory mongoDbFactory, @Qualifier(value="datamapMongoMappingContext") MongoMappingContext mongoMappingContext) throws Exception {
        return new MongoTemplate(this.mongoDbFactory(), (MongoConverter)this.mappingMongoConverter());
    }

    @Bean(value={"datamapMappingMongoConverter"})
    public MappingMongoConverter mappingMongoConverter() throws Exception {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.mongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext());
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        converter.setCustomConversions(this.customConversions());
        return converter;
    }

    protected String getDatabaseName() {
        return this.databaseDatamap;
    }

    @Generated
    public DataMapMongodbConfig() {
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getDatabaseDatamap() {
        return this.databaseDatamap;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setDatabaseDatamap(String databaseDatamap) {
        this.databaseDatamap = databaseDatamap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataMapMongodbConfig)) {
            return false;
        }
        DataMapMongodbConfig other = (DataMapMongodbConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$databaseDatamap = this.getDatabaseDatamap();
        String other$databaseDatamap = other.getDatabaseDatamap();
        return !(this$databaseDatamap == null ? other$databaseDatamap != null : !this$databaseDatamap.equals(other$databaseDatamap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataMapMongodbConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $databaseDatamap = this.getDatabaseDatamap();
        result = result * 59 + ($databaseDatamap == null ? 43 : $databaseDatamap.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataMapMongodbConfig(uri=" + this.getUri() + ", databaseDatamap=" + this.getDatabaseDatamap() + ")";
    }
}

