/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config.mongodb;

import com.digiwin.athena.km_deployer_service.config.mongodb.ExtendSimpleMongoRepository;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"com.digiwin.athena.mongodb.knowledgegraphSystem.repository"}, repositoryBaseClass=ExtendSimpleMongoRepository.class)
@ConditionalOnProperty(prefix="spring.data.mongo-kgsys", name={"database"})
public class KgsysMongodbConfig
extends MongoConfigurationSupport {
    public static final String BASE_PACKAGE = "com.digiwin.athena.mongodb.knowledgegraphSystem.repository";
    public static final String MONGO_TEMPLATE_REF = "mongoKgsysTemplate";
    @Value(value="${spring.data.mongodb.uri}")
    private String uri;
    @Value(value="${spring.data.mongo-kgsys.database}")
    private String databaseKgsys;

    @Bean(value={"kgsysMongoClient"})
    public MongoClient mongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.uri)).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxWaitQueueSize(300).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Bean(value={"kgsysMongoMappingContext"})
    public MongoMappingContext mongoMappingContext() {
        MongoMappingContext mappingContext = new MongoMappingContext();
        return mappingContext;
    }

    @Bean(value={"kgsysMongoDbFactory"})
    public MongoDbFactory mongoDbFactory() {
        return new SimpleMongoClientDbFactory(this.mongoClient(), this.getDatabaseName());
    }

    @Bean(name={"mongoKgsysTemplate"})
    public MongoTemplate mongoTemplate(@Qualifier(value="kgsysMongoDbFactory") MongoDbFactory mongoDbFactory, @Qualifier(value="kgsysMongoMappingContext") MongoMappingContext mongoMappingContext) {
        return new MongoTemplate(this.mongoDbFactory(), (MongoConverter)this.kgsysMappingMongoConverter());
    }

    @Bean(value={"kgsysMappingMongoConverter"})
    public MappingMongoConverter kgsysMappingMongoConverter() {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.mongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext());
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        converter.setCustomConversions(this.customConversions());
        return converter;
    }

    protected String getDatabaseName() {
        return this.databaseKgsys;
    }

    @Generated
    public KgsysMongodbConfig() {
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getDatabaseKgsys() {
        return this.databaseKgsys;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setDatabaseKgsys(String databaseKgsys) {
        this.databaseKgsys = databaseKgsys;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KgsysMongodbConfig)) {
            return false;
        }
        KgsysMongodbConfig other = (KgsysMongodbConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$databaseKgsys = this.getDatabaseKgsys();
        String other$databaseKgsys = other.getDatabaseKgsys();
        return !(this$databaseKgsys == null ? other$databaseKgsys != null : !this$databaseKgsys.equals(other$databaseKgsys));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KgsysMongodbConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $databaseKgsys = this.getDatabaseKgsys();
        result = result * 59 + ($databaseKgsys == null ? 43 : $databaseKgsys.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KgsysMongodbConfig(uri=" + this.getUri() + ", databaseKgsys=" + this.getDatabaseKgsys() + ")";
    }
}

