/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config.neo4j;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableNeo4jRepositories(sessionFactoryRef="domain2SessionFactory", basePackages={"com.digiwin.athena.km_deployer_service.neo4jbasepkg.backup"}, transactionManagerRef="domain2TransactionManager")
@ConditionalOnProperty(prefix="spring.data.neo4j.domain2", name={"enable"}, havingValue="true")
public class BackupNeo4jConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackupNeo4jConfig.class);
    public static final String SESSION_FACTORY = "domain2SessionFactory";
    public static final String TRANSACTION_MANAGER = "domain2TransactionManager";
    public static final String Neo4j_SESSION = "domain2Session";
    public static final String NEO4J_DRIVER_SESSION = "domain2DriverSession";
    public static final String NEO4J_DRIVER = "domain2Driver";
    static final String BASE_PACKAGE = "com.digiwin.athena.km_deployer_service.neo4jbasepkg.backup";

    @Bean(name={"domain2Neo4jProperties"})
    @ConfigurationProperties(value="spring.data.neo4j.domain2")
    public Neo4jProperties neo4jProperties() {
        return new Neo4jProperties();
    }

    @Bean(name={"domain2OgmConfiguration"})
    public org.neo4j.ogm.config.Configuration ogmConfiguration() {
        return this.neo4jProperties().createConfiguration();
    }

    @Bean(name={"domain2SessionFactory"})
    public SessionFactory sessionFactory() {
        return new SessionFactory(this.ogmConfiguration(), new String[]{BASE_PACKAGE});
    }

    @Bean(name={"domain2Session"})
    public Neo4jSession session() {
        return (Neo4jSession)this.sessionFactory().openSession();
    }

    @Bean(name={"domain2Driver"})
    public Driver driver() {
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        Driver driver = GraphDatabase.driver((String)this.neo4jProperties().getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties().getUsername(), (String)this.neo4jProperties().getPassword()), (Config)config);
        try {
            driver.verifyConnectivity();
        }
        catch (Exception e) {
            log.error("back\u5e93\u521d\u59cb\u5316\u5931\u8d25");
            driver = null;
        }
        return driver;
    }

    @Bean(name={"domain2DriverSession"})
    public Session neo4jSession() {
        Driver driver = this.driver();
        if (driver == null) {
            return null;
        }
        return driver.session();
    }

    @Bean(name={"domain2TransactionManager"})
    public Neo4jTransactionManager neo4jTransactionManager() {
        return new Neo4jTransactionManager(this.sessionFactory());
    }
}

