/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config.neo4j;

import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableNeo4jRepositories(basePackages={"com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository"})
public class MasterNeo4jConfig {
    public static final String SESSION_FACTORY = "sessionFactory";
    public static final String TRANSACTION_MANAGER = "transactionManager";
    public static final String Neo4j_SESSION = "session";
    public static final String NEO4J_DRIVER_SESSION = "driverSession";
    public static final String NEO4J_DRIVER = "driver";
    static final String BASE_PACKAGE = "com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.domain";

    @Primary
    @Bean(name={"neo4jProperties"})
    @ConfigurationProperties(value="spring.data.neo4j")
    public Neo4jProperties neo4jProperties() {
        return new Neo4jProperties();
    }

    @Primary
    @Bean
    public org.neo4j.ogm.config.Configuration ogmConfiguration() {
        return this.neo4jProperties().createConfiguration();
    }

    @Primary
    @Bean(name={"sessionFactory"})
    public SessionFactory sessionFactory() {
        return new SessionFactory(this.ogmConfiguration(), new String[]{BASE_PACKAGE});
    }

    @Primary
    @Bean(name={"session"})
    public Neo4jSession session() {
        return (Neo4jSession)this.sessionFactory().openSession();
    }

    @Primary
    @Bean(name={"driver"})
    public Driver driver() {
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        Driver driver = GraphDatabase.driver((String)this.neo4jProperties().getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties().getUsername(), (String)this.neo4jProperties().getPassword()), (Config)config);
        return driver;
    }

    @Bean(name={"driverSession"})
    @Primary
    public Session neo4jSession() {
        return this.driver().session();
    }

    @Bean(name={"transactionManager"})
    @Primary
    public Neo4jTransactionManager neo4jTransactionManager() {
        return new Neo4jTransactionManager(this.sessionFactory());
    }
}

