/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.deploy.BasicQuery;
import com.digiwin.athena.deploy.DeployLog;
import com.digiwin.athena.deploy.DeployReq;
import com.digiwin.athena.deploy.DeployResp;
import com.digiwin.athena.deploy.DeployTask;
import com.digiwin.athena.km_deployer_service.config.AppConfig;
import com.digiwin.athena.km_deployer_service.domain.DeployDataRecord;
import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.km_deployer_service.domain.MonitorHash;
import com.digiwin.athena.km_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.EspActionIdSwitchResDto;
import com.digiwin.athena.km_deployer_service.povo.EspSwitchMsgEnum;
import com.digiwin.athena.km_deployer_service.service.AdapterService;
import com.digiwin.athena.km_deployer_service.service.DeployService;
import com.digiwin.athena.km_deployer_service.service.km.ActionService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.util.SecurityUtils;
import com.digiwin.athena.km_deployer_service.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deploy"})
public class DeployController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployController.class);
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    DeployService deployService;
    @Autowired
    AdapterService adapterService;
    @Autowired
    AppConfig appConfig;
    @Autowired
    ActionService actionService;
    @Value(value="${envMode}")
    private String envMode;

    @GetMapping(value={"test01"})
    public Object test01() {
        CrudReq req = new CrudReq();
        req.setDbName("datamap");
        req.setColName("api");
        req.setParams(new HashMap());
        req.getParams().put("key1", 1);
        List list = this.mongoCrudService.query(req);
        return list;
    }

    @GetMapping(value={"init_kmtables"})
    public Object init_kmtables() {
        List tables = this.deployService.initTables();
        this.mongoTemplate.dropCollection(KmTable.class);
        this.mongoTemplate.insertAll((Collection)tables);
        return tables.size();
    }

    @GetMapping(value={"buildIndex"})
    public DeployResp buildIndex() throws IOException {
        DeployResp response = new DeployResp();
        this.mongoTemplate.indexOps(DeployTask.class).ensureIndex((IndexDefinition)new Index().named("deployId").on("deployId", Sort.Direction.ASC));
        this.mongoTemplate.indexOps(DeployDataRecord.class).ensureIndex((IndexDefinition)new Index().named("deployId").on("deployId", Sort.Direction.ASC));
        this.mongoTemplate.indexOps(MonitorHash.class).ensureIndex((IndexDefinition)new Index().named("deployId").on("deployId", Sort.Direction.ASC));
        this.mongoTemplate.indexOps(DeployLog.class).ensureIndex((IndexDefinition)new Index().named("eventId").on("eventId", Sort.Direction.ASC));
        return response;
    }

    @PostMapping(value={"deployApp"})
    public DeployResp deployApp(@RequestBody DeployReq request, HttpServletRequest servletRequest) throws IOException {
        String token = servletRequest.getHeader("token");
        String routerKey = servletRequest.getHeader("routerKey");
        request.setToken(token);
        request.setRouterKey(routerKey);
        DeployResp response = this.deployService.publishApplication(request);
        return response;
    }

    @PostMapping(value={"switchApp"})
    public DeployResp switchApp(@RequestBody DeployReq request, HttpServletRequest servletRequest) {
        String token = servletRequest.getHeader("token");
        String routerKey = servletRequest.getHeader("routerKey");
        request.setToken(token);
        request.setRouterKey(routerKey);
        DeployResp response = null;
        response = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)request.getDeployId()) && CollectionUtil.isNotEmpty((Collection)request.getDeployIds()) ? this.deployService.switchApplications(request) : this.deployService.switchApplication(request);
        return response;
    }

    @PostMapping(value={"revokeApp"})
    public DeployResp revokeApp(@RequestBody DeployReq request) {
        DeployResp response = this.deployService.revokeApp(request);
        return response;
    }

    @PostMapping(value={"redoApp"})
    public DeployResp redoApp(@RequestBody DeployReq request) {
        DeployResp response = this.deployService.redoApp(request);
        return response;
    }

    @PostMapping(value={"deployLogs"})
    public DeployResp deployLogs(@RequestBody DeployReq request) {
        String eid2;
        DeployResp response = new DeployResp();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)request.getEventId())) {
            return response;
        }
        String eventId = request.getEventId();
        if (eventId.startsWith("batchSwitch") && null != (eid2 = this.checkParent(eventId))) {
            eventId = eid2;
        }
        request.setEventId(eventId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"eventId").is((Object)eventId));
        DeployTask event = (DeployTask)this.mongoTemplate.findOne(query, DeployTask.class);
        List logs = this.deployService.deployLogs(request);
        response.setData((Object)logs);
        response.setExt((Object)event);
        return response;
    }

    private String checkParent(String parentEventId) {
        if (StringUtils.isEmpty((Object)parentEventId)) {
            return null;
        }
        List subTasks = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"parentEventId").is((Object)parentEventId)), DeployTask.class);
        if (CollectionUtil.isEmpty((Collection)subTasks)) {
            return null;
        }
        String eventId = null;
        for (DeployTask t : subTasks) {
            if (0 == t.getStatus() || 1 == t.getStatus() || 3 == t.getStatus()) {
                return t.getEventId();
            }
            eventId = t.getEventId();
        }
        return eventId;
    }

    @PostMapping(value={"query"})
    public DeployResp query(@RequestBody BasicQuery query) {
        DeployResp response = new DeployResp();
        List tasks = this.mongoTemplate.find(Utils.buildQuery((BasicQuery)query), DeployTask.class);
        response.setData((Object)tasks);
        return response;
    }

    @PostMapping(value={"updateVersion"})
    public DeployResp updateVersion(@RequestBody DeployReq request) {
        DeployResp response = this.deployService.updateVersion(request);
        return response;
    }

    @PostMapping(value={"startTask"})
    public DeployResp startTask(@RequestBody DeployReq request) {
        DeployResp response = new DeployResp();
        this.deployService.restartTaking(request, false);
        return response;
    }

    @PostMapping(value={"stopTask"})
    public DeployResp stopTask(@RequestBody DeployReq request) {
        DeployResp response = new DeployResp();
        this.deployService.stopTaking(request, Boolean.valueOf(false));
        return response;
    }

    @PostMapping(value={"initApplicationSourceId"})
    public DeployResp initApplicationSourceId(@RequestBody DeployReq request) throws IOException {
        DeployResp response = this.deployService.test_initApplicationSourceId(request);
        return response;
    }

    @PostMapping(value={"cleanApplicationSourceId"})
    public DeployResp cleanApplicationSourceId(@RequestBody DeployReq request) throws IOException {
        DeployResp response = this.deployService.test_cleanApplicationSourceId(request);
        return response;
    }

    @GetMapping(value={"initTenantId"})
    public DeployResp initTenantId() throws IOException {
        DeployResp response = this.deployService.test_initTenantId();
        return response;
    }

    @PostMapping(value={"cleanDeploy"})
    public DeployResp cleanDeploy(@RequestBody DeployReq request) throws IOException {
        DeployResp response = new DeployResp();
        this.deployService.cleandeploy(request.getDeployId());
        return response;
    }

    @GetMapping(value={"cleanAll"})
    public DeployResp cleanAll() throws IOException {
        this.deployService.cleanAll();
        return DeployResp.success((Object)"ok");
    }

    @PostMapping(value={"mongo"})
    public DeployResp mongo(@RequestBody CrudReq req) throws IOException {
        DeployResp response = new DeployResp();
        List result = null;
        switch (req.getOpType()) {
            case "select": {
                result = this.mongoCrudService.query(req);
                break;
            }
            case "insert": {
                this.mongoCrudService.insertOne(req);
                break;
            }
            case "update": {
                this.mongoCrudService.update(req);
                break;
            }
            case "delete": {
                if (!"tuo".equals(req.getPwd())) break;
                this.mongoCrudService.delete(req);
                break;
            }
            default: {
                throw new IllegalArgumentException("not support opType:" + req.getOpType());
            }
        }
        response.setData((Object)result);
        return response;
    }

    @PostMapping(value={"onlineSwitch"})
    public DeployResp onlineSwitch(@RequestBody DeployReq request) throws IOException {
        String eventId = Utils.uid();
        request.setEventId(eventId);
        boolean check = SecurityUtils.checkSign((DeployReq)request, (String)this.appConfig.getPrivateKey());
        if (!check) {
            return DeployResp.failed((Integer)1, (String)"\u5b89\u5168\u6821\u9a8c\u9519\u8bef");
        }
        if (null == request.getDeployId() || null == request.getAppId()) {
            return DeployResp.failed((Integer)1, (String)"\u53c2\u6570\u9519\u8bef");
        }
        DeployResp response = new DeployResp();
        response.setEventId(eventId);
        this.adapterService.copy(request);
        return response;
    }

    @GetMapping(value={"assignSwitchEspAction"})
    public ResultBean<List<EspActionIdSwitchResDto>> assignSwitchEspAction(String id, String actionIds) {
        if ("all".equalsIgnoreCase(actionIds)) {
            ArrayList<EspActionIdSwitchResDto> data = new ArrayList<EspActionIdSwitchResDto>();
            EspActionIdSwitchResDto dto = new EspActionIdSwitchResDto();
            dto.setActionId(actionIds);
            data.add(dto);
            this.actionService.incrementSwitchEspAction(id);
            return ResultBean.success(data);
        }
        String[] actionIdArr = actionIds.split(",");
        List actionIdList = Arrays.stream(actionIdArr).distinct().collect(Collectors.toList());
        ArrayList<EspActionIdSwitchResDto> data = new ArrayList<EspActionIdSwitchResDto>();
        ArrayList createdActionIdList = new ArrayList();
        for (String actionId : actionIdList) {
            try {
                EspActionIdSwitchResDto dto = this.actionService.assignSwitchEspAction(id, actionId, createdActionIdList);
                dto.setActionId(actionId);
                data.add(dto);
            }
            catch (Exception e) {
                log.error("assignSwitchEspAction exception:" + e.getMessage(), (Throwable)e);
                data.add(new EspActionIdSwitchResDto(EspSwitchMsgEnum.UPDATE_FAIL.getType(), EspSwitchMsgEnum.UPDATE_FAIL.formatMsg(actionId, e.getMessage())));
            }
        }
        if (!createdActionIdList.isEmpty()) {
            this.actionService.createEspActionRelaWithVirtualTenant();
        }
        return ResultBean.success(data);
    }

    @PostMapping(value={"queryKmTables"})
    public DeployResp queryKmTables(@RequestBody BasicQuery query) {
        DeployResp response = new DeployResp();
        List tasks = this.mongoTemplate.find(Utils.buildQuery((BasicQuery)query), KmTable.class);
        response.setData((Object)tasks);
        return response;
    }

    @PostMapping(value={"cleanApp"})
    public DeployResp cleanApp(@RequestBody DeployReq request, HttpServletRequest servletRequest) {
        String token = servletRequest.getHeader("token");
        DeployResp response = new DeployResp();
        if (this.envMode.contains("Prod")) {
            response.setMsg("\u6b63\u5f0f\u73af\u5883\u4e0d\u53ef\u4ee5\u6e05\u9664\u5e94\u7528");
            response.setCode(Integer.valueOf(1));
            return response;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getSourceId())) {
            response = this.deployService.cleanAppBySourceId(request.getSourceId(), request.getAppId(), token);
            response.setData((Object)request.getSourceId());
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getAppId())) {
            response = this.deployService.cleanAppByNamespace(request.getAppId(), request.getForce(), token);
            response.setData((Object)request.getAppId());
        } else {
            response.setMsg("sourceId appId \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        return response;
    }

    @PostMapping(value={"checkApp"})
    public DeployResp checkApp(@RequestBody DeployReq request, HttpServletRequest servletRequest) {
        DeployResp response = new DeployResp();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getSourceId())) {
            boolean r = this.deployService.checkSource(request.getSourceId());
            response.setData((Object)r);
        } else {
            response.setMsg("sourceId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return response;
    }
}

