/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service;

import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class CleanableCaches {
    @Autowired
    MongoTemplate mongoTemplate;
    Cache<String, List<KmTable>> kmTables = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).initialCapacity(4).maximumSize(8L).build();

    public void cleanAll() {
        this.kmTables.invalidateAll();
    }

    public List<KmTable> getKmTables() {
        String key = "kmTables";
        List tables = (List)this.kmTables.getIfPresent((Object)key);
        if (null == tables) {
            tables = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"category").is((Object)"deploy")), KmTable.class);
            this.kmTables.put((Object)key, (Object)tables);
        }
        return tables;
    }
}

