/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.deploy.DeployConstants;
import com.digiwin.athena.deploy.DeployLog;
import com.digiwin.athena.deploy.DeployReq;
import com.digiwin.athena.deploy.DeployResp;
import com.digiwin.athena.deploy.DeployTask;
import com.digiwin.athena.deploy.JobRecord;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.athena.km_deployer_service.config.AppConfig;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.DeployDataRecord;
import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.km_deployer_service.domain.MonitorHash;
import com.digiwin.athena.km_deployer_service.povo.Application2CommonRelationParam;
import com.digiwin.athena.km_deployer_service.povo.CreateApplicationRelationParam;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.EspActionEnumkeyModule;
import com.digiwin.athena.km_deployer_service.service.CleanableCaches;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.deploy.MonitorService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.ActionService;
import com.digiwin.athena.km_deployer_service.service.km.ApplicationService;
import com.digiwin.athena.km_deployer_service.service.km.CommonDataService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.spi.AtmcService;
import com.digiwin.athena.km_deployer_service.spi.KgService;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import com.digiwin.athena.km_deployer_service.util.SecurityUtils;
import com.digiwin.athena.km_deployer_service.util.Utils;
import com.google.common.collect.Lists;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DeployService
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployService.class);
    private boolean stop = false;
    public static ExecutorService pool = Executors.newFixedThreadPool(15);
    private int batchInsert = 100;
    private int batchRecord = 100;
    private Thread takingThread;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    Neo4jCrudService neo4jCrudService;
    @Autowired
    RedisLockRegistry redisLockRegistry;
    @Autowired
    DmcService dmcService;
    @Autowired
    AppConfig appConfig;
    @Autowired
    HelpService helpService;
    @Autowired
    MonitorService monitorService;
    @Autowired
    CleanableCaches cleanableCaches;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Resource
    RedissonClient redissonClient;
    @Autowired
    ActionService actionService;
    @Autowired
    GridFsTemplate gridFsTemplate;
    @Autowired
    KgService kgService;
    @Autowired
    AtmcService atmcService;
    @Autowired
    CommonDataService commonDataService;
    @Autowired
    ApplicationService applicationService;
    @Value(value="${deployTask.expiredMinutes:10}")
    private long expiredMinutes;
    @Value(value="${deployTask.mongoDocSplitSize:100}")
    private int mongoDocSplitSize;

    public DeployResp publishApplication(DeployReq request) throws IOException {
        DeployTask publishTask2;
        log.info("publishApplication...." + JSON.toJSONString((Object)request));
        DeployResp response = new DeployResp();
        boolean check = SecurityUtils.checkSign((DeployReq)request, (String)this.appConfig.getPrivateKey());
        if (!check) {
            return DeployResp.failed((Integer)1, (String)"\u5b89\u5168\u6821\u9a8c\u9519\u8bef");
        }
        if (null == request.getDeployId()) {
            return DeployResp.failed((Integer)1, (String)"deployId is null");
        }
        if (null == request.getSourceId()) {
            return DeployResp.failed((Integer)1, (String)"sourceId is null");
        }
        if (null == request.getAppId()) {
            return DeployResp.failed((Integer)1, (String)"appId is null");
        }
        if (null == request.getType()) {
            return DeployResp.failed((Integer)1, (String)"type is null");
        }
        if (!("app".equalsIgnoreCase(request.getType()) || "tenantApp".equalsIgnoreCase(request.getType()) || "tenantCustom".equalsIgnoreCase(request.getType()) || "joblist".equalsIgnoreCase(request.getType()))) {
            return DeployResp.failed((Integer)1, (String)"type not support");
        }
        if ("tenantApp".equalsIgnoreCase(request.getType()) && CollectionUtils.isEmpty((Collection)request.getTenantIds())) {
            request.setTenantIds(new ArrayList());
        }
        if ("tenantCustom".equalsIgnoreCase(request.getType()) && CollectionUtils.isEmpty((Collection)request.getTenantIds())) {
            request.setTenantIds(new ArrayList());
        }
        if (request.getFileId() == null && request.getAppData() == null) {
            return DeployResp.failed((Integer)1, (String)"\u53d1\u7248\u65f6\u5fc5\u987b\u8bbe\u7f6efileId\u6216\u8005\u4f20\u5165\u6570\u636e");
        }
        DeployTask publishTask = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)request.getDeployId())), DeployTask.class);
        if (null != publishTask) {
            DeployResp resp = DeployResp.failed((Integer)2, (String)("deployId\u5df2\u5b58\u5728\uff1a" + request.getDeployId()));
            resp.setEventId(publishTask.getEventId());
            return resp;
        }
        boolean deploying = this.appDeploying(request);
        if (deploying) {
            return DeployResp.failed((Integer)1, (String)"\u8be5\u5e94\u7528\u6b63\u5728\u90e8\u7f72\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        request.setVersion("1.0");
        ApplicationData appData = request.getAppData();
        if (request.getFileId() != null) {
            appData = this.parseFile(request.getAppId(), request.getSourceId(), request.getFileId());
        }
        if (null == appData || CollectionUtil.isEmpty((Collection)appData.getCyphers()) && CollectionUtil.isEmpty((Collection)appData.getMongoData())) {
            return DeployResp.failed((Integer)1, (String)"\u6ca1\u6709\u4efb\u4f55\u53d1\u5e03\u7684\u6570\u636e");
        }
        this.preProcess(appData, request);
        appData.setDeployId(request.getDeployId());
        if ("app".equalsIgnoreCase(request.getType())) {
            publishTask2 = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)request.getAppId()).and("type").is((Object)"app")), DeployTask.class);
            if (null == publishTask2) {
                this.test_initApplicationSourceId(request);
            }
        } else if ("tenantApp".equalsIgnoreCase(request.getType()) && null == (publishTask2 = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)request.getAppId()).and("type").is((Object)"app")), DeployTask.class))) {
            return DeployResp.failed((Integer)1, (String)"\u53d1\u7248\u4e2a\u6848\u4e4b\u524d\u9700\u8981\u5148\u53d1\u7248\u4e00\u6b21\u6807\u51c6");
        }
        DeployTask task = (DeployTask)JSON.parseObject((String)JSON.toJSONString((Object)request), DeployTask.class);
        task.setStatus(Integer.valueOf(0));
        task.setCreateTime(new Date());
        task.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        task.setEventId(Utils.uid());
        task.setVersion("1.0");
        this.monitorService.monitorRuleHash((DeployTask)request);
        task.setLastIndividualTenantIds(request.getLastIndividualTenantIds());
        task.setIndividualAddedTenantIds(request.getIndividualAddedTenantIds());
        task.setIndividualKeepTenantIds(request.getIndividualKeepTenantIds());
        task.setIndividualRemovedTenantIds(request.getIndividualRemovedTenantIds());
        this.saveAppData(request, appData);
        if (Boolean.TRUE.equals(request.getSync())) {
            task.setStatus(Integer.valueOf(1));
            this.mongoTemplate.save((Object)task);
            this.process(task);
            task.setStatus(Integer.valueOf(2));
        }
        this.mongoTemplate.save((Object)task);
        response.setDeployId(request.getDeployId());
        response.setEventId(task.getEventId());
        return response;
    }

    public DeployResp switchApplications(DeployReq request) {
        DeployResp resp = new DeployResp();
        DeployTask task = new DeployTask();
        task.setId(null);
        task.setStatus(Integer.valueOf(1));
        task.setCreateTime(new Date());
        task.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        task.setEventId("batchSwitch" + Utils.uid());
        task.setVersion("2.0");
        task.setProcessCount(Integer.valueOf(0));
        task.setCost(null);
        task.setSubDeployIds(request.getDeployIds());
        task.setSubEventIds(new ArrayList());
        task.setUpdateEspVersion(request.getUpdateEspVersion());
        task.setToken(request.getToken());
        resp.setEventId(task.getEventId());
        new /* Unavailable Anonymous Inner Class!! */.start();
        this.mongoTemplate.save((Object)task);
        return resp;
    }

    public DeployResp switchApplication(DeployReq request) {
        log.info("switchApplication...." + JSON.toJSONString((Object)request));
        DeployResp response = new DeployResp();
        boolean check = SecurityUtils.checkSign((DeployReq)request, (String)this.appConfig.getPrivateKey());
        if (!check) {
            return DeployResp.failed((Integer)1, (String)("\u5b89\u5168\u6821\u9a8c\u9519\u8bef," + request.getDeployId()));
        }
        if (null == request.getDeployId()) {
            return DeployResp.failed((Integer)1, (String)("\u53c2\u6570\u9519\u8bef," + request.getDeployId()));
        }
        DeployTask publishTask = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)request.getDeployId()).and("version").is((Object)"1.0")), DeployTask.class);
        if (null == publishTask || publishTask.getStatus() != 2 && publishTask.getStatus() != 7) {
            DeployResp resp = DeployResp.failed((Integer)1, (String)("\u53d1\u7248\u6ca1\u6709\u6210\u529f " + request.getDeployId()));
            if (null != publishTask) {
                resp.setEventId(publishTask.getEventId());
            }
            return resp;
        }
        request.setSourceId(publishTask.getSourceId());
        boolean deploying = this.appDeploying(request);
        if (deploying) {
            List switchTasks = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)request.getDeployId()).and("version").is((Object)"2.0")), DeployTask.class);
            DeployResp resp = DeployResp.failed((Integer)1, (String)("\u8be5\u5e94\u7528\u6b63\u5728\u90e8\u7f72\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5," + request.getDeployId()));
            if (switchTasks.size() > 0) {
                resp.setEventId(((DeployTask)switchTasks.get(switchTasks.size() - 1)).getEventId());
            }
            return resp;
        }
        DeployTask task = (DeployTask)JSON.parseObject((String)JSON.toJSONString((Object)publishTask), DeployTask.class);
        task.setId(null);
        task.setStatus(Integer.valueOf(0));
        task.setCreateTime(new Date());
        task.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        task.setEventId(Utils.uid());
        task.setVersion("2.0");
        task.setProcessCount(Integer.valueOf(0));
        task.setCost(null);
        task.setParentEventId(request.getParentEventId());
        task.setUpdateEspVersion(request.getUpdateEspVersion());
        if (CollectionUtil.isNotEmpty((Collection)request.getTenantIds()) || "app".equalsIgnoreCase(task.getType())) {
            task.setTenantIds(request.getTenantIds());
        }
        if (null != request.getToken()) {
            request.setToken(request.getToken());
        }
        if (Boolean.TRUE.equals(request.getSync())) {
            task.setStatus(Integer.valueOf(1));
            this.mongoTemplate.save((Object)task);
            this.process(task);
            task.setStatus(Integer.valueOf(2));
        }
        this.mongoTemplate.save((Object)task);
        response.setDeployId(request.getDeployId());
        response.setEventId(task.getEventId());
        return response;
    }

    public DeployResp revokeApp(DeployReq request) {
        DeployResp response = new DeployResp();
        boolean check = SecurityUtils.checkSign((DeployReq)request, (String)this.appConfig.getPrivateKey());
        if (!check) {
            return DeployResp.failed((Integer)1, (String)"\u5b89\u5168\u6821\u9a8c\u9519\u8bef");
        }
        if (null == request.getDeployId()) {
            return DeployResp.failed((Integer)1, (String)"deployId is null");
        }
        DeployTask publishTask = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)request.getDeployId()).and("version").is((Object)request.getVersion())), DeployTask.class);
        if (null == publishTask) {
            return DeployResp.failed((Integer)1, (String)("\u53d1\u7248\u6ca1\u6709\u6210\u529f " + request.getDeployId()));
        }
        if (publishTask.getStatus() == 1 && !Boolean.TRUE.equals(request.getForce())) {
            return DeployResp.failed((Integer)1, (String)("\u53d1\u5e03\u6b63\u5728\u8fdb\u884c\u4e2d " + request.getDeployId()));
        }
        publishTask.setStatus(Integer.valueOf(4));
        publishTask.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.mongoTemplate.save((Object)publishTask);
        DeployContext deployContext = new DeployContext();
        deployContext.setAppId(publishTask.getAppId());
        deployContext.setDeployId(publishTask.getDeployId());
        deployContext.setEventId(publishTask.getEventId());
        deployContext.setSourceId(publishTask.getSourceId());
        deployContext.setProcess(0);
        HelpService.setDeployContext((DeployContext)deployContext);
        this.cleanData(publishTask, publishTask.getSourceId(), request.getVersion(), null);
        return response;
    }

    public DeployResp redoApp(DeployReq request) {
        DeployResp response = new DeployResp();
        boolean check = SecurityUtils.checkSign((DeployReq)request, (String)this.appConfig.getPrivateKey());
        if (!check) {
            return DeployResp.failed((Integer)1, (String)"\u5b89\u5168\u6821\u9a8c\u9519\u8bef");
        }
        if (null == request.getDeployId()) {
            return DeployResp.failed((Integer)1, (String)"\u53c2\u6570\u9519\u8bef");
        }
        DeployTask publishTask = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)request.getDeployId()).and("version").is((Object)request.getVersion())), DeployTask.class);
        if (null == publishTask) {
            return DeployResp.failed((Integer)1, (String)("\u53d1\u7248\u6ca1\u6709\u6210\u529f " + request.getDeployId()));
        }
        if (publishTask.getStatus() == 1 && !Boolean.TRUE.equals(request.getForce())) {
            return DeployResp.failed((Integer)1, (String)("\u53d1\u5e03\u6b63\u5728\u8fdb\u884c\u4e2d " + request.getDeployId()));
        }
        publishTask.setStatus(Integer.valueOf(0));
        publishTask.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.mongoTemplate.save((Object)publishTask);
        return response;
    }

    public DeployResp updateVersion(DeployReq request) {
        DeployResp response = new DeployResp();
        boolean check = SecurityUtils.checkSign((DeployReq)request, (String)this.appConfig.getPrivateKey());
        if (!check) {
            return DeployResp.failed((Integer)1, (String)"\u5b89\u5168\u6821\u9a8c\u9519\u8bef");
        }
        if (null == request.getVersion() || CollectionUtil.isEmpty((Collection)request.getTenantIds())) {
            return DeployResp.failed((Integer)1, (String)"\u53c2\u6570\u9519\u8bef");
        }
        this.neo4jCrudService.updateTenantVersion(request.getTenantIds(), request.getVersion());
        HashMap<String, List> param1 = new HashMap<String, List>();
        param1.put("tenantId", request.getTenantIds());
        Bson setv = Updates.set((String)"version", (Object)request.getVersion());
        this.mongoTemplate.getMongoDbFactory().getDb(Constant.db_kg_sys).getCollection("tenantEntity").updateMany(MongoCrudService.buildBson(param1), setv);
        return response;
    }

    private void saveAppData(DeployReq req, ApplicationData data) {
        ArrayList<DeployDataRecord> records = new ArrayList<DeployDataRecord>();
        for (String sql : data.getCyphers()) {
            DeployDataRecord record = new DeployDataRecord();
            record.setDeployId(req.getDeployId());
            record.setType("neo4j");
            record.setCypher(sql);
            records.add(record);
        }
        for (ApplicationMongoData data1 : data.getMongoData()) {
            List multiDocs = Lists.partition((List)data1.getDocs(), (int)this.mongoDocSplitSize);
            for (List docs : multiDocs) {
                DeployDataRecord record = new DeployDataRecord();
                record.setDeployId(req.getDeployId());
                record.setType("mongo");
                ApplicationMongoData mongoData = new ApplicationMongoData();
                mongoData.setDb(data1.getDb());
                mongoData.setCol(data1.getCol());
                mongoData.setDocs(docs);
                mongoData.setParams(data1.getParams());
                record.setDatas(mongoData);
                records.add(record);
            }
        }
        if (null != data.getEnumKeyMappingModule()) {
            DeployDataRecord record = new DeployDataRecord();
            record.setDeployId(req.getDeployId());
            record.setType("espEnumKeys");
            record.setData((Object)data.getEnumKeyMappingModule());
            records.add(record);
        }
        this.mongoTemplate.insertAll(records);
    }

    private ApplicationData loadData(String deployId) {
        ApplicationData data = new ApplicationData();
        List records = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)deployId)), DeployDataRecord.class);
        if (CollectionUtil.isEmpty((Collection)records)) {
            return null;
        }
        List mergedRecords = this.mergeMongoData(records);
        for (DeployDataRecord record : mergedRecords) {
            if ("neo4j".equalsIgnoreCase(record.getType())) {
                data.getCyphers().add(record.getCypher());
                continue;
            }
            if ("espEnumKeys".equalsIgnoreCase(record.getType())) {
                EspActionEnumkeyModule module = (EspActionEnumkeyModule)JSON.parseObject((String)((String)record.getData()), EspActionEnumkeyModule.class);
                data.setEnumKeyMapping(module.getEnumKeyMapping());
                continue;
            }
            data.getMongoData().add(record.getDatas());
        }
        return data;
    }

    private List<DeployDataRecord> mergeMongoData(List<DeployDataRecord> records) {
        HashMap<String, DeployDataRecord> map = new HashMap<String, DeployDataRecord>();
        Iterator<DeployDataRecord> iterator = records.iterator();
        while (iterator.hasNext()) {
            DeployDataRecord record = iterator.next();
            if (!"mongo".equalsIgnoreCase(record.getType())) continue;
            iterator.remove();
            String key = record.getDatas().getDb() + "." + record.getDatas().getCol();
            if (map.containsKey(key)) {
                DeployDataRecord record1 = (DeployDataRecord)map.get(key);
                record1.getDatas().getDocs().addAll(record.getDatas().getDocs());
                continue;
            }
            map.put(key, record);
        }
        ArrayList<DeployDataRecord> result = new ArrayList<DeployDataRecord>(records);
        result.addAll(map.values());
        return result;
    }

    private boolean appDeploying(DeployReq request) {
        boolean r = this.mongoTemplate.exists(Query.query((CriteriaDefinition)Criteria.where((String)"sourceId").is((Object)request.getSourceId()).and("status").lt((Object)2)), DeployTask.class);
        return r;
    }

    public List<DeployLog> deployLogs(DeployReq request) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"eventId").is((Object)request.getEventId()));
        if (null != request.getStartTime()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createTime").gt((Object)request.getStartTime()));
        }
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createTime"}));
        List logs = this.mongoTemplate.find(query, DeployLog.class);
        return logs;
    }

    public ApplicationData parseFile(String application, String deployId, String fileId) throws IOException {
        ApplicationData data = new ApplicationData();
        String appDir = deployId;
        String applicationCompileZipPath = this.compileZipPath + File.separator + appDir + File.separator;
        String applicationCompileDataPath = this.compileDataPath + File.separator + appDir + File.separator;
        String compileDataZipPath = applicationCompileZipPath + appDir + ".zip";
        InputStream inputStream = this.dmcService.download(fileId);
        FileUtil.writeFromStream((InputStream)inputStream, (String)compileDataZipPath);
        File compileDataDirector = new File(applicationCompileDataPath);
        FileUtil.del((File)compileDataDirector);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationCompileDataPath);
        File[] compileDataFiles = compileDataDirector.listFiles();
        if (null == compileDataFiles) {
            return data;
        }
        for (File file : compileDataFiles) {
            File[] files;
            String filename = file.getName();
            if ("cypher".equals(filename)) {
                files = file.listFiles();
                if (files == null) continue;
                for (File file1 : files) {
                    if (!file1.getName().endsWith("json")) continue;
                    List lines = FileUtil.readLines((File)file1, (String)"UTF-8");
                    data.getCyphers().addAll(lines);
                }
                continue;
            }
            if ("designer".equals(filename)) {
                files = file.listFiles();
                if (files == null) continue;
                for (File file1 : files) {
                    String content;
                    File[] files2;
                    if (!"espActionEnumKey".equals(file1.getName()) || (files2 = file1.listFiles()) == null || files2.length == 0 || StringUtil.isEmpty((Object)(content = FileUtil.readString((File)files2[0], (String)"UTF-8")))) continue;
                    data.setEnumKeyMappingModule(content);
                }
                continue;
            }
            if (this.isDb(filename)) {
                File[] dirs = file.listFiles();
                if (dirs == null) continue;
                for (File col : dirs) {
                    String colName = col.getName();
                    if (!this.isCol(col)) continue;
                    ApplicationMongoData mongoData = new ApplicationMongoData();
                    mongoData.setDb(filename);
                    mongoData.setCol(colName);
                    File[] files2 = col.listFiles();
                    if (files2 == null) continue;
                    for (File file1 : files2) {
                        if (!file1.getName().endsWith("json")) continue;
                        List lines = FileUtil.readLines((File)file1, (String)"UTF-8");
                        lines.forEach(line -> {
                            Document document = Document.parse((String)line);
                            mongoData.getDocs().add(document);
                        });
                    }
                    data.getMongoData().add(mongoData);
                }
                continue;
            }
            log.info("ignore file " + filename);
        }
        FileUtil.del((String)compileDataZipPath);
        FileUtil.del((String)applicationCompileDataPath);
        return data;
    }

    private void preProcess(ApplicationData data, DeployReq req) {
        String sourceId = req.getSourceId();
        String application = req.getAppId();
        data.getMongoData().forEach(applicationMongoData -> {
            applicationMongoData.setDb(applicationMongoData.getDb() + this.getDbSuffix());
            applicationMongoData.getDocs().forEach(document -> {
                document.remove((Object)"_id");
                document.remove((Object)"isMigrate");
                document.put("version", (Object)"3.0");
                if (null != sourceId) {
                    document.put("sourceId", (Object)sourceId);
                    document.put("deployId", (Object)req.getDeployId());
                }
                if ("tenantApp".equalsIgnoreCase(req.getType())) {
                    document.put("sourceLevel", (Object)DeployConstants.SourceLevel.tenantApp);
                } else if ("tenantCustom".equalsIgnoreCase(req.getType())) {
                    document.put("sourceLevel", (Object)DeployConstants.SourceLevel.tenantCustom);
                }
            });
        });
    }

    private boolean isDb(String name) {
        List<String> dbs = Arrays.asList("knowledgegraphSystem", "datamap", "preset", "tagSystem", "deliveryDesigner");
        return dbs.contains(name);
    }

    private boolean isCol(File file) {
        return file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTaking() {
        while (!this.stop) {
            RLock lock = this.redissonClient.getLock("km:deploy:deployTask");
            DeployTask task = null;
            try {
                lock.lock(10L, TimeUnit.SECONDS);
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"status").is((Object)0));
                query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updateTime"}));
                task = (DeployTask)this.mongoTemplate.findOne(query, DeployTask.class);
                System.out.println(new Date() + " " + Thread.currentThread().getName() + " \u83b7\u53d6\u53d1\u5e03\u4efb\u52a1\uff1a" + task);
                if (null != task) {
                    task.setStatus(Integer.valueOf(1));
                    task.setBeginTime(new Date());
                    if (null == task.getProcessCount()) {
                        task.setProcessCount(Integer.valueOf(1));
                    } else {
                        task.setProcessCount(Integer.valueOf(task.getProcessCount() + 1));
                    }
                    DeployTask finalTask = task;
                    this.mongoTemplate.save((Object)task);
                    pool.submit(() -> this.process(finalTask));
                }
            }
            catch (Exception e) {
                log.error("startTaking error", (Throwable)e);
            }
            finally {
                if (null != lock && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
            if (null != task) continue;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public DeployResp stopTaking(DeployReq request, Boolean back) {
        boolean check;
        if (!back.booleanValue() && !(check = SecurityUtils.checkSign((DeployReq)request, (String)this.appConfig.getPrivateKey()))) {
            return DeployResp.failed((Integer)1, (String)"\u5b89\u5168\u6821\u9a8c\u9519\u8bef");
        }
        if (null != this.takingThread) {
            this.stop = true;
            this.takingThread = null;
        }
        return new DeployResp();
    }

    public DeployResp restartTaking(DeployReq request, boolean back) {
        try {
            this.stopTaking(request, Boolean.valueOf(back));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop = false;
        this.takingThread = new /* Unavailable Anonymous Inner Class!! */;
        this.takingThread.start();
        return new DeployResp();
    }

    public void process(DeployTask task) {
        task.setBeginTime(new Date());
        String appId = task.getAppId();
        String version = task.getVersion();
        try {
            DeployContext deployContext = new DeployContext();
            deployContext.setAppId(task.getAppId());
            deployContext.setDeployId(task.getDeployId());
            deployContext.setEventId(task.getEventId());
            deployContext.setSourceId(task.getSourceId());
            deployContext.setProcess(0);
            HelpService.setDeployContext((DeployContext)deployContext);
            this.log(task.getEventId(), "\u5f00\u59cb\u6267\u884c\u66f4\u65b0", Integer.valueOf(0), null);
            ApplicationData appData = this.loadData(task.getDeployId());
            if (appData == null) {
                this.log(task.getEventId(), "\u6570\u636e\u4e22\u5931", Integer.valueOf(0), Integer.valueOf(3));
                task.setStatus(Integer.valueOf(3));
                task.setMsg("\u6570\u636e\u4e22\u5931");
                this.mongoTemplate.save((Object)task);
                return;
            }
            JSONObject neo4jNodeKeyJson = new JSONObject();
            List kmTables = this.cleanableCaches.getKmTables();
            for (KmTable kmTable : kmTables) {
                if (!"neo4j".equalsIgnoreCase(kmTable.getType()) || !CollectionUtil.isNotEmpty((Collection)kmTable.getUniKey())) continue;
                neo4jNodeKeyJson.put(kmTable.getTable(), kmTable.getUniKey().get(0));
            }
            List relations = new ArrayList();
            if (this.isCommonApp(task)) {
                Application2CommonRelationParam findApplication2CommonParam = new Application2CommonRelationParam().setApplicationList((List)ListUtil.toList((Object[])new String[]{appId, "espCommon"})).setNeo4jNodeKeyJson(neo4jNodeKeyJson).setApplicationVersion(version).setCommonVersion(version);
                relations = this.commonDataService.findApp2OtherAppRelations(findApplication2CommonParam);
            }
            this.checkAppAndTenant(task);
            this.cleanData(task, task.getSourceId(), "3.0", null);
            this.processApplicationData(task, appData);
            this.cleanData(task, task.getSourceId(), task.getVersion(), null);
            if ("tenantApp".equalsIgnoreCase(task.getType()) && CollectionUtil.isNotEmpty((Map)task.getCleanSourceTenants())) {
                task.getCleanSourceTenants().forEach((k, v) -> this.cleanData(task, k, task.getVersion(), v));
            }
            this.updateVersion(task, appData);
            boolean mechanismFirstCompileSuccess = true;
            if (null == task.getJobList() || task.getJobList().isEmpty()) {
                try {
                    this.executeMechanismFirstCompile(task, appData.getMongoData());
                }
                catch (Exception e) {
                    mechanismFirstCompileSuccess = false;
                    this.log(task.getEventId(), "\u673a\u5236\u4e00\u6b21\u7f16\u8bd1\u5931\u8d25" + e.getMessage(), Integer.valueOf(0), null);
                    log.error("\u673a\u5236\u4e00\u6b21\u7f16\u8bd1\u5931\u8d25", (Throwable)e);
                }
            }
            if ("1.0".equalsIgnoreCase(task.getVersion())) {
                if (null != appData.getEnumKeyMapping()) {
                    log.info("updateEspActionEnumKey......");
                    this.actionService.updateEspActionEnumKey(appData.getEnumKeyMapping());
                }
                this.monitorService.monitorHash(task, task.getSourceId(), 1);
            } else if ("2.0".equalsIgnoreCase(task.getVersion()) && Boolean.TRUE.equals(task.getUpdateEspVersion())) {
                this.incrementSwitchEspAction(task.getEventId());
            }
            if (this.isCommonApp(task)) {
                CreateApplicationRelationParam createApplicationRelationParam = new CreateApplicationRelationParam().setRelationList(relations).setNeo4jNodeKeyJson(neo4jNodeKeyJson).setCommonVersion(version).setApplicationVersion(version);
                this.applicationService.createApplication2CommonRelation(createApplicationRelationParam);
            }
            this.monitorService.checkAndPush(task);
            this.log(task.getEventId(), "\u68c0\u67e5\u4fa6\u6d4b\u5e76\u63a8\u9001\u6210\u529f", Integer.valueOf(2), null);
            this.kgService.updateApplicationComponentList(task);
            if (mechanismFirstCompileSuccess) {
                this.log(task.getEventId(), "\u66f4\u65b0\u5168\u90e8\u6210\u529f", Integer.valueOf(0), Integer.valueOf(2));
                task.setStatus(Integer.valueOf(2));
            } else {
                task.setStatus(Integer.valueOf(7));
                this.log(task.getEventId(), "\u66f4\u65b0\u64cd\u4f5c\u6210\u529f\uff0c\u673a\u5236\u4e00\u6b21\u7f16\u8bd1\u5931\u8d25", Integer.valueOf(0), Integer.valueOf(2));
            }
        }
        catch (Exception e) {
            task.setStatus(Integer.valueOf(3));
            task.setMsg(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            this.log(task.getEventId(), "\u66f4\u65b0\u64cd\u4f5c\u5931\u8d25," + e.getMessage(), Integer.valueOf(0), Integer.valueOf(3));
            try {
                this.cleanData(task, task.getSourceId(), "3.0", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        task.setEndTime(new Date());
        task.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        Long duration = DateUtil.between((Date)task.getBeginTime(), (Date)task.getEndTime(), (DateUnit)DateUnit.SECOND);
        task.setCost(duration);
        this.mongoTemplate.save((Object)task);
        this.checkParent(task.getParentEventId());
    }

    private void checkParent(String parentEventId) {
        if (StringUtils.isEmpty((Object)parentEventId)) {
            return;
        }
        DeployTask task = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"eventId").is((Object)parentEventId)), DeployTask.class);
        if (null == task || CollectionUtil.isEmpty((Collection)task.getSubEventIds())) {
            return;
        }
        List subTasks = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"eventId").in((Collection)task.getSubEventIds())), DeployTask.class);
        if (CollectionUtil.isEmpty((Collection)subTasks)) {
            return;
        }
        boolean hasRun = false;
        for (DeployTask t : subTasks) {
            if (0 == t.getStatus() || 1 == t.getStatus()) {
                hasRun = true;
                continue;
            }
            if (3 != t.getStatus()) continue;
            task.setStatus(Integer.valueOf(3));
            task.setMsg(t.getMsg());
            this.mongoTemplate.save((Object)task);
            break;
        }
        if (!hasRun) {
            task.setStatus(Integer.valueOf(2));
            this.mongoTemplate.save((Object)task);
        }
    }

    private void executeMechanismFirstCompile(DeployTask task, List<ApplicationMongoData> mongoData) {
        List mechanismCodes = mongoData.stream().filter(each -> ("knowledgegraphSystem" + this.getDbSuffix()).equals(each.getDb()) && "mechanism".equals(each.getCol())).findFirst().map(each -> each.getDocs().stream().map(doc -> doc.get((Object)"code").toString()).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        this.log(task.getEventId(), String.format("\u5f00\u59cb\u673a\u5236\u4e00\u6b21\u7f16\u8bd1, mechanismCodes:%s", String.join((CharSequence)",", mechanismCodes)), Integer.valueOf(1), null);
        this.kgService.executeMechanismCompile(task, mechanismCodes);
        this.log(task.getEventId(), String.format("\u673a\u5236\u4e00\u6b21\u7f16\u8bd1\u6210\u529f, mechanismCodes:%s", String.join((CharSequence)",", mechanismCodes)), Integer.valueOf(1), null);
    }

    private void incrementSwitchEspAction(String id) {
        log.info("try incrementSwitchEspAction......");
        RLock rLock = this.redissonClient.getLock("km:deploy:incrementSwitchEspAction");
        if (rLock.tryLock()) {
            try {
                log.info("incrementSwitchEspAction......");
                this.actionService.incrementSwitchEspAction(id);
            }
            finally {
                rLock.unlock();
            }
        }
    }

    private void checkAppAndTenant(DeployTask task) {
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("code", task.getAppId());
        List app = this.neo4jCrudService.query("AppEntity", map3);
        if (app.isEmpty()) {
            this.log(task.getEventId(), "\u521b\u5efa\u5e94\u7528", Integer.valueOf(1), null);
            this.createApplication(task.getAppId(), task.getAppName(), Boolean.valueOf(Boolean.TRUE.equals(task.getCommonApp())));
        }
        if (CollectionUtil.isNotEmpty((Collection)task.getTenantIds())) {
            this.log(task.getEventId(), "\u68c0\u67e5\u79df\u6237", Integer.valueOf(1), null);
            ArrayList oldTenantIds = new ArrayList();
            List tenants = this.neo4jCrudService.query("TenantEntity", (Map)MapUtil.of((Object)"tenantId", (Object)task.getTenantIds()));
            tenants.forEach(t -> {
                try {
                    String tenantId = (String)t.get("tenantId");
                    oldTenantIds.add(tenantId);
                }
                catch (Exception e) {
                    log.error("checkAppAndTenant error", (Throwable)e);
                }
            });
            List newTenantIds = CollectionUtil.subtractToList((Collection)task.getTenantIds(), oldTenantIds);
            Iterator iterator = newTenantIds.iterator();
            while (iterator.hasNext()) {
                String newTenantId;
                String tenantName = newTenantId = (String)iterator.next();
                if (null != task.getTenantIdNames()) {
                    tenantName = (String)task.getTenantIdNames().get(newTenantId);
                }
                this.createTenant(newTenantId, tenantName, task.getVersion());
            }
            this.neo4jCrudService.createRelation("TenantEntity", (Map)MapUtil.of((Object)"tenantId", (Object)task.getTenantIds()), "AppEntity", map3, "USE");
        }
        try {
            this.checkAppAndTenant2(task, task.getTenantIds());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkAppAndTenant2(DeployTask task, List<String> tenantIds) {
        if (CollectionUtil.isEmpty(tenantIds)) {
            return;
        }
        CrudReq req2 = new CrudReq();
        req2.setDbName(Constant.db_kg_sys);
        req2.setColName("tenantEntity");
        HashMap<String, List<String>> param2 = new HashMap<String, List<String>>();
        param2.put("tenantId", tenantIds);
        req2.setParams(param2);
        List tenantInDb = this.mongoCrudService.query(req2);
        List tenantIdInDb = tenantInDb.stream().map(document -> (String)document.get((Object)"tenantId")).collect(Collectors.toList());
        List tenantIdInDbTodo = this.notContain(tenantIds, tenantIdInDb);
        ApplicationMongoData insertReq2 = new ApplicationMongoData();
        insertReq2.setDb(Constant.db_kg_sys);
        insertReq2.setCol("tenantEntity");
        for (String t : tenantIdInDbTodo) {
            Document document2 = new Document();
            document2.put("tenantId", (Object)t);
            document2.put("version", (Object)task.getVersion());
            insertReq2.getDocs().add(document2);
        }
        this.mongoCrudService.insert(insertReq2);
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("tenantAppRelation");
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("appCode", task.getAppId());
        param1.put("tenantId", tenantIds);
        req1.setParams(param1);
        List apps = this.mongoCrudService.query(req1);
        List tenantIds1 = apps.stream().map(document -> (String)document.get((Object)"tenantId")).collect(Collectors.toList());
        List tenantIds1Todo = this.notContain(tenantIds, tenantIds1);
        ApplicationMongoData insertReq1 = new ApplicationMongoData();
        insertReq1.setDb(Constant.db_kg_sys);
        insertReq1.setCol("tenantAppRelation");
        for (String tenantId : tenantIds1Todo) {
            Document document3 = new Document();
            document3.put("tenantId", (Object)tenantId);
            document3.put("appCode", (Object)task.getAppId());
            insertReq1.getDocs().add(document3);
        }
        this.mongoCrudService.insert(insertReq1);
    }

    private List<String> notContain(List<String> all, List<String> sub) {
        ArrayList<String> notcontain = new ArrayList<String>();
        for (String str : all) {
            if (sub.contains(str)) continue;
            notcontain.add(str);
        }
        return notcontain;
    }

    private void cleanData(DeployTask task, String sourceId, String version, List<String> tenantIds) {
        if (StringUtils.isEmpty((Object)sourceId)) {
            log.warn("cleanData need sourceId");
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)task.getJobList())) {
            this.cleanDataForJobList(task, sourceId, version, tenantIds);
            return;
        }
        this.log(task.getEventId(), "\u5f00\u59cb\u5220\u9664\u8001\u7248\u672cneo4j:" + version, Integer.valueOf(1), null);
        this.neo4jCrudService.cleanNeo4jData(sourceId, version, tenantIds);
        this.log(task.getEventId(), "\u5220\u9664\u8001\u7248\u672cneo4j\u6210\u529f:" + version, Integer.valueOf(2), null);
        this.log(task.getEventId(), "\u5f00\u59cb\u5220\u9664\u8001\u7248\u672cmongo:" + version, Integer.valueOf(1), null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", version);
        params.put("sourceId", sourceId);
        Bson bson = MongoCrudService.buildBson(params);
        List tables = this.cleanableCaches.getKmTables();
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDbFactory().getDb(table.getDb()).getCollection(table.getTable()).deleteMany(bson);
        }
        this.log(task.getEventId(), "\u5220\u9664\u8001\u7248\u672cmongo\u6210\u529f:" + version, Integer.valueOf(2), null);
    }

    private void cleanDataForJobList(DeployTask task, String sourceId, String version, List<String> tenantIds) {
        this.log(task.getEventId(), "\u5f00\u59cb\u5220\u9664\u8001\u7248\u672cneo4j " + version, Integer.valueOf(2), null);
        HashMap<String, Object> baseMap = new HashMap<String, Object>();
        baseMap.put("sourceId", sourceId);
        baseMap.put("version", version);
        if (!CollectionUtils.isEmpty(tenantIds) && ("tenantApp".equalsIgnoreCase(task.getType()) || "tenantCustom".equalsIgnoreCase(task.getType()))) {
            baseMap.put("tenantId", tenantIds);
        }
        for (JobRecord record : task.getJobList()) {
            HashMap<String, Object> param;
            if (CollectionUtil.isEmpty((Collection)record.getKeys())) continue;
            if ("neo4j".equalsIgnoreCase(record.getDb())) {
                for (Map condition : record.getKeys()) {
                    if (condition.isEmpty()) continue;
                    param = new HashMap<String, Object>();
                    param.putAll(baseMap);
                    param.putAll(condition);
                    this.neo4jCrudService.cleanNeo4jData(record.getTable(), param);
                }
                continue;
            }
            for (Map key : record.getKeys()) {
                if (key.isEmpty()) continue;
                param = new HashMap();
                param.putAll(baseMap);
                param.putAll(key);
                Bson bson = MongoCrudService.buildBson(param);
                this.mongoTemplate.getMongoDbFactory().getDb(record.getDb() + this.getDbSuffix()).getCollection(record.getTable()).deleteMany(bson);
            }
        }
        this.log(task.getEventId(), "\u5220\u9664\u8001\u7248\u672cneo4j\u6210\u529f " + version, Integer.valueOf(4), null);
    }

    public DeployResp cleanAppByNamespace(String namespace, Boolean force, String token) {
        DeployResp resp = new DeployResp();
        if (StringUtils.isEmpty((Object)namespace)) {
            return resp;
        }
        this.monitorService.deleteMonitorRules(namespace, token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("athena_namespace", namespace);
        String cyhper = "match(node) where node.athena_namespace=$athena_namespace detach delete node";
        this.neo4jCrudService.executeCypher(cyhper, param);
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)namespace), Filters.eq((String)"athena_namespace", (Object)namespace)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM"), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.ne((String)"tenantId", (Object)"SYSTEM"), Filters.eq((String)"athena_publishType", (Object)"individualCase")})})});
        if (Boolean.TRUE.equals(force)) {
            bson = Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)namespace), Filters.eq((String)"athena_namespace", (Object)namespace)});
        }
        List tables = this.cleanableCaches.getKmTables();
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDbFactory().getDb(table.getDb()).getCollection(table.getTable()).deleteMany(bson);
        }
        return resp;
    }

    public DeployResp cleanAppBySourceId(String sourceId, String appId, String token) {
        DeployResp resp = new DeployResp();
        if (StringUtils.isEmpty((Object)sourceId)) {
            return resp;
        }
        DeployTask task = (DeployTask)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"sourceId").is((Object)sourceId)), DeployTask.class);
        if (null == appId) {
            if (null != task) {
                appId = task.getAppId();
            } else {
                resp.setCode(Integer.valueOf(1));
                resp.setMsg("cant find appId by sourceId:" + sourceId);
            }
        }
        this.monitorService.deleteMonitorRules(appId, token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sourceId", sourceId);
        String cyhper = "match(node) where node.sourceId=$sourceId detach delete node";
        this.neo4jCrudService.executeCypher(cyhper, param);
        Bson bson = MongoCrudService.buildBson(param);
        List tables = this.cleanableCaches.getKmTables();
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDbFactory().getDb(table.getDb()).getCollection(table.getTable()).deleteMany(bson);
        }
        if (null != task && "app".equalsIgnoreCase(task.getType())) {
            this.deleteAppEntity(appId);
        }
        return resp;
    }

    private void deleteAppEntity(String appId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", appId);
        String cyhper = "match(node:AppEntity) where node.code=$code detach delete node";
        this.neo4jCrudService.executeCypher(cyhper, param);
    }

    private void createApplication(String appCode, String appName, Boolean commonApp) {
        String name = appName == null ? appCode : appName;
        String cql = "create(app:AppEntity{code:$code,athena_namespace:$code,namespace:$code,name:$name,commonApp:$commonApp,version:'2.0'})";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", appCode);
        map.put("name", name);
        map.put("commonApp", commonApp);
        this.neo4jCrudService.executeCypher(cql, map);
    }

    private void createTenant(String tenantId, String tenantName, String version) {
        String name = tenantName == null ? tenantId : tenantName;
        String cql = "create(app:TenantEntity{tenantId:$tenantId,tenantName:$name,version:$version})";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantId", tenantId);
        map.put("name", name);
        map.put("version", version);
        this.neo4jCrudService.executeCypher(cql, map);
    }

    private void processApplicationData(DeployTask task, ApplicationData data) {
        if ("app".equalsIgnoreCase(task.getType())) {
            this.processApplicationData(task, data, "SYSTEM");
        } else if ("tenantApp".equalsIgnoreCase(task.getType()) || "tenantCustom".equalsIgnoreCase(task.getType())) {
            for (String tenantId : task.getTenantIds()) {
                this.processApplicationData(task, data, tenantId);
            }
        }
        this.log(task.getEventId(), "\u6570\u636e\u5237\u5165\u6210\u529f", Integer.valueOf(20), null);
    }

    public static void main(String[] args) {
        String cypher = "create (node:Tag{athena_namespace:'APC9d5e51',code:'performer__apc_project_schedule__ORDER_40',commonApp:false,source:'designer',compileVersion:'0.0.0.2504010918_alpha',version:'{athena_version}',scope:['column'],name:'\u987a\u5e8f40',tenantId:'SYSTEM',namespacePath:'task&apc_project_schedule',id:959381334059384834,nameSpace:'APC',category:'ORDER',status:1})";
        String tenantReplace = "tenantId:'tenant001',sourceLevel:200";
        cypher = cypher.replaceAll("tenantId:'SYSTEM'", tenantReplace);
        System.out.println(cypher);
    }

    private void processApplicationData(DeployTask task, ApplicationData data, String tenantId) {
        this.log(task.getEventId(), "\u5f00\u59cb\u5237\u5165\u6570\u636e tenant:" + tenantId, Integer.valueOf(1), null);
        ArrayList<String> cyphers = new ArrayList<String>();
        for (String cypher : data.getCyphers()) {
            cypher = cypher.replaceAll("\\{athena_version}", "3.0");
            cypher = cypher.replaceAll("\\{common_version}", task.getVersion());
            String tenantReplace = "tenantId:'" + tenantId + "',sourceId:'" + task.getSourceId() + "'";
            if ("tenantApp".equalsIgnoreCase(task.getType())) {
                tenantReplace = tenantReplace + ",sourceLevel:" + DeployConstants.SourceLevel.tenantApp;
            } else if ("tenantCustom".equalsIgnoreCase(task.getType())) {
                tenantReplace = tenantReplace + ",sourceLevel:" + DeployConstants.SourceLevel.tenantCustom;
            }
            cypher = cypher.replaceAll("tenantId:'SYSTEM'", tenantReplace);
            if ("tenantApp".equalsIgnoreCase(task.getType()) || "tenantCustom".equalsIgnoreCase(task.getType())) {
                cypher = cypher.replaceAll("tenantId='SYSTEM0'", "tenantId='" + tenantId + "'");
            }
            cyphers.add(cypher);
        }
        this.neo4jCrudService.executeCyphers(cyphers, new HashMap());
        for (ApplicationMongoData item : data.getMongoData()) {
            item.getDocs().forEach(document -> {
                Object docTenantId = document.get((Object)"tenantId");
                if (StringUtils.isEmpty((Object)docTenantId) || "SYSTEM".equals(docTenantId) || "tenantApp".equalsIgnoreCase(task.getType()) || "tenantCustom".equalsIgnoreCase(task.getType())) {
                    document.put("tenantId", (Object)tenantId);
                }
            });
            this.mongoCrudService.insert(item);
            this.log(task.getEventId(), "mongo\u63d2\u5165 " + item.getDb() + " " + item.getCol() + " " + item.getDocs().size() + "\u6761\u8bb0\u5f55", Integer.valueOf(0), null);
        }
    }

    private void updateVersion(DeployTask task, ApplicationData appData) {
        this.log(task.getEventId(), "\u5f00\u59cb\u66f4\u65b0\u53d1\u7248\u6570\u636e\u7248\u672cneo4j", Integer.valueOf(1), null);
        String cypher = "match(n{sourceId:$sourceId,version:$version}) set n.version=$updateVersion";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceId", task.getSourceId());
        params.put("version", "3.0");
        params.put("updateVersion", task.getVersion());
        this.neo4jCrudService.executeCypher(cypher, params);
        this.log(task.getEventId(), "\u66f4\u65b0\u53d1\u7248\u6570\u636e\u7248\u672cneo4j\u6210\u529f", Integer.valueOf(2), null);
        this.log(task.getEventId(), "\u5f00\u59cb\u66f4\u65b0\u53d1\u7248\u6570\u636e\u7248\u672cmongo", Integer.valueOf(1), null);
        for (ApplicationMongoData item : appData.getMongoData()) {
            HashMap<String, String> param1 = new HashMap<String, String>();
            param1.put("sourceId", task.getSourceId());
            param1.put("version", "3.0");
            Bson setv = Updates.set((String)"version", (Object)task.getVersion());
            this.mongoTemplate.getMongoDbFactory().getDb(item.getDb()).getCollection(item.getCol()).updateMany(MongoCrudService.buildBson(param1), setv);
        }
        this.log(task.getEventId(), "\u66f4\u65b0\u53d1\u7248\u6570\u636e\u7248\u672cmongo\u6210\u529f", Integer.valueOf(2), null);
    }

    public void cleanCache() {
        this.kgService.cleanCache();
        this.atmcService.cleanCache();
    }

    private void log(String group, String msg, Integer process, Integer status) {
        this.helpService.logDetail(group, msg, process, status);
    }

    private boolean isCommonApp(DeployTask task) {
        return Boolean.TRUE.equals(task.getCommonApp());
    }

    public DeployResp test_initApplicationSourceId(DeployReq request) throws IOException {
        DeployResp resp = new DeployResp();
        if (null == request.getSourceId() || null == request.getAppId()) {
            return DeployResp.failed((Integer)1, (String)"\u53c2\u6570\u9519\u8bef");
        }
        String cypher = "match(n) where n.athena_namespace=$appId and not any(label in labels(n) WHERE label in ['AppEntity','TenantEntity']) set n.sourceId=$sourceId";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appId", request.getAppId());
        params.put("sourceId", request.getSourceId());
        this.neo4jCrudService.executeCypher(cypher, params);
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)request.getAppId()), Filters.eq((String)"athena_namespace", (Object)request.getAppId())}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM"), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.ne((String)"tenantId", (Object)"SYSTEM"), Filters.eq((String)"athena_publishType", (Object)"individualCase")})})});
        Bson setv = Updates.set((String)"sourceId", (Object)request.getSourceId());
        List tables = this.cleanableCaches.getKmTables();
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDbFactory().getDb(table.getDb()).getCollection(table.getTable()).updateMany(bson, setv);
        }
        return resp;
    }

    public DeployResp test_cleanApplicationSourceId(DeployReq request) throws IOException {
        DeployResp resp = new DeployResp();
        if (null == request.getAppId()) {
            return DeployResp.failed((Integer)1, (String)"\u53c2\u6570\u9519\u8bef");
        }
        String cypher = "match(n) where n.athena_namespace=$appId set n.sourceId=null";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appId", request.getAppId());
        this.neo4jCrudService.executeCypher(cypher, params);
        Bson bson = Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)request.getAppId()), Filters.eq((String)"athena_namespace", (Object)request.getAppId())});
        Bson setv = Updates.set((String)"sourceId", null);
        List tables = this.cleanableCaches.getKmTables();
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDbFactory().getDb(table.getDb()).getCollection(table.getTable()).updateMany(bson, setv);
        }
        return resp;
    }

    public DeployResp test_initTenantId() throws IOException {
        DeployResp resp = new DeployResp();
        String cypher = "match(n) where n.tenantId is null set n.tenantId='SYSTEM'";
        HashMap params = new HashMap();
        this.neo4jCrudService.executeCypher(cypher, params);
        String cypher2 = "match(t:TenantEntity{ifCommon:true})-[]->(n) set n.commonApp=true";
        HashMap params2 = new HashMap();
        this.neo4jCrudService.executeCypher(cypher2, params2);
        Bson qb = Filters.or((Bson[])new Bson[]{Filters.exists((String)"tenantId", (boolean)false), Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"")});
        Bson setv = Updates.set((String)"tenantId", (Object)"SYSTEM");
        List tables = this.cleanableCaches.getKmTables();
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDbFactory().getDb(table.getDb()).getCollection(table.getTable()).updateMany(qb, setv);
        }
        return resp;
    }

    public void cleandeploy(String deployId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)deployId));
        this.mongoTemplate.remove(query, DeployDataRecord.class);
        this.mongoTemplate.remove(query, DeployLog.class);
        this.mongoTemplate.remove(query, MonitorHash.class);
        String appDir = deployId;
        String applicationCompileZipPath = this.compileZipPath + File.separator + appDir;
        String applicationCompileDataPath = this.compileDataPath + File.separator + appDir;
        FileUtil.del((String)applicationCompileZipPath);
        FileUtil.del((String)applicationCompileDataPath);
    }

    public boolean checkSource(String sourceId) {
        long count = this.mongoTemplate.getMongoDbFactory().getDb(Constant.db_kg_sys).getCollection("application").countDocuments(Filters.eq((String)"sourceId", (Object)sourceId));
        return count > 0L;
    }

    public void cleanHis() {
        long time = System.currentTimeMillis() - 1296000000L;
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"updateTime").lt((Object)time));
        List tasks = this.mongoTemplate.find(query, DeployTask.class);
        System.out.println("\u6e05\u7406\u5386\u53f2\u6570\u636e...." + tasks.size());
        for (DeployTask task : tasks) {
            this.cleandeploy(task.getDeployId());
        }
    }

    public void cleanTimeoutTask() {
        long time = System.currentTimeMillis() - this.expiredMinutes * 60L * 1000L;
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"status").is((Object)1));
        List tasks = this.mongoTemplate.find(query, DeployTask.class);
        for (DeployTask task : tasks) {
            if (null == task.getUpdateTime() || task.getUpdateTime() >= time) continue;
            System.out.println("\u4efb\u52a1\u5df2\u8fc7\u671f\uff1a" + task);
            task.setStatus(Integer.valueOf(5));
            task.setEndTime(new Date());
            this.mongoTemplate.save((Object)task);
        }
    }

    public void cleanAll() {
        Query query = new Query();
        this.mongoTemplate.remove(query, DeployTask.class);
        this.mongoTemplate.remove(query, DeployDataRecord.class);
        this.mongoTemplate.remove(query, DeployLog.class);
        this.mongoTemplate.remove(query, MonitorHash.class);
    }

    public List<KmTable> initTables() {
        ArrayList<KmTable> tables = new ArrayList<KmTable>();
        List knowledgegraphSystem = Utils.loadObjects((String)"/doc/knowledgegraphSystem.json", KmTable.class);
        List knowledgegraph = Utils.loadObjects((String)"/doc/knowledgegraph.json", KmTable.class);
        List datamap = Utils.loadObjects((String)"/doc/datamap.json", KmTable.class);
        List preset = Utils.loadObjects((String)"/doc/preset.json", KmTable.class);
        List tagSystem = Utils.loadObjects((String)"/doc/tagSystem.json", KmTable.class);
        List deliveryDesigner = Utils.loadObjects((String)"/doc/deliveryDesigner.json", KmTable.class);
        List neo4j = Utils.loadObjects((String)"/doc/neo4j.json", KmTable.class);
        tables.addAll(knowledgegraphSystem);
        tables.addAll(knowledgegraph);
        tables.addAll(datamap);
        tables.addAll(preset);
        tables.addAll(tagSystem);
        tables.addAll(deliveryDesigner);
        tables.addAll(neo4j);
        tables.forEach(table -> table.setDb(table.getDb() + this.getDbSuffix()));
        return tables;
    }

    public String getDbSuffix() {
        if (Boolean.TRUE.equals(this.appConfig.getUcMode())) {
            return this.appConfig.getUcSuffix();
        }
        return "";
    }

    public void afterPropertiesSet() throws Exception {
        Constant.db_datamap = Constant.db_datamap + this.getDbSuffix();
        Constant.db_kg = Constant.db_kg + this.getDbSuffix();
        Constant.db_kg_sys = Constant.db_kg_sys + this.getDbSuffix();
        this.restartTaking(null, true);
    }
}

