/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service;

import com.digiwin.athena.deploy.DeployLog;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class HelpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelpService.class);
    @Autowired
    RedisLockRegistry redisLockRegistry;
    @Autowired
    MongoTemplate mongoTemplate;
    private static ThreadLocal<DeployContext> deployLocal = new InheritableThreadLocal();

    public static void setDeployContext(DeployContext context) {
        deployLocal.set(context);
    }

    public static DeployContext getDeployContext() {
        return (DeployContext)deployLocal.get();
    }

    public static void remove() {
        deployLocal.remove();
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public boolean lock(String key) {
        boolean result = this.redisLockRegistry.obtain((Object)key).tryLock();
        return result;
    }

    public void logDetail(String group, String msg, Integer process, Integer status) {
        if (null == process) {
            process = 0;
        }
        if (null == status) {
            status = 1;
        }
        DeployContext context = HelpService.getDeployContext();
        context.setProcess(context.getProcess() + process);
        DeployLog dlog = new DeployLog();
        dlog.setDeployId(context.getDeployId());
        dlog.setEventId(context.getEventId());
        dlog.setAppId(context.getAppId());
        dlog.setSourceId(context.getSourceId());
        dlog.setProcess(Integer.valueOf(context.getProcess()));
        dlog.setGroup(group);
        dlog.setMsg(msg);
        dlog.setStatus(status);
        dlog.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        if (status != 2 && dlog.getProcess() > 99) {
            dlog.setProcess(Integer.valueOf(99));
        }
        if (status == 2) {
            dlog.setProcess(Integer.valueOf(100));
        }
        this.mongoTemplate.save((Object)dlog);
        log.info(dlog.getAppId() + " " + dlog.getSourceId() + " " + dlog.getDeployId() + " " + dlog.getEventId() + " " + msg + " " + dlog.getProcess());
    }

    public void logDetail(String group, String msg, int process) {
        this.logDetail(group, msg, Integer.valueOf(process), Integer.valueOf(1));
    }

    public void logDetail(String group, String msg) {
        log.info(group + " " + msg);
    }
}

