/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service;

import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.povo.PageVo;
import com.digiwin.athena.km_deployer_service.povo.ServerMapReq;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapInfoAppender;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapMongoAnalyzer;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapNeo4jAnalyzer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ServerMapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerMapService.class);
    private final MongoTemplate mongoTemplate;
    private final MongoCrudService mongoCrudService;
    private final Neo4jCrudService neo4jCrudService;
    @Value(value="${spring.data.mongodb.database}")
    private String dbName;
    @Value(value="${serverMap.mongo.batch.size:100}")
    private int mongoBatchSize;
    @Value(value="${serverMap.neo4j.batch.size:100}")
    private int neo4jBatchSize;

    public ServerMapService(MongoTemplate mongoTemplate, MongoCrudService mongoCrudService, Neo4jCrudService neo4jCrudService) {
        this.mongoTemplate = mongoTemplate;
        this.mongoCrudService = mongoCrudService;
        this.neo4jCrudService = neo4jCrudService;
    }

    public void analysisServer() {
        long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ArrayList futures = new ArrayList();
        ServerMapInfoAppender appender = new ServerMapInfoAppender(this.mongoCrudService, this.neo4jCrudService);
        futures.add(executorService.submit(new ServerMapNeo4jAnalyzer("MonitorRule", "\u4fa6\u6d4b", this.neo4jCrudService, this.mongoTemplate, appender, this.neo4jBatchSize, this.mongoBatchSize)));
        futures.add(executorService.submit(new ServerMapMongoAnalyzer("datamap", "project", "project", "\u9879\u76ee", this.mongoCrudService, this.mongoTemplate, appender, this.mongoBatchSize)));
        futures.add(executorService.submit(new ServerMapMongoAnalyzer("datamap", "pageView", "task", "\u4efb\u52a1", this.mongoCrudService, this.mongoTemplate, appender, this.mongoBatchSize)));
        futures.add(executorService.submit(new ServerMapMongoAnalyzer("knowledgegraphSystem", "activityConfigs", "basicActivity", "\u57fa\u7840\u8d44\u6599/\u62a5\u8868", this.mongoCrudService, this.mongoTemplate, appender, this.mongoBatchSize)));
        futures.add(executorService.submit(new ServerMapMongoAnalyzer("knowledgegraphSystem", "mechanismCapacity", "mechanism", "\u673a\u5236", this.mongoCrudService, this.mongoTemplate, appender, this.mongoBatchSize)));
        futures.add(executorService.submit(new ServerMapMongoAnalyzer("knowledgegraphSystem", "variableDefinition", "variableDefinition", "\u673a\u5236\u53d8\u91cf", this.mongoCrudService, this.mongoTemplate, appender, this.mongoBatchSize)));
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        log.info("analysisServer finished cost: {}", (Object)(System.currentTimeMillis() - start));
    }

    public PageVo<EspServiceMapDto> query(ServerMapReq req) {
        return this.mongoCrudService.queryWithPage(this.dbName, "espServiceMapDto", req.getQueryParams(), req.getPage(), req.getPageSize(), EspServiceMapDto.class);
    }

    public void delete(ServerMapReq req) {
        CrudReq deleteReq = new CrudReq();
        deleteReq.setDbName(this.dbName);
        deleteReq.setColName("espServiceMapDto");
        deleteReq.setParams(req.getQueryParams());
        this.mongoCrudService.delete(deleteReq);
    }

    public void update(ServerMapReq req) {
        CrudReq update = new CrudReq();
        update.setDbName(this.dbName);
        update.setColName("espServiceMapDto");
        update.setParams(req.getQueryParams());
        update.setData(req.getUpdateParams());
        this.mongoCrudService.update(update);
    }

    public void insert(List<EspServiceMapDto> dto) {
        this.mongoTemplate.insertAll(dto);
    }

    public void deleteAll() {
        this.mongoTemplate.dropCollection("espServiceMapDto");
    }
}

