/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.asaDeploy.impl;

import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployVersionParam;
import com.digiwin.athena.km_deployer_service.domain.asa.param.SwitchVersionParam;
import com.digiwin.athena.km_deployer_service.helper.AniaHelper;
import com.digiwin.athena.km_deployer_service.helper.AssistantRhApiHelper;
import com.digiwin.athena.km_deployer_service.helper.IMApiHelper;
import com.digiwin.athena.km_deployer_service.service.appEntity.AppEntityService;
import com.digiwin.athena.km_deployer_service.service.asaDeploy.AsaDeployService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.CacheService;
import com.digiwin.athena.km_deployer_service.service.km.TenantService;
import com.digiwin.athena.km_deployer_service.service.page.PageService;
import com.digiwin.athena.km_deployer_service.spi.AtmcService;
import com.digiwin.athena.km_deployer_service.spi.KgService;
import com.digiwin.athena.km_deployer_service.template.ITemplate;
import com.digiwin.athena.km_deployer_service.thread.DeployThread;
import com.digiwin.athena.km_deployer_service.thread.SwitchVersionThread;
import com.digiwin.athena.km_deployer_service.util.CurThreadInfoUtils;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class AsaDeployServiceImpl
implements AsaDeployService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsaDeployServiceImpl.class);
    @Resource(name="asaMongoTemplate")
    private MongoTemplate asaMongoTemplate;
    @Resource(name="mongoDatamapTemplate")
    private MongoTemplate kmMongoTemplate;
    @Resource(name="mongoKgsysTemplate")
    private MongoTemplate kgsysMongoTemplate;
    @Resource(name="mongoPresetTemplate")
    private MongoTemplate presetMongoTemplate;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Value(value="${spring.data.mongo-datamap.database}")
    private String datamapDBName;
    @Value(value="${spring.data.mongo-kgsys.database}")
    private String kgsysDBName;
    @Value(value="${spring.data.mongo-preset.database}")
    private String presetDBName;
    @Autowired
    private CacheService cacheService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    protected PageService pageService;
    @Autowired
    private AppEntityService appEntityService;
    @Autowired
    private IMApiHelper imApiHelper;
    @Autowired
    private KgService kgService;
    @Autowired
    private AtmcService atmcService;
    @Resource
    private ApplicationContext applicationContext;
    @Autowired
    private Map<String, ITemplate> templateMap;
    @Autowired
    private AssistantRhApiHelper assistantRhApiHelper;
    @Autowired
    private AniaHelper aniaHelper;

    public void deploy(DeployVersionParam deployVersionParam) {
        DeployThread deployThread = new DeployThread(deployVersionParam);
        deployThread.setCacheService(this.cacheService);
        deployThread.setDmcService(this.dmcService);
        deployThread.setTenantService(this.tenantService);
        deployThread.setPageService(this.pageService);
        deployThread.setAppEntityService(this.appEntityService);
        deployThread.setMongoTemplate(this.asaMongoTemplate);
        deployThread.setKmMongoTemplate(this.kmMongoTemplate);
        deployThread.setKgsysMongoTemplate(this.kgsysMongoTemplate);
        deployThread.setPresetMongoTemplate(this.presetMongoTemplate);
        deployThread.setImApiHelper(this.imApiHelper);
        deployThread.setKgService(this.kgService);
        deployThread.setAtmcService(this.atmcService);
        deployThread.setCompileZipPath(this.compileZipPath);
        deployThread.setCompileDataPath(this.compileDataPath);
        deployThread.setApplicationContext(this.applicationContext);
        deployThread.setTemplateMap(this.templateMap);
        deployThread.setDatamapDBName(this.datamapDBName);
        deployThread.setKgsysDBName(this.kgsysDBName);
        deployThread.setPresetDBName(this.presetDBName);
        deployThread.setAssistantRhApiHelper(this.assistantRhApiHelper);
        deployThread.setAniaHelper(this.aniaHelper);
        deployThread.setRouterKey(CurThreadInfoUtils.getRouterKey());
        deployThread.start();
    }

    public void switchVersion(SwitchVersionParam switchVersionParam) {
        SwitchVersionThread switchVersionThread = new SwitchVersionThread(switchVersionParam);
        switchVersionThread.setCacheService(this.cacheService);
        switchVersionThread.setMongoTemplate(this.asaMongoTemplate);
        switchVersionThread.setKmMongoTemplate(this.kmMongoTemplate);
        switchVersionThread.setKgsysMongoTemplate(this.kgsysMongoTemplate);
        switchVersionThread.setPresetMongoTemplate(this.presetMongoTemplate);
        switchVersionThread.setImApiHelper(this.imApiHelper);
        switchVersionThread.setKgService(this.kgService);
        switchVersionThread.setAtmcService(this.atmcService);
        switchVersionThread.setApplicationContext(this.applicationContext);
        switchVersionThread.setDatamapDBName(this.datamapDBName);
        switchVersionThread.setKgsysDBName(this.kgsysDBName);
        switchVersionThread.setPresetDBName(this.presetDBName);
        switchVersionThread.setTenantService(this.tenantService);
        switchVersionThread.setPageService(this.pageService);
        switchVersionThread.setAssistantRhApiHelper(this.assistantRhApiHelper);
        switchVersionThread.setAniaHelper(this.aniaHelper);
        switchVersionThread.setRouterKey(CurThreadInfoUtils.getRouterKey());
        switchVersionThread.start();
    }
}

