/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.deploy;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.DeployTask;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.MonitorHash;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.KmPublishRepo;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.deploy.KmPublishRepo2;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MonitorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorService.class);
    private static final String DEFAULT_VERSION = "1.0";
    private static final List<String> EXCLUDE_FIELDS = Arrays.asList("_id", "_class", "id", "version", "compileVersion", "oldNodeId", "publishTime", "sourceId", "athena_namespace", "application", "pluginId", "tenantId", "deployId");
    @Resource
    private MongoCrudService mongoCrudService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private Neo4jCrudService neo4jCrudService;
    @Resource
    KmPublishRepo kmPublishRepo;
    @Autowired
    KmPublishRepo2 kmPublishRepo2;
    @Value(value="${module.km.domain}/restful/service/knowledgegraph/")
    private String knowledgeGraphUrl;

    public void monitorRuleHash(DeployTask task) {
        if ("tenantApp".equalsIgnoreCase(task.getType())) {
            String appSourceId;
            if (!Boolean.TRUE.equals(task.getIndividualAll())) {
                return;
            }
            List oldTenants = this.kmPublishRepo2.findUseSourceAppTenants(task.getSourceId(), task.getVersion());
            task.setLastIndividualTenantIds(oldTenants);
            ArrayList<String> individualRemovedTenantIds = new ArrayList<String>();
            ArrayList<String> individualAddedTenantIds = new ArrayList<String>();
            ArrayList<String> individualKeepTenantIds = new ArrayList<String>();
            for (String tenantId : task.getTenantIds()) {
                if (oldTenants.contains(tenantId)) {
                    individualKeepTenantIds.add(tenantId);
                    continue;
                }
                individualAddedTenantIds.add(tenantId);
            }
            for (String tenantId : oldTenants) {
                if (task.getTenantIds().contains(tenantId)) continue;
                individualRemovedTenantIds.add(tenantId);
            }
            task.setIndividualAddedTenantIds(individualAddedTenantIds);
            task.setIndividualKeepTenantIds(individualKeepTenantIds);
            task.setIndividualRemovedTenantIds(individualRemovedTenantIds);
            this.monitorHash(task, task.getSourceId(), 0);
            if (!(individualAddedTenantIds.isEmpty() && individualRemovedTenantIds.isEmpty() || null == (appSourceId = this.kmPublishRepo2.appSourceId(task.getAppId())))) {
                this.monitorHash(task, appSourceId, 2);
            }
        } else {
            this.monitorHash(task, task.getSourceId(), 0);
        }
    }

    public void monitorHash(DeployTask deployReq, String sourceId, int position) {
        CrudReq req = new CrudReq();
        req.setDbName(Constant.db_kg_sys);
        req.setColName("applicationRelation");
        req.setParams(new HashMap());
        req.getParams().put("version", DEFAULT_VERSION);
        req.getParams().put("sourceId", sourceId);
        req.getParams().put("type", "monitorRule");
        List applicationRelations = this.mongoCrudService.query(req);
        if (CollectionUtil.isEmpty((Collection)applicationRelations)) {
            return;
        }
        List monitorCodes = applicationRelations.stream().map(e -> MapUtil.getStr((Map)e, (Object)"code")).distinct().collect(Collectors.toList());
        HashMap monitorMaps = new HashMap();
        HashMap<String, Object> monitorParam = new HashMap<String, Object>();
        monitorParam.put("sourceId", sourceId);
        monitorParam.put("version", DEFAULT_VERSION);
        monitorParam.put("code", monitorCodes);
        List monitorRules = this.neo4jCrudService.query("MonitorRule", monitorParam);
        Map<Object, Object> monitorRuleMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)monitorRules)) {
            monitorRuleMap = monitorRules.stream().collect(Collectors.toMap(e -> MapUtil.getStr((Map)e, (Object)"code"), e -> e, (a, b) -> a));
            monitorRuleMap.forEach((k, v) -> {
                EXCLUDE_FIELDS.forEach(v::remove);
                HashMap<String, Map> info = new HashMap<String, Map>();
                info.put("monitorRule", (Map)v);
                monitorMaps.put(k, info);
            });
        }
        CrudReq monitorRuleProductConfigReq = new CrudReq();
        monitorRuleProductConfigReq.setDbName(Constant.db_kg_sys);
        monitorRuleProductConfigReq.setColName("monitorRuleProductConfig");
        monitorRuleProductConfigReq.setParams(new HashMap());
        monitorRuleProductConfigReq.getParams().put("version", DEFAULT_VERSION);
        monitorRuleProductConfigReq.getParams().put("sourceId", sourceId);
        List monitorRuleProductConfigs = this.mongoCrudService.query(monitorRuleProductConfigReq);
        for (Document productDoc : monitorRuleProductConfigs) {
            Object monitorMap;
            String monitorCode = productDoc.getString((Object)"monitorRuleId");
            String productName = productDoc.getString((Object)"productName");
            if (null == monitorCode || null == productName || null == (monitorMap = (Map)monitorMaps.get(monitorCode))) continue;
            EXCLUDE_FIELDS.forEach(arg_0 -> ((Document)productDoc).remove(arg_0));
            monitorMap.put(productName, productDoc);
        }
        List last = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)deployReq.getDeployId())), MonitorHash.class);
        for (String code : monitorCodes) {
            MonitorHash mh = new MonitorHash();
            for (MonitorHash hash : last) {
                if (!code.equals(hash.getMonitorCode())) continue;
                mh = hash;
                break;
            }
            mh.setDeployId(deployReq.getDeployId());
            mh.setMonitorCode(code);
            Map map = (Map)monitorMaps.get(code);
            if (MapUtil.isNotEmpty((Map)map)) {
                int hash = HashUtil.apHash((String)JSON.toJSONString((Object)map));
                switch (position) {
                    case 0: {
                        mh.setHash0(Integer.valueOf(hash));
                        break;
                    }
                    case 1: {
                        mh.setHash1(Integer.valueOf(hash));
                        break;
                    }
                    case 2: {
                        mh.setHash2(Integer.valueOf(hash));
                    }
                }
                Map info = (Map)map.get("monitorRule");
                mh.setActionType(MapUtil.getStr((Map)info, (Object)"actionType"));
                mh.setAutoRun(MapUtil.getBool((Map)info, (Object)"autoRun"));
                StringBuilder stringBuilder = new StringBuilder();
                map.forEach((k, v) -> {
                    if (!"monitorRule".equals(k)) {
                        stringBuilder.append((String)k).append(",");
                    }
                });
                mh.setProductNames(stringBuilder.toString());
            }
            this.mongoTemplate.save((Object)mh);
        }
    }

    public void checkAndPush(DeployTask task) {
        List hashs = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)task.getDeployId())), MonitorHash.class);
        if ("tenantApp".equalsIgnoreCase(task.getType()) || "tenantCustom".equalsIgnoreCase(task.getType())) {
            if (!CollectionUtils.isEmpty((Collection)task.getIndividualRemovedTenantIds())) {
                for (MonitorHash hash : hashs) {
                    if (null == hash.getHash0() || null != hash.getHash2()) continue;
                    this.monitorDelete(task.getToken(), hash, (Collection)task.getIndividualRemovedTenantIds());
                    hash.setAction("delete");
                    hash.setActionTime(new Date());
                    hash.setDesc("Individual delete code=" + hash.getMonitorCode() + ",tenants=" + task.getIndividualRemovedTenantIds());
                    this.mongoTemplate.save((Object)hash);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)task.getIndividualAddedTenantIds())) {
                HashSet<String> updateCodes = new HashSet<String>();
                ArrayList<String> addedCodes = new ArrayList<String>();
                for (MonitorHash hash : hashs) {
                    if (null != hash.getHash1() && null == hash.getHash2()) {
                        if (!"workflow".equalsIgnoreCase(hash.getActionType()) && !Boolean.TRUE.equals(hash.getAutoRun())) continue;
                        addedCodes.add(hash.getMonitorCode());
                        hash.setAction("add");
                        hash.setActionTime(new Date());
                        hash.setDesc("Individual add code=" + hash.getMonitorCode() + ",tenants=" + task.getIndividualAddedTenantIds());
                        this.mongoTemplate.save((Object)hash);
                        continue;
                    }
                    if (Boolean.TRUE.equals(hash.getShouldPush()) || null != hash.getHash1() && !hash.getHash1().equals(hash.getHash2())) {
                        hash.setAction("modify");
                        hash.setActionTime(new Date());
                        hash.setDesc("Individual modify code=" + hash.getMonitorCode() + ",tenants=" + task.getIndividualAddedTenantIds());
                        this.mongoTemplate.save((Object)hash);
                        updateCodes.add(hash.getMonitorCode());
                        continue;
                    }
                    if (null != hash.getHash1() || null == hash.getHash2()) continue;
                    this.monitorDelete(task.getToken(), hash, (Collection)task.getIndividualAddedTenantIds());
                    hash.setAction("delete");
                    hash.setActionTime(new Date());
                    hash.setDesc("Individual delete code=" + hash.getMonitorCode() + ",tenants=" + task.getIndividualAddedTenantIds());
                    this.mongoTemplate.save((Object)hash);
                }
                this.monitorAdd(task, addedCodes, (Collection)task.getIndividualAddedTenantIds());
                this.monitorModify(task, updateCodes, new HashSet(task.getIndividualAddedTenantIds()));
            }
            if (!CollectionUtils.isEmpty((Collection)task.getIndividualKeepTenantIds())) {
                this.checkAndPush0(hashs, task, new HashSet(task.getIndividualKeepTenantIds()));
            }
        } else {
            Set useAppTenants = this.kmPublishRepo2.findUseAppTenants(task.getAppId(), task.getVersion());
            this.checkAndPush0(hashs, task, useAppTenants);
        }
    }

    public void checkAndPush0(List<MonitorHash> last, DeployTask deployReq, Set<String> useAppTenants) {
        if (CollectionUtils.isEmpty(useAppTenants)) {
            return;
        }
        HashSet<String> updateCodes = new HashSet<String>();
        ArrayList<String> addedCodes = new ArrayList<String>();
        for (MonitorHash hash : last) {
            if (null == hash.getHash0() && null == hash.getHash1()) continue;
            if (null == hash.getHash0()) {
                if (!"workflow".equalsIgnoreCase(hash.getActionType()) && !Boolean.TRUE.equals(hash.getAutoRun())) continue;
                addedCodes.add(hash.getMonitorCode());
                hash.setAction("add");
                hash.setActionTime(new Date());
                this.mongoTemplate.save((Object)hash);
                continue;
            }
            if (null == hash.getHash1()) {
                this.monitorDelete(deployReq.getToken(), hash, useAppTenants);
                hash.setAction("delete");
                hash.setActionTime(new Date());
                this.mongoTemplate.save((Object)hash);
                continue;
            }
            if (!Boolean.TRUE.equals(hash.getShouldPush()) && hash.getHash0().equals(hash.getHash1())) continue;
            hash.setAction("modify");
            hash.setActionTime(new Date());
            this.mongoTemplate.save((Object)hash);
            updateCodes.add(hash.getMonitorCode());
        }
        if ("tenantApp".equalsIgnoreCase(deployReq.getType()) || "tenantCustom".equalsIgnoreCase(deployReq.getType())) {
            this.monitorModify(deployReq, updateCodes, useAppTenants);
            this.monitorAdd(deployReq, addedCodes, useAppTenants);
        } else {
            this.monitorModify(deployReq, updateCodes, null);
            this.monitorAdd(deployReq, addedCodes, null);
        }
    }

    private void monitorAdd(DeployTask req, MonitorHash hash, Set<String> useAppTenants) {
        String code = hash.getMonitorCode();
        System.out.println("monitorAdd:" + code);
        ArrayList<String> products = new ArrayList<String>();
        if (null != hash.getProductNames()) {
            products.addAll(Arrays.asList(hash.getProductNames().split(",")));
        } else {
            products.add(req.getAppId());
        }
        for (String tenantId : useAppTenants) {
            Document d = new Document();
            d.put("monitorRuleId", (Object)code);
            d.put("tenantId", (Object)tenantId);
            d.put("status", (Object)1);
            d.put("configId", (Object)RandomUtil.randomStringUpper((int)33));
            for (String pro : products) {
                d.put("productName", (Object)pro);
                JSONObject paramJson = new JSONObject();
                paramJson.put("config", (Object)d);
                this.requestKg("MonitorRuleConfig", paramJson, Method.PUT, req.getToken());
            }
        }
    }

    private void monitorAdd(DeployTask req, List<String> monitorCodes, Collection<String> useAppTenants) {
        if (monitorCodes.isEmpty()) {
            return;
        }
        System.out.println("monitorAdd:" + monitorCodes);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appCode", req.getAppId());
        param.put("ruleIdList", monitorCodes);
        param.put("tenantIds", useAppTenants);
        JSONObject paramJson = new JSONObject();
        paramJson.put("param", param);
        this.requestKg("tenant/initMonitorRuleForExistsTenant", paramJson, Method.POST, req.getToken());
    }

    private void monitorDelete(String token, MonitorHash hash, Collection<String> useAppTenants) {
        System.out.println("monitorDelete:" + hash.getMonitorCode());
        for (String tenantId : useAppTenants) {
            JSONObject config = new JSONObject();
            config.fluentPut("tenantId", (Object)tenantId).fluentPut("monitorRuleId", (Object)hash.getMonitorCode());
            JSONObject param = new JSONObject();
            param.put("config", (Object)config);
            this.requestKg("MonitorRuleConfig", param, Method.DELETE, token);
        }
    }

    private void monitorModify(DeployTask req, Set<String> updateCodes, Set<String> useAppTenants) {
        if (updateCodes.isEmpty()) {
            return;
        }
        System.out.println("monitorModify:" + updateCodes);
        JSONObject noticeInfo = new JSONObject();
        noticeInfo.fluentPut("ruleIds", updateCodes).fluentPut("version", (Object)req.getVersion()).fluentPut("limitedTenantIdList", useAppTenants).fluentPut("excludedTenantIdList", Collections.emptyList()).fluentPut("productChangeInfo", Collections.emptyMap());
        JSONObject paramJson = new JSONObject();
        paramJson.put("noticeInfo", (Object)noticeInfo);
        this.requestKg("MonitorRuleConfig/noticeWhenMonitorRuleConfigChange", paramJson, Method.POST, req.getToken());
    }

    public void deleteMonitorRules(String appId, String token) {
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        Set tenants = this.kmPublishRepo2.findUseAppTenants(appId, null);
        CrudReq req = new CrudReq();
        req.setDbName(Constant.db_kg_sys);
        req.setColName("applicationRelation");
        req.setParams(new HashMap());
        req.getParams().put("appCode", appId);
        req.getParams().put("type", "monitorRule");
        List applicationRelations = this.mongoCrudService.query(req);
        if (CollectionUtil.isEmpty((Collection)applicationRelations)) {
            return;
        }
        List monitorCodes = applicationRelations.stream().map(e -> MapUtil.getStr((Map)e, (Object)"code")).distinct().collect(Collectors.toList());
        for (String code : monitorCodes) {
            MonitorHash monitorHash = new MonitorHash();
            monitorHash.setMonitorCode(code);
            this.monitorDelete(token, monitorHash, (Collection)tenants);
        }
    }

    private void requestKg(String serviceName, JSONObject paramJson, Method method, String token) {
        String url = this.knowledgeGraphUrl + serviceName;
        try {
            String response = ((HttpRequest)HttpUtil.createRequest((Method)method, (String)url).header("token", token)).body(paramJson.toJSONString()).execute().body();
            log.info("\u8bf7\u6c42kg\u6210\u529f:{}", (Object)response);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42kg\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }
}

