/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.km_deployer_service.domain.km.CleanMongoParam;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.PageVo;
import com.digiwin.athena.km_deployer_service.service.km.BatchProcessCallBack;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MongoCrudService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;

    public List<String> listTables(String db) {
        ArrayList<String> tables = new ArrayList<String>();
        MongoIterable iterable = this.mongoTemplate.getMongoDbFactory().getDb(db).listCollectionNames();
        iterable.forEach((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        return tables;
    }

    public void insert(ApplicationMongoData req) {
        if (null == req.getDb() || null == req.getCol() || CollectionUtil.isEmpty((Collection)req.getDocs())) {
            return;
        }
        List docsSplit = ListUtil.split((List)req.getDocs(), (int)100);
        for (List documents : docsSplit) {
            documents.forEach(doc -> doc.remove((Object)"_id"));
            this.mongoTemplate.getMongoDbFactory().getDb(req.getDb()).getCollection(req.getCol()).insertMany(documents);
        }
    }

    public void insertOne(CrudReq req) {
        if (null == req.getDbName() || null == req.getColName() || null == req.getData()) {
            return;
        }
        Document doc = MongoCrudService.toDoc((Map)req.getData());
        this.mongoTemplate.getMongoDbFactory().getDb(req.getDbName()).getCollection(req.getColName()).insertOne((Object)doc);
    }

    public void delete(CrudReq req) {
        if (null == req.getDbName() || null == req.getColName() || CollectionUtil.isEmpty((Map)req.getParams())) {
            return;
        }
        this.mongoTemplate.getMongoDbFactory().getDb(req.getDbName()).getCollection(req.getColName()).deleteMany(MongoCrudService.buildBson((Map)req.getParams()));
    }

    public void update(CrudReq req) {
        if (null == req.getDbName() || null == req.getColName() || CollectionUtil.isEmpty((Map)req.getParams())) {
            return;
        }
        this.mongoTemplate.getMongoDbFactory().getDb(req.getDbName()).getCollection(req.getColName()).updateMany(MongoCrudService.buildBson((Map)req.getParams()), MongoCrudService.buildUpdateSet((Map)req.getData()));
    }

    public static List<Bson> buildUpdateSet(Map<String, Object> data) {
        ArrayList<Bson> bsons = new ArrayList<Bson>();
        data.forEach((k, v) -> bsons.add(Updates.set((String)k, (Object)v)));
        return bsons;
    }

    public List<Document> query(CrudReq req) {
        if (null == req.getDbName() || null == req.getColName()) {
            return null;
        }
        ArrayList<Document> list = new ArrayList<Document>();
        FindIterable docs = this.mongoTemplate.getMongoDbFactory().getDb(req.getDbName()).getCollection(req.getColName()).find(MongoCrudService.buildBson((Map)req.getParams()));
        docs.forEach(doc -> list.add((Document)doc));
        return list;
    }

    public void updateVersion(ApplicationMongoData req, String app, String version, String updateVersion) {
        HashMap<String, String> param1 = new HashMap<String, String>();
        param1.put("athena_namespace", app);
        param1.put("version", version);
        Bson setv = Updates.set((String)"version", (Object)updateVersion);
        this.mongoTemplate.getMongoDbFactory().getDb(req.getDb()).getCollection(req.getCol()).updateMany(MongoCrudService.buildBson(param1), setv);
    }

    public void cleanMongoData(CleanMongoParam cleanMongoParam) {
        Map collectionInfo = cleanMongoParam.getCollectionInfo();
        String application = cleanMongoParam.getApplication();
        collectionInfo.forEach((dbName, collectionNameList) -> {
            Bson bson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)cleanMongoParam.getDeployVersion()), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM"), Filters.eq((String)"athena_publishType", (Object)"individualCase")})});
            for (String collectionName : collectionNameList) {
                this.mongoTemplate.getMongoDbFactory().getDb(dbName).getCollection(collectionName).deleteMany(bson);
            }
        });
    }

    public static List<Document> toDocs(List<Map<String, Object>> docs) {
        return docs.stream().map(map -> MongoCrudService.toDoc((Map)map)).collect(Collectors.toList());
    }

    public static Document toDoc(Map<String, Object> doc) {
        return new Document(doc);
    }

    public static Bson buildBson(Map<String, Object> params) {
        if (null == params || params.isEmpty()) {
            return new BsonDocument();
        }
        ArrayList bsons = new ArrayList();
        params.forEach((k, v) -> {
            if ("OR".equals(k)) {
                Map v2 = (Map)v;
                bsons.add(MongoCrudService.buildBson((Map)v2));
            } else if (v instanceof List) {
                bsons.add(Filters.in((String)k, (Iterable)((List)v)));
            } else {
                bsons.add(Filters.eq((String)k, (Object)v));
            }
        });
        return Filters.and(bsons);
    }

    public void processLargeQuery(String db, String col, Map<String, Object> params, int batchSize, BatchProcessCallBack callBack) {
        try (MongoCursor cursor = this.mongoTemplate.getMongoDbFactory().getDb(db).getCollection(col).find((Bson)(params.isEmpty() ? new BsonDocument() : MongoCrudService.buildBson(params))).noCursorTimeout(true).batchSize(batchSize).cursor();){
            ArrayList<Document> batch = new ArrayList<Document>(batchSize);
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                batch.add(doc);
                if (batch.size() != batchSize) continue;
                callBack.process(batch, false);
                batch.clear();
            }
            callBack.process(batch, true);
        }
    }

    public <T> PageVo<T> queryWithPage(String dbName, String colName, Map<String, Object> params, int page, int pageSize, Class<T> tClass) {
        Bson bson = MongoCrudService.buildBson(params);
        long totalCount = this.mongoTemplate.getMongoDbFactory().getDb(dbName).getCollection(colName).countDocuments(bson);
        FindIterable findIterable = this.mongoTemplate.getMongoDbFactory().getDb(dbName).getCollection(colName).find(bson, Document.class).skip((page - 1) * pageSize).limit(pageSize);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Document each : findIterable) {
            list.add(this.mongoConverter.read(tClass, (Object)each));
        }
        return new PageVo(totalCount, list, page, pageSize, (int)Math.ceil((double)totalCount / (double)pageSize));
    }

    public <T> List<T> find(String db, String col, Bson filter, Bson projections, Class<T> tClass) {
        FindIterable findIterable = this.mongoTemplate.getMongoDbFactory().getDb(db).getCollection(col).find(filter).projection(projections);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Document each : findIterable) {
            list.add(this.mongoConverter.read(tClass, (Object)each));
        }
        return list;
    }
}

