/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.km_deployer_service.domain.km.CleanNeo4jParam;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.domain.TenantEntity;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.TenantEntityRepository;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.km.BatchProcessCallBack;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.driver.Driver;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class Neo4jCrudService {
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    HelpService helpService;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    TenantEntityRepository tenantEntityRepository;

    public String tenantVersion(String tenantId) {
        String version = "1.0";
        TenantEntity tenantEntity = this.tenantEntityRepository.tenantEntity(tenantId);
        System.out.println(tenantEntity);
        if (null != tenantEntity) {
            version = tenantEntity.getVersion();
        }
        return version;
    }

    public void executeCypher(String cql, Map<String, Object> params) {
        Neo4jMultipleUtil.executeCql((String)cql, params, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void executeCyphers(List<String> cqls, Map<String, Object> params) {
        List splits = ListUtil.split(cqls, (int)1000);
        int count = 0;
        int total = cqls.size();
        for (List split : splits) {
            this.helpService.logDetail("create", "\u6267\u884ccypher " + (count += split.size()) + "/" + total, 0);
            List collect = split.stream().map(cql -> new Cql().setCql(cql).setParams(params)).collect(Collectors.toList());
            Neo4jMultipleUtil.executeCqlTrans(collect, (Driver[])new Driver[]{this.driver1, this.driver2});
        }
    }

    public List<Map<String, Object>> query(String col, Map<String, Object> params) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Session session = this.sessionFactory.openSession();
        StringBuilder sb = new StringBuilder();
        sb.append("match(n:").append(col).append(")").append(" where 1=1 ");
        params.forEach((k, v) -> {
            sb.append(" and n.").append((String)k);
            if (v instanceof Collection || v.getClass().isArray()) {
                sb.append(" in ");
            } else {
                sb.append(" = ");
            }
            sb.append(" $").append((String)k).append("");
        });
        sb.append(" return n;");
        String cql = sb.toString();
        Result result = session.query(cql, params);
        result.forEach(map -> {
            Object n = map.get("n");
            if (n instanceof NodeModel) {
                NodeModel node = (NodeModel)n;
                HashMap map2 = new HashMap();
                node.getPropertyList().forEach(p -> map2.put(p.getKey(), p.getValue()));
                list.add(map2);
            } else {
                list.add((Map<String, Object>)JSON.parseObject((String)JSON.toJSONString(n)));
            }
        });
        return list;
    }

    public void delete(String col, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("match(n:").append(col).append(")").append(" where 1=1 ");
        params.forEach((k, v) -> {
            sb.append(" and n.").append((String)k);
            if (v instanceof Collection || v.getClass().isArray()) {
                sb.append(" in ");
            } else {
                sb.append(" = ");
            }
            sb.append(" $").append((String)k).append("");
        });
        sb.append(" detach delete n");
        String cql = sb.toString();
        this.executeCypher(cql, params);
    }

    public void createRelation(String fromTable, Map<String, Object> fromParams, String toTable, Map<String, Object> toParams, String relation) {
        StringBuilder sb = new StringBuilder();
        sb.append("match(a:").append(fromTable).append("),(b:").append(toTable).append(") where 1=1 ");
        sb.append(Neo4jCrudService.paramAnd(fromParams, (String)"a")).append(Neo4jCrudService.paramAnd(toParams, (String)"b"));
        sb.append(" merge (a)-[:").append(relation).append("]->(b) ");
        String cyhper = sb.toString();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(fromParams);
        params.putAll(toParams);
        this.executeCypher(cyhper, params);
    }

    public void createRelation(String fromTable, Map<String, Object> fromParams, List<String> toTables, Map<String, Object> toParams, String relation) {
        StringBuilder sb = new StringBuilder();
        sb.append("match(a:").append(fromTable).append("),(b) where 1=1 ");
        sb.append(Neo4jCrudService.paramAnd(fromParams, (String)"a")).append(Neo4jCrudService.paramAnd(toParams, (String)"b"));
        sb.append(" and any(label in labels(b) where label in $toTables) create (a)-[:").append(relation).append("]->(b) ");
        String cyhper = sb.toString();
        this.executeCypher(cyhper, (Map)MapUtil.of((Object)"toTables", toTables));
    }

    public void updateVersion(String app, String version, String updateVersion) {
        String cypher = "match(n{athena_namespace:$app,version:$version}) set n.version=$updateVersion";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app", app);
        params.put("version", version);
        params.put("updateVersion", updateVersion);
        this.executeCypher(cypher, params);
    }

    public void updateTenantVersion(List<String> tenantIds, String updateVersion) {
        String cypher = "match(n:TenantEntity) where n.tenantId in $tenantIds set n.version=$updateVersion";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantIds", tenantIds);
        params.put("updateVersion", updateVersion);
        this.executeCypher(cypher, params);
    }

    public void executeCyphers(List<Cql> cqlList) {
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    private static String paramMap(Map<String, Object> param) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        param.forEach((k, v) -> {
            sb.append((String)k).append(":");
            if (v instanceof String) {
                sb.append("'").append(v).append("'");
            } else if (!(v instanceof Collection)) {
                sb.append(v);
            }
            sb.append(",");
        });
        if (param.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public static String paramAnd(Map<String, Object> params, String alias) {
        StringBuilder sb = new StringBuilder();
        params.forEach((k, v) -> {
            sb.append(" and ").append(alias).append(".").append((String)k);
            if (v instanceof Collection || v.getClass().isArray()) {
                sb.append(" in ");
            } else {
                sb.append(" = ");
            }
            sb.append(" $").append((String)k).append("");
        });
        return sb.toString();
    }

    public void cleanNeo4jData(CleanNeo4jParam cleanNeo4jParam) {
        Boolean cleanEsp = cleanNeo4jParam.getCleanEsp();
        String deployVersion = cleanNeo4jParam.getDeployVersion();
        String application = cleanNeo4jParam.getApplication();
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("nameSpace", application);
        param.put("version", deployVersion);
        String cql = "MATCH (node)  where node.version =$version and (node.athena_namespace =$nameSpace or node.athena_namespace=$nameSpace) and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node";
        cqlList.add(new Cql().setCql(cql).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void cleanNeo4jData(String sourceId, String version, List<String> tenants) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sourceId", sourceId);
        param.put("version", version);
        String cql = "MATCH (node)  where node.version =$version and node.sourceId=$sourceId detach delete node";
        cqlList.add(new Cql().setCql(cql).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void cleanNeo4jData(String label, Map<String, Object> params) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        StringBuilder sb = new StringBuilder();
        sb.append("MATCH (node:").append(label).append(") where 1=1");
        params.forEach((k, v) -> {
            String op = "=";
            if (v instanceof Collection) {
                op = " in ";
            }
            sb.append(" and node.").append((String)k).append(op).append("$").append((String)k);
        });
        sb.append(" detach delete node");
        String cql = sb.toString();
        cqlList.add(new Cql().setCql(cql).setParams(params));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void processLargeQuery(String label, Map<String, Object> params, int batchSize, BatchProcessCallBack callBack) {
        List batch;
        int skip = 0;
        do {
            batch = this.queryWithPagination(label, params, skip, batchSize);
            callBack.process(batch, false);
            skip += batchSize;
        } while (batch.size() == batchSize);
        callBack.process(Collections.emptyList(), true);
    }

    private List<Map<String, Object>> queryWithPagination(String label, Map<String, Object> params, int skip, int limit) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Session session = this.sessionFactory.openSession();
        StringBuilder sb = new StringBuilder();
        sb.append("MATCH (n:").append(label).append(") WHERE 1=1 ");
        params.forEach((k, v) -> {
            sb.append(" AND n.").append((String)k);
            if (v instanceof Collection || v.getClass().isArray()) {
                sb.append(" IN ");
            } else {
                sb.append(" = ");
            }
            sb.append(" $").append((String)k);
        });
        sb.append(" RETURN n SKIP ").append(skip).append(" LIMIT ").append(limit);
        String cql = sb.toString();
        Result result = session.query(cql, params);
        result.forEach(map -> {
            Object n = map.get("n");
            if (n instanceof NodeModel) {
                NodeModel node = (NodeModel)n;
                HashMap map2 = new HashMap();
                node.getPropertyList().forEach(p -> map2.put(p.getKey(), p.getValue()));
                list.add(map2);
            } else {
                list.add((Map<String, Object>)JSON.parseObject((String)JSON.toJSONString(n)));
            }
        });
        return list;
    }

    public static void main(String[] args) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("key1", "value1");
        param.put("key2", 2);
        System.out.println(Neo4jCrudService.paramMap(param));
    }
}

