/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.domain.neo4j.FromNode;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Relation;
import com.digiwin.athena.km_deployer_service.domain.neo4j.ToNode;
import com.digiwin.athena.km_deployer_service.povo.CreateApplicationRelationParam;
import com.digiwin.athena.km_deployer_service.povo.UpdateVersionParam;
import com.digiwin.athena.km_deployer_service.service.km.ApplicationService;
import com.digiwin.athena.km_deployer_service.service.km.TenantService;
import com.digiwin.athena.km_deployer_service.util.MongoHelper;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ApplicationServiceImpl
implements ApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    private static ConcurrentHashMap<String, ReentrantLock> LOCK_MAP = new ConcurrentHashMap();
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoHelper mongoHelper;
    @Autowired
    private TenantService tenantService;

    public void updateVersion(UpdateVersionParam updateVersionParam) {
        List cqlList = this.getUpdateAppDataVersionCqlList(updateVersionParam);
        Neo4jMultipleUtil.executeCqlTrans((List)cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> getUpdateVersionCqlList(UpdateVersionParam updateVersionParam) {
        List cqlList = this.getUpdateAppDataVersionCqlList(updateVersionParam);
        return cqlList;
    }

    private List<Cql> getUpdateAppDataVersionCqlList(UpdateVersionParam updateVersionParam) {
        String application = updateVersionParam.getApplication();
        String oldVersion = updateVersionParam.getOldVersion();
        String newVersion = updateVersionParam.getNewVersion();
        List tenantIdList = updateVersionParam.getTenantIdList();
        List publishDbMongoData = updateVersionParam.getPublishDbMongoData();
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)oldVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM")})});
        Bson deleteFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)newVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM")})});
        Document update = new Document("$set", (Object)new Document().append("version", (Object)newVersion));
        this.mongoHelper.deleteAndUpdate(publishDbMongoData, filter, deleteFilter, (Bson)update);
        Map tenantVersionMap = this.tenantService.getTenantVersion(tenantIdList);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("oldVersion", oldVersion);
        param.put("newVersion", newVersion);
        param.put("application", application);
        Cql updateCql = new Cql();
        updateCql.setCql("match (node) where node.version = $oldVersion and node.athena_namespace = $application set node.version=$newVersion");
        updateCql.setParams(param);
        Cql deleteCql = new Cql();
        deleteCql.setCql("match (node) where node.version = $newVersion and node.athena_namespace = $application detach delete node");
        deleteCql.setParams(param);
        Cql updateTenantCql = new Cql();
        param.put("tenantIdList", tenantIdList);
        updateTenantCql.setCql("match (n:TenantEntity) where n.tenantId in $tenantIdList set n.version=$newVersion");
        updateTenantCql.setParams(param);
        cqlList.add(deleteCql);
        cqlList.add(updateCql);
        cqlList.add(updateTenantCql);
        if (!"common".equals(application)) {
            Cql updateAppCql = new Cql();
            updateAppCql.setCql("match (n:AppEntity) where n.code = $application set n.version=$newVersion");
            updateAppCql.setParams(param);
            cqlList.add(updateAppCql);
        }
        List cqls = this.tenantService.mergeRelationBetweenTenantAndCommon(application, tenantIdList, newVersion, tenantVersionMap);
        cqlList.addAll(cqls);
        return cqlList;
    }

    private List<Cql> getUpdateAppListDataVersionCqlList(UpdateVersionParam updateVersionParam) {
        List applicationList = updateVersionParam.getApplicationList();
        String oldVersion = updateVersionParam.getOldVersion();
        String newVersion = updateVersionParam.getNewVersion();
        List tenantIdList = updateVersionParam.getTenantIdList();
        List publishDbMongoData = updateVersionParam.getPublishDbMongoData();
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)oldVersion), Filters.in((String)"athena_namespace", (Iterable)applicationList)});
        Bson deleteFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)newVersion), Filters.in((String)"athena_namespace", (Iterable)applicationList)});
        Document update = new Document("$set", (Object)new Document().append("version", (Object)newVersion));
        this.mongoHelper.deleteAndUpdate(publishDbMongoData, filter, deleteFilter, (Bson)update);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("oldVersion", oldVersion);
        param.put("newVersion", newVersion);
        param.put("applicationList", applicationList);
        Cql updateCql = new Cql();
        updateCql.setCql("match (node) where node.version = $oldVersion and node.athena_namespace in $applicationList set node.version=$newVersion");
        updateCql.setParams(param);
        Cql deleteCql = new Cql();
        deleteCql.setCql("match (node) where node.version = $newVersion and node.athena_namespace in $applicationList detach delete node");
        deleteCql.setParams(param);
        Cql updateTenantCql = new Cql();
        param.put("tenantIdList", tenantIdList);
        updateTenantCql.setCql("match (n:TenantEntity) where n.tenantId in $tenantIdList set n.version=$newVersion");
        updateTenantCql.setParams(param);
        Cql updateAppCql = new Cql();
        updateAppCql.setCql("match (n:AppEntity) where n.code in $applicationList set n.version=$newVersion");
        updateAppCql.setParams(param);
        cqlList.add(deleteCql);
        cqlList.add(updateCql);
        cqlList.add(updateTenantCql);
        cqlList.add(updateAppCql);
        return cqlList;
    }

    public void createApplication2CommonRelation(CreateApplicationRelationParam createApplicationRelationParam) {
        String applicationVersion = createApplicationRelationParam.getApplicationVersion();
        String commonVersion = createApplicationRelationParam.getCommonVersion();
        JSONObject neo4jNodeKeyJson = createApplicationRelationParam.getNeo4jNodeKeyJson();
        List relationList = createApplicationRelationParam.getRelationList();
        if (CollUtil.isEmpty((Collection)relationList)) {
            return;
        }
        relationList.stream().forEach(relation -> {
            relation.setFromNodeVersion(applicationVersion);
            relation.setToNodeVersion(commonVersion);
        });
        List cqlList = this.getNodeRelationCql(neo4jNodeKeyJson, relationList);
        Neo4jMultipleUtil.executeCqlTrans((List)cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> getCqlByRelation(CreateApplicationRelationParam createApplicationRelationParam) {
        String applicationVersion = createApplicationRelationParam.getApplicationVersion();
        String commonVersion = createApplicationRelationParam.getCommonVersion();
        JSONObject neo4jNodeKeyJson = createApplicationRelationParam.getNeo4jNodeKeyJson();
        List relationList = createApplicationRelationParam.getRelationList();
        if (CollUtil.isEmpty((Collection)relationList)) {
            return new ArrayList<Cql>();
        }
        relationList.stream().forEach(relation -> {
            relation.setFromNodeVersion(applicationVersion);
            relation.setToNodeVersion(commonVersion);
        });
        List cqlList = this.getNodeRelationCql(neo4jNodeKeyJson, relationList);
        return cqlList;
    }

    public void combineNodeProperties(Map<String, Object> properties, StringBuffer nodeCypher) {
        properties.forEach((k, v) -> {
            if (!"version".equals(k) && !"oldNodeId".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append(String.format("`%s`:", k));
                } else {
                    nodeCypher.append(String.format("%s:", k));
                }
                if (v instanceof String) {
                    String propertyValue2 = (String)v;
                    propertyValue2 = propertyValue2.replace("'", "\\\"");
                    nodeCypher.append(String.format("'%s',", propertyValue2));
                } else if (v instanceof Collection) {
                    nodeCypher.append("[");
                    List propertyValueList = (List)v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append(v).append(",");
                }
            }
        });
    }

    public List<Cql> getNodeRelationCql(JSONObject neo4jNodeKeyJson, List<Relation> relations) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        for (Relation relation : relations) {
            Object toNodePrimaryKey;
            FromNode fromNode = relation.getFromNode();
            ToNode toNode = relation.getToNode();
            String cqlStr = "match (fromNode:{}) where fromNode.{} = {} and fromNode.athena_namespace = '{}' and fromNode.version='{}'  match(toNode:{}) where toNode.{} = {} and toNode.athena_namespace = '{}' and toNode.version='{}' merge (fromNode)-[:{}]->(toNode)";
            Object fromNodePrimaryKey = fromNode.getPrimaryKey();
            if (fromNodePrimaryKey instanceof String) {
                fromNodePrimaryKey = "'" + fromNodePrimaryKey + "'";
            }
            if ((toNodePrimaryKey = toNode.getPrimaryKey()) instanceof String) {
                toNodePrimaryKey = "'" + toNodePrimaryKey + "'";
            }
            cqlStr = StrUtil.format((CharSequence)cqlStr, (Object[])new Object[]{fromNode.getLabel(), neo4jNodeKeyJson.getString(fromNode.getLabel()), fromNodePrimaryKey, fromNode.getApplication(), fromNode.getVersion(), toNode.getLabel(), neo4jNodeKeyJson.getString(toNode.getLabel()), toNodePrimaryKey, toNode.getApplication(), toNode.getVersion(), toNode.getType()});
            Cql cql = new Cql().setCql(cqlStr);
            cqlList.add(cql);
        }
        return cqlList;
    }

    private void copyNeo4jData(String application, String oldVersion, String newVersion, Neo4jManager neo4jManager) {
        long t0 = System.currentTimeMillis();
        ConcurrentHashMap<Long, Long> nodeNeo4jIdMap = new ConcurrentHashMap<Long, Long>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", oldVersion);
        param.put("application", application);
        List nodeResultList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        List relationList = neo4jManager.ExecuteQuery("match (startNode)-[relation]->(endNode) where startNode.version = $version and (startNode.athena_namespace = $application or startNode.nameSpace = $application) and endNode.version = $version and (endNode.athena_namespace = $application or endNode.nameSpace = $application) return id(startNode) as startNodeId,type(relation) as relationType,id(endNode) as endNodeId", param);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        for (Object nodeResult : nodeResultList) {
            StringBuffer nodeCypher = new StringBuffer("create (node");
            Collection labels = ((InternalNode)nodeResult.get("node")).labels();
            long nodeId = ((InternalNode)nodeResult.get("node")).id();
            for (String label : labels) {
                nodeCypher.append(String.format(":%s", label));
            }
            nodeCypher.append("{");
            Map properties = ((InternalNode)nodeResult.get("node")).asMap();
            this.combineNodeProperties(properties, nodeCypher);
            nodeCypher.append("oldNodeId:" + nodeId + ",");
            nodeCypher.append(String.format("version:'%s', publishTime:'%s'}) return id(node) as nodeId", newVersion, DateUtil.now()));
            cqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)nodeCypher.toString())));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList);
        param.put("version", newVersion);
        param.put("application", application);
        List newNodeList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        for (Object nodeResult : newNodeList) {
            long newNodeId = ((InternalNode)nodeResult.get("node")).id();
            Map properties = ((InternalNode)nodeResult.get("node")).asMap();
            Long oldNodeId = Convert.toLong(properties.get("oldNodeId"));
            nodeNeo4jIdMap.put(oldNodeId, newNodeId);
        }
        relationList.forEach(relation -> {
            relation.put("startNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("startNodeId").toString())));
            relation.put("endNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("endNodeId").toString())));
        });
        ArrayList<Cql> cqlList1 = new ArrayList<Cql>();
        for (Map relation2 : relationList) {
            String relationCypher = String.format("match (startNode),(endNode) WHERE id(startNode)=%d and id(endNode)=%d merge (startNode)-[relation:%s]->(endNode)", (Long)relation2.get("startNodeId"), (Long)relation2.get("endNodeId"), relation2.get("relationType"));
            cqlList1.add(new Cql().setParams(new HashMap()).setCql(relationCypher));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList1);
        long t1 = System.currentTimeMillis();
        log.info(application + "\u5e94\u7528\u590d\u5236neo4j\u6570\u636e\u8017\u65f6\uff08ms\uff09\uff1a" + (t1 - t0));
    }

    private void copyMongoData(String application, String oldVersion, String newVersion, List<JSONObject> publishDbMongoData) {
        Bson filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)oldVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM")})});
        for (JSONObject dbMongo : publishDbMongoData) {
            ((List)dbMongo.get((Object)"collectionName")).forEach(collection -> {
                ArrayList newDocuments = new ArrayList();
                FindIterable documents = this.mongoTemplate.getMongoDbFactory().getDb((String)dbMongo.get((Object)"dbName")).getCollection(collection).find(filters);
                documents.forEach(document -> {
                    Document newDocument = new Document((Map)document);
                    newDocument.remove((Object)"_id");
                    newDocument.put("version", (Object)newVersion);
                    newDocument.put("publishTime", (Object)new Date());
                    newDocuments.add(newDocument);
                });
                if (!newDocuments.isEmpty()) {
                    this.mongoTemplate.getMongoDbFactory().getDb((String)dbMongo.get((Object)"dbName")).getCollection(collection).insertMany(newDocuments);
                }
            });
        }
    }

    private void revert(String application, String version, List<JSONObject> publishDbMongoData) {
        String cql1 = StrUtil.format((CharSequence)"MATCH (node)  where node.version ='{}' and node.athena_namespace = '{}' and not any(label in labels(node) WHERE label in ['AppEntity','TenantEntity']) detach delete node", (Object[])new Object[]{version, application});
        Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
        neo4jManager1.ExecuteNoQuery(cql1);
        if (this.driver2 != null) {
            Neo4jManager neo4jManager2 = new Neo4jManager(this.driver2);
            neo4jManager2.ExecuteNoQuery(cql1);
        }
        Bson filter1 = Filters.eq((String)"version", (Object)version);
        Bson filter2 = Filters.eq((String)"athena_namespace", (Object)application);
        Bson filters = Filters.and((Bson[])new Bson[]{filter1, filter2});
        for (JSONObject map : publishDbMongoData) {
            String dbName = (String)map.get((Object)"dbName");
            List collections = (List)map.get((Object)"collectionName");
            collections.forEach(collection -> this.mongoTemplate.getMongoDbFactory().getDb(dbName).getCollection(collection).deleteMany(filters));
        }
    }
}

