/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.impl;

import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.km_deployer_service.constant.DbInfo;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.KmPublishRepo;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.DeployResponse;
import com.digiwin.athena.km_deployer_service.povo.DeployTenantRequest;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.ActionService;
import com.digiwin.athena.km_deployer_service.service.km.ApplicationService;
import com.digiwin.athena.km_deployer_service.service.km.CommonDataService;
import com.digiwin.athena.km_deployer_service.service.km.ITenantPublishService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.service.km.handler.KmDeployEventHandler;
import com.digiwin.athena.km_deployer_service.service.km.impl.PublishServiceImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;

@Service
public class TenantPublishServiceImpl
implements ITenantPublishService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    Neo4jCrudService neo4jCrudService;
    @Autowired
    RedisLockRegistry redisLockRegistry;
    @Autowired
    DmcService dmcService;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Autowired
    KmPublishRepo kmPublishRepo;
    @Autowired
    HelpService helpService;
    @Autowired
    CommonDataService commonDataService;
    @Autowired
    ApplicationService applicationService;
    @Autowired
    ActionService actionService;
    @Autowired
    List<KmDeployEventHandler> eventHandlers;
    @Autowired
    PublishServiceImpl publishService;

    public DeployResponse publishTenant(DeployTenantRequest request) {
        DeployResponse response = new DeployResponse();
        String version = this.neo4jCrudService.tenantVersion(request.getTenantId());
        try {
            ApplicationData appData = this.publishService.parseFile(null, request.getFileId());
            appData.getMongoData().forEach(mongoData -> mongoData.getDocs().forEach(doc -> {
                doc.put("tenantId", (Object)request.getTenantId());
                doc.put("pluginId", (Object)request.getDataId());
                doc.put("version", (Object)version);
            }));
            this.cleanData(request.getDataId(), request.getTenantId());
            this.publishService.processApplicationData(appData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public DeployResponse revokeTenant(DeployTenantRequest request) {
        DeployResponse response = new DeployResponse();
        this.cleanData(request.getDataId(), request.getTenantId());
        return response;
    }

    public void cleanData(String pluginId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("pluginId", pluginId);
        DbInfo.dbTables.forEach((db, tables) -> tables.forEach(table -> {
            CrudReq req = new CrudReq();
            req.setDbName(db);
            req.setColName(table);
            req.setParams(params);
            this.mongoCrudService.delete(req);
        }));
    }
}

