/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.TenantUser;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.domain.neo4j.CqlMapper;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.domain.system.TenantUserResult;
import com.digiwin.athena.km_deployer_service.service.km.TenantService;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TenantServiceImpl
implements TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    private static final String queryAllTenants = "/api/iam/v2/tenant/tenants/by/customer";
    private static final String queryAllTenantUser = "/api/iam/v2/tenant/user/list";
    private static final String tokenParseUrl = "/api/iam/v2/identity/token/analyze";
    private static final String authUserUrl = "/api/iam/v2/tenant/auth/with/users";
    private static final String policyAddUrl = "/api/iam/v2/policy/batch/add";
    private static final String URL_GET_INTERNAL_TOKEN = "/api/iam/v2/identity/login/internal";
    private static final String GMC_MODULE_SEARCH = "/api/cloudgoods/{}/simple";
    private static final String GMC_MODULE_UPDATE = "/api/cloudgoods/modules";
    @Value(value="${appToken}")
    private String appToken;
    @Value(value="${module.iam.domain}")
    private String iamUrl;
    @Value(value="${module.gmc.domain}")
    private String gmcUrl;
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private MongoTemplate mongoTemplate;

    public JSONObject queryUserTenants(String tenantId) {
        return null;
    }

    public TenantUserResult queryUserInTenant(String tenantId, String token, Integer pageSize, Integer pageNum) {
        String param = String.format("?pageSize=%d&pageNum=%d", pageSize, pageNum);
        String queryUserInTenantsUrl = queryAllTenantUser + param;
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + queryUserInTenantsUrl)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", token)).body(paramJson.toJSONString()).execute().body();
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            List users = responseObj.getJSONArray("list").toJavaList(JSONObject.class);
            Integer total = responseObj.getInteger("total");
            return new TenantUserResult().setUserList(users).setTotal(total);
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25:{}", (Object)response);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public List<JSONObject> queryAllUserInTenant(String tenantId, String token) {
        ArrayList<JSONObject> allUsers = new ArrayList<JSONObject>();
        Integer pageSize = 100;
        Integer pageNum = 1;
        String param = String.format("?pageSize=%d&pageNum=%d", pageSize, pageNum);
        String queryUserInTenantsUrl = queryAllTenantUser + param;
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + queryUserInTenantsUrl)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", token)).body(paramJson.toJSONString()).execute().body();
        log.info("queryAllUserInTenant response:{}", (Object)response);
        try {
            JSONObject responseJson = JSON.parseObject((String)response);
            String code = responseJson.getString("code");
            if (!StringUtils.isEmpty((Object)code) && "500".equals(code)) {
                JSONObject tenantInfoByToken = this.getTenantInfoByToken(token);
                String id = tenantInfoByToken.getString("id");
                JSONArray list = new JSONArray();
                JSONObject supplementObject = new JSONObject();
                supplementObject.put("id", (Object)id);
                list.add((Object)supplementObject);
                responseJson.put("list", (Object)list);
                responseJson.put("total", (Object)1);
            }
            List users = responseJson.getJSONArray("list").toJavaList(JSONObject.class);
            allUsers.addAll(users);
            Integer total = responseJson.getInteger("total");
            if (total > pageSize) {
                Integer size = total / pageSize;
                for (int i = 0; i < size; ++i) {
                    Integer n = pageNum;
                    Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                    TenantUserResult tenantUserResult = this.queryUserInTenant(tenantId, token, pageSize, pageNum);
                    List userJson = tenantUserResult.getUserList();
                    allUsers.addAll(userJson);
                }
            }
            return allUsers;
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            throw new BusinessException(responseObj.getString("errorMessage"));
        }
    }

    public boolean currentUserExistInTenant(String userId, String tenantId, String token) {
        return false;
    }

    private void checkModule(JSONArray modules, List<String> ids, String id, String name) {
        if (!ids.contains(id)) {
            JSONObject module = new JSONObject();
            module.put("id", (Object)id);
            module.put("name", (Object)name);
            modules.add((Object)module);
        }
    }

    private JSONObject getGmcModule(String gmcCode) {
        String url = this.gmcUrl + StrUtil.format((CharSequence)GMC_MODULE_SEARCH, (Object[])new Object[]{gmcCode});
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).addHeaders(header)).execute();
        if (response != null && 200 == response.getStatus()) {
            String responseStr = response.body();
            JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
            JSONObject modules = jsonObject.getJSONObject("modules");
            return modules;
        }
        return null;
    }

    private void updateGmcModule(JSONObject modules, String gmcCode, String token) {
        String url = this.gmcUrl + GMC_MODULE_UPDATE;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("digi-middleware-auth-app", this.appToken);
        header.put("digi-middleware-auth-user", token);
        JSONObject param = new JSONObject();
        param.put("code", (Object)gmcCode);
        param.put("multiLanguageResource", new ArrayList());
        param.put("modules", (Object)modules);
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(header)).body(param.toJSONString()).execute();
        if (response == null || 200 != response.getStatus()) {
            log.error("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u5931\u8d25:" + Optional.ofNullable(response).map(r -> response.body()).orElse("body is null"));
            throw new BusinessException(Optional.ofNullable(response).map(r -> response.body()).orElse("body is null"));
        }
        log.info("\u66f4\u65b0\u5546\u54c1\u6a21\u7ec4\u6210\u529f!");
    }

    private List<String> getUserIdList(List<JSONObject> userJson) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userJson.forEach(user -> userIdList.add(user.getString("id")));
        return userIdList;
    }

    private List<JSONObject> handleUserIdList(List<String> userIds) {
        ArrayList<JSONObject> userIdJson = new ArrayList<JSONObject>();
        userIds.forEach(userId -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", userId);
            userIdJson.add(jsonObject);
        });
        return userIdJson;
    }

    public void createTenants(List<String> tenantIds, String version) {
        for (String tenantId : tenantIds) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("version", version);
            String findCql = "MATCH (n:TenantEntity) where n.tenantId = $tenantId RETURN properties(n) as tenant";
            List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
            if (CollUtil.isEmpty((Collection)tenants)) {
                String cql = "create (n:TenantEntity{tenantId:$tenantId,tenantName:$tenantId,version:$version})";
                Neo4jMultipleUtil.executeCql((String)cql, param, (Driver[])new Driver[]{this.driver1, this.driver2});
            }
            try {
                Document document = new Document();
                document.put("tenantId", (Object)tenantId);
                document.put("tenantName", (Object)tenantId);
                document.put("version", (Object)version);
                Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId)});
                this.mongoTemplate.getMongoDbFactory().getDb(Constant.db_kg_sys).getCollection("tenantEntity").updateOne(filter, (Bson)new Document("$set", (Object)document), new UpdateOptions().upsert(true));
            }
            catch (Exception e) {
                log.warn("\u5a1c\u5a1c\u53d1\u7248\u65b0\u589emongoDB tenantEntity\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    public void createOrUpdateTenants(List<String> tenantIds, String version) {
        for (String tenantId : tenantIds) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("version", version);
            String findCql = "MATCH (n:TenantEntity) where n.tenantId = $tenantId RETURN properties(n) as tenant";
            List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
            String cql = "";
            cql = CollUtil.isEmpty((Collection)tenants) ? "create (n:TenantEntity{tenantId:$tenantId,tenantName:$tenantId,version:$version})" : "MATCH (n:TenantEntity) where n.tenantId = $tenantId set n.version = $version";
            Neo4jMultipleUtil.executeCql((String)cql, param, (Driver[])new Driver[]{this.driver1, this.driver2});
        }
    }

    public void createTenantAndApplicationRelation(String application, String tenantVersion, String appVersion, List<String> tenantIds) {
        List authAppTenantIdList = this.getAuthAppTenantIdList(application, tenantVersion, tenantIds);
        this.mergeRelation(application, tenantVersion, appVersion, authAppTenantIdList);
    }

    public void createAllAuthTenantAndApplicationRelation(String application, String tenantVersion, String appVersion) {
        List authAppTenantIdList = this.getAllAuthAppTenantIdList(application, tenantVersion);
        this.mergeRelation(application, tenantVersion, appVersion, authAppTenantIdList);
    }

    public void createRelation(String application, String tenantVersion, String appVersion, List<String> tenantIds) {
        this.mergeRelation(application, tenantVersion, appVersion, tenantIds);
    }

    private void mergeRelation(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList) {
        List executeCqlList = this.getMergeTenantAndAppDataRelationCql(application, tenantVersion, appVersion, authAppTenantIdList);
        Neo4jMultipleUtil.executeCqlTrans((List)executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> getMergeTenantAndAppDataRelationCql(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("nameSpace", application);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", authAppTenantIdList);
        String cql2 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Activity{version:$appVersion}) where (m.nameSpace = $nameSpace or m.athena_namespace = $nameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:MonitorRule{version:$appVersion}) where (m.nameSpace = $nameSpace or m.athena_namespace = $nameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Action{version:$appVersion}) where (m.nameSpace = $nameSpace or m.athena_namespace = $nameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        List cqls = this.addTenantRelaWithProcess(Stream.of(application).collect(Collectors.toSet()), tenantVersion, appVersion, authAppTenantIdList);
        executeCqlList.addAll(cqls);
        return executeCqlList;
    }

    private List<Cql> mergeSpecificTenantAndAppDataRelation(String tenantId, String tenantVersion, String appVersion, Set<String> appCodeList) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", tenantId);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("appCodeList", appCodeList);
        String cql2 = "match(n:TenantEntity{version:$tenantVersion, tenantId:$tenantId}) match(m:Activity{version:$appVersion}) where (m.athena_namespace in $appCodeList or m.nameSpace in $appCodeList) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(n:TenantEntity{version:$tenantVersion, tenantId:$tenantId}) match(m:MonitorRule{version:$appVersion}) where (m.athena_namespace in $appCodeList or m.nameSpace in $appCodeList) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(n:TenantEntity{version:$tenantVersion, tenantId:$tenantId}) match(m:Action{version:$appVersion}) where (m.athena_namespace in $appCodeList or m.nameSpace in $appCodeList) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        List cqls = this.addTenantRelaWithProcess(appCodeList, tenantVersion, appVersion, Collections.singletonList(tenantId));
        executeCqlList.addAll(cqls);
        return executeCqlList;
    }

    public List<String> getAuthAppTenantIdList(String application, String version, List<String> excludeTenants) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("excludeTenants", excludeTenants);
        param.put("version", version);
        String cql = "match(n:TenantEntity{version:$version}) -[]-> (m:AppEntity{code:$application}) where not n.tenantId in $excludeTenants return n.tenantId as tenantId";
        List authAppTenantList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        List<String> authAppTenantIdList = authAppTenantList.stream().map(authAppTenant -> String.valueOf(authAppTenant.get("tenantId"))).collect(Collectors.toList());
        return authAppTenantIdList;
    }

    private List<String> getAllAuthAppTenantIdList(String application, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        param.put("version", version);
        String cql = "match(n:TenantEntity{version:$version}) -[]-> (m:AppEntity{code:$application}) return n.tenantId as tenantId";
        List authAppTenantList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        List<String> authAppTenantIdList = authAppTenantList.stream().map(authAppTenant -> String.valueOf(authAppTenant.get("tenantId"))).collect(Collectors.toList());
        return authAppTenantIdList;
    }

    public void createTenantAndCommonRelation(List<String> tenantIds, String version) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantIdList", tenantIds);
        param.put("version", version);
        param.put("publishTime", DateUtil.now());
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql2 = "match(m:Activity{version:$version}) where not (m)<-[:ACTIVITY]-(:TenantEntity) and m.nameSpace in ['common','espCommon'] match(n:TenantEntity) where not n.tenantId in $tenantIdList merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(m:MonitorRule{version:$version}) where not (m)<-[:USE]-(:TenantEntity) and m.nameSpace in ['common','espCommon'] match(n:TenantEntity) where not n.tenantId in $tenantIdList merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(m:Action{version:$version}) WHERE NOT (m)<-[:ACTION]-(:TenantEntity) and m.nameSpace in ['common','espCommon'] match(n:TenantEntity) where not n.tenantId in $tenantIdList merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> createAllTenantAndCommonRelation(String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql2 = "match(m:Activity{version:$version}) match(n:TenantEntity{version:$version}) where m.nameSpace = 'common' merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(m:MonitorRule{version:$version}) match(n:TenantEntity{version:$version}) where m.nameSpace = 'common' merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(m:Action{version:$version}) match(n:TenantEntity{version:$version}) where m.nameSpace = 'common' merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }

    public List<Cql> getSpecificTenantAndCommonAndEspRelationCql(String tenantId, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("version", version);
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql2 = "match(m:Activity{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) where m.nameSpace in ['common','espCommon'] merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(m:MonitorRule{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) where m.nameSpace in ['common','espCommon'] merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(m:Action{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) WHERE m.nameSpace in ['common','espCommon'] and (m.tenantId is null or m.tenantId = $tenantId) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }

    public Cql getSpecificTenantAndEspActionRelationCql(String tenantId, String version) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("version", version);
        String addRelaCql1 = "match(m:Action{version:$version}) match(n:TenantEntity{version:$version, tenantId:$tenantId}) WHERE m.nameSpace = 'espCommon' and (m.tenantId is null or m.tenantId = $tenantId) merge (n)-[:ACTION]->(m)";
        return new Cql().setCql(addRelaCql1).setParams(param);
    }

    public JSONObject getTenantInfoByToken(String token) {
        String response = this.analyzeIamToken(token);
        JSONObject responseObj = JSON.parseObject((String)response);
        String tenantId = responseObj.getString("tenantId");
        if (StringUtils.isEmpty((Object)tenantId)) {
            log.error("\u89e3\u6790token\u5931\u8d25:", (Object)response);
            throw new BusinessException("\u79df\u6237\u83b7\u53d6\u5931\u8d25\uff1a" + responseObj.getString("errorMessage"));
        }
        log.info("getTenantInfoByToken response is -->{}", (Object)responseObj);
        return responseObj;
    }

    public String analyzeIamToken(String token) {
        String response = ((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + tokenParseUrl)).header("digi-middleware-auth-user", token)).execute().body();
        return response;
    }

    public Set<String> getAllTenants(String version) {
        String findCql = "MATCH (n:TenantEntity{version:$version}) RETURN n.tenantId as tenantId";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        HashSet<String> tenantIdList = new HashSet<String>();
        if (CollUtil.isNotEmpty((Collection)tenants)) {
            tenants.forEach(tenant -> tenantIdList.add(String.valueOf(tenant.get("tenantId"))));
        }
        return tenantIdList;
    }

    public Map<String, String> getTenantVersion(List<String> tenantIdList) {
        String findCql = "MATCH (n:TenantEntity) WHERE n.tenantId in $tenantIdList RETURN n.tenantId as tenantId, n.version as version";
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("tenantIdList", tenantIdList);
        List tenants = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        HashMap<String, String> re = new HashMap<String, String>();
        if (CollUtil.isNotEmpty((Collection)tenants)) {
            tenants.forEach(tenant -> re.put((String)tenant.get("tenantId"), (String)tenant.get("version")));
        }
        return re;
    }

    public Set<String> getAppEntityFullNamespace(Set<String> appCode) {
        String findCql = "MATCH (n:AppEntity) WHERE n.code in $appCode RETURN n.fullNamespace as fullNamespace";
        HashMap<String, Set<String>> param = new HashMap<String, Set<String>>();
        param.put("appCode", appCode);
        List appInfo = new Neo4jManager(this.driver1).ExecuteQuery(findCql, param);
        HashSet<String> re = new HashSet<String>();
        if (CollUtil.isNotEmpty((Collection)appInfo)) {
            appInfo.forEach(info -> {
                if (!String.valueOf(info.get("fullNamespace")).equals("NULL") && !ObjectUtils.isEmpty(info.get("fullNamespace"))) {
                    re.add(String.valueOf(info.get("fullNamespace")));
                }
            });
        }
        return re;
    }

    public List<Cql> mergeRelationBetweenTenantAndCommon(String application, List<String> tenantIdList, String targetVersion, Map<String, String> tenantVersionMap) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("targetVersion", targetVersion);
        param.put("application", application);
        if ("common".equals(application)) {
            List allTenantAndCommonRelation = this.createAllTenantAndCommonRelation(targetVersion);
            cqlList.addAll(allTenantAndCommonRelation);
            tenantIdList.forEach(tenantId -> {
                if (StringUtils.isEmpty(tenantVersionMap.get(tenantId))) {
                    Cql cql = this.getSpecificTenantAndEspActionRelationCql(tenantId, targetVersion);
                    cqlList.add(cql);
                } else if (!targetVersion.equals(tenantVersionMap.get(tenantId))) {
                    param.put("oldVersion", (String)tenantVersionMap.get(tenantId));
                    param.put("tenantId", (String)tenantId);
                    String deleteRelaCql = "match (tenant:TenantEntity{version:$targetVersion})-[relation]->(commonNode{version:$oldVersion}) where tenant.tenantId = $tenantId and commonNode.nameSpace in ['common','espCommon'] delete relation";
                    cqlList.add(new Cql().setCql(deleteRelaCql).setParams((Map)param));
                    Cql cql = this.getSpecificTenantAndEspActionRelationCql(tenantId, targetVersion);
                    cqlList.add(cql);
                    Set appCodeList = this.getAppCodeRelaToTenantId(tenantId);
                    List cql2 = this.mergeSpecificTenantAndAppDataRelation(tenantId, targetVersion, targetVersion, appCodeList);
                    cqlList.addAll(cql2);
                    List cqlDelAndAdd = this.addTenantRelaWithProcess(appCodeList, targetVersion, targetVersion, Collections.singletonList(tenantId));
                    cqlList.addAll(cqlDelAndAdd);
                }
            });
        } else {
            tenantIdList.forEach(tenantId -> {
                if (StringUtils.isEmpty(tenantVersionMap.get(tenantId))) {
                    List cql = this.getSpecificTenantAndCommonAndEspRelationCql(tenantId, targetVersion);
                    cqlList.addAll(cql);
                } else if (!targetVersion.equals(tenantVersionMap.get(tenantId))) {
                    param.put("oldVersion", (String)tenantVersionMap.get(tenantId));
                    param.put("tenantId", (String)tenantId);
                    String deleteRelaCql = "match (tenant:TenantEntity{version:$targetVersion})-[relation]->(commonNode{version:$oldVersion}) where tenant.tenantId = $tenantId and commonNode.nameSpace in ['common','espCommon'] delete relation";
                    cqlList.add(new Cql().setCql(deleteRelaCql).setParams((Map)param));
                    cqlList.addAll(this.getSpecificTenantAndCommonAndEspRelationCql(tenantId, targetVersion));
                    Set appCodeList = this.getAppCodeRelaToTenantId(tenantId);
                    List cqlDelAndAdd = this.addTenantRelaWithProcess(appCodeList, targetVersion, targetVersion, Collections.singletonList(tenantId));
                    cqlList.addAll(cqlDelAndAdd);
                    appCodeList.remove(application);
                    List cql2 = this.mergeSpecificTenantAndAppDataRelation(tenantId, targetVersion, targetVersion, appCodeList);
                    cqlList.addAll(cql2);
                }
            });
        }
        return cqlList;
    }

    public void modifyTenantRelaWithNotMatchAppDataInSwitch(String application, List<String> tenantIdList) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        if ("common".equals(application)) {
            ArrayList authAppTenantIdList = new ArrayList(this.getAllTenants("1.0"));
            List deleteCqls = this.deleteRelationBetweenAppAndTenant(application, "1.0", "2.0", authAppTenantIdList);
            cqlList.addAll(deleteCqls);
            List allTenantAndCommonRelation = this.createAllTenantAndCommonRelation("1.0");
            cqlList.addAll(allTenantAndCommonRelation);
        } else {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("application", application);
            param.put("version", "1.0");
            String cql = "match(n:TenantEntity{version:$version}) -[]-> (m:AppEntity{code:$application}) return n.tenantId as tenantId";
            List authAppTenantList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
            List authAppTenantIdList = authAppTenantList.stream().map(authAppTenant -> String.valueOf(authAppTenant.get("tenantId"))).collect(Collectors.toList());
            List deleteCqls = this.deleteRelationBetweenAppAndTenant(application, "1.0", "2.0", authAppTenantIdList);
            cqlList.addAll(deleteCqls);
            List mergeCqls = this.getMergeTenantAndAppDataRelationCql(application, "1.0", "1.0", authAppTenantIdList);
            cqlList.addAll(mergeCqls);
        }
        cqlList.add(this.deleteDiffVersionRelaBetweenTenantAndAppData("2.0", "1.0", tenantIdList));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> deleteRelationBetweenAppAndTenant(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", authAppTenantIdList);
        String cql1 = "match (n:TenantEntity{version:$tenantVersion})-[r:ACTIVITY]->(m:Activity{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
        String cql2 = "match (n:TenantEntity{version:$tenantVersion})-[r:USE]->(m:MonitorRule{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match (n:TenantEntity{version:$tenantVersion})-[r:ACTION]->(m:Action{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match (n:TenantEntity{version:$tenantVersion})-[r:TASK]->(m:TASK{version:$appVersion}) where n.tenantId in $tenantIdList and (m.athena_namespace=$application or m.nameSpace=$application) delete r";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }

    public void modifyTenantRelaWithNotMatchAppDataInPublish(String tenantVersion, String appVersion, List<String> tenantIdList) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        cqlList.add(this.deleteDiffVersionRelaBetweenTenantAndAppData(tenantVersion, appVersion, tenantIdList));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void modifyTenantConfig(String version, List<String> tenantIdList) {
        String tenantConfigVersion = version.split("\\.")[0] + ".x";
        for (String tenantId : tenantIdList) {
            Bson filterFind = Filters.eq((String)"tenantId", (Object)tenantId);
            FindIterable documents = this.mongoTemplate.getMongoDbFactory().getDb("datamap").getCollection("tenantConfig").find(filterFind);
            Document document = (Document)documents.first();
            if (document == null) {
                Document newDocument = new Document();
                newDocument.put("version", (Object)tenantConfigVersion);
                newDocument.put("tenantId", (Object)tenantId);
                this.mongoTemplate.getMongoDbFactory().getDb("datamap").getCollection("tenantConfig").insertOne((Object)newDocument);
                continue;
            }
            boolean needUpdate = false;
            for (Document doc : documents) {
                if (tenantConfigVersion.equals(doc.get((Object)"version"))) continue;
                needUpdate = true;
                break;
            }
            if (!needUpdate) continue;
            Document update = new Document("$set", (Object)new Document().append("version", (Object)tenantConfigVersion));
            this.mongoTemplate.getMongoDbFactory().getDb("datamap").getCollection("tenantConfig").updateMany(filterFind, (Bson)update);
        }
    }

    public String grantUserAuth(TenantUser tenantUser, String application, String strategyCode, String token) {
        String tenantId = tenantUser.getTenantId();
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        paramJson.put("userIds", (Object)tenantUser.getUserIdList());
        paramJson.put("appId", (Object)application);
        paramJson.put("strategyCode", (Object)strategyCode);
        String url = this.iamUrl + authUserUrl;
        HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).body(paramJson.toJSONString()).execute();
        log.info("\u8c03\u7528iam\u63a5\u53e3,\u8d4b\u4e88\u7528\u6237\u5e94\u7528\u6743\u9650#post,url:{},response:{}", (Object)url, (Object)JSON.toJSONString((Object)response));
        if (response != null) {
            if (200 == response.getStatus()) {
                return "SUCCESS";
            }
            return response.body();
        }
        return "";
    }

    public String getRealTimeTenantToken(String tenantId) {
        JSONObject param = new JSONObject();
        param.put("tenantId", (Object)tenantId);
        param.put("userId", (Object)"integration");
        param.put("passwordHash", (Object)"6826CC688C4AF1BD0A8DDA2DBDF8897B");
        String body = JSON.toJSONString((Object)param);
        String url = this.iamUrl + URL_GET_INTERNAL_TOKEN;
        HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).header("digi-middleware-auth-app", this.appToken)).header("Client-Agent", "mobileplatform-2.0.1.1")).header("Content-Type", "application/json")).body(body).execute();
        log.info("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token#post,url:{},response:{}", (Object)url, (Object)JSON.toJSONString((Object)response));
        String result = response.body();
        JSONObject resultInfo = JSON.parseObject((String)result);
        String tenantToken = resultInfo.getString("token");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tenantToken)) {
            log.error("\u8c03\u7528iam\u63a5\u53e3,\u83b7\u53d6\u79df\u6237token\u5f02\u5e38");
            throw new BusinessException(String.format("\u83b7\u53d6IAM\u96c6\u6210\u8d26\u53f7\u79df\u6237token:%s\u63a5\u53e3\u5f02\u5e38", "getTenantToken"));
        }
        return tenantToken;
    }

    public void updateTenantVersion(List<String> tenantIdList, String application, String version) {
        log.info("\u66f4\u65b0\u79df\u6237\u7248\u672c\uff1a\u79df\u6237:{},\u7248\u672c:{} ...", tenantIdList, (Object)version);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        cqlList.add(CqlMapper.updateTenantVersion(tenantIdList, (String)version));
        this.modifyTenantConfig(version, tenantIdList);
        cqlList.add(CqlMapper.mergeTenantAppEntityRelation(tenantIdList, (String)application));
        log.info("\u66f4\u65b0\u79df\u6237--\u5f00\u59cb\u6267\u884ccql\uff1a" + JSON.toJSONString(cqlList));
        new Neo4jManager(this.driver1).ExecuteTransactionNoQuery(cqlList);
        if (this.driver2 != null) {
            new Neo4jManager(this.driver2).ExecuteTransactionNoQuery(cqlList);
        }
        try {
            Bson filterBson = Filters.and((Bson[])new Bson[]{Filters.in((String)"tenantId", tenantIdList)});
            Document updateBson = new Document("$set", (Object)new Document().append("version", (Object)version));
            this.mongoTemplate.getMongoDbFactory().getDb(Constant.db_kg_sys).getCollection("tenantEntity").updateMany(filterBson, (Bson)updateBson);
            for (String tenantId : tenantIdList) {
                Document document = new Document();
                document.put("tenantId", (Object)tenantId);
                document.put("appCode", (Object)application);
                Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"appCode", (Object)application)});
                this.mongoTemplate.getMongoDbFactory().getDb(Constant.db_kg_sys).getCollection("tenantAppRelation").updateOne(filter, (Bson)new Document("$set", (Object)document), new UpdateOptions().upsert(true));
            }
        }
        catch (Exception e) {
            log.warn("\u5a1c\u5a1c\u53d1\u7248\u4fee\u6539mongoDB\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("\u66f4\u65b0\u79df\u6237\u7248\u672c\u5b8c\u6210\uff1a\u79df\u6237:{},\u7248\u672c:{} ...", tenantIdList, (Object)version);
    }

    public Set<String> getNotCommonAppCodeRelaToTenantId(String tenantId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        String cql = "match(n:TenantEntity{tenantId:$tenantId})-[]->(m:AppEntity) where m.commonApp is null or m.commonApp<>true return m.code as code";
        List authAppCodeList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        Set<String> appCode = authAppCodeList.stream().map(authAppCode -> String.valueOf(authAppCode.get("code"))).collect(Collectors.toSet());
        return appCode;
    }

    public void createOneTenantAndMoreAppRelation(Set<String> appCodeList, String tenantVersion, String appVersion, String tenantId) {
        List executeCqlList = this.mergeSpecificTenantAndAppDataRelation(tenantId, tenantVersion, appVersion, appCodeList);
        Neo4jMultipleUtil.executeCqlTrans((List)executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void updateAppDataVersion(String application, String oldVersion, String newVersion, List<String> tenantIdList) {
        ArrayList executeCqlList = new ArrayList();
        List updateAppDataVersionCqlList = this.getUpdateAppDataVersion(application, oldVersion, newVersion, tenantIdList);
        executeCqlList.addAll(updateAppDataVersionCqlList);
        Neo4jMultipleUtil.executeCqlTrans((List)updateAppDataVersionCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
        this.modifyTenantConfig(newVersion, tenantIdList);
        try {
            Bson filterBson = Filters.and((Bson[])new Bson[]{Filters.in((String)"tenantId", tenantIdList), Filters.ne((String)"version", (Object)newVersion)});
            Document updateBson = new Document("$set", (Object)new Document().append("version", (Object)newVersion));
            this.mongoTemplate.getMongoDbFactory().getDb(Constant.db_kg_sys).getCollection("tenantEntity").updateMany(filterBson, (Bson)updateBson);
        }
        catch (Exception e) {
            log.warn("\u4fee\u6539mongoDB tenantEntity\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void copyAppVersionData(String application, String oldVersion, String newVersion) {
        long startTime = System.currentTimeMillis();
        log.info(application + "\u5e94\u7528\u5207\u7248-\u5f00\u59cb\u590d\u5236{}\u7248\u672c\u6570\u636e\u81f3{}\u7248\u672c......", (Object)oldVersion, (Object)newVersion);
        Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
        this.copyNeo4jData(application, oldVersion, newVersion, neo4jManager1);
        if (this.driver2 != null) {
            Neo4jManager neo4jManager2 = new Neo4jManager(this.driver2);
            this.copyNeo4jData(application, oldVersion, newVersion, neo4jManager2);
        }
        long neoT = System.currentTimeMillis();
        log.info(application + "\u5e94\u7528\u5207\u7248-\u8fdb\u5165\u590d\u5236\u5e94\u7528\u5230\u590d\u5236\u5b8cneo4j\u6570\u636e\u7684\u8017\u65f6\uff1a" + (neoT - startTime));
        Update update = new Update();
        update.set("copied", (Object)true);
        this.mongoTemplate.upsert(new Query(), update, "application");
        long mongoT = System.currentTimeMillis();
        log.info(application + "\u5e94\u7528\u5207\u7248-\u590d\u5236\u5b8cmongo\u6570\u636e\u7684\u8017\u65f6\uff1a" + (mongoT - neoT));
        log.info(application + "\u5e94\u7528\u5207\u7248-\u590d\u5236\u5b8c\u6210");
    }

    private void copyNeo4jData(String application, String oldVersion, String newVersion, Neo4jManager neo4jManager) {
        long t0 = System.currentTimeMillis();
        ConcurrentHashMap<Long, Long> nodeNeo4jIdMap = new ConcurrentHashMap<Long, Long>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", oldVersion);
        param.put("application", application);
        List nodeResultList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        List relationList = neo4jManager.ExecuteQuery("match (startNode)-[relation]->(endNode) where startNode.version = $version and (startNode.athena_namespace = $application or startNode.nameSpace = $application) and endNode.version = $version and (endNode.athena_namespace = $application or endNode.nameSpace = $application) return id(startNode) as startNodeId,type(relation) as relationType,id(endNode) as endNodeId", param);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        for (Object nodeResult : nodeResultList) {
            StringBuilder nodeCypher = new StringBuilder("create (node");
            Collection labels = ((InternalNode)nodeResult.get("node")).labels();
            long nodeId = ((InternalNode)nodeResult.get("node")).id();
            for (String label : labels) {
                nodeCypher.append(String.format(":%s", label));
            }
            nodeCypher.append("{");
            Map properties = ((InternalNode)nodeResult.get("node")).asMap();
            this.combineNodeProperties(properties, nodeCypher);
            nodeCypher.append("oldNodeId:" + nodeId + ",");
            nodeCypher.append(String.format("version:'%s', publishTime:'%s'}) return id(node) as nodeId", newVersion, DateUtil.now()));
            cqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)nodeCypher.toString())));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList);
        param.put("version", newVersion);
        param.put("application", application);
        List newNodeList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        for (Object nodeResult : newNodeList) {
            long newNodeId = ((InternalNode)nodeResult.get("node")).id();
            Map properties = ((InternalNode)nodeResult.get("node")).asMap();
            Long oldNodeId = Convert.toLong(properties.get("oldNodeId"));
            nodeNeo4jIdMap.put(oldNodeId, newNodeId);
        }
        relationList.forEach(relation -> {
            relation.put("startNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("startNodeId").toString())));
            relation.put("endNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("endNodeId").toString())));
        });
        ArrayList<Cql> cqlList1 = new ArrayList<Cql>();
        for (Map relation2 : relationList) {
            String relationCypher = String.format("match (startNode),(endNode) WHERE id(startNode)=%s and id(endNode)=%s merge (startNode)-[relation:%s]->(endNode)", relation2.get("startNodeId"), relation2.get("endNodeId"), relation2.get("relationType"));
            cqlList1.add(new Cql().setParams(new HashMap()).setCql(relationCypher));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList1);
        long t1 = System.currentTimeMillis();
        log.info(application + "\u5e94\u7528\u590d\u5236neo4j\u6570\u636e\u8017\u65f6\uff08ms\uff09\uff1a" + (t1 - t0));
    }

    private void combineNodeProperties(Map<String, Object> properties, StringBuilder nodeCypher) {
        properties.forEach((k, v) -> {
            if (!"version".equals(k) && !"oldNodeId".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append(String.format("`%s`:", k));
                } else {
                    nodeCypher.append(String.format("%s:", k));
                }
                if (v instanceof String) {
                    String propertyValue2 = (String)v;
                    propertyValue2 = propertyValue2.replace("'", "\\\"");
                    nodeCypher.append(String.format("'%s',", propertyValue2));
                } else if (v instanceof Collection) {
                    nodeCypher.append("[");
                    List propertyValueList = (List)v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append(v).append(",");
                }
            }
        });
    }

    public List<Cql> getUpdateAppDataVersion(String application, String oldVersion, String newVersion, List<String> tenantIdList) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("oldVersion", oldVersion);
        param.put("newVersion", newVersion);
        param.put("application", application);
        Cql deleteCql = new Cql();
        deleteCql.setCql("match (node) where node.version = $newVersion and node.athena_namespace = $application detach delete node");
        deleteCql.setParams(param);
        Cql updateCql = new Cql();
        updateCql.setCql("match (node) where node.version = $oldVersion and node.athena_namespace = $application set node.version=$newVersion");
        updateCql.setParams(param);
        Cql updateTenantCql = new Cql();
        param.put("tenantIdList", tenantIdList);
        updateTenantCql.setCql("match (n:TenantEntity) where n.tenantId in $tenantIdList and n.version<>$newVersion set n.version=$newVersion");
        updateTenantCql.setParams(param);
        cqlList.add(deleteCql);
        cqlList.add(updateCql);
        cqlList.add(updateTenantCql);
        Cql updateAppCql = new Cql();
        updateAppCql.setCql("match (n:AppEntity) where n.code = $application and n.version<>$newVersion set n.version=$newVersion");
        updateAppCql.setParams(param);
        cqlList.add(updateAppCql);
        return cqlList;
    }

    private Cql deleteDiffVersionRelaBetweenTenantAndAppData(String tenantVersion, String appVersion, List<String> tenantIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", tenantIdList);
        String cqlStr = "match (n:TenantEntity{version:$tenantVersion})-[r]->(m) where n.tenantId in $tenantIdList and m.version=$appVersion and NOT m:AppEntity delete r";
        Cql cql = new Cql().setCql(cqlStr).setParams(param);
        return cql;
    }

    private Set<String> getAppCodeRelaToTenantId(String tenantId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        String cql = "match(n:TenantEntity{tenantId:$tenantId})-[]->(m:AppEntity) return m.code as code";
        List authAppCodeList = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        Set<String> appCode = authAppCodeList.stream().map(authAppCode -> String.valueOf(authAppCode.get("code"))).collect(Collectors.toSet());
        return appCode;
    }

    private List<Cql> addTenantRelaWithProcess(Set<String> application, String tenantVersion, String appVersion, List<String> tenantIdList) {
        List<Object> executeCqlList = new ArrayList<Cql>();
        if (!tenantVersion.equals(appVersion)) {
            return executeCqlList;
        }
        Set fullNameSpace = this.getAppEntityFullNamespace(application);
        if (CollUtil.isEmpty((Collection)fullNameSpace)) {
            return executeCqlList;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("application", application);
        param.put("tenantVersion", tenantVersion);
        param.put("appVersion", appVersion);
        param.put("tenantIdList", tenantIdList);
        param.put("fullNameSpace", fullNameSpace);
        executeCqlList = this.addTenantRelaWithNodeInProcess(param);
        return executeCqlList;
    }

    private List<Cql> addTenantRelaWithNodeInProcess(Map<String, Object> param) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        String cql1 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Task{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:TASK]->(m)";
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
        String cql2 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Activity{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTIVITY]->(m)";
        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        String cql3 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:MonitorRule{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:USE]->(m)";
        executeCqlList.add(new Cql().setCql(cql3).setParams(param));
        String cql4 = "match(n:TenantEntity{version:$tenantVersion}) where n.tenantId in $tenantIdList match(m:Action{version:$appVersion}) where (m.nameSpace in $fullNameSpace or m.athena_namespace in $fullNameSpace) and ((m.inclusionTenant is null and m.notInclusionTenant is null) or (m.inclusionTenant is not null and n.tenantId in m.inclusionTenant) or (m.notInclusionTenant is not null and not n.tenantId in m.notInclusionTenant)) merge (n)-[:ACTION]->(m)";
        executeCqlList.add(new Cql().setCql(cql4).setParams(param));
        return executeCqlList;
    }
}

