/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.servermap;

import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.servermap.EspExtractUtil;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapInfoAppender;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

public class ServerMapMongoAnalyzer
implements Callable<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerMapMongoAnalyzer.class);
    private final String db;
    private final String col;
    private final String type;
    private final String name;
    private final MongoCrudService mongoCrudService;
    private final MongoTemplate mongoTemplate;
    private final ServerMapInfoAppender serverMapInfoAppender;
    private final int mongoBatchSize;
    private final List<EspServiceMapDto> toInsert = new ArrayList();
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Void call() {
        long start = System.currentTimeMillis();
        this.mongoCrudService.processLargeQuery(this.db, this.col, Collections.emptyMap(), this.mongoBatchSize, (arg_0, arg_1) -> this.processBatch(arg_0, arg_1));
        log.info("processLargeQuery from mongo col: {} cost: {}", (Object)this.col, (Object)(System.currentTimeMillis() - start));
        return null;
    }

    private void processBatch(List<Map<String, Object>> batch, boolean isLastBatch) {
        for (Map<String, Object> map : batch) {
            String s = this.objectMapper.writeValueAsString(map);
            List espStrings = EspExtractUtil.extractEspStrings((String)s);
            for (String esp : espStrings) {
                EspServiceMapDto espServiceMapDto = new EspServiceMapDto();
                espServiceMapDto.setKey(UUID.randomUUID().toString());
                espServiceMapDto.setType(this.type);
                espServiceMapDto.setName(this.name);
                espServiceMapDto.setAppCode(map.getOrDefault("application", map.getOrDefault("sourceId", "")).toString());
                espServiceMapDto.setEspServiceId(esp);
                espServiceMapDto.setCreateTime(LocalDateTime.now());
                espServiceMapDto.setFlag(Integer.valueOf(0));
                this.toInsert.add(espServiceMapDto);
            }
        }
        if (this.toInsert.size() >= this.mongoBatchSize || isLastBatch) {
            this.serverMapInfoAppender.addAppNameAndEspName(this.toInsert);
            this.saveToMongo(this.toInsert);
            this.toInsert.clear();
        }
    }

    private void saveToMongo(List<EspServiceMapDto> dto) {
        if (dto.isEmpty()) {
            return;
        }
        this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, EspServiceMapDto.class).insert(dto).execute();
    }

    @Generated
    public ServerMapMongoAnalyzer(String db, String col, String type, String name, MongoCrudService mongoCrudService, MongoTemplate mongoTemplate, ServerMapInfoAppender serverMapInfoAppender, int mongoBatchSize) {
        this.db = db;
        this.col = col;
        this.type = type;
        this.name = name;
        this.mongoCrudService = mongoCrudService;
        this.mongoTemplate = mongoTemplate;
        this.serverMapInfoAppender = serverMapInfoAppender;
        this.mongoBatchSize = mongoBatchSize;
    }
}

