/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.page.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.service.page.PageService;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PageServiceImpl
implements PageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageServiceImpl.class);
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;

    public void pagePublish2KM(JSONObject neo4jDatas, JSONObject originalCodeRelationShip, String version) {
        if (neo4jDatas.get((Object)"Activity") != null) {
            List activityDatas = (List)neo4jDatas.get((Object)"Activity");
            log.info("activityDatas:{}", (Object)activityDatas);
            for (String neo4jData : activityDatas) {
                neo4jData = neo4jData.replaceAll("\\{athena_version}", version);
                List newNeo4jDatas = this.replaceCode(neo4jData, originalCodeRelationShip);
                for (String cql : newNeo4jDatas) {
                    Neo4jMultipleUtil.executeCql((String)cql, (Driver[])new Driver[]{this.driver1, this.driver2});
                }
            }
        }
    }

    private List<String> replaceCode(String neo4jData, JSONObject originalCodeRelationShip) {
        String originalCode = "";
        Pattern pattern = Pattern.compile("code:'(\\w+)'");
        Matcher matcher = pattern.matcher(neo4jData);
        if (matcher.find()) {
            originalCode = matcher.group(1);
        }
        ArrayList<String> newNeo4jDatas = new ArrayList<String>();
        JSONObject activityConfigRelation = originalCodeRelationShip.getJSONObject("activityConfigs");
        if (activityConfigRelation.get((Object)originalCode) != null) {
            List relaItemStepCodes = (List)activityConfigRelation.get((Object)originalCode);
            for (String itemStepCode : relaItemStepCodes) {
                String newCode = itemStepCode + originalCode;
                String newNeo4jData = neo4jData.replace("code:'" + originalCode + "'", "code:'" + newCode + "'");
                newNeo4jDatas.add(newNeo4jData);
            }
        }
        return newNeo4jDatas;
    }

    public void cleanPageDataFromKM(String application, String version) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        param.put("version", version);
        String cqlStr = "MATCH (n:Activity {athena_namespace: $application, version: $version})OPTIONAL MATCH (n)-[r]-() DELETE r, n;";
        cqlList.add(new Cql().setCql(cqlStr).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void updatePageDataVersion(String application, String oldVersion, String newVersion) {
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        param.put("oldVersion", oldVersion);
        param.put("newVersion", newVersion);
        String cqlStr = "match (n:Activity) where n.athena_namespace = $application and n.version=$oldVersion set n.version=$newVersion";
        cqlList.add(new Cql().setCql(cqlStr).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void createNewPageData(String application, String oldVersion, String newVersion) {
        Neo4jManager neo4jManager1 = new Neo4jManager(this.driver1);
        this.createNewActivity(application, oldVersion, newVersion, neo4jManager1);
        if (this.driver2 != null) {
            Neo4jManager neo4jManager2 = new Neo4jManager(this.driver2);
            this.createNewActivity(application, oldVersion, newVersion, neo4jManager2);
        }
    }

    private void createNewActivity(String application, String oldVersion, String newVersion, Neo4jManager neo4jManager) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("application", application);
        param.put("oldVersion", oldVersion);
        String cqlStr = "match (n:Activity) where n.athena_namespace = $application and n.version=$oldVersion return n";
        List activityResults = neo4jManager.ExecuteQuery(cqlStr, param);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        for (Map activityResult : activityResults) {
            StringBuilder nodeCypher = new StringBuilder("create (n:Activity");
            nodeCypher.append("{");
            Map properties = ((InternalNode)activityResult.get("n")).asMap();
            this.combineNodeProperties(properties, nodeCypher);
            nodeCypher.append(String.format("version:'%s', publishTime:'%s'})", newVersion, DateUtil.now()));
            cqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)nodeCypher.toString())));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList);
    }

    private void combineNodeProperties(Map<String, Object> properties, StringBuilder nodeCypher) {
        properties.forEach((k, v) -> {
            if (!"version".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append(String.format("`%s`:", k));
                } else {
                    nodeCypher.append(String.format("%s:", k));
                }
                if (v instanceof String) {
                    String propertyValue2 = (String)v;
                    propertyValue2 = propertyValue2.replace("'", "\\\"");
                    nodeCypher.append(String.format("'%s',", propertyValue2));
                } else if (v instanceof Collection) {
                    nodeCypher.append("[");
                    List propertyValueList = (List)v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append(v).append(",");
                }
            }
        });
    }
}

