/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.spi;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.DeployTask;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class KgService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KgService.class);
    @Value(value="${module.km.domain}/restful/service/knowledgegraph/")
    private String knowledgeGraphUrl;
    @Autowired
    private ModuleConfig moduleConfig;

    @Async
    public void cleanCache() {
        JSONObject param = new JSONObject();
        param.put("keyPattern", Arrays.asList("kg:*", "tag*", "presetLibrary*"));
        this.requestKg("cache/withPattern", param, Method.DELETE);
    }

    public void cacheResetToKm() {
        JSONObject param = new JSONObject();
        param.put("keyPatterns", Arrays.asList("knowledgegraph*", "tagsystem*", "presetlibrary*"));
        this.requestKg("cache/withPattern", param, Method.DELETE);
    }

    public String requestKg(String serviceName, JSONObject paramJson, Method method) {
        String url = this.knowledgeGraphUrl + serviceName;
        try {
            String response = HttpUtil.createRequest((Method)method, (String)url).body(paramJson.toJSONString()).execute().body();
            log.info("\u8bf7\u6c42kg\u6210\u529f:{}", (Object)response);
            return response;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42kg\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
    }

    public void updateApplicationComponentList(DeployTask task) {
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/Component/UpdateApplicationComponentList";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", task.getToken());
        if (null != task.getRouterKey()) {
            headers.put("routerKey", task.getRouterKey());
        }
        JSONObject body = new JSONObject();
        body.put("appCode", (Object)task.getAppId());
        body.put("version", (Object)task.getVersion());
        if ("tenantApp".equals(task.getType())) {
            body.put("tenantIds", (Object)task.getTenantIds());
        }
        log.info("updateApplicationComponentList url is -->{}", (Object)url);
        log.info("updateApplicationComponentList headers is -->{}", headers);
        log.info("updateApplicationComponentList request is -->{}", (Object)body);
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)body)).execute().body();
        log.info("updateApplicationComponentList response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/Component/UpdateApplicationComponentList\u63a5\u53e3\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }

    public void executeMechanismCompile(DeployTask task, List<String> mechanismCodes) {
        String url = this.moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/mechanismDesign/applyMechanisms";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", task.getToken());
        if (null != task.getRouterKey()) {
            headers.put("routerKey", task.getRouterKey());
        }
        JSONObject body = new JSONObject();
        body.put("mechanismCodes", mechanismCodes);
        body.put("application", (Object)task.getAppId());
        body.put("version", (Object)task.getVersion());
        if ("tenantApp".equals(task.getType())) {
            body.put("tenantIds", (Object)task.getTenantIds());
        }
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(headers)).body(JSON.toJSONString((Object)body)).execute().body();
        log.info("applyMechanisms response is -->{}", (Object)response);
        JSONObject responseObj = JSON.parseObject((String)response);
        if (responseObj.getInteger("status") != 200) {
            throw new BusinessException("\u8c03\u7528/restful/service/knowledgegraph/mechanismDesign/applyMechanisms \u63a5\u53e3\u673a\u5236\u4e00\u6b21\u7f16\u8bd1\u5931\u8d25\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + response);
        }
    }
}

