/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.template;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.base.AbilityEnum;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.ActivityModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;
import com.digiwin.athena.km_deployer_service.template.AbstractTemplate;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="activityTemplate")
public class ActivityTemplate
extends AbstractTemplate<ActivityModel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActivityTemplate.class);

    @PostConstruct
    public void init() {
        this.initTemplateList("activity", "activity");
    }

    protected ActivityModel initModel(String fileContent, CustomConfigModel model, Class<ActivityModel> cls) {
        JSONObject fileContentObject = (JSONObject)JSONUtil.toBean((String)fileContent, JSONObject.class);
        String code = fileContentObject.getString("code");
        boolean addHeader = false;
        if (code.endsWith("_Api_CustomCall")) {
            addHeader = true;
            fileContent = fileContent.replace("#{domain}", model.getDomain()).replace("#{method}", model.getMethod()).replace("#{ApiUrl}", model.getUrl()).replace("#{contentType}", model.getContentType());
        } else if (code.endsWith("_Api_Call")) {
            addHeader = true;
            fileContent = fileContent.replace("#{domain}", model.getDomain()).replace("#{method}", model.getMethod()).replace("#{ApiUrl}", model.getUrl()).replace("#{contentType}", model.getContentType());
            if (StrUtil.isNotBlank((CharSequence)model.getRequestScript())) {
                String requestScript = StringEscapeUtils.escapeJson((String)model.getRequestScript());
                fileContent = fileContent.replace("#{requestScript}", requestScript);
            }
            if (StrUtil.isNotBlank((CharSequence)model.getResponseScript())) {
                String responseScript = StringEscapeUtils.escapeJson((String)model.getResponseScript());
                fileContent = fileContent.replace("#{responseScript}", responseScript);
            }
        }
        ActivityModel result = (ActivityModel)JSON.parseObject((String)fileContent, cls);
        if (addHeader) {
            this.addHeader(model, result.getConfig());
        }
        return result;
    }

    public void fillCustomConfigModel(CustomConfigModel defConfigModel, JSONObject assistantSceneItemStep) {
        String abilityCode = assistantSceneItemStep.getString("abilityCode");
        if (abilityCode.equals(AbilityEnum.OPENAPI.getAbilityCode())) {
            JSONObject config = assistantSceneItemStep.getJSONObject("config");
            JSONObject apiConfig = config.getJSONObject("apiconfig");
            JSONObject request = apiConfig.getJSONObject("request");
            JSONObject response = apiConfig.getJSONObject("response");
            defConfigModel.setDomain(request.getString("domain"));
            defConfigModel.setMethod(request.getString("method"));
            defConfigModel.setUrl(request.getString("url"));
            if (StrUtil.isBlank((CharSequence)request.getString("contentType"))) {
                defConfigModel.setContentType("json");
            } else {
                defConfigModel.setContentType(request.getString("contentType"));
            }
            defConfigModel.setHeaders((Map)request.getJSONObject("headers"));
            if (StrUtil.isBlank((CharSequence)request.getString("requestScript"))) {
                defConfigModel.setRequestScript("var request={};return request;");
            } else {
                defConfigModel.setRequestScript(request.getString("requestScript"));
            }
            defConfigModel.setResponseScript(response.getString("responseScript"));
        }
    }
}

