/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.thread;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.base.AbilityEnum;
import com.digiwin.athena.km_deployer_service.base.SceneType;
import com.digiwin.athena.km_deployer_service.base.SynonymEntityType;
import com.digiwin.athena.km_deployer_service.domain.asa.deploy.DeployDetail;
import com.digiwin.athena.km_deployer_service.domain.asa.deploy.DeployProcess;
import com.digiwin.athena.km_deployer_service.domain.asa.enent.DeployEvent;
import com.digiwin.athena.km_deployer_service.domain.asa.model.CollectionModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.AssistantModelCorpus;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.AssistantProjectModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployParam;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployVersionParam;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.povo.asa.BasicInfoDto;
import com.digiwin.athena.km_deployer_service.service.appEntity.AppEntityService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.template.ITemplate;
import com.digiwin.athena.km_deployer_service.template.model.IGenerateModel;
import com.digiwin.athena.km_deployer_service.thread.AbstructVersionThread;
import com.digiwin.athena.km_deployer_service.util.CurThreadInfoUtils;
import com.digiwin.athena.km_deployer_service.util.IdSnowflake;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.CollectionUtils;

public class DeployThread
extends AbstructVersionThread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployThread.class);
    private static final List<String> ANALYZE_MONGODB_LIST = new ArrayList();
    private static final List<String> ANALYZE_COLLECTION_LIST;
    private static final List<String> ANALYZE_NEO4J_NODE_LIST;
    private static final String STEP_TYPE_END = "end";
    private static final String PARTITION = "DEPLOY_PROCESS";
    private static final String FILE_FOLDER_CYPHER = "cypher";
    private DeployVersionParam deployVersionParam;
    private String compileZipPath;
    private String compileDataPath;
    private DmcService dmcService;
    private AppEntityService appEntityService;
    private Map<String, ITemplate> templateMap;
    private JSONObject compiledData;
    private String assistantName;
    private String curTenantToken;
    private JSONObject originalCodeRelationShip = new JSONObject();

    public DeployThread(DeployVersionParam deployVersionParam) {
        this.deployVersionParam = deployVersionParam;
        this.parentThreadId = deployVersionParam.getThreadId();
        this.deployNo = deployVersionParam.getDeployNo();
    }

    public void run() {
        CurThreadInfoUtils.setRouterKey((String)this.routerKey);
        this.application = this.deployVersionParam.getApplication();
        this.compiledData = this.deployVersionParam.getCompiledData();
        this.tenantIdList = this.deployVersionParam.getTenantIdList().toJavaList(String.class);
        this.currentUser = this.deployVersionParam.getCurrentUser();
        this.currentTenantId = this.currentUser.getTenantId();
        String env = this.deployVersionParam.getEnv();
        log.info("\u5f00\u59cb\u90e8\u7f72{}:{}", (Object)this.deployVersionParam.getApplication(), (Object)this.parentThreadId);
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u5728\u5a1c\u5a1c\u540e\u53f0\u90e8\u7f72..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        this.curTenantToken = this.tenantService.getRealTimeTenantToken(this.currentTenantId);
        File compiledDataFilesDirectory = this.getCompiledDataFiles(this.compiledData);
        JSONObject analysedDatas = this.analyseDataFromFile(compiledDataFilesDirectory);
        this.cleanMongoData();
        if (!this.isSkipTemplate) {
            this.instantiateTemplateData(analysedDatas);
        }
        if (!this.isSkipGPT) {
            this.doGPTDeploy(analysedDatas);
        }
        this.doUrgeRuleDeploy(analysedDatas);
        this.putData2Mongo(analysedDatas, env);
        try {
            this.aniaHelper.deployerCache(this.curTenantToken, this.isCNaDeploy, true, this.assistantCode);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u52a9\u7406\u7f13\u5b58error. ", (Throwable)e);
        }
        this.doAfterDataProcess();
        this.doProcess4ProdAndAuth();
        this.resetCache(this.curTenantToken);
        DeployProcess deployProcess = (DeployProcess)this.cacheService.get(PARTITION, this.application, DeployProcess.class);
        if (deployProcess != null) {
            deployProcess.setDeployedNum(deployProcess.getTotal());
        }
        log.info("\u90e8\u7f72\u5b8c\u6210:{}", (Object)this.parentThreadId);
        deployDetail.setResult("finish");
        long mills = this.calculateExecuteMills(deployDetail.getTime());
        deployDetail.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
        deployEvent.setMsg("process:" + JSON.toJSONString((Object)deployDetail));
        deployEvent.setComplete(true);
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
    }

    private void doUrgeRuleDeploy(JSONObject analysedDatas) {
        List assistantDataList = (List)analysedDatas.getJSONObject("asa").get((Object)"assistant");
        List assistantUrgeList = (List)analysedDatas.getJSONObject("asa").get((Object)"asa_assistant_urge");
        this.updateAsssitant(assistantDataList, assistantUrgeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGPTDeploy(JSONObject analysedDatas) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("GPT\u90e8\u7f72..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            List assistantDataList = (List)analysedDatas.getJSONObject("asa").get((Object)"assistant");
            List projectDataList = (List)analysedDatas.getJSONObject("asa").get((Object)"asa_assistant_project");
            List modelDataList = (List)analysedDatas.getJSONObject("asa").get((Object)"asa_assistant_model");
            List utterancesDataList = (List)analysedDatas.getJSONObject("asa").get((Object)"asa_model_corpus");
            List synonymDataList = (List)analysedDatas.getJSONObject("designer").get((Object)"agiledata_synonym");
            ArrayList<JSONObject> keywordList = new ArrayList<JSONObject>();
            ArrayList<JSONObject> synonymList = new ArrayList<JSONObject>();
            for (JSONObject synonymData : synonymDataList) {
                if ("\u76ee\u6807".equals(synonymData.getString("entityTypeName"))) {
                    keywordList.add(synonymData);
                    continue;
                }
                synonymList.add(synonymData);
            }
            if (!synonymList.isEmpty()) {
                this.executeEsDelete(this.application, SynonymEntityType.SYNONYM.getName(), "test", this.curTenantToken);
                this.executeEsUpsert(this.application, SynonymEntityType.SYNONYM.getName(), synonymList, "test", this.curTenantToken);
            }
            String llmPromptId = null;
            if (!CollectionUtils.isEmpty((Collection)projectDataList) && !CollectionUtils.isEmpty((Collection)modelDataList) && !CollectionUtils.isEmpty((Collection)utterancesDataList) && Objects.nonNull(this.deployVersionParam.getModelInfo()) && StringUtils.isNotBlank((CharSequence)this.deployVersionParam.getModelInfo().getString("projectCode")) && Objects.nonNull(this.deployVersionParam.getModelInfo().getObject("modelTypes", List.class)) && StringUtils.isNotBlank((CharSequence)this.deployVersionParam.getModelInfo().getString("modelCode")) && StringUtils.isNotBlank((CharSequence)this.deployVersionParam.getCurrentEnv()) && StringUtils.isNotBlank((CharSequence)this.deployVersionParam.getEnv())) {
                String modelCode = this.deployVersionParam.getModelInfo().getString("modelCode");
                List modelTypes = (List)this.deployVersionParam.getModelInfo().getObject("modelTypes", List.class);
                List assistantProjectModel = modelDataList.stream().filter(item -> Objects.equals(modelCode, item.getString("modelCode"))).collect(Collectors.toList());
                String deployMode = "test";
                Bson filterFind = Filters.eq((String)"assistantCode", (Object)this.assistantCode);
                FindIterable documents = this.mongoTemplate.getMongoDbFactory().getDb("asa").getCollection("assistant").find(filterFind);
                Document assistant = (Document)documents.first();
                if (Objects.isNull(assistant)) {
                    if (!Objects.equals(this.deployVersionParam.getCurrentEnv(), this.deployVersionParam.getEnv())) {
                        llmPromptId = this.addLlmPrompt(projectDataList, this.deployVersionParam, modelDataList, utterancesDataList);
                        if (StringUtils.isNotBlank((CharSequence)((JSONObject)assistantProjectModel.get(0)).getString("llmPromptId"))) {
                            this.assistantRhApiHelper.modifyLLMPrompt(llmPromptId, ((JSONObject)assistantProjectModel.get(0)).getString("llmMode"), ((JSONObject)assistantProjectModel.get(0)).getString("llmPrompt"), "", this.curTenantToken);
                        }
                        this.deployllm(this.deployVersionParam.getModelInfo().getString("projectCode"), llmPromptId, deployMode);
                    }
                } else {
                    JSONObject aiProject;
                    JSONObject jSONObject = aiProject = Objects.isNull(JSON.parseObject((String)JSON.toJSONString((Object)assistant.get((Object)"aiProject")))) ? new JSONObject() : JSON.parseObject((String)JSON.toJSONString((Object)assistant.get((Object)"aiProject")));
                    if (!Objects.equals(this.deployVersionParam.getModelInfo().getString("modelCode"), aiProject.getString("modelCode")) && !Objects.equals(this.deployVersionParam.getCurrentEnv(), this.deployVersionParam.getEnv())) {
                        llmPromptId = this.addLlmPrompt(projectDataList, this.deployVersionParam, modelDataList, utterancesDataList);
                        if (StringUtils.isNotBlank((CharSequence)((JSONObject)assistantProjectModel.get(0)).getString("llmPromptId"))) {
                            this.assistantRhApiHelper.modifyLLMPrompt(llmPromptId, ((JSONObject)assistantProjectModel.get(0)).getString("llmMode"), ((JSONObject)assistantProjectModel.get(0)).getString("llmPrompt"), "", this.curTenantToken);
                        }
                        this.deployllm(this.deployVersionParam.getModelInfo().getString("projectCode"), llmPromptId, deployMode);
                    }
                }
                if (Objects.equals(this.deployVersionParam.getCurrentEnv(), this.deployVersionParam.getEnv())) {
                    if (!CollectionUtils.isEmpty((Collection)modelDataList)) {
                        log.info("\u6a21\u578b\u6570\uff1a{}", (Object)modelDataList.size());
                        log.info(modelCode);
                        log.info(JSONObject.toJSONString((Object)modelDataList));
                    }
                    if (StringUtils.isBlank((CharSequence)((JSONObject)assistantProjectModel.get(0)).getString("llmPromptId"))) {
                        llmPromptId = this.addLlmPrompt(projectDataList, this.deployVersionParam, modelDataList, utterancesDataList);
                        this.deployllm(this.deployVersionParam.getModelInfo().getString("projectCode"), llmPromptId, deployMode);
                    } else {
                        llmPromptId = ((JSONObject)assistantProjectModel.get(0)).getString("llmPromptId");
                        Bson assistantFindFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.assistantCode), Filters.eq((String)"version", (Object)"2.0")});
                        FindIterable assistantDoc = this.mongoTemplate.getMongoDbFactory().getDb("asa").getCollection("assistant").find(assistantFindFilterBson);
                        Document commercialAssistant = (Document)assistantDoc.first();
                        if (Objects.nonNull(commercialAssistant) && Objects.nonNull(commercialAssistant.get((Object)"aiProject"))) {
                            JSONObject aiProject = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)commercialAssistant.get((Object)"aiProject")), JSONObject.class);
                            String prodLlmPromptId = aiProject.getString("llmPromptId");
                            String prodModelCode = aiProject.getString("modelCode");
                            if (llmPromptId.equals(prodLlmPromptId)) {
                                deployMode = "test&prod";
                            }
                            this.deployllm(this.deployVersionParam.getModelInfo().getString("projectCode"), ((JSONObject)assistantProjectModel.get(0)).getString("llmPromptId"), deployMode);
                            if (modelTypes.contains(MODEL_TYPE_NLU)) {
                                deployMode = modelCode.equals(prodModelCode) ? "test&prod" : "test";
                                this.nluTagDeployer(this.deployVersionParam, deployMode);
                            }
                        } else {
                            this.deployllm(this.deployVersionParam.getModelInfo().getString("projectCode"), ((JSONObject)assistantProjectModel.get(0)).getString("llmPromptId"), deployMode);
                            if (modelTypes.contains(MODEL_TYPE_NLU)) {
                                this.nluTagDeployer(this.deployVersionParam, deployMode);
                            }
                        }
                    }
                }
                if (modelTypes.contains(MODEL_TYPE_ES) && !keywordList.isEmpty()) {
                    this.executeEsDelete(this.application, SynonymEntityType.TARGET.getName(), "test", this.curTenantToken);
                    this.executeEsUpsert(this.application, SynonymEntityType.TARGET.getName(), keywordList, "test", this.curTenantToken);
                }
                this.updateAsssitant(assistantDataList, modelDataList, this.deployVersionParam, llmPromptId);
            } else {
                List assistantSceneList = (List)analysedDatas.getJSONObject("asa").get((Object)"assistantScene");
                llmPromptId = this.addLlmPromptWithoutModel(assistantSceneList, this.curTenantToken, (JSONObject)assistantDataList.get(0));
                this.deployllm(this.application, llmPromptId, "test");
                this.updateAsssitant(assistantDataList, new ArrayList(), this.deployVersionParam, llmPromptId);
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("GPT\u90e8\u7f72\u5f02\u5e38:", (Throwable)e);
            this.setWarnDeployDetail(deployDetail, e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void updateAsssitant(List<JSONObject> assistantDataList, List<JSONObject> modelDataList, DeployVersionParam deployVersionParam, String llmPromptId) {
        Document assistantProjectModel = null;
        for (JSONObject jSONObject : modelDataList) {
            Document modelDoc = Document.parse((String)jSONObject.toJSONString());
            if (!modelDoc.getString((Object)"modelCode").equals(deployVersionParam.getModelInfo().getString("modelCode"))) continue;
            assistantProjectModel = modelDoc;
            break;
        }
        if (Objects.nonNull(assistantProjectModel)) {
            AssistantProjectModel assistantProjectModel1 = (AssistantProjectModel)JSON.parseObject((String)JSON.toJSONString(assistantProjectModel), AssistantProjectModel.class);
            for (JSONObject assistantData : assistantDataList) {
                JSONObject jsonObjectAiProject = Objects.isNull(JSON.parseObject((String)JSON.toJSONString((Object)assistantData.getString("aiProject")), JSONObject.class)) ? new JSONObject() : (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)assistantData.getString("aiProject")), JSONObject.class);
                jsonObjectAiProject.fluentPut("projectCode", (Object)deployVersionParam.getModelInfo().getString("projectCode"));
                jsonObjectAiProject.fluentPut("modelTypes", deployVersionParam.getModelInfo().getObject("modelTypes", List.class));
                jsonObjectAiProject.fluentPut("llmFoundationModel", (Object)assistantProjectModel1.getLlmModel()).fluentPut("modelCode", (Object)deployVersionParam.getModelInfo().getString("modelCode"));
                jsonObjectAiProject.fluentPut("llmPromptId", (Object)llmPromptId);
                jsonObjectAiProject.fluentPut("modelTag", (Object)"test");
                assistantData.put("aiProject", (Object)jsonObjectAiProject);
            }
        } else {
            for (JSONObject jSONObject : assistantDataList) {
                JSONObject jsonObjectAiProject = Objects.isNull(JSON.parseObject((String)JSON.toJSONString((Object)jSONObject.getString("aiProject")), JSONObject.class)) ? new JSONObject() : (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)jSONObject.getString("aiProject")), JSONObject.class);
                jsonObjectAiProject.fluentPut("projectCode", (Object)this.application);
                jsonObjectAiProject.fluentPut("modelTypes", Arrays.asList(MODEL_TYPE_LLM));
                jsonObjectAiProject.fluentPut("llmFoundationModel", (Object)"ChatGPT").fluentPut("modelCode", null);
                jsonObjectAiProject.fluentPut("llmPromptId", (Object)llmPromptId);
                jsonObjectAiProject.fluentPut("modelTag", (Object)"test");
                jSONObject.put("aiProject", (Object)jsonObjectAiProject);
            }
        }
    }

    private void updateAsssitant(List<JSONObject> assistantDataList, List<JSONObject> assistantUrgeList) {
        for (JSONObject urgeData : assistantUrgeList) {
            Document urgeDoc = Document.parse((String)urgeData.toJSONString());
            String application = urgeDoc.getString((Object)"application");
            for (JSONObject assistantData : assistantDataList) {
                String assistantCode = assistantData.getString("assistantCode");
                if (!assistantCode.equals(application)) continue;
                JSONObject jsonObjectUrge = new JSONObject();
                jsonObjectUrge.fluentPut("count", (Object)urgeDoc.getInteger((Object)"count")).fluentPut("intervalInMinutes", (Object)urgeDoc.getInteger((Object)"intervalInMinutes")).fluentPut("startAfter", (Object)urgeDoc.getInteger((Object)"startAfter")).fluentPut("effectiveStatus", (Object)urgeDoc.getBoolean((Object)"effectiveStatus")).fluentPut("urgeWayShow", (Object)urgeDoc.getInteger((Object)"urgeWayShow")).fluentPut("urgeTypes", (Object)urgeDoc.getList((Object)"urgeTypes", Map.class));
                assistantData.fluentPut("urge", (Object)jsonObjectUrge);
            }
        }
    }

    private void nluTagDeployer(DeployVersionParam deployVersionParam, String deployMode) {
        HashMap<String, String> projectName = new HashMap<String, String>();
        projectName.put("project_name", deployVersionParam.getModelInfo().getString("projectCode"));
        StringBuffer stringBuffer = new StringBuffer("deploy_");
        String create_mode = "model_1";
        stringBuffer.append(create_mode.replace("_", "")).append("_").append(deployVersionParam.getModelInfo().getString("modelCode"));
        this.assistantRhApiHelper.tagDeployer(create_mode, projectName, deployMode, stringBuffer.toString(), this.curTenantToken);
        create_mode = "model_2";
        this.assistantRhApiHelper.tagDeployer(create_mode, projectName, deployMode, stringBuffer.toString().replaceFirst("model1", "model2"), this.curTenantToken);
    }

    private File getCompiledDataFiles(JSONObject compiledData) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u4eceDMC\u4e0b\u8f7d\u6570\u636e\u6587\u4ef6..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        File compileZipFile = null;
        File compileDataDirectory = null;
        try {
            String randomPath = IdUtil.fastSimpleUUID();
            String applicationCompileZipPath = this.compileZipPath + File.separator + randomPath + File.separator + FilenameUtils.getName((String)this.application) + File.separator;
            String applicationCompileDataPath = this.compileDataPath + File.separator + randomPath + File.separator + FilenameUtils.getName((String)this.application) + File.separator;
            String shareUrl = compiledData.getString("compiledDataShareUrl");
            log.info("DMC\u5171\u4eab\u7f16\u8bd1\u6570\u636e\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)shareUrl);
            String compileDataZipFile = StrUtil.format((CharSequence)(this.application + "_{}.zip"), (Object[])new Object[]{compiledData.getString("version")});
            compileZipFile = FileUtil.file((String)applicationCompileZipPath, (String)FilenameUtils.getName((String)compileDataZipFile));
            this.downloadFileFromDmc(shareUrl, compileZipFile);
            compileDataDirectory = FileUtil.file((String)applicationCompileDataPath);
            ZipUtil.unzip((File)compileZipFile, (File)compileDataDirectory);
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Download data file from DMC error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
            try {
                if (null != compileZipFile) {
                    FileUtil.del((File)compileZipFile.getParentFile().getParentFile());
                }
            }
            catch (IORuntimeException iore) {
                log.error("Clean compile zip file error.", (Throwable)iore);
            }
        }
        return compileDataDirectory;
    }

    private JSONObject analyseDataFromFile(File compiledDataFilesDirectory) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u89e3\u6790\u6570\u636e\u6587\u4ef6..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        JSONObject analysedDatas = new JSONObject();
        for (String dbName : DB_COLLECTION.keySet()) {
            JSONObject collectionDatas = new JSONObject();
            List collectionList = (List)DB_COLLECTION.get(dbName);
            for (String collectionName : collectionList) {
                collectionDatas.put(collectionName, new ArrayList());
            }
            analysedDatas.put(dbName, (Object)collectionDatas);
        }
        try {
            File[] compiledDataFiles;
            NameFileFilter nameFileFilter = new NameFileFilter(".DS_Store");
            NotFileFilter notFileFilter = new NotFileFilter((IOFileFilter)nameFileFilter);
            List files = FileUtil.loopFiles((File)compiledDataFilesDirectory, (FileFilter)notFileFilter);
            int total = files.stream().mapToInt(file -> FileUtil.readLines((File)file, (String)"utf-8").size()).sum();
            DeployProcess deployProcess = new DeployProcess().setTotal(Integer.valueOf(total)).setLeft(Integer.valueOf(total));
            this.cacheService.set(PARTITION, this.application, (Object)deployProcess);
            for (File compileDataFile : compiledDataFiles = compiledDataFilesDirectory.listFiles()) {
                File[] collectionFiles;
                if (!compileDataFile.isDirectory() || !"asa".equals(compileDataFile.getName())) continue;
                for (File collectionFile : collectionFiles = compileDataFile.listFiles()) {
                    String collectionName;
                    if (!collectionFile.isDirectory() || !"assistant".equals(collectionName = collectionFile.getName())) continue;
                    File[] collectionDataFiles = collectionFile.listFiles();
                    this.sendDeployDetailMsg(String.format("\u89e3\u6790%s\u96c6\u5408\u7684\u6570\u636e..", "assistant"), deployDetail, deployEvent);
                    this.sendDeployDetailMsg(String.format("\u5f02\u6784%s\u6570\u636e..", "assistant"), deployDetail, deployEvent);
                    for (File dataFile : collectionDataFiles) {
                        if (".DS_Store".equals(dataFile.getName())) continue;
                        List datas = FileUtil.readLines((File)dataFile, (Charset)StandardCharsets.UTF_8);
                        for (String dataLine : datas) {
                            JSONObject assistantData;
                            deployProcess = (DeployProcess)this.cacheService.get(PARTITION, this.application, DeployProcess.class);
                            if (deployProcess != null) {
                                deployProcess.deployedNumIncrease();
                                deployProcess.setType("asa.assistant");
                            }
                            if ((assistantData = this.transferAssistantData(dataLine)) == null) continue;
                            analysedDatas.getJSONObject("asa").getJSONArray(collectionName).add((Object)assistantData);
                        }
                    }
                    this.sendDeployDetailResult("success", deployDetail, deployEvent);
                }
            }
            for (File compileDataFile : compiledDataFiles) {
                File[] collectionFiles;
                String dbName = compileDataFile.getName();
                if (!compileDataFile.isDirectory() || !ANALYZE_MONGODB_LIST.contains(dbName) && !FILE_FOLDER_CYPHER.equals(dbName)) continue;
                if (FILE_FOLDER_CYPHER.equals(dbName)) {
                    File[] cypherFiles;
                    for (File cypherFile : cypherFiles = compileDataFile.listFiles()) {
                        if (cypherFile.isDirectory()) continue;
                        List cypherDatas = FileUtil.readLines((File)cypherFile, (Charset)StandardCharsets.UTF_8);
                        JSONObject cypherDataInfo = new JSONObject();
                        for (String cypherData : cypherDatas) {
                            List<String> nodeCypherDatas;
                            JSONObject skillCypherData;
                            String cypherNode = this.getCypherNode(cypherData);
                            String cypherSkillCode = this.getCypherSkillCode(cypherData);
                            if (cypherDataInfo.get((Object)cypherSkillCode) == null) {
                                skillCypherData = new JSONObject();
                                cypherDataInfo.put(cypherSkillCode, (Object)skillCypherData);
                            }
                            if ((skillCypherData = cypherDataInfo.getJSONObject(cypherSkillCode)).get((Object)cypherNode) == null) {
                                nodeCypherDatas = new ArrayList();
                                skillCypherData.put(cypherNode, nodeCypherDatas);
                            }
                            nodeCypherDatas = (List)skillCypherData.get((Object)cypherNode);
                            nodeCypherDatas.add(cypherData.replaceAll(",?\\s*skillCode:'[A-Za-z0-9]+'", ""));
                        }
                        analysedDatas.put(FILE_FOLDER_CYPHER, (Object)cypherDataInfo);
                    }
                    continue;
                }
                for (File collectionFile : collectionFiles = compileDataFile.listFiles()) {
                    String collectionName;
                    if (!collectionFile.isDirectory() || !ANALYZE_COLLECTION_LIST.contains(collectionName = collectionFile.getName())) continue;
                    File[] collectionDataFiles = collectionFile.listFiles();
                    this.sendDeployDetailMsg(String.format("\u89e3\u6790%s\u96c6\u5408\u7684\u6570\u636e..", collectionName), deployDetail, deployEvent);
                    this.sendDeployDetailMsg(String.format("\u5f02\u6784%s\u6570\u636e..", collectionName), deployDetail, deployEvent);
                    for (File dataFile : collectionDataFiles) {
                        if (".DS_Store".equals(dataFile.getName())) continue;
                        List datas = FileUtil.readLines((File)dataFile, (Charset)StandardCharsets.UTF_8);
                        for (String dataLine : datas) {
                            JSONObject applicationData;
                            deployProcess = (DeployProcess)this.cacheService.get(PARTITION, this.application, DeployProcess.class);
                            if (deployProcess != null) {
                                deployProcess.deployedNumIncrease();
                                deployProcess.setType("asa." + collectionName);
                            }
                            if ((applicationData = this.transferData(collectionName, dataLine)) == null) continue;
                            if (((List)DB_COLLECTION.get("datamap")).contains(collectionName)) {
                                analysedDatas.getJSONObject("datamap").getJSONArray(collectionName).add((Object)applicationData);
                                continue;
                            }
                            if (((List)DB_COLLECTION.get("preset")).contains(collectionName)) {
                                analysedDatas.getJSONObject("preset").getJSONArray(collectionName).add((Object)applicationData);
                                continue;
                            }
                            analysedDatas.getJSONObject(dbName).getJSONArray(collectionName).add((Object)applicationData);
                        }
                    }
                    this.sendDeployDetailResult("success", deployDetail, deployEvent);
                }
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("\u4ece\u6587\u4ef6\u4e2d\u89e3\u6790\u6570\u636e\u5931\u8d25:", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException("Deployment failed, please contact the developer", (Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
            try {
                FileUtil.del((File)compiledDataFilesDirectory.getParentFile());
            }
            catch (IORuntimeException iore) {
                log.error("Clean compile data file error.", (Throwable)iore);
            }
        }
        return analysedDatas;
    }

    private String getCypherNode(String cypherData) {
        Pattern patternNode = Pattern.compile("\\(node:([A-Za-z]+)");
        Matcher matcherNode = patternNode.matcher(cypherData);
        if (matcherNode.find()) {
            String node = matcherNode.group(1);
            return node;
        }
        return null;
    }

    private String getCypherSkillCode(String cypherData) {
        Pattern patternSkillCode = Pattern.compile("skillCode:'([A-Za-z0-9]+)'");
        Matcher matcherSkillCode = patternSkillCode.matcher(cypherData);
        if (matcherSkillCode.find()) {
            String skillCode = matcherSkillCode.group(1);
            return skillCode;
        }
        return null;
    }

    private JSONObject transferData(String collectionName, String dataLine) {
        if ("assistant".equals(collectionName)) {
            return this.transferAssistantData(dataLine);
        }
        if ("assistantScene".equals(collectionName)) {
            return this.transferAssistantSceneData(dataLine);
        }
        return JSON.parseObject((String)dataLine);
    }

    private JSONObject transferAssistantData(String dataLine) {
        JSONObject designerAssistantData = JSON.parseObject((String)dataLine);
        Integer appChannel = designerAssistantData.getInteger("appChannel");
        if (appChannel == null || appChannel == 0) {
            this.isCNaDeploy = true;
            appChannel = 0;
        }
        JSONObject assistant = new JSONObject();
        this.assistatnSubType = designerAssistantData.getInteger("appSubType");
        if (ASSISTANT_SUB_TYPE_KNOWLEDGE.equals(this.assistatnSubType)) {
            String knowledgeType = designerAssistantData.getString("knowledgeType");
            this.isSkipTemplate = true;
            this.isSkipGPT = true;
            assistant.put("knowledgeType", (Object)knowledgeType);
        }
        this.assistantCode = designerAssistantData.getString("code");
        this.assistantName = designerAssistantData.getString("name");
        if (this.isCNaDeploy) {
            this.assistantCode = this.assistantCode + "_beta";
        }
        String accId = this.imApiHelper.queryAccId(this.assistantCode, this.curTenantToken).getString("accid");
        assistant.put("assistantCode", (Object)this.assistantCode);
        assistant.put("name", (Object)designerAssistantData.getString("name"));
        assistant.put("description", (Object)designerAssistantData.getString("description"));
        assistant.put("sourceCustom", (Object)false);
        assistant.put("category", (Object)designerAssistantData.getString("category"));
        assistant.put("version", (Object)"1.0");
        assistant.put("status", (Object)1);
        assistant.put("lang", designerAssistantData.get((Object)"lang"));
        assistant.put("searchKeywords", designerAssistantData.get((Object)"searchKeywords"));
        assistant.put("assistantAvatar", (Object)designerAssistantData.getString("iconUrl"));
        assistant.put("avatarType", (Object)designerAssistantData.getString("iconType"));
        assistant.put("tenantId", (Object)this.currentTenantId);
        assistant.put("appointTenants", (Object)this.tenantIdList);
        assistant.put("clientType", (Object)designerAssistantData.getJSONArray("clientType"));
        assistant.put("assistantType", (Object)appChannel);
        assistant.put("assistantSubType", (Object)this.assistatnSubType);
        assistant.put("accid", (Object)accId);
        assistant.put("prologue", (Object)designerAssistantData.getString("prologue"));
        return assistant;
    }

    private JSONObject transferAssistantSceneData(String dataLine) {
        JSONObject assistantScene = new JSONObject();
        JSONObject designerAssistantSceneData = JSON.parseObject((String)dataLine);
        String assistantSceneCode = designerAssistantSceneData.getString("code");
        this.assistantSceneList.add(designerAssistantSceneData);
        assistantScene.put("assistantCode", (Object)this.assistantCode);
        assistantScene.put("code", (Object)assistantSceneCode);
        assistantScene.put("name", designerAssistantSceneData.get((Object)"name"));
        assistantScene.put("description", designerAssistantSceneData.get((Object)"description"));
        assistantScene.put("knowledgeBase", designerAssistantSceneData.get((Object)"knowledgeBase"));
        assistantScene.put("knowledgeBases", designerAssistantSceneData.get((Object)"knowledgeBases"));
        assistantScene.put("publicIdentity", designerAssistantSceneData.get((Object)"publicIdentity"));
        assistantScene.put("inspirationPhrase", designerAssistantSceneData.get((Object)"inspirationPhrase"));
        assistantScene.put("type", designerAssistantSceneData.get((Object)"type"));
        assistantScene.put("dataMetric", designerAssistantSceneData.get((Object)"dataMetric"));
        assistantScene.put("lang", designerAssistantSceneData.get((Object)"lang"));
        assistantScene.put("version", (Object)"1.0");
        if (Objects.nonNull(designerAssistantSceneData.get((Object)"sort"))) {
            assistantScene.put("sort", designerAssistantSceneData.get((Object)"sort"));
        }
        ArrayList<JSONObject> assistantSceneSteps = new ArrayList<JSONObject>();
        JSONArray assistantSceneElementMetadatas = new JSONArray();
        JSONArray desingerAssistantSceneSteps = designerAssistantSceneData.getJSONArray("itemSteps");
        if (desingerAssistantSceneSteps != null) {
            int order = 0;
            for (int i = 0; i < desingerAssistantSceneSteps.size(); ++i) {
                JSONObject assistantSceneStep = new JSONObject();
                JSONObject desingerAssistantSceneStep = desingerAssistantSceneSteps.getJSONObject(i);
                String abilityType = desingerAssistantSceneStep.getString("abilityType");
                JSONObject designerAssistantSceneStepConfig = desingerAssistantSceneStep.getJSONObject("config");
                if (null != designerAssistantSceneStepConfig) {
                    JSONArray elementMetadatas = designerAssistantSceneStepConfig.getJSONArray("element_metadata");
                    if (null != elementMetadatas) {
                        assistantSceneElementMetadatas.addAll((Collection)elementMetadatas);
                        designerAssistantSceneStepConfig.remove((Object)"element_metadata");
                    }
                    if (STEP_TYPE_END.equals(abilityType)) {
                        JSONObject endEvent = designerAssistantSceneStepConfig;
                        JSONObject assistantEvent = new JSONObject();
                        assistantEvent.put("endEvent", (Object)endEvent);
                        assistantScene.put("assistantEvent", (Object)assistantEvent);
                    }
                }
                if ("platform".equalsIgnoreCase(abilityType)) {
                    assistantSceneStep.put("assistantCode", (Object)this.assistantCode);
                    assistantSceneStep.put("assistantSceneCode", designerAssistantSceneData.get((Object)"code"));
                    assistantSceneStep.put("code", desingerAssistantSceneStep.get((Object)"code"));
                    assistantSceneStep.put("name", desingerAssistantSceneStep.get((Object)"name"));
                    assistantSceneStep.put("abilityType", (Object)abilityType);
                    assistantSceneStep.put("abilityCode", desingerAssistantSceneStep.get((Object)"abilityCode"));
                    assistantSceneStep.put("lang", desingerAssistantSceneStep.get((Object)"lang"));
                    assistantSceneStep.put("order", (Object)order);
                    assistantSceneStep.put("version", (Object)"1.0");
                    assistantSceneStep.put("config", (Object)designerAssistantSceneStepConfig);
                    assistantSceneSteps.add(assistantSceneStep);
                    ++order;
                    continue;
                }
                if ("private".equalsIgnoreCase(abilityType)) {
                    assistantSceneStep.put("assistantCode", (Object)this.assistantCode);
                    assistantSceneStep.put("assistantSceneCode", designerAssistantSceneData.get((Object)"code"));
                    assistantSceneStep.put("code", desingerAssistantSceneStep.get((Object)"code"));
                    assistantSceneStep.put("name", desingerAssistantSceneStep.get((Object)"name"));
                    assistantSceneStep.put("abilityType", (Object)abilityType);
                    assistantSceneStep.put("abilityCode", desingerAssistantSceneStep.get((Object)"abilityCode"));
                    assistantSceneStep.put("lang", desingerAssistantSceneStep.get((Object)"lang"));
                    assistantSceneStep.put("order", (Object)order);
                    assistantSceneStep.put("version", (Object)"1.0");
                    assistantSceneSteps.add(assistantSceneStep);
                    ++order;
                    continue;
                }
                if (!"privateInterface".equalsIgnoreCase(abilityType)) continue;
                assistantSceneStep.put("assistantCode", (Object)this.assistantCode);
                assistantSceneStep.put("assistantSceneCode", designerAssistantSceneData.get((Object)"code"));
                assistantSceneStep.put("code", desingerAssistantSceneStep.get((Object)"code"));
                assistantSceneStep.put("name", desingerAssistantSceneStep.get((Object)"name"));
                assistantSceneStep.put("abilityType", (Object)abilityType);
                assistantSceneStep.put("abilityCode", desingerAssistantSceneStep.get((Object)"abilityCode"));
                assistantSceneStep.put("lang", desingerAssistantSceneStep.get((Object)"lang"));
                assistantSceneStep.put("order", (Object)order);
                assistantSceneStep.put("version", (Object)"1.0");
                assistantSceneSteps.add(assistantSceneStep);
                ++order;
            }
        }
        assistantScene.put("element_metadata", (Object)assistantSceneElementMetadatas);
        assistantScene.put("assistantSceneItemStep", assistantSceneSteps);
        return assistantScene;
    }

    private void instantiateTemplateData(JSONObject analysedDatas) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u5b9e\u4f8b\u5316\u6a21\u677f\u6570\u636e..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            this.processKMDatas(analysedDatas);
            List assistantScenes = (List)analysedDatas.getJSONObject("asa").get((Object)"assistantScene");
            CustomConfigModel defConfigModel = new CustomConfigModel();
            defConfigModel.setAssistantCode(this.application);
            defConfigModel.setAssistantName(this.assistantName);
            defConfigModel.setVersion("1.0");
            for (JSONObject assistantScene : assistantScenes) {
                if (SceneType.KNOWLEDGE.getType().equals(assistantScene.getInteger("type")) || SceneType.DATA.getType().equals(assistantScene.getInteger("type"))) continue;
                List assistantSceneItemSteps = (List)assistantScene.get((Object)"assistantSceneItemStep");
                String assistantSceneCode = assistantScene.getString("code");
                this.sendDeployDetailMsg(String.format("\u5b9e\u4f8b\u5316\u573a\u666f%s\u7684\u6570\u636e..", assistantSceneCode), deployDetail, deployEvent);
                DeployProcess deployProcess = (DeployProcess)this.cacheService.get(PARTITION, this.application, DeployProcess.class);
                if (deployProcess != null) {
                    deployProcess.deployedNumIncrease();
                    deployProcess.setType("asa.assistantScene");
                }
                defConfigModel.setSceneCode(assistantSceneCode);
                defConfigModel.setSceneName(assistantScene.getString("name"));
                defConfigModel.setItemStepsLength(assistantSceneItemSteps.size());
                defConfigModel.setSceneLang(assistantScene.getJSONObject("lang"));
                defConfigModel.setTemplateType("ASSISTANT_SCENE_TEMPLATE");
                List templateDocs = this.processModel(defConfigModel, model -> ((ITemplate)this.templateMap.get("projectTemplate")).generate(model));
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("project").insertMany(templateDocs);
                templateDocs = this.processModel(defConfigModel, model -> ((ITemplate)this.templateMap.get("activityTemplate")).generate(model));
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("activity").insertMany(templateDocs);
                templateDocs = this.processModel(defConfigModel, model -> ((ITemplate)this.templateMap.get("dataDescriptionTemplate")).generate(model));
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("dataDescription").insertMany(templateDocs);
                templateDocs = this.processModel(defConfigModel, model -> ((ITemplate)this.templateMap.get("dataStateTemplate")).generate(model));
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("dataState").insertMany(templateDocs);
                templateDocs = this.processModel(defConfigModel, model -> ((ITemplate)this.templateMap.get("flowGraphTemplate")).generate(model));
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("flowGraph").insertMany(templateDocs);
                templateDocs = this.processModel(defConfigModel, model -> ((ITemplate)this.templateMap.get("taskTemplate")).generate(model));
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("task").insertMany(templateDocs);
                templateDocs = this.processModel(defConfigModel, model -> ((ITemplate)this.templateMap.get("appRelationTemplate")).generate(model));
                this.kgsysMongoTemplate.getMongoDbFactory().getDb(this.kgsysDBName).getCollection("applicationRelation").insertMany(templateDocs);
                for (JSONObject assistantSceneItemStep : assistantSceneItemSteps) {
                    JSONObject dataMapCollectionDatas;
                    String itemStepCode = assistantSceneItemStep.getString("code");
                    int itemStepNum = assistantSceneItemStep.getIntValue("order");
                    String abilityType = assistantSceneItemStep.getString("abilityType");
                    String abilityCode = assistantSceneItemStep.getString("abilityCode");
                    defConfigModel.setItemStepCode(itemStepCode);
                    defConfigModel.setItemStepName(assistantSceneItemStep.getString("name"));
                    defConfigModel.setItemStepNum(itemStepNum);
                    defConfigModel.setItemStepLang(assistantSceneItemStep.getJSONObject("lang"));
                    defConfigModel.setAbilityCode(abilityCode);
                    defConfigModel.setAbilityType(abilityType);
                    defConfigModel.setAssistantSceneItemStep(assistantSceneItemStep);
                    if ("platform".equalsIgnoreCase(abilityType)) {
                        AbilityEnum abilityEnum = AbilityEnum.getAbilityByCode((String)abilityCode);
                        if (null != abilityEnum) {
                            defConfigModel.setTemplateType(abilityEnum.getTemplateType());
                            for (String key : this.templateMap.keySet()) {
                                ITemplate iTemplate = (ITemplate)this.templateMap.get(key);
                                iTemplate.fillCustomConfigModel(defConfigModel, assistantSceneItemStep);
                                templateDocs = this.processModel(defConfigModel, model -> iTemplate.generate(model));
                                this.mongoInsertMany(iTemplate.getCollectName(), templateDocs);
                            }
                            if (abilityCode.equals(AbilityEnum.FORMTASK.getAbilityCode())) {
                                JSONObject config = assistantSceneItemStep.getJSONObject("config");
                                String taskCode = config.getString("taskCode");
                                JSONObject dataMapCollectionDatas2 = analysedDatas.getJSONObject("datamap");
                                JSONObject presetCollectionDatas = analysedDatas.getJSONObject("preset");
                                List ruleList = this.getAnalysedDataClone(presetCollectionDatas, "rules");
                                ArrayList<JSONObject> newRules = new ArrayList<JSONObject>();
                                for (JSONObject rule : ruleList) {
                                    if (!taskCode.equals(rule.getString("domainId"))) continue;
                                    newRules.add(rule);
                                }
                                List pageUIElementList = this.getAnalysedDataClone(dataMapCollectionDatas2, "pageUIElement");
                                ArrayList<JSONObject> newPageUIElements = new ArrayList<JSONObject>();
                                for (JSONObject pageUIElement : pageUIElementList) {
                                    if (!taskCode.equals(pageUIElement.getString("code"))) continue;
                                    newPageUIElements.add(pageUIElement);
                                }
                                List pageViewList = this.getAnalysedDataClone(dataMapCollectionDatas2, "pageView");
                                ArrayList<JSONObject> newPageViewList = new ArrayList<JSONObject>();
                                for (JSONObject pageView : pageViewList) {
                                    if (!taskCode.equals(pageView.getString("code"))) continue;
                                    newPageViewList.add(pageView);
                                }
                                this.processGeneralFormPageUIElement(newPageUIElements, itemStepCode);
                                this.processGeneralFormRules(newRules, itemStepCode);
                                this.processGeneralFormPageView(newPageViewList, itemStepCode);
                            }
                        }
                    } else if ("private".equalsIgnoreCase(abilityType)) {
                        dataMapCollectionDatas = analysedDatas.getJSONObject("datamap");
                        this.customSkill(dataMapCollectionDatas, assistantSceneCode, itemStepCode, abilityCode, itemStepNum, defConfigModel);
                        JSONObject kmDatas = analysedDatas.getJSONObject("knowledgegraphSystem");
                        this.processPrivateDataActivityConfig(kmDatas, this.application, itemStepCode, abilityCode);
                    } else if ("privateInterface".equalsIgnoreCase(abilityType)) {
                        dataMapCollectionDatas = analysedDatas.getJSONObject("datamap");
                        JSONObject presetCollectionDatas = analysedDatas.getJSONObject("preset");
                        this.customSkill(dataMapCollectionDatas, assistantSceneCode, itemStepCode, abilityCode, itemStepNum, defConfigModel);
                        JSONObject kmDatas = analysedDatas.getJSONObject("knowledgegraphSystem");
                        this.processPrivateDataActivityConfig(kmDatas, this.application, itemStepCode, abilityCode);
                        this.processPrivateInterfaceTaskRule(presetCollectionDatas, this.application, itemStepCode, abilityCode);
                        this.processPrivateInterfaceTaskPageUIElement(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
                    }
                    this.processNeo4jData(analysedDatas, abilityCode);
                }
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("\u5b9e\u4f8b\u5316\u6a21\u677f\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException("Deployment failed, please contact the developer", (Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void processGeneralFormPageUIElement(List<JSONObject> pageUIElements, String itemStepCode) {
        if (null != pageUIElements && !pageUIElements.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject pageUIElement : pageUIElements) {
                String taskCode = itemStepCode + "_GeneralForm_Filling";
                pageUIElement.put("code", (Object)taskCode);
                pageUIElement.put("activityId", (Object)taskCode);
                pageUIElement.put("pageCode", (Object)"task-card");
                Document doc = this.processPrivateModel(pageUIElement, this.assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("pageUIElement").insertMany(insertDocs);
            }
        }
    }

    private void processGeneralFormPageView(List<JSONObject> pageViewList, String itemStepCode) {
        if (null != pageViewList && !pageViewList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject pageView : pageViewList) {
                pageView.put("code", (Object)(itemStepCode + "_GeneralForm_Filling"));
                Document doc = this.processPrivateModel(pageView, this.assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("pageView").insertMany(insertDocs);
            }
        }
    }

    private void processGeneralFormRules(List<JSONObject> rules, String itemStepCode) {
        if (null != rules && !rules.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject rule : rules) {
                String taskCode = itemStepCode + "_GeneralForm_Filling";
                rule.put("domainId", (Object)taskCode);
                rule.put("taskCode", (Object)taskCode);
                rule.put("key", (Object)(rule.getString("key") + "_" + IdSnowflake.snowflakeIdStr()));
                Document doc = this.processPrivateModel(rule, this.assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.presetMongoTemplate.getMongoDbFactory().getDb(this.presetDBName).getCollection("rules").insertMany(insertDocs);
            }
        }
    }

    private void customSkill(JSONObject dataMapCollectionDatas, String assistantSceneCode, String itemStepCode, String abilityCode, int itemStepNum, CustomConfigModel defConfigModel) {
        this.processPrivateActivity(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateDataState(dataMapCollectionDatas, this.application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode);
        this.processPrivateDataDescription(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateDataFeatureSet(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateFlowGraph(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivatePageView(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateTask(dataMapCollectionDatas, this.application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode, defConfigModel);
    }

    private void kmCustomSkill(JSONObject dataMapCollectionDatas, String assistantSceneCode, String itemStepCode, String abilityCode, int itemStepNum, CustomConfigModel defConfigModel) {
        this.processPrivateActivity(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateDataState(dataMapCollectionDatas, this.application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode);
        this.processPrivateDataDescription(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateDataFeatureSet(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateFlowGraph(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivatePageView(dataMapCollectionDatas, this.application, itemStepCode, abilityCode);
        this.processPrivateTask(dataMapCollectionDatas, this.application, assistantSceneCode, itemStepCode, itemStepNum, abilityCode, defConfigModel);
    }

    private void processPrivateActivity(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List activityList = this.getAnalysedDataClone(analysedDatas, "activity");
        if (null != activityList && !activityList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject activity : activityList) {
                String activitySkillCode = activity.getString("skillCode");
                if (!skillCode.equals(activitySkillCode)) continue;
                String activityCode = activity.getString("code");
                activity.put("code", (Object)(itemStepCode + activityCode));
                List events = (List)activity.getObject("events", List.class);
                if (null != events) {
                    for (JSONObject event : events) {
                        String flowCode = event.getString("flowCode");
                        if (StringUtils.isEmpty((CharSequence)flowCode)) continue;
                        event.put("flowCode", (Object)(itemStepCode + flowCode));
                    }
                }
                Document doc = this.processPrivateModel(activity, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("activity").insertMany(insertDocs);
            }
        }
    }

    public List<JSONObject> getAnalysedDataClone(JSONObject analysedDatas, String key) {
        List analysedDataList = (List)analysedDatas.get((Object)key);
        return (List)JSON.parseObject((String)JSON.toJSONString((Object)analysedDataList), List.class);
    }

    private void processPrivateDataState(JSONObject analysedDatas, String assistantCode, String sceneCode, String itemStepCode, int itemStepNum, String skillCode) {
        List dataStateList = this.getAnalysedDataClone(analysedDatas, "dataState");
        if (null != dataStateList && !dataStateList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject dataState : dataStateList) {
                String dataStateSkillCode = dataState.getString("skillCode");
                if (!skillCode.equals(dataStateSkillCode)) continue;
                String dataStateCode = dataState.getString("code");
                if (dataStateCode.equals(skillCode + "_start")) {
                    dataState.put("code", (Object)(sceneCode + "_" + itemStepNum));
                } else {
                    dataState.put("code", (Object)(itemStepCode + dataStateCode));
                }
                String dataCode = dataState.getString("dataCode");
                if (!StringUtils.isEmpty((CharSequence)dataCode)) {
                    dataState.put("dataCode", (Object)(itemStepCode + dataCode));
                }
                Document doc = this.processPrivateModel(dataState, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("dataState").insertMany(insertDocs);
            }
        }
    }

    private void processPrivateDataDescription(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List dataDescriptionList = this.getAnalysedDataClone(analysedDatas, "dataDescription");
        if (null != dataDescriptionList && !dataDescriptionList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject dataDescription : dataDescriptionList) {
                String dataDescriptionSkillCode = dataDescription.getString("skillCode");
                if (!skillCode.equals(dataDescriptionSkillCode)) continue;
                String dataDescriptionCode = dataDescription.getString("code");
                dataDescription.put("code", (Object)(itemStepCode + dataDescriptionCode));
                Document doc = this.processPrivateModel(dataDescription, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("dataDescription").insertMany(insertDocs);
            }
        }
    }

    private void processPrivateDataActivityConfig(JSONObject kmDatas, String assistantCode, String itemStepCode, String skillCode) {
        List activityConfigList = this.getAnalysedDataClone(kmDatas, "activityConfigs");
        if (null != activityConfigList && !activityConfigList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject activityConfig : activityConfigList) {
                String activityConfigSkillCode = activityConfig.getString("skillCode");
                if (!skillCode.equals(activityConfigSkillCode)) continue;
                String activityConfigCode = activityConfig.getString("code");
                activityConfig.put("code", (Object)(itemStepCode + activityConfigCode));
                JSONObject dataSources = activityConfig.getJSONObject("dataSources");
                if (null != dataSources) {
                    for (String dataSourceName : dataSources.keySet()) {
                        JSONObject dataSource = dataSources.getJSONObject(dataSourceName);
                        String viewCode = dataSource.getString("viewCode");
                        dataSource.put("viewCode", (Object)(itemStepCode + viewCode));
                        dataSource.getJSONObject("dataViewQuery").put("code", (Object)(itemStepCode + viewCode));
                    }
                    Document doc = this.processPrivateModel(activityConfig, assistantCode);
                    insertDocs.add(doc);
                }
                this.getDataRelaItemStep("activityConfigs", activityConfigCode, itemStepCode);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.kgsysDBName).getCollection("activityConfigs").insertMany(insertDocs);
            }
        }
    }

    private void getDataRelaItemStep(String dataType, String dataCode, String itemStepCode) {
        List<String> activityConfigsRelaItemStepCodes;
        JSONObject activityConfigsRelation;
        if (this.originalCodeRelationShip.get((Object)dataType) == null) {
            activityConfigsRelation = new JSONObject();
            this.originalCodeRelationShip.put("activityConfigs", (Object)activityConfigsRelation);
        }
        if ((activityConfigsRelation = this.originalCodeRelationShip.getJSONObject("activityConfigs")).get((Object)dataCode) == null) {
            activityConfigsRelaItemStepCodes = new ArrayList();
            activityConfigsRelation.put(dataCode, activityConfigsRelaItemStepCodes);
        }
        activityConfigsRelaItemStepCodes = (List)activityConfigsRelation.get((Object)dataCode);
        activityConfigsRelaItemStepCodes.add(itemStepCode);
    }

    private void processPrivateDataFeatureSet(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List dataFeatureSetList = this.getAnalysedDataClone(analysedDatas, "dataFeatureSet");
        if (null != dataFeatureSetList && !dataFeatureSetList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject dataFeatureSet : dataFeatureSetList) {
                String dataFeatureSetSkillCode = dataFeatureSet.getString("skillCode");
                if (!skillCode.equals(dataFeatureSetSkillCode)) continue;
                String dataFeatureSetCode = dataFeatureSet.getString("code");
                dataFeatureSet.put("code", (Object)(itemStepCode + dataFeatureSetCode));
                String dataCode = dataFeatureSet.getString("dataCode");
                if (!StringUtils.isEmpty((CharSequence)dataCode)) {
                    dataFeatureSet.put("dataCode", (Object)(itemStepCode + dataCode));
                }
                Document doc = this.processPrivateModel(dataFeatureSet, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("dataFeatureSet").insertMany(insertDocs);
            }
        }
    }

    private void processPrivateFlowGraph(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List flowGraphList = this.getAnalysedDataClone(analysedDatas, "flowGraph");
        if (null != flowGraphList && !flowGraphList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject flowGraph : flowGraphList) {
                String flowGraphSkillCode = flowGraph.getString("skillCode");
                if (!skillCode.equals(flowGraphSkillCode)) continue;
                String flowGraphCode = flowGraph.getString("code");
                flowGraph.put("code", (Object)(itemStepCode + flowGraphCode));
                List nodes = (List)flowGraph.getObject("nodes", List.class);
                if (null != nodes) {
                    for (Map node : nodes) {
                        if (!"activity".equals(node.get("type"))) continue;
                        String activityCode = (String)node.get("activityCode");
                        node.put("activityCode", itemStepCode + activityCode);
                    }
                }
                Document doc = this.processPrivateModel(flowGraph, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("flowGraph").insertMany(insertDocs);
            }
        }
    }

    private void processPrivatePageView(JSONObject analysedDatas, String assistantCode, String itemStepCode, String skillCode) {
        List pageViewList = this.getAnalysedDataClone(analysedDatas, "pageView");
        if (null != pageViewList && !pageViewList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject pageView : pageViewList) {
                String pageViewSkillCode = pageView.getString("skillCode");
                if (!skillCode.equals(pageViewSkillCode)) continue;
                String pageViewCode = pageView.getString("code");
                pageView.put("code", (Object)(itemStepCode + pageViewCode));
                String pageViewString = pageView.toJSONString().replaceAll("\\bSP_[a-zA-Z0-9_]+", itemStepCode + "$0");
                Document doc = this.processPrivateModel(pageViewString, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("pageView").insertMany(insertDocs);
            }
        }
    }

    private void processPrivateInterfaceTaskPageUIElement(JSONObject dataMapCollectionDatas, String assistantCode, String itemStepCode, String abilityCode) {
        List pageUIElementList = this.getAnalysedDataClone(dataMapCollectionDatas, "pageUIElement");
        if (null != pageUIElementList && !pageUIElementList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject pageUIElement : pageUIElementList) {
                if (!abilityCode.equals(pageUIElement.getString("skillCode"))) continue;
                String taskCode = itemStepCode + pageUIElement.getString("code");
                String activityId = itemStepCode + pageUIElement.getString("activityId");
                pageUIElement.put("code", (Object)taskCode);
                pageUIElement.put("activityId", (Object)activityId);
                pageUIElement.put("version", (Object)"1.0");
                Document doc = this.processPrivateModel(pageUIElement, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("pageUIElement").insertMany(insertDocs);
            }
        }
    }

    private void processPrivateInterfaceTaskRule(JSONObject dataMapCollectionDatas, String assistantCode, String itemStepCode, String abilityCode) {
        List ruleList = this.getAnalysedDataClone(dataMapCollectionDatas, "rules");
        if (null != ruleList && !ruleList.isEmpty()) {
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject rule2 : ruleList) {
                if (!abilityCode.equals(rule2.getString("skillCode"))) continue;
                String taskCode = itemStepCode + rule2.getString("taskCode");
                rule2.put("domainId", (Object)taskCode);
                rule2.put("taskCode", (Object)taskCode);
                rule2.put("key", (Object)(rule2.getString("key") + "_" + IdSnowflake.snowflakeIdStr()));
                rule2.put("version", (Object)"1.0");
                Document doc = this.processPrivateModel(rule2, assistantCode);
                insertDocs.add(doc);
            }
            if (!insertDocs.isEmpty()) {
                List rules = insertDocs.stream().filter(rule -> rule.getString((Object)"tenantId").equals("SYSTEM")).collect(Collectors.toList());
                List tenantRules = insertDocs.stream().filter(rule -> !rule.getString((Object)"tenantId").equals("SYSTEM")).collect(Collectors.toList());
                if (!rules.isEmpty()) {
                    this.presetMongoTemplate.getMongoDbFactory().getDb(this.presetDBName).getCollection("rules").insertMany(rules);
                }
                if (!tenantRules.isEmpty()) {
                    this.presetMongoTemplate.getMongoDbFactory().getDb(this.presetDBName).getCollection("tenantRules").insertMany(rules);
                }
            }
        }
    }

    private void processPrivateTask(JSONObject analysedDatas, String assistantCode, String sceneCode, String itemStepCode, int itemStepNum, String skillCode, CustomConfigModel defConfigModel) {
        List taskList = this.getAnalysedDataClone(analysedDatas, "task");
        if (null != taskList && !taskList.isEmpty()) {
            ArrayList<Document> taskDocs = new ArrayList<Document>();
            for (JSONObject task : taskList) {
                List dataFeatureList;
                List stateMapList;
                List toList;
                Object from2;
                String taskSkillCode = task.getString("skillCode");
                task.put("daemon", (Object)true);
                if (!skillCode.equals(taskSkillCode)) continue;
                String taskCode = task.getString("code");
                task.put("code", (Object)(itemStepCode + taskCode));
                String flowCode = task.getString("flowCode");
                task.put("flowCode", (Object)(itemStepCode + flowCode));
                String pageCode = task.getString("pageCode");
                task.put("pageCode", (Object)(itemStepCode + pageCode));
                List fromList = (List)task.getObject("from", List.class);
                if (null != fromList) {
                    ArrayList<String> newFromList = new ArrayList<String>();
                    for (Object from2 : fromList) {
                        if (((String)from2).equals(skillCode + "_start")) {
                            newFromList.add(sceneCode + "_" + itemStepNum);
                            continue;
                        }
                        newFromList.add(itemStepCode + from2);
                    }
                    task.put("from", newFromList);
                }
                if (null != (toList = (List)task.getObject("to", List.class))) {
                    ArrayList<String> newToList = new ArrayList<String>();
                    from2 = toList.iterator();
                    while (from2.hasNext()) {
                        String to = (String)from2.next();
                        if (to.equals(skillCode + "_end")) {
                            newToList.add(sceneCode.concat("_").concat(String.valueOf(itemStepNum + 1)));
                            continue;
                        }
                        newToList.add(itemStepCode + to);
                    }
                    task.put("to", newToList);
                }
                if (null != (stateMapList = (List)task.getObject("stateMaps", List.class))) {
                    from2 = stateMapList.iterator();
                    while (from2.hasNext()) {
                        JSONObject output;
                        JSONObject stateMap = (JSONObject)from2.next();
                        String input = stateMap.getString("input");
                        if (!StringUtils.isEmpty((CharSequence)input)) {
                            if (input.equals(skillCode + "_start")) {
                                stateMap.put("input", (Object)(sceneCode + "_" + itemStepNum));
                            } else {
                                stateMap.put("input", (Object)(itemStepCode + input));
                            }
                        }
                        if (null == (output = stateMap.getJSONObject("output"))) continue;
                        for (String outputKey : output.keySet()) {
                            String outputValue = output.getString(outputKey);
                            if (outputValue.equals(skillCode + "_end")) {
                                output.put(outputKey, (Object)sceneCode.concat("_").concat(String.valueOf(itemStepNum + 1)));
                                continue;
                            }
                            output.put(outputKey, (Object)(itemStepCode + outputValue));
                        }
                    }
                }
                if (null != (dataFeatureList = (List)task.getObject("dataFeatures", List.class))) {
                    for (JSONObject dataFeature : dataFeatureList) {
                        String dataFeaturesCode = dataFeature.getString("code");
                        dataFeature.put("code", (Object)(itemStepCode + dataFeaturesCode));
                    }
                }
                ArrayList<JSONObject> atmcDataList = (ArrayList<JSONObject>)task.getObject("atmcDatas", List.class);
                JSONObject sourceTypeData = new JSONObject();
                sourceTypeData.put("proVarKey", (Object)"sourceType");
                sourceTypeData.put("athenaKey", (Object)"sourceType");
                if (null == atmcDataList) {
                    atmcDataList = new ArrayList<JSONObject>();
                }
                atmcDataList.add(sourceTypeData);
                task.put("atmcDatas", atmcDataList);
                JSONObject config = task.getJSONObject("config");
                if (Objects.isNull(config)) {
                    config = new JSONObject();
                }
                config.put("asaAbilityCode", (Object)defConfigModel.getAbilityCode());
                config.put("asaAbilityType", (Object)defConfigModel.getAbilityType());
                config.put("asaSceneItemStepCode", (Object)defConfigModel.getItemStepCode());
                task.put("config", (Object)config);
                Document doc = this.processPrivateModel(task, assistantCode);
                taskDocs.add(doc);
            }
            if (!taskDocs.isEmpty()) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection("task").insertMany(taskDocs);
            }
        }
    }

    private void processKMDatas(JSONObject analysedDatas) {
        JSONObject kmDatas = analysedDatas.getJSONObject("knowledgegraphSystem");
        for (String kmCollectionName : kmDatas.keySet()) {
            List collectionDatas;
            if (kmCollectionName.equals("activityConfigs") || null == (collectionDatas = (List)kmDatas.get((Object)kmCollectionName)) || collectionDatas.isEmpty()) continue;
            ArrayList<Document> insertDocs = new ArrayList<Document>();
            for (JSONObject appRelation : collectionDatas) {
                Document doc = Document.parse((String)appRelation.toJSONString());
                doc.put("version", (Object)"1.0");
                doc.put("application", (Object)this.application);
                insertDocs.add(doc);
            }
            if (insertDocs.isEmpty()) continue;
            this.kgsysMongoTemplate.getMongoDbFactory().getDb(this.kgsysDBName).getCollection(kmCollectionName).insertMany(insertDocs);
        }
    }

    private Document processPrivateModel(String dataString, String assistantCode) {
        Document doc = Document.parse((String)dataString);
        doc.remove((Object)"_id");
        doc.put("application", (Object)assistantCode);
        doc.put("groupCode", (Object)assistantCode);
        doc.put("version", (Object)"1.0");
        doc.put("athena_namespace", (Object)assistantCode);
        doc.put("tenantId", (Object)"SYSTEM");
        return doc;
    }

    private Document processPrivateModel(JSONObject privateData, String assistantCode) {
        Document doc = Document.parse((String)privateData.toJSONString());
        doc.remove((Object)"_id");
        doc.put("application", (Object)assistantCode);
        doc.put("groupCode", (Object)assistantCode);
        doc.put("version", (Object)"1.0");
        doc.put("athena_namespace", (Object)assistantCode);
        doc.put("tenantId", (Object)"SYSTEM");
        return doc;
    }

    private <T> List<Document> processModel(CustomConfigModel defConfigModel, IGenerateModel<T> generateModel) {
        ArrayList<Document> modelDocs = new ArrayList<Document>();
        List models = generateModel.generate(defConfigModel);
        for (Object model : models) {
            if (model instanceof CollectionModel) {
                CollectionModel collectionModel = (CollectionModel)model;
                List collections = collectionModel.getCollection();
                CollUtil.emptyIfNull((List)collections).forEach(collection -> {
                    Document modelDocument = this.createDocument(JSON.toJSONString((Object)collection), defConfigModel);
                    modelDocs.add(modelDocument);
                });
                continue;
            }
            Document modelDocument = this.createDocument(JSON.toJSONString(model), defConfigModel);
            modelDocs.add(modelDocument);
        }
        return modelDocs;
    }

    private Document createDocument(String jsonString, CustomConfigModel defConfigModel) {
        Document doc = Document.parse((String)jsonString);
        doc.remove((Object)"_id");
        doc.put("application", (Object)defConfigModel.getAssistantCode());
        doc.put("version", (Object)defConfigModel.getVersion());
        doc.put("athena_namespace", (Object)defConfigModel.getAssistantCode());
        return doc;
    }

    private void processNeo4jData(JSONObject analysedDatas, String skillCode) {
        JSONObject cypherData;
        JSONObject cypher = analysedDatas.getJSONObject(FILE_FOLDER_CYPHER);
        if (cypher != null && (cypherData = cypher).get((Object)skillCode) != null) {
            JSONObject skillCypherData = cypherData.getJSONObject(skillCode);
            this.pageService.pagePublish2KM(skillCypherData, this.originalCodeRelationShip, "1.0");
        }
    }

    private void cleanMongoData() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u6e05\u7406\u65e71.0\u7248\u672c\u7684\u6570\u636e..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            Bson assistantFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.assistantCode), Filters.eq((String)"version", (Object)"1.0")});
            for (Object collectionName : (List)DB_COLLECTION.get("asa")) {
                this.mongoTemplate.getMongoDbFactory().getDb("asa").getCollection((String)collectionName).deleteMany(assistantFilter);
            }
            Bson templateFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)this.application), Filters.eq((String)"version", (Object)"1.0")});
            for (Object collectionName : (List)DB_COLLECTION.get("datamap")) {
                this.kmMongoTemplate.getMongoDbFactory().getDb(this.datamapDBName).getCollection((String)collectionName).deleteMany(templateFilter);
            }
            Bson kmAppFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)this.application), Filters.eq((String)"version", (Object)"1.0")});
            for (Object collectionName : (List)DB_COLLECTION.get("knowledgegraphSystem")) {
                this.kgsysMongoTemplate.getMongoDbFactory().getDb(this.kgsysDBName).getCollection((String)collectionName).deleteMany(kmAppFilter);
            }
            Bson presetAppFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)this.application), Filters.eq((String)"version", (Object)"1.0")});
            for (String collectionName : (List)DB_COLLECTION.get("preset")) {
                this.presetMongoTemplate.getMongoDbFactory().getDb(this.presetDBName).getCollection(collectionName).deleteMany(presetAppFilter);
            }
            this.pageService.cleanPageDataFromKM(this.application, "1.0");
            try {
                ArrayList cleanDocList = new ArrayList();
                Bson kmAppCleanFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"code", (Object)this.application)});
                FindIterable applicationDocs = this.kgsysMongoTemplate.getMongoDbFactory().getDb(this.kgsysDBName).getCollection("application").find(kmAppCleanFilter);
                applicationDocs.forEach(doc -> {
                    if (StringUtils.isEmpty((CharSequence)doc.getString((Object)"version"))) {
                        cleanDocList.add((ObjectId)doc.get((Object)"_id"));
                    }
                });
                if (!cleanDocList.isEmpty()) {
                    Bson cleanFilter = Filters.and((Bson[])new Bson[]{Filters.in((String)"_id", (Object[])cleanDocList.toArray())});
                    this.kmMongoTemplate.getMongoDbFactory().getDb(this.kgsysDBName).getCollection("application").deleteMany(cleanFilter);
                }
            }
            catch (Exception ex) {
                log.error("clean redundancy data error.", (Throwable)ex);
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Clean version 1.0 data error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void putData2Mongo(JSONObject analysedDatas, String env) {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u5e94\u7528\u6570\u636e\u5165\u5e93..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            List assistantDataList = (List)analysedDatas.getJSONObject("asa").get((Object)"assistant");
            for (JSONObject assistantData : assistantDataList) {
                Document assistantDoc = Document.parse((String)assistantData.toJSONString());
                this.mongoTemplate.getMongoDbFactory().getDb("asa").getCollection("assistant").insertOne((Object)assistantDoc);
            }
            List assistantScenes = (List)analysedDatas.getJSONObject("asa").get((Object)"assistantScene");
            for (JSONObject assistantScene : assistantScenes) {
                String assistantCode = assistantScene.getString("assistantCode");
                List assistantCode1 = assistantDataList.stream().filter(item -> Objects.equals(assistantCode, item.getString("assistantCode"))).collect(Collectors.toList());
                Integer assistantSubType = ((JSONObject)assistantCode1.get(0)).getInteger("assistantSubType");
                String knowledgeType = ((JSONObject)assistantCode1.get(0)).getString("knowledgeType");
                if (Objects.equals(2, assistantSubType) && "public".equals(knowledgeType) || Objects.equals(2, assistantSubType) && Objects.equals("public", Objects.isNull(assistantScene.get((Object)"knowledgeBases")) ? "private" : ((JSONObject)((List)assistantScene.get((Object)"knowledgeBases")).get(0)).getString("type")) || Objects.equals(4, assistantSubType) && Objects.equals(2, assistantScene.getInteger("type")) && Objects.equals("public", Objects.isNull(assistantScene.get((Object)"knowledgeBases")) ? "private" : ((JSONObject)((List)assistantScene.get((Object)"knowledgeBases")).get(0)).getString("type"))) {
                    List knowledgeBases = (List)assistantScene.get((Object)"knowledgeBases");
                    if (CollectionUtils.isEmpty((Collection)knowledgeBases)) {
                        log.error("\u7b26\u5408\u53d1\u5e03\u73af\u5883\u7684\u77e5\u8bc6\u5e93\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
                        deployDetail.setResult("fail");
                        throw new BusinessException("\u7b26\u5408\u53d1\u5e03\u73af\u5883\u7684\u77e5\u8bc6\u5e93\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
                    }
                    List knowledgeBasesAccordingEnv = knowledgeBases.stream().filter(item -> env.equals(item.getString("env"))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(knowledgeBasesAccordingEnv)) {
                        log.error("\u7b26\u5408\u53d1\u5e03\u73af\u5883\u7684\u77e5\u8bc6\u5e93\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
                        deployDetail.setResult("fail");
                        throw new BusinessException("\u7b26\u5408\u53d1\u5e03\u73af\u5883\u7684\u77e5\u8bc6\u5e93\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
                    }
                    JSONObject jsonObject = (JSONObject)knowledgeBasesAccordingEnv.get(0);
                    assistantScene.remove((Object)"knowledgeBase");
                    assistantScene.remove((Object)"publicIdentity");
                    JSONObject knowledgeBaseForAsa = new JSONObject();
                    knowledgeBaseForAsa.fluentPut("historyNum", (Object)jsonObject.getInteger("historyNum"));
                    knowledgeBaseForAsa.fluentPut("type", (Object)jsonObject.getString("type"));
                    knowledgeBaseForAsa.fluentPut("assistantCode", (Object)jsonObject.getString("assistantCode"));
                    knowledgeBaseForAsa.fluentPut("defaultKBS", (Object)(Objects.isNull(jsonObject.getBooleanValue("defaultKBS")) ? false : jsonObject.getBooleanValue("defaultKBS")));
                    assistantScene.fluentPut("knowledgeBase", (Object)knowledgeBaseForAsa);
                    JSONObject publicIdentityForAsa = new JSONObject();
                    publicIdentityForAsa.fluentPut("tenantId", (Object)jsonObject.getString("tenantId"));
                    assistantScene.fluentPut("publicIdentity", (Object)publicIdentityForAsa);
                    assistantScene.remove((Object)"knowledgeBases");
                }
                List assistantSceneItemSteps = (List)assistantScene.get((Object)"assistantSceneItemStep");
                assistantScene.remove((Object)"assistantSceneItemStep");
                Document assistantSceneDoc = Document.parse((String)assistantScene.toJSONString());
                this.mongoTemplate.getMongoDbFactory().getDb("asa").getCollection("assistantScene").insertOne((Object)assistantSceneDoc);
                for (JSONObject assistantSceneItemStep : assistantSceneItemSteps) {
                    Document assistantSceneItemStepDoc = Document.parse((String)assistantSceneItemStep.toJSONString());
                    this.mongoTemplate.getMongoDbFactory().getDb("asa").getCollection("assistantSceneItemStep").insertOne((Object)assistantSceneItemStepDoc);
                }
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Put deploy data to db error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void downloadFileFromDmc(String shareUrl, File destFile) {
        InputStream inputStream = this.dmcService.downloadByUrl(shareUrl);
        FileUtil.writeFromStream((InputStream)inputStream, (File)destFile);
    }

    protected void doAfterDataProcess() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u5904\u7406\u5173\u7cfb\u6570\u636e..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            this.appEntityService.initAppEntityVersion(this.application, "1.0");
            if (!this.isCNaDeploy) {
                this.switchVersion();
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Do after deploy error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void switchVersion() {
        Map deployTenantVersion = this.tenantService.getTenantVersion(this.tenantIdList);
        this.tenantService.createTenants(this.tenantIdList, "1.0");
        List authAppTenantIdList = this.tenantService.getAuthAppTenantIdList(this.application, "1.0", this.tenantIdList);
        this.tenantService.updateTenantVersion(this.tenantIdList, this.application, "1.0");
        this.tenantService.createRelation(this.application, "1.0", "1.0", authAppTenantIdList);
        ArrayList<String> vChangeTenantIdList = new ArrayList<String>();
        for (String tenantId : this.tenantIdList) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)deployTenantVersion.get(tenantId))) || "1.0".equals(deployTenantVersion.get(tenantId))) continue;
            vChangeTenantIdList.add(tenantId);
            Set appCodeList = this.tenantService.getNotCommonAppCodeRelaToTenantId(tenantId);
            appCodeList.remove(this.application);
            this.tenantService.createOneTenantAndMoreAppRelation(appCodeList, "1.0", "1.0", tenantId);
        }
        if (!vChangeTenantIdList.isEmpty()) {
            this.tenantService.modifyTenantRelaWithNotMatchAppDataInPublish("1.0", "2.0", vChangeTenantIdList);
        }
    }

    protected void doProcess4ProdAndAuth() {
        if (!this.isCNaDeploy) {
            super.iamAuthorizationInSwitch((DeployParam)this.deployVersionParam);
        }
    }

    private void deployllm(String projectCode, String llmPromptId, String deployMode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("project_name", projectCode);
        map.put("mode", "intent");
        this.assistantRhApiHelper.llmDeployer(map, llmPromptId, deployMode, this.curTenantToken);
    }

    private List<Map> constructRh(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            return map;
        }).collect(Collectors.toList());
    }

    private String addLlmPrompt(List<JSONObject> projectDataList, DeployVersionParam deployVersionParam, List<JSONObject> modelDataList, List<JSONObject> utterancesDataList) {
        Document assistantProject = null;
        for (JSONObject projectData : projectDataList) {
            Document projectDoc = Document.parse((String)projectData.toJSONString());
            if (!projectDoc.getString((Object)"projectCode").equals(deployVersionParam.getModelInfo().getString("projectCode"))) continue;
            assistantProject = projectDoc;
            break;
        }
        if (assistantProject == null) {
            throw new BusinessException("\u521b\u5efa\u63d0\u793a\u8bcd\u5931\u8d25");
        }
        BasicInfoDto basicInfoDto = new BasicInfoDto();
        basicInfoDto.setNickname(assistantProject.getList((Object)"nickname", String.class));
        basicInfoDto.setProject_name(assistantProject.getString((Object)"projectCode"));
        basicInfoDto.setAssistant_id(assistantProject.getString((Object)"assistantCode"));
        Document assistantProjectModel = null;
        for (JSONObject modelData : modelDataList) {
            Document modelDoc = Document.parse((String)modelData.toJSONString());
            if (!modelDoc.getString((Object)"modelCode").equals(deployVersionParam.getModelInfo().getString("modelCode"))) continue;
            assistantProjectModel = modelDoc;
            break;
        }
        AssistantProjectModel assistantProjectModel1 = (AssistantProjectModel)JSON.parseObject((String)JSON.toJSONString(assistantProjectModel), AssistantProjectModel.class);
        List intent_definition = assistantProjectModel1.constructIntentDefinition();
        List assistantModelCorpuses = JSON.parseArray((String)JSON.toJSONString(utterancesDataList), AssistantModelCorpus.class);
        List example = assistantModelCorpuses.stream().filter(item -> Objects.equals(1, item.getCorpusType())).collect(Collectors.toList());
        List ng = assistantModelCorpuses.stream().filter(item -> Objects.equals(5, item.getCorpusType())).collect(Collectors.toList());
        JSONObject result = this.assistantRhApiHelper.addLlmPrompt(basicInfoDto, intent_definition, this.constructRh(example), this.curTenantToken, this.constructRh(ng), assistantProjectModel1.getIntroduction());
        String llmPromptId = result.getOrDefault((Object)"llm_prompt_id", (Object)"").toString();
        return llmPromptId;
    }

    private String addLlmPromptWithoutModel(List<JSONObject> assistantSceneList, String curTenantToken, JSONObject assistantData) {
        BasicInfoDto basicInfoDto = new BasicInfoDto();
        basicInfoDto.setNickname((List)ListUtil.toList((Object[])new String[]{"\u5a1c\u5a1c", "AI\u52a9\u7406", assistantData.getString("name")}));
        basicInfoDto.setProject_name(this.application);
        basicInfoDto.setAssistant_id(this.application);
        ArrayList intent_definition = new ArrayList();
        ArrayList mapExample = new ArrayList();
        for (JSONObject assistantScene : assistantSceneList) {
            HashMap<String, String> intentDef = new HashMap<String, String>();
            intentDef.put("intent", assistantScene.getString("name"));
            intentDef.put("definition", assistantScene.getString("description"));
            intentDef.put("create", "O");
            intentDef.put("read", "X");
            intentDef.put("update", "X");
            intentDef.put("delete", "X");
            intent_definition.add(intentDef);
            if (null != assistantScene.get((Object)"inspirationPhrase")) {
                for (String string : JSON.parseArray((String)JSON.toJSONString((Object)assistantScene.get((Object)"inspirationPhrase")), String.class)) {
                    HashMap<String, String> exampleMap = new HashMap<String, String>();
                    exampleMap.put("intent", assistantScene.getString("name"));
                    exampleMap.put("utterances", string);
                    mapExample.add(exampleMap);
                }
                continue;
            }
            HashMap<String, String> exampleMap = new HashMap<String, String>();
            exampleMap.put("intent", assistantScene.getString("name"));
            exampleMap.put("utterances", assistantScene.getString("description"));
            mapExample.add(exampleMap);
        }
        JSONObject result = this.assistantRhApiHelper.addLlmPrompt(basicInfoDto, intent_definition, mapExample, curTenantToken, new ArrayList(), assistantData.getString("description"));
        String llmPromptId = result.getOrDefault((Object)"llm_prompt_id", (Object)"").toString();
        return llmPromptId;
    }

    @Generated
    public DeployVersionParam getDeployVersionParam() {
        return this.deployVersionParam;
    }

    @Generated
    public String getCompileZipPath() {
        return this.compileZipPath;
    }

    @Generated
    public String getCompileDataPath() {
        return this.compileDataPath;
    }

    @Generated
    public DmcService getDmcService() {
        return this.dmcService;
    }

    @Generated
    public AppEntityService getAppEntityService() {
        return this.appEntityService;
    }

    @Generated
    public Map<String, ITemplate> getTemplateMap() {
        return this.templateMap;
    }

    @Generated
    public JSONObject getCompiledData() {
        return this.compiledData;
    }

    @Generated
    public String getAssistantName() {
        return this.assistantName;
    }

    @Generated
    public String getCurTenantToken() {
        return this.curTenantToken;
    }

    @Generated
    public JSONObject getOriginalCodeRelationShip() {
        return this.originalCodeRelationShip;
    }

    @Generated
    public void setDeployVersionParam(DeployVersionParam deployVersionParam) {
        this.deployVersionParam = deployVersionParam;
    }

    @Generated
    public void setCompileZipPath(String compileZipPath) {
        this.compileZipPath = compileZipPath;
    }

    @Generated
    public void setCompileDataPath(String compileDataPath) {
        this.compileDataPath = compileDataPath;
    }

    @Generated
    public void setDmcService(DmcService dmcService) {
        this.dmcService = dmcService;
    }

    @Generated
    public void setAppEntityService(AppEntityService appEntityService) {
        this.appEntityService = appEntityService;
    }

    @Generated
    public void setTemplateMap(Map<String, ITemplate> templateMap) {
        this.templateMap = templateMap;
    }

    @Generated
    public void setCompiledData(JSONObject compiledData) {
        this.compiledData = compiledData;
    }

    @Generated
    public void setAssistantName(String assistantName) {
        this.assistantName = assistantName;
    }

    @Generated
    public void setCurTenantToken(String curTenantToken) {
        this.curTenantToken = curTenantToken;
    }

    @Generated
    public void setOriginalCodeRelationShip(JSONObject originalCodeRelationShip) {
        this.originalCodeRelationShip = originalCodeRelationShip;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployThread)) {
            return false;
        }
        DeployThread other = (DeployThread)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DeployVersionParam this$deployVersionParam = this.getDeployVersionParam();
        DeployVersionParam other$deployVersionParam = other.getDeployVersionParam();
        if (this$deployVersionParam == null ? other$deployVersionParam != null : !this$deployVersionParam.equals(other$deployVersionParam)) {
            return false;
        }
        String this$compileZipPath = this.getCompileZipPath();
        String other$compileZipPath = other.getCompileZipPath();
        if (this$compileZipPath == null ? other$compileZipPath != null : !this$compileZipPath.equals(other$compileZipPath)) {
            return false;
        }
        String this$compileDataPath = this.getCompileDataPath();
        String other$compileDataPath = other.getCompileDataPath();
        if (this$compileDataPath == null ? other$compileDataPath != null : !this$compileDataPath.equals(other$compileDataPath)) {
            return false;
        }
        DmcService this$dmcService = this.getDmcService();
        DmcService other$dmcService = other.getDmcService();
        if (this$dmcService == null ? other$dmcService != null : !this$dmcService.equals(other$dmcService)) {
            return false;
        }
        AppEntityService this$appEntityService = this.getAppEntityService();
        AppEntityService other$appEntityService = other.getAppEntityService();
        if (this$appEntityService == null ? other$appEntityService != null : !this$appEntityService.equals(other$appEntityService)) {
            return false;
        }
        Map this$templateMap = this.getTemplateMap();
        Map other$templateMap = other.getTemplateMap();
        if (this$templateMap == null ? other$templateMap != null : !((Object)this$templateMap).equals(other$templateMap)) {
            return false;
        }
        JSONObject this$compiledData = this.getCompiledData();
        JSONObject other$compiledData = other.getCompiledData();
        if (this$compiledData == null ? other$compiledData != null : !this$compiledData.equals(other$compiledData)) {
            return false;
        }
        String this$assistantName = this.getAssistantName();
        String other$assistantName = other.getAssistantName();
        if (this$assistantName == null ? other$assistantName != null : !this$assistantName.equals(other$assistantName)) {
            return false;
        }
        String this$curTenantToken = this.getCurTenantToken();
        String other$curTenantToken = other.getCurTenantToken();
        if (this$curTenantToken == null ? other$curTenantToken != null : !this$curTenantToken.equals(other$curTenantToken)) {
            return false;
        }
        JSONObject this$originalCodeRelationShip = this.getOriginalCodeRelationShip();
        JSONObject other$originalCodeRelationShip = other.getOriginalCodeRelationShip();
        return !(this$originalCodeRelationShip == null ? other$originalCodeRelationShip != null : !this$originalCodeRelationShip.equals(other$originalCodeRelationShip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployThread;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeployVersionParam $deployVersionParam = this.getDeployVersionParam();
        result = result * 59 + ($deployVersionParam == null ? 43 : $deployVersionParam.hashCode());
        String $compileZipPath = this.getCompileZipPath();
        result = result * 59 + ($compileZipPath == null ? 43 : $compileZipPath.hashCode());
        String $compileDataPath = this.getCompileDataPath();
        result = result * 59 + ($compileDataPath == null ? 43 : $compileDataPath.hashCode());
        DmcService $dmcService = this.getDmcService();
        result = result * 59 + ($dmcService == null ? 43 : $dmcService.hashCode());
        AppEntityService $appEntityService = this.getAppEntityService();
        result = result * 59 + ($appEntityService == null ? 43 : $appEntityService.hashCode());
        Map $templateMap = this.getTemplateMap();
        result = result * 59 + ($templateMap == null ? 43 : ((Object)$templateMap).hashCode());
        JSONObject $compiledData = this.getCompiledData();
        result = result * 59 + ($compiledData == null ? 43 : $compiledData.hashCode());
        String $assistantName = this.getAssistantName();
        result = result * 59 + ($assistantName == null ? 43 : $assistantName.hashCode());
        String $curTenantToken = this.getCurTenantToken();
        result = result * 59 + ($curTenantToken == null ? 43 : $curTenantToken.hashCode());
        JSONObject $originalCodeRelationShip = this.getOriginalCodeRelationShip();
        result = result * 59 + ($originalCodeRelationShip == null ? 43 : $originalCodeRelationShip.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployThread(deployVersionParam=" + this.getDeployVersionParam() + ", compileZipPath=" + this.getCompileZipPath() + ", compileDataPath=" + this.getCompileDataPath() + ", dmcService=" + this.getDmcService() + ", appEntityService=" + this.getAppEntityService() + ", templateMap=" + this.getTemplateMap() + ", compiledData=" + this.getCompiledData() + ", assistantName=" + this.getAssistantName() + ", curTenantToken=" + this.getCurTenantToken() + ", originalCodeRelationShip=" + this.getOriginalCodeRelationShip() + ")";
    }

    static {
        ANALYZE_MONGODB_LIST.add("asa");
        ANALYZE_MONGODB_LIST.add("knowledgegraphSystem");
        ANALYZE_MONGODB_LIST.add("designer");
        ANALYZE_COLLECTION_LIST = new ArrayList();
        ANALYZE_COLLECTION_LIST.add("assistantScene");
        ANALYZE_COLLECTION_LIST.add("activity");
        ANALYZE_COLLECTION_LIST.add("dataState");
        ANALYZE_COLLECTION_LIST.add("dataDescription");
        ANALYZE_COLLECTION_LIST.add("dataFeatureSet");
        ANALYZE_COLLECTION_LIST.add("flowGraph");
        ANALYZE_COLLECTION_LIST.add("pageView");
        ANALYZE_COLLECTION_LIST.add("task");
        ANALYZE_COLLECTION_LIST.add("application");
        ANALYZE_COLLECTION_LIST.add("asa_assistant_project");
        ANALYZE_COLLECTION_LIST.add("asa_assistant_model");
        ANALYZE_COLLECTION_LIST.add("asa_model_corpus");
        ANALYZE_COLLECTION_LIST.add("pageUIElement");
        ANALYZE_COLLECTION_LIST.add("rules");
        ANALYZE_COLLECTION_LIST.add("agiledata_synonym");
        ANALYZE_COLLECTION_LIST.add("activityConfigs");
        ANALYZE_COLLECTION_LIST.add("applicationCustomizedConfig");
        ANALYZE_COLLECTION_LIST.add("asa_assistant_urge");
        ANALYZE_NEO4J_NODE_LIST = new ArrayList();
        ANALYZE_NEO4J_NODE_LIST.add("Activity");
    }
}

