/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config;

import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.km_deployer_service.service.DeployService;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class DeployConfig
implements ApplicationRunner {
    @Autowired
    DeployService deployService;
    @Autowired
    MongoTemplate mongoTemplate;

    @Scheduled(cron="0 0 1 * * ?")
    public void cleanHisTask() {
        this.deployService.cleanHis();
    }

    @Scheduled(cron="0 0/2 * * * ?")
    public void cleanTimeoutTask() {
        this.deployService.cleanTimeoutTask();
    }

    public void run(ApplicationArguments args) throws Exception {
        long count = this.mongoTemplate.count(new Query(), KmTable.class);
        List tables = this.deployService.initTables();
        System.out.println("check KmTable dbCount=" + count + ",docCount=" + tables.size());
        if (count < (long)tables.size()) {
            System.out.println("init tables...");
            this.mongoTemplate.dropCollection(KmTable.class);
            this.mongoTemplate.insertAll((Collection)tables);
        }
    }
}

