/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config;

import com.digiwin.athena.km_deployer_service.domain.system.AthenaUser;
import com.digiwin.loadbalance.scan.candidate.DWGroupResourceHelper;
import com.digiwin.loadbalance.service.TenantIdService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
public class LoadBalanceConfig {
    @Value(value="${module.iam.domain}")
    private String iamUrl;
    @Value(value="${appToken}")
    private String appToken;
    private final String TOKEN_VERIFY_URL = "/api/iam/v2/identity/token/analyze";
    private final String IAM_USER_TOKEN = "digi-middleware-auth-user";
    private final String IAM_APP_TOKEN = "digi-middleware-auth-app";

    @Bean
    public DWGroupResourceHelper dwGroupResourceHelper() {
        return new DWGroupResourceHelper();
    }

    @Bean
    TenantIdService tenantIdService() {
        RestTemplate restTemplate = new RestTemplate();
        return token -> {
            if (StringUtils.isEmpty((CharSequence)token)) {
                return null;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", token);
            headers.add("digi-middleware-auth-app", this.appToken);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity result = restTemplate.postForEntity(this.iamUrl + "/api/iam/v2/identity/token/analyze", (Object)httpEntity, AthenaUser.class, new Object[0]);
            AthenaUser athenaUser = (AthenaUser)result.getBody();
            if (athenaUser == null) {
                return null;
            }
            return athenaUser.getTenantId();
        };
    }
}

