/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"com.digiwin.athena.mongodb.repository"})
@ConditionalOnProperty(prefix="spring.data.mongo-asa", name={"database"})
public class AsaMongodbConfig
extends MongoConfigurationSupport {
    public static final String BASE_PACKAGE = "com.digiwin.athena.mongodb.repository";
    public static final String MONGO_TEMPLATE_REF = "asaMongoTemplate";
    @Value(value="${spring.data.mongodb.uri}")
    private String uri;
    @Value(value="${spring.data.mongo-asa.database}")
    private String databaseAsa;

    @Bean(value={"asaMongoClient"})
    public MongoClient mongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.uri)).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Bean(value={"asaMongoMappingContext"})
    public MongoMappingContext mongoMappingContext() {
        MongoMappingContext mappingContext = new MongoMappingContext();
        return mappingContext;
    }

    @Bean(value={"asaMongoDbFactory"})
    public SimpleMongoClientDatabaseFactory mongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.getDatabaseName());
    }

    @Bean(name={"asaMongoTemplate"})
    public MongoTemplate mongoTemplate(@Qualifier(value="asaMongoDbFactory") MongoDatabaseFactory mongoDbFactory, @Qualifier(value="asaMongoMappingContext") MongoMappingContext mongoMappingContext) throws Exception {
        return new MongoTemplate((MongoDatabaseFactory)this.mongoDbFactory(), (MongoConverter)this.asaMappingMongoConverter());
    }

    @Bean(value={"asaMappingMongoConverter"})
    public MappingMongoConverter asaMappingMongoConverter() throws Exception {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver((MongoDatabaseFactory)this.mongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext());
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        converter.setCustomConversions((CustomConversions)this.customConversions());
        return converter;
    }

    protected String getDatabaseName() {
        return this.databaseAsa;
    }

    public String getUri() {
        return this.uri;
    }

    public String getDatabaseAsa() {
        return this.databaseAsa;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setDatabaseAsa(String databaseAsa) {
        this.databaseAsa = databaseAsa;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsaMongodbConfig)) {
            return false;
        }
        AsaMongodbConfig other = (AsaMongodbConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$databaseAsa = this.getDatabaseAsa();
        String other$databaseAsa = other.getDatabaseAsa();
        return !(this$databaseAsa == null ? other$databaseAsa != null : !this$databaseAsa.equals(other$databaseAsa));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsaMongodbConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $databaseAsa = this.getDatabaseAsa();
        result = result * 59 + ($databaseAsa == null ? 43 : $databaseAsa.hashCode());
        return result;
    }

    public String toString() {
        return "AsaMongodbConfig(uri=" + this.getUri() + ", databaseAsa=" + this.getDatabaseAsa() + ")";
    }
}

