/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config.mongodb;

import com.digiwin.athena.km_deployer_service.config.mongodb.MySimpleMongoClientDbFactory;
import com.digiwin.athena.km_deployer_service.config.mongodb.MySimpleMongoDbFactory;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoDatabaseFactorySupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
@ConfigurationProperties(prefix="spring.data.mongodb")
public class MongoConfig
extends MongoConfigurationSupport {
    private String uri;
    private String database;
    @Value(value="${mongo.suffix}")
    private String mongoSuffix;

    @Bean
    @Primary
    MongoTemplate mongoTemplate() throws Exception {
        return new MongoTemplate(this.mongoDbFactory(), (MongoConverter)this.mappingMongoConverter());
    }

    @Primary
    @Bean
    public MongoDatabaseFactory mongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory(this.mongoClient(), this.getDatabaseName());
    }

    @Bean
    @Primary
    public MongoClient mongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.uri)).applyToConnectionPoolSettings(builder -> builder.maxSize(30).maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Bean
    @Primary
    public MappingMongoConverter mappingMongoConverter() throws Exception {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.mongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext(this.customConversions()));
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        converter.setCustomConversions((CustomConversions)this.customConversions());
        return converter;
    }

    @Bean
    @Primary
    public MongoClient mongo() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(this.uri)).applyToConnectionPoolSettings(builder -> builder.maxSize(30).minSize(10).maxConnectionIdleTime(10L, TimeUnit.MINUTES).maxConnectionLifeTime(10L, TimeUnit.MINUTES).maxWaitTime(15L, TimeUnit.MINUTES)).build();
        return MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    @Bean
    MongoDatabaseFactorySupport<?> mongoDbFactory(ObjectProvider<MongoClient> mongo, ObjectProvider<MongoClient> mongoClient, MongoProperties properties) {
        MongoClient preferredClient = (MongoClient)mongo.getIfAvailable();
        if (preferredClient != null) {
            return new MySimpleMongoDbFactory(preferredClient, properties.getMongoClientDatabase(), this.mongoSuffix);
        }
        MongoClient fallbackClient = (MongoClient)mongoClient.getIfAvailable();
        if (fallbackClient != null) {
            return new MySimpleMongoClientDbFactory(fallbackClient, properties.getMongoClientDatabase(), this.mongoSuffix);
        }
        throw new IllegalStateException("Expected to find at least one MongoDB client.");
    }

    protected String getDatabaseName() {
        return this.database;
    }

    public String getUri() {
        return this.uri;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getMongoSuffix() {
        return this.mongoSuffix;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setMongoSuffix(String mongoSuffix) {
        this.mongoSuffix = mongoSuffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoConfig)) {
            return false;
        }
        MongoConfig other = (MongoConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$mongoSuffix = this.getMongoSuffix();
        String other$mongoSuffix = other.getMongoSuffix();
        return !(this$mongoSuffix == null ? other$mongoSuffix != null : !this$mongoSuffix.equals(other$mongoSuffix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $mongoSuffix = this.getMongoSuffix();
        result = result * 59 + ($mongoSuffix == null ? 43 : $mongoSuffix.hashCode());
        return result;
    }

    public String toString() {
        return "MongoConfig(uri=" + this.getUri() + ", database=" + this.getDatabase() + ", mongoSuffix=" + this.getMongoSuffix() + ")";
    }
}

