/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.config.neo4j;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement
@EnableNeo4jRepositories(basePackages={"com.digiwin.athena.km_deployer_service.neo4jbasepkg.backup"}, transactionManagerRef="domain2TransactionManager")
@ConditionalOnProperty(prefix="spring.neo4j.domain2", name={"enable"}, havingValue="true")
public class BackupNeo4jConfig {
    private static final Logger log = LoggerFactory.getLogger(BackupNeo4jConfig.class);
    public static final String TRANSACTION_MANAGER = "domain2TransactionManager";
    public static final String NEO4J_DRIVER = "domain2Driver";
    public static final String NEO4J_TEMPLATE = "domain2Neo4jTemplate";
    static final String BASE_PACKAGE = "com.digiwin.athena.km_deployer_service.neo4jbasepkg.backup";

    @Bean(name={"domain2Neo4jProperties"})
    @ConfigurationProperties(value="spring.neo4j.domain2")
    public Neo4jProperties neo4jProperties() {
        return new Neo4jProperties();
    }

    @Bean(name={"domain2Driver"})
    public Driver driver() {
        log.info("neo4j domain2 driver\u521d\u59cb\u5316\u5f00\u59cb\uff0c username: {}, password: {}", (Object)this.neo4jProperties().getAuthentication().getUsername(), (Object)this.neo4jProperties().getAuthentication().getPassword());
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        Driver driver = GraphDatabase.driver((URI)this.neo4jProperties().getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties().getAuthentication().getUsername(), (String)this.neo4jProperties().getAuthentication().getPassword()), (Config)config);
        try {
            driver.verifyConnectivity();
        }
        catch (Exception e) {
            log.error("back\u5e93\u521d\u59cb\u5316\u5931\u8d25");
            driver = null;
        }
        return driver;
    }

    @Bean
    public Neo4jClient neo4jClient() {
        return Neo4jClient.create((Driver)this.driver());
    }

    @Bean(name={"domain2TransactionManager"})
    public Neo4jTransactionManager neo4jTransactionManager() {
        return new Neo4jTransactionManager(this.driver());
    }

    @Bean(name={"domain2Neo4jTemplate"})
    public Neo4jTemplate neo4jTemplate(Driver driver) {
        return new Neo4jTemplate(Neo4jClient.create((Driver)driver));
    }
}

