/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployVersionParam;
import com.digiwin.athena.km_deployer_service.domain.asa.param.SwitchVersionParam;
import com.digiwin.athena.km_deployer_service.listener.AsaDeployListener;
import com.digiwin.athena.km_deployer_service.service.asaDeploy.AsaDeployService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/asaDeploy"})
public class AsaDeployController {
    private static final Logger log = LoggerFactory.getLogger(AsaDeployController.class);
    private static Long DEFAULT_TIME_OUT = 300000L;
    @Autowired
    private AsaDeployService asaDeployService;
    @Autowired
    private AsaDeployListener deployListener;

    @PostMapping(produces={"text/event-stream"})
    public SseEmitter deploy(@RequestBody DeployVersionParam deployVersionParam) {
        log.info("DeployController.deployVersionParam: {}", (Object)JSON.toJSONString((Object)deployVersionParam));
        long threadId = Thread.currentThread().getId();
        SseEmitter emitter = new SseEmitter(DEFAULT_TIME_OUT);
        try {
            deployVersionParam.setThreadId(threadId);
            this.deployListener.addSseEmitters(threadId, emitter);
            this.asaDeployService.deploy(deployVersionParam);
        }
        catch (Exception e) {
            log.error("\u53d1\u7248\u5931\u8d25:", (Throwable)e);
        }
        return emitter;
    }

    @PostMapping(value={"/switchVersion"}, produces={"text/event-stream"})
    public SseEmitter switchVersion(@RequestBody SwitchVersionParam switchVersionParam) {
        log.info("DeployController.switchVersion: {}", (Object)JSON.toJSONString((Object)switchVersionParam));
        long threadId = Thread.currentThread().getId();
        SseEmitter emitter = new SseEmitter(DEFAULT_TIME_OUT);
        try {
            switchVersionParam.setThreadId(threadId);
            this.deployListener.addSseEmitters(threadId, emitter);
            this.asaDeployService.switchVersion(switchVersionParam);
        }
        catch (Exception e) {
            log.error("switchVersion\u7ed1\u5b9a\u79df\u6237\u4e0e\u5e94\u7528\u6210\u679c\u5173\u7cfb\u5931\u8d25:", (Throwable)e);
        }
        return emitter;
    }
}

