/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.controller;

import com.digiwin.athena.km_deployer_service.domain.km.KmDeployEvent;
import com.digiwin.athena.km_deployer_service.domain.km.KmEventParam;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.DeployRequest;
import com.digiwin.athena.km_deployer_service.povo.DeployResponse;
import com.digiwin.athena.km_deployer_service.povo.DeployTenantRequest;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.km.IPublishService;
import com.digiwin.athena.km_deployer_service.service.km.ITenantPublishService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publish"})
public class PublishController {
    private static final Logger log = LoggerFactory.getLogger(PublishController.class);
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    IPublishService publishService;
    @Autowired
    ITenantPublishService tenantPublishService;
    @Autowired
    MongoTemplate mongoTemplate;

    @GetMapping(value={"test01"})
    public Object test01() {
        System.out.println("test01....");
        CrudReq req = new CrudReq();
        req.setDbName("datamap");
        req.setColName("api");
        req.setParams(new HashMap());
        req.getParams().put("key1", 1);
        List list = this.mongoCrudService.query(req);
        return list;
    }

    @PostMapping(value={"deployApp"})
    public DeployResponse deployApp(@RequestBody DeployRequest request) {
        KmDeployEvent eventInDb;
        DeployResponse response = new DeployResponse();
        if (null == request.getVersion() || null == request.getAppId() || null == request.getFileId()) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("\u53c2\u6570\u9519\u8bef");
            return response;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)request.getAppId()).and("status").is((Object)1));
        if (Boolean.TRUE.equals(request.getForcePub())) {
            this.mongoTemplate.remove(query, KmDeployEvent.class);
        }
        if (null != (eventInDb = (KmDeployEvent)this.mongoTemplate.findOne(query, KmDeployEvent.class))) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("\u8be5\u5e94\u7528\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            return response;
        }
        request.setDeployId(HelpService.uuid());
        request.setEventId(HelpService.uuid());
        this.publishService.publishApplication(request);
        response.setDeployId(request.getDeployId());
        response.setEventId(request.getEventId());
        return response;
    }

    @PostMapping(value={"switchApp"})
    public DeployResponse switchApp(@RequestBody DeployRequest request) {
        DeployResponse response = new DeployResponse();
        request.setEventId(HelpService.uuid());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)request.getAppId()).and("status").is((Object)2));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"updateTime"}));
        KmDeployEvent event = (KmDeployEvent)this.mongoTemplate.findOne(query, KmDeployEvent.class);
        if (null == event) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("\u672a\u627e\u5230\u4e0a\u6b21\u53d1\u7248\u6210\u529f\u7684\u8bb0\u5f55\uff0c\u8bf7\u5148\u53d1\u7248\uff01");
            return response;
        }
        this.publishService.switchApplication(request);
        response.setEventId(request.getEventId());
        return response;
    }

    @PostMapping(value={"deployLogs"})
    public DeployResponse deployLogs(@RequestBody DeployRequest request) {
        DeployResponse response = new DeployResponse();
        Query query = Query.query((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"eventId").is((Object)request.getEventId()), Criteria.where((String)"switchEventId").is((Object)request.getEventId())}));
        KmDeployEvent event = (KmDeployEvent)this.mongoTemplate.findOne(query, KmDeployEvent.class);
        if (null != event) {
            response.setStatus(event.getStatus());
            if (null != event.getStatus() && event.getStatus() > 3) {
                response.setStatus(Integer.valueOf(event.getStatus() - 3));
            }
        }
        List logs = this.publishService.deployLogs(request);
        response.setData((Object)logs);
        return response;
    }

    @PostMapping(value={"event"})
    public DeployResponse event(@RequestBody KmEventParam param) {
        DeployResponse deployResponse = new DeployResponse();
        try {
            this.publishService.handleEvent(param);
        }
        catch (Exception e) {
            log.error("\u4e8b\u4ef6\u53d1\u5e03\u5f02\u5e38\uff1a", (Throwable)e);
            deployResponse.setCode(Integer.valueOf(-1));
            deployResponse.setMsg(e.getMessage());
        }
        return deployResponse;
    }

    @PostMapping(value={"deployTenant"})
    public DeployResponse deployTenant(@RequestBody DeployTenantRequest request) {
        DeployResponse response = new DeployResponse();
        if (null == request.getTenantId() || null == request.getDataId() || null == request.getFileId()) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("\u53c2\u6570\u9519\u8bef");
            return response;
        }
        response = this.tenantPublishService.publishTenant(request);
        return response;
    }

    @PostMapping(value={"revokeDeployTenant"})
    public DeployResponse revokeDeployTenant(@RequestBody DeployTenantRequest request) {
        DeployResponse response = new DeployResponse();
        if (null == request.getTenantId() || null == request.getDataId()) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("\u53c2\u6570\u9519\u8bef");
            return response;
        }
        response = this.tenantPublishService.revokeTenant(request);
        return response;
    }
}

