/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.controller;

import com.digiwin.athena.km_deployer_service.povo.CopyDataDTO;
import com.digiwin.athena.km_deployer_service.service.CleanableCaches;
import com.digiwin.athena.km_deployer_service.service.ToolService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    ToolService toolService;
    @Autowired
    CleanableCaches cleanableCaches;

    @GetMapping(value={"test01"})
    public Object test01() {
        System.out.println("test01...." + Runtime.getRuntime().availableProcessors());
        return "list";
    }

    @GetMapping(value={"cleanTables"})
    public Object cleanTables() {
        System.out.println("cleanTables...." + Runtime.getRuntime().availableProcessors());
        this.cleanableCaches.cleanAll();
        return "list";
    }

    @PostMapping(value={"copyCol"})
    public Object copyCol(@RequestBody CopyDataDTO req) {
        int c = this.copyData(req, (Bson)new BsonDocument());
        return c;
    }

    @PostMapping(value={"copyTenant"})
    public Object copyTenant(@RequestBody CopyDataDTO req) {
        int c;
        CopyDataDTO dto;
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        List<String> cols = Arrays.asList("activity", "task", "project", "emailView", "flowGraph", "pageUIElement", "pageView", "process", "dataDescription", "dataFeature", "dataState", "eventSubscribe", "eventTemplate", "openWindowDecision");
        List<String> cols2 = Arrays.asList("ActivityAdaptation", "PageViewAdaptation", "PageUIElementAdaptation", "erpSyncRecord", "pluginBinding", "pluginRecord", "mechanismDecision", "mechanismDecisionTarget", "taskSchedule");
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", (Object)"SYSTEM"), Filters.ne((String)"athena_publishType", (Object)"individualCase")});
        BsonDocument bson2 = new BsonDocument();
        if (!CollectionUtils.isEmpty((Collection)req.getTenantIds())) {
            bson = Filters.and((Bson[])new Bson[]{Filters.in((String)"tenantId", (Iterable)req.getTenantIds()), Filters.ne((String)"athena_publishType", (Object)"individualCase")});
            bson2 = Filters.in((String)"tenantId", (Iterable)req.getTenantIds());
        }
        for (String col : cols) {
            System.out.println("copy " + col);
            dto = new CopyDataDTO();
            dto.setFromDb(req.getFromDb());
            dto.setToDb(req.getToDb());
            dto.setFromCol(col);
            dto.setToCol(col);
            c = this.copyData(dto, bson);
            count.put(col, c);
        }
        for (String col : cols2) {
            System.out.println("copy " + col);
            dto = new CopyDataDTO();
            dto.setFromDb(req.getFromDb());
            dto.setToDb(req.getToDb());
            dto.setFromCol(col);
            dto.setToCol(col);
            c = this.copyData(dto, (Bson)bson2);
            count.put(col, c);
        }
        return count;
    }

    private int copyData(CopyDataDTO req, Bson bson) {
        int batchSize = 1000;
        AtomicInteger count = new AtomicInteger();
        ArrayList list = new ArrayList();
        FindIterable docs = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).find(bson);
        docs.forEach(doc -> {
            list.add(doc);
            if (list.size() == batchSize) {
                this.insert(list, req.getToDb(), req.getToCol());
                list.clear();
                count.addAndGet(batchSize);
            }
        });
        if (list.size() > 0) {
            this.insert(list, req.getToDb(), req.getToCol());
            count.addAndGet(list.size());
        }
        return count.get();
    }

    private void insert(List<Document> list, String db, String col) {
        try {
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(col).insertMany(list);
        }
        catch (Exception e) {
            for (Document doc : list) {
                try {
                    this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(col).insertOne((Object)doc);
                }
                catch (Exception exception) {}
            }
        }
    }

    @PostMapping(value={"createIndex"})
    public Object createIndex(@RequestBody CopyDataDTO req) {
        Bson index1 = Indexes.ascending((List)req.getFields());
        IndexOptions options = new IndexOptions();
        options.unique(Boolean.TRUE.equals(req.getUnique()));
        String name = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).createIndex(index1, options);
        return name;
    }

    @PostMapping(value={"createIndexAll"})
    public Object createIndexAll(@RequestBody CopyDataDTO req) {
        Bson tenantIdCode = Indexes.ascending((String[])new String[]{"tenantId", "code"});
        List<String> colsUseCode = Arrays.asList("activity", "task", "project", "emailView", "flowGraph", "pageUIElement", "pageView", "process", "dataDescription", "dataFeature", "dataState", "openWindowDecision", "ActivityAdaptation", "PageViewAdaptation", "PageUIElementAdaptation");
        for (String col : colsUseCode) {
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(col).createIndex(tenantIdCode);
        }
        return colsUseCode;
    }

    @PostMapping(value={"dropIndex"})
    public Object dropIndex(@RequestBody CopyDataDTO req) {
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).dropIndex(req.getIndexName());
        return req.getIndexName();
    }

    @PostMapping(value={"listIndex"})
    public Object listIndex(@RequestBody CopyDataDTO req) {
        ListIndexesIterable docs = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).listIndexes();
        ArrayList result = new ArrayList();
        docs.forEach((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    @GetMapping(value={"copyEntity"})
    public Object copyEntity() {
        Map result = this.toolService.copyEntity();
        return result;
    }

    @GetMapping(value={"processSubType"})
    public Object processSubType() {
        this.toolService.updateSubType();
        return "ok";
    }

    @GetMapping(value={"copyActivity"})
    public Object copyActivity(@RequestParam(value="pwd") String pwd) {
        if (!"copyActivity@123".equals(pwd)) {
            return "pwd error";
        }
        Map result = this.toolService.copyActivity();
        return result;
    }

    @GetMapping(value={"getActivity"})
    public Object getActivity() {
        return this.toolService.getActivity();
    }
}

