/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="asa_model_corpus")
public class AssistantModelCorpus {
    @Id
    private String objectId;
    private String corpusCode;
    private String projectCode;
    private String modelCode;
    private Integer corpusType;
    private Integer originalType;
    private String intent;
    private String utterances;
    private String originalText;
    private String generateMode;
    private String label;
    private String modelType;
    private String baseVersion;
    private String trainVersion;
    private String originalVersion;

    public static List<Map> constructRhProjectNotLabel(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            map.put("label", assistantModelCorpus.getLabel());
            return map;
        }).collect(Collectors.toList());
    }

    public static List<Map> constructRhProject(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            map.put("label", assistantModelCorpus.getLabel());
            return map;
        }).collect(Collectors.toList());
    }

    public static List<Map> constructTrainOptimal(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            map.put("original_text", assistantModelCorpus.getOriginalText());
            map.put("label", assistantModelCorpus.getLabel());
            return map;
        }).collect(Collectors.toList());
    }

    public static List<JSONObject> constructTest(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("intent", (Object)assistantModelCorpus.getIntent());
            jsonObject.put("text", (Object)assistantModelCorpus.getUtterances());
            return jsonObject;
        }).collect(Collectors.toList());
    }

    public static String generateKey(String intent, String utterance) {
        return intent + "_" + utterance;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getCorpusCode() {
        return this.corpusCode;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public Integer getCorpusType() {
        return this.corpusType;
    }

    public Integer getOriginalType() {
        return this.originalType;
    }

    public String getIntent() {
        return this.intent;
    }

    public String getUtterances() {
        return this.utterances;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getGenerateMode() {
        return this.generateMode;
    }

    public String getLabel() {
        return this.label;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getTrainVersion() {
        return this.trainVersion;
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setCorpusCode(String corpusCode) {
        this.corpusCode = corpusCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public void setModelCode(String modelCode) {
        this.modelCode = modelCode;
    }

    public void setCorpusType(Integer corpusType) {
        this.corpusType = corpusType;
    }

    public void setOriginalType(Integer originalType) {
        this.originalType = originalType;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public void setUtterances(String utterances) {
        this.utterances = utterances;
    }

    public void setOriginalText(String originalText) {
        this.originalText = originalText;
    }

    public void setGenerateMode(String generateMode) {
        this.generateMode = generateMode;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    public void setTrainVersion(String trainVersion) {
        this.trainVersion = trainVersion;
    }

    public void setOriginalVersion(String originalVersion) {
        this.originalVersion = originalVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssistantModelCorpus)) {
            return false;
        }
        AssistantModelCorpus other = (AssistantModelCorpus)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$corpusType = this.getCorpusType();
        Integer other$corpusType = other.getCorpusType();
        if (this$corpusType == null ? other$corpusType != null : !((Object)this$corpusType).equals(other$corpusType)) {
            return false;
        }
        Integer this$originalType = this.getOriginalType();
        Integer other$originalType = other.getOriginalType();
        if (this$originalType == null ? other$originalType != null : !((Object)this$originalType).equals(other$originalType)) {
            return false;
        }
        String this$objectId = this.getObjectId();
        String other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$corpusCode = this.getCorpusCode();
        String other$corpusCode = other.getCorpusCode();
        if (this$corpusCode == null ? other$corpusCode != null : !this$corpusCode.equals(other$corpusCode)) {
            return false;
        }
        String this$projectCode = this.getProjectCode();
        String other$projectCode = other.getProjectCode();
        if (this$projectCode == null ? other$projectCode != null : !this$projectCode.equals(other$projectCode)) {
            return false;
        }
        String this$modelCode = this.getModelCode();
        String other$modelCode = other.getModelCode();
        if (this$modelCode == null ? other$modelCode != null : !this$modelCode.equals(other$modelCode)) {
            return false;
        }
        String this$intent = this.getIntent();
        String other$intent = other.getIntent();
        if (this$intent == null ? other$intent != null : !this$intent.equals(other$intent)) {
            return false;
        }
        String this$utterances = this.getUtterances();
        String other$utterances = other.getUtterances();
        if (this$utterances == null ? other$utterances != null : !this$utterances.equals(other$utterances)) {
            return false;
        }
        String this$originalText = this.getOriginalText();
        String other$originalText = other.getOriginalText();
        if (this$originalText == null ? other$originalText != null : !this$originalText.equals(other$originalText)) {
            return false;
        }
        String this$generateMode = this.getGenerateMode();
        String other$generateMode = other.getGenerateMode();
        if (this$generateMode == null ? other$generateMode != null : !this$generateMode.equals(other$generateMode)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$modelType = this.getModelType();
        String other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) {
            return false;
        }
        String this$baseVersion = this.getBaseVersion();
        String other$baseVersion = other.getBaseVersion();
        if (this$baseVersion == null ? other$baseVersion != null : !this$baseVersion.equals(other$baseVersion)) {
            return false;
        }
        String this$trainVersion = this.getTrainVersion();
        String other$trainVersion = other.getTrainVersion();
        if (this$trainVersion == null ? other$trainVersion != null : !this$trainVersion.equals(other$trainVersion)) {
            return false;
        }
        String this$originalVersion = this.getOriginalVersion();
        String other$originalVersion = other.getOriginalVersion();
        return !(this$originalVersion == null ? other$originalVersion != null : !this$originalVersion.equals(other$originalVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssistantModelCorpus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $corpusType = this.getCorpusType();
        result = result * 59 + ($corpusType == null ? 43 : ((Object)$corpusType).hashCode());
        Integer $originalType = this.getOriginalType();
        result = result * 59 + ($originalType == null ? 43 : ((Object)$originalType).hashCode());
        String $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $corpusCode = this.getCorpusCode();
        result = result * 59 + ($corpusCode == null ? 43 : $corpusCode.hashCode());
        String $projectCode = this.getProjectCode();
        result = result * 59 + ($projectCode == null ? 43 : $projectCode.hashCode());
        String $modelCode = this.getModelCode();
        result = result * 59 + ($modelCode == null ? 43 : $modelCode.hashCode());
        String $intent = this.getIntent();
        result = result * 59 + ($intent == null ? 43 : $intent.hashCode());
        String $utterances = this.getUtterances();
        result = result * 59 + ($utterances == null ? 43 : $utterances.hashCode());
        String $originalText = this.getOriginalText();
        result = result * 59 + ($originalText == null ? 43 : $originalText.hashCode());
        String $generateMode = this.getGenerateMode();
        result = result * 59 + ($generateMode == null ? 43 : $generateMode.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $modelType = this.getModelType();
        result = result * 59 + ($modelType == null ? 43 : $modelType.hashCode());
        String $baseVersion = this.getBaseVersion();
        result = result * 59 + ($baseVersion == null ? 43 : $baseVersion.hashCode());
        String $trainVersion = this.getTrainVersion();
        result = result * 59 + ($trainVersion == null ? 43 : $trainVersion.hashCode());
        String $originalVersion = this.getOriginalVersion();
        result = result * 59 + ($originalVersion == null ? 43 : $originalVersion.hashCode());
        return result;
    }

    public String toString() {
        return "AssistantModelCorpus(objectId=" + this.getObjectId() + ", corpusCode=" + this.getCorpusCode() + ", projectCode=" + this.getProjectCode() + ", modelCode=" + this.getModelCode() + ", corpusType=" + this.getCorpusType() + ", originalType=" + this.getOriginalType() + ", intent=" + this.getIntent() + ", utterances=" + this.getUtterances() + ", originalText=" + this.getOriginalText() + ", generateMode=" + this.getGenerateMode() + ", label=" + this.getLabel() + ", modelType=" + this.getModelType() + ", baseVersion=" + this.getBaseVersion() + ", trainVersion=" + this.getTrainVersion() + ", originalVersion=" + this.getOriginalVersion() + ")";
    }
}

