/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.helper;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.povo.asa.BasicInfoDto;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AssistantRhApiHelper {
    private static final Logger log = LoggerFactory.getLogger(AssistantRhApiHelper.class);
    private static final String URL_COMMON_HDL = "/api/ai/RequestHDL";
    private static final String URL_MODEL_LLM_PROMPT = "model/llm_prompt";
    private static final String URL_MODEL_LLM_PROMPT_MODIFY = "model/llm_prompt_modify";
    private static final String URL_MODEL_LLM_DEPLOY = "model/llm/deploy";
    private static final String URL_MODEL_DEPLOY_TAG = "model/deploy_tag";
    private static final String URL_ES_METADATA_UPSERT = "es/metadata/upsert";
    private static final String URL_ES_METADATA_DELETE = "es/metadata/delete";
    private static final String URL_ES_METADATA_DEPLOY = "es/metadata/deploy";
    @Value(value="${appToken}")
    private String appToken;
    private String rhDomain;

    @Autowired
    public void setModule(ModuleConfig module) {
        this.rhDomain = module.getKafka_middle().getDomain();
    }

    public void llmDeployer(Map map, String deployLlmPromptId, String deployMode, String curTenantToken) {
        try {
            JSONObject requestParam = new JSONObject();
            requestParam.put("basic_info", (Object)map);
            requestParam.put("deploy_llm_prompt_id", (Object)deployLlmPromptId);
            requestParam.put("deploy_mode", (Object)deployMode);
            JSONObject data = this.executeRhRequest(URL_MODEL_LLM_DEPLOY, requestParam, curTenantToken);
            if (data == null) {
                throw new BusinessException("\u5927\u6a21\u578b\u90e8\u7f72\u5931\u8d25");
            }
            Assert.isTrue((data.getIntValue("code") == 0 ? 1 : 0) != 0, () -> new BusinessException(data.getString("msg")));
        }
        catch (Exception e) {
            log.error("AssistantRhApiHelper.llmDeployer.error", (Throwable)e);
            throw new BusinessException("\u5927\u6a21\u578b\u90e8\u7f72\u5931\u8d25");
        }
    }

    public void tagDeployer(String create_mode, Map projectName, String deployMode, String deploy_name, String curTenantToken) {
        try {
            JSONObject requestParam = new JSONObject();
            requestParam.put("create_mode", (Object)create_mode);
            requestParam.put("basic_info", (Object)projectName);
            requestParam.put("deploy_mode", (Object)deployMode);
            requestParam.put("deploy_name", (Object)deploy_name);
            JSONObject data = this.executeRhRequest(URL_MODEL_DEPLOY_TAG, requestParam, curTenantToken);
            if (data == null) {
                throw new BusinessException("\u5c0f\u6a21\u578b\u90e8\u7f72\u5931\u8d25");
            }
            Assert.isTrue((data.getIntValue("code") == 0 ? 1 : 0) != 0, () -> new BusinessException(data.getString("msg")));
        }
        catch (Exception e) {
            log.error("AssistantRhApiHelper.modelDeployer.error", (Throwable)e);
            throw new BusinessException("\u5c0f\u6a21\u578b\u90e8\u7f72\u5931\u8d25");
        }
    }

    public JSONObject addLlmPrompt(BasicInfoDto basicInfoDto, List<Map> intentDefinition, List<Map> example, String curTenantToken, List<Map> llmPredictNg, String assistantIntroduction) {
        try {
            JSONObject requestParam = new JSONObject();
            requestParam.put("example", example);
            requestParam.put("basic_info", (Object)basicInfoDto);
            requestParam.put("intent_definition", intentDefinition);
            requestParam.put("assistant_introduction", (Object)assistantIntroduction);
            requestParam.put("llm_predict_ng", llmPredictNg);
            JSONObject responseData = this.executeRhRequest(URL_MODEL_LLM_PROMPT, requestParam, curTenantToken);
            if (responseData == null) {
                throw new BusinessException("\u521b\u5efa\u63d0\u793a\u8bcd\u5931\u8d25");
            }
            return new JSONObject((Map)responseData.get((Object)"data"));
        }
        catch (Exception e) {
            log.error("AssistantRhApiHelper.addLlmPrompt.error", (Throwable)e);
            throw new BusinessException("\u521b\u5efa\u63d0\u793a\u8bcd\u5931\u8d25");
        }
    }

    public JSONObject modifyLLMPrompt(String llmPromptId, String mode, String systemPrompt, String inputPrompt, String iamToken) {
        JSONObject requestData = new JSONObject();
        requestData.put("llm_prompt_id", (Object)llmPromptId);
        requestData.put("mode", (Object)mode);
        requestData.put("system_prompt", (Object)systemPrompt);
        requestData.put("input_prompt", (Object)inputPrompt);
        JSONObject responseData = this.executeRhRequest(URL_MODEL_LLM_PROMPT_MODIFY, requestData, iamToken);
        return responseData;
    }

    public void esDeployer(String application, String fromMode, String toMode, String curTenantToken) {
        try {
            JSONObject requestParam = new JSONObject();
            requestParam.put("assistant_id", (Object)application);
            requestParam.put("from_deploy_mode", (Object)fromMode);
            requestParam.put("to_deploy_mode", (Object)toMode);
            JSONObject data = this.executeRhRequest(URL_ES_METADATA_DEPLOY, requestParam, curTenantToken);
            if (data == null) {
                throw new BusinessException("\u540c\u4e49\u8bcdES\u90e8\u7f72\u5931\u8d25");
            }
            Assert.isTrue((data.getIntValue("code") == 0 ? 1 : 0) != 0, () -> new BusinessException(data.getString("msg")));
        }
        catch (Exception e) {
            log.error("AssistantRhApiHelper.esDeployer.error", (Throwable)e);
            throw new BusinessException("\u540c\u4e49\u8bcdES\u90e8\u7f72\u5931\u8d25");
        }
    }

    public void writeEsUpdateData(JSONObject requestParam, String curTenantToken) {
        try {
            JSONObject responseData = this.executeRhRequest(URL_ES_METADATA_UPSERT, requestParam, curTenantToken);
            if (responseData == null) {
                throw new BusinessException("\u8c03\u7528\u8c03\u7528es\u63a5\u53e3\u6279\u6b21\u5199\u5165\u8d44\u6599\u5931\u8d25");
            }
            Assert.isTrue((responseData.getIntValue("code") == 0 ? 1 : 0) != 0, () -> new BusinessException(responseData.getString("msg")));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u8c03\u7528es\u63a5\u53e3\u6279\u6b21\u5199\u5165\u8d44\u6599\u5931\u8d25", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    public void writeEsDeleteData(JSONObject requestParam, String curTenantToken) {
        try {
            JSONObject responseData = this.executeRhRequest(URL_ES_METADATA_DELETE, requestParam, curTenantToken);
            if (responseData == null) {
                throw new BusinessException("\u8c03\u7528\u8c03\u7528es\u63a5\u53e3\u6279\u6b21\u5220\u9664\u8d44\u6599\u5931\u8d25");
            }
            Assert.isTrue((responseData.getIntValue("code") == 0 ? 1 : 0) != 0, () -> new BusinessException(responseData.getString("msg")));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u8c03\u7528es\u63a5\u53e3\u6279\u6b21\u5220\u9664\u8d44\u6599\u5931\u8d25", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    private JSONObject executeRhRequest(String modelUrl, JSONObject requestData, String iamToken) {
        String requestUrl = this.rhDomain + URL_COMMON_HDL;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.add("token", iamToken);
        httpHeaders.add("digi-middleware-auth-user", iamToken);
        httpHeaders.add("digi-middleware-auth-app", this.appToken);
        JSONObject requestParam = this.buildRequestBody(modelUrl, requestData);
        HttpEntity entity = new HttpEntity((Object)requestParam, (MultiValueMap)httpHeaders);
        log.info("executeRhRequest #pre,url : {}, param : {}", (Object)requestUrl, (Object)JSON.toJSONString((Object)entity));
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.postForEntity(requestUrl, (Object)entity, JSONObject.class, new Object[0]);
        log.info("executeRhRequest #post,result : {}", (Object)JSON.toJSONString((Object)result));
        JSONObject responseData = this.getResponseData((JSONObject)result.getBody());
        return responseData;
    }

    private JSONObject buildRequestBody(String modelUrl, JSONObject data) {
        JSONObject dataBody = new JSONObject();
        dataBody.fluentPut("method", (Object)"CLU_IE").fluentPut("model", (Object)modelUrl).fluentPut("topic", (Object)"AI").fluentPut("timeout", (Object)60).fluentPut("data", (Object)data);
        JSONObject body = new JSONObject();
        body.fluentPut("key", (Object)"0").fluentPut("asynchronous", (Object)false).fluentPut("data", (Object)dataBody);
        return body;
    }

    private JSONObject getResponseData(JSONObject responseBody) {
        Integer code = responseBody.getInteger("code");
        if (code != null && code == 0) {
            return responseBody.getJSONObject("data");
        }
        return null;
    }
}

