/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.listener;

import com.digiwin.athena.km_deployer_service.domain.asa.enent.DeployEvent;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class AsaDeployListener {
    private static final Logger log = LoggerFactory.getLogger(AsaDeployListener.class);
    private static Map<Long, SseEmitter> sseEmitters = new Hashtable();

    public void addSseEmitters(long id, SseEmitter sseEmitter) {
        sseEmitters.put(id, sseEmitter);
        sseEmitter.onTimeout(() -> {
            SseEmitter cfr_ignored_0 = (SseEmitter)sseEmitters.remove(id);
        });
        sseEmitter.onCompletion(() -> {
            SseEmitter cfr_ignored_0 = (SseEmitter)sseEmitters.remove(id);
        });
    }

    @EventListener
    public void deployEventHandler(DeployEvent deployEvent) {
        long id = deployEvent.getId();
        SseEmitter sseEmitter = (SseEmitter)sseEmitters.get(id);
        try {
            sseEmitter.send(SseEmitter.event().data((Object)deployEvent.getMsg()));
            if (deployEvent.isComplete()) {
                sseEmitter.complete();
            }
        }
        catch (IOException e) {
            sseEmitter.complete();
            log.error("Send emit message error.", (Throwable)e);
        }
    }
}

