/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.deploy.DeployReq;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.service.CleanableCaches;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.text.StringEscapeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AdapterService {
    private static final Logger log = LoggerFactory.getLogger(AdapterService.class);
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    HelpService helpService;
    @Autowired
    CleanableCaches cleanableCaches;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    Neo4jCrudService neo4jCrudService;

    @Async
    public void copy(DeployReq request) {
        DeployContext deployContext = new DeployContext();
        deployContext.setAppId(request.getAppId());
        deployContext.setDeployId(request.getDeployId());
        deployContext.setEventId(request.getEventId());
        deployContext.setSourceId(request.getSourceId());
        deployContext.setProcess(0);
        HelpService.setDeployContext((DeployContext)deployContext);
        String application = request.getAppId();
        String oldVersion = request.getFromVersion();
        String tempVersion = "4.0";
        String finalVersion = request.getToVersion();
        if (null == oldVersion) {
            oldVersion = "1.0";
        }
        if (null == finalVersion) {
            finalVersion = "2.0";
        }
        this.helpService.logDetail(null, "\u5f00\u59cbcopy\u6570\u636e", Integer.valueOf(0), Integer.valueOf(1));
        this.copyNeo4jData(application, oldVersion, tempVersion, new Neo4jManager(this.driver1));
        if (null != this.driver2) {
            this.copyNeo4jData(application, oldVersion, tempVersion, new Neo4jManager(this.driver2));
        }
        this.helpService.logDetail(null, "copy neo4j\u6570\u636e\u5b8c\u6210", Integer.valueOf(10), Integer.valueOf(1));
        Bson filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)oldVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM"), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.ne((String)"tenantId", (Object)"SYSTEM"), Filters.eq((String)"athena_publishType", (Object)"individualCase")})})});
        List tables = this.cleanableCaches.getKmTables();
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            ArrayList newDocuments = new ArrayList();
            FindIterable documents = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).find(filters);
            documents.forEach(document -> {
                Document newDocument = new Document((Map)document);
                newDocument.remove((Object)"_id");
                newDocument.put("version", (Object)tempVersion);
                newDocument.put("publishTime", (Object)new Date());
                newDocuments.add(newDocument);
            });
            if (newDocuments.isEmpty()) continue;
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).insertMany(newDocuments);
        }
        this.helpService.logDetail(null, "copy mongo \u6570\u636e\u5b8c\u6210", Integer.valueOf(0), Integer.valueOf(1));
        this.helpService.logDetail(null, "\u5f00\u59cb\u5220\u9664\u76ee\u6807\u7248\u672c\u6570\u636e", Integer.valueOf(10), Integer.valueOf(1));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", finalVersion);
        param.put("application", application);
        String cypher1 = "match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) detach delete node";
        this.neo4jCrudService.executeCypher(cypher1, param);
        this.helpService.logDetail(null, "\u5220\u9664\u76ee\u6807\u7248\u672cneo4j\u6570\u636e\u5b8c\u6210", Integer.valueOf(10), Integer.valueOf(1));
        Bson filters2 = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)finalVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM"), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.ne((String)"tenantId", (Object)"SYSTEM"), Filters.eq((String)"athena_publishType", (Object)"individualCase")})})});
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).deleteMany(filters2);
        }
        this.helpService.logDetail(null, "\u5220\u9664\u76ee\u6807\u7248\u672cmongo\u6570\u636e\u5b8c\u6210", Integer.valueOf(0), Integer.valueOf(1));
        this.helpService.logDetail(null, "\u5f00\u59cb\u66f4\u65b0\u76ee\u6807\u7248\u672c\u6570\u636e", Integer.valueOf(10), Integer.valueOf(1));
        HashMap<String, String> param2 = new HashMap<String, String>();
        param2.put("version", tempVersion);
        param2.put("updateVersion", finalVersion);
        param2.put("application", application);
        String cypher2 = "match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) set node.version=$updateVersion";
        this.neo4jCrudService.executeCypher(cypher2, param2);
        this.helpService.logDetail(null, "\u66f4\u65b0\u76ee\u6807\u7248\u672cneo4j\u6570\u636e\u5b8c\u6210", Integer.valueOf(10), Integer.valueOf(1));
        Bson filters3 = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)tempVersion), Filters.or((Bson[])new Bson[]{Filters.eq((String)"application", (Object)application), Filters.eq((String)"athena_namespace", (Object)application)}), Filters.or((Bson[])new Bson[]{Filters.eq((String)"tenantId", null), Filters.eq((String)"tenantId", (Object)"SYSTEM"), Filters.and((Bson[])new Bson[]{Filters.ne((String)"tenantId", null), Filters.ne((String)"tenantId", (Object)"SYSTEM"), Filters.eq((String)"athena_publishType", (Object)"individualCase")})})});
        Bson setv = Updates.set((String)"version", (Object)finalVersion);
        for (KmTable table : tables) {
            if ("neo4j".equalsIgnoreCase(table.getType())) continue;
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).updateMany(filters3, setv);
        }
        this.helpService.logDetail(null, "\u66f4\u65b0\u76ee\u6807\u7248\u672cmongo\u6570\u636e\u5b8c\u6210", Integer.valueOf(0), Integer.valueOf(2));
    }

    private void copyNeo4jData(String application, String oldVersion, String newVersion, Neo4jManager neo4jManager) {
        long t0 = System.currentTimeMillis();
        ConcurrentHashMap<Long, Long> nodeNeo4jIdMap = new ConcurrentHashMap<Long, Long>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", oldVersion);
        param.put("application", application);
        List nodeResultList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        List relationList = neo4jManager.ExecuteQuery("match (startNode)-[relation]->(endNode) where startNode.version = $version and (startNode.athena_namespace = $application or startNode.nameSpace = $application) and endNode.version = $version and (endNode.athena_namespace = $application or endNode.nameSpace = $application) return id(startNode) as startNodeId,type(relation) as relationType,id(endNode) as endNodeId", param);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        for (Object nodeResult : nodeResultList) {
            StringBuffer nodeCypher = new StringBuffer("create (node");
            Collection labels = ((InternalNode)nodeResult.get("node")).labels();
            long nodeId = ((InternalNode)nodeResult.get("node")).id();
            for (String label : labels) {
                nodeCypher.append(String.format(":%s", label));
            }
            nodeCypher.append("{");
            Map properties = ((InternalNode)nodeResult.get("node")).asMap();
            this.combineNodeProperties(properties, nodeCypher);
            nodeCypher.append("oldNodeId:" + nodeId + ",");
            nodeCypher.append(String.format("version:'%s', publishTime:'%s'}) return id(node) as nodeId", newVersion, DateUtil.now()));
            cqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava((String)nodeCypher.toString())));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList);
        param.put("version", newVersion);
        param.put("application", application);
        List newNodeList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        for (Object nodeResult : newNodeList) {
            long newNodeId = ((InternalNode)nodeResult.get("node")).id();
            Map properties = ((InternalNode)nodeResult.get("node")).asMap();
            Long oldNodeId = Convert.toLong(properties.get("oldNodeId"));
            nodeNeo4jIdMap.put(oldNodeId, newNodeId);
        }
        relationList.forEach(relation -> {
            relation.put("startNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("startNodeId").toString())));
            relation.put("endNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("endNodeId").toString())));
        });
        ArrayList<Cql> cqlList1 = new ArrayList<Cql>();
        for (Map relation2 : relationList) {
            String relationCypher = String.format("match (startNode),(endNode) WHERE id(startNode)=%d and id(endNode)=%d merge (startNode)-[relation:%s]->(endNode)", (Long)relation2.get("startNodeId"), (Long)relation2.get("endNodeId"), relation2.get("relationType"));
            cqlList1.add(new Cql().setParams(new HashMap()).setCql(relationCypher));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList1);
        long t1 = System.currentTimeMillis();
        log.info(application + "\u5e94\u7528\u590d\u5236neo4j\u6570\u636e\u8017\u65f6\uff08ms\uff09\uff1a" + (t1 - t0));
    }

    public void combineNodeProperties(Map<String, Object> properties, StringBuffer nodeCypher) {
        properties.forEach((k, v) -> {
            if (!"version".equals(k) && !"oldNodeId".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append(String.format("`%s`:", k));
                } else {
                    nodeCypher.append(String.format("%s:", k));
                }
                if (v instanceof String) {
                    String propertyValue2 = (String)v;
                    propertyValue2 = propertyValue2.replace("'", "\\\"");
                    nodeCypher.append(String.format("'%s',", propertyValue2));
                } else if (v instanceof Collection) {
                    nodeCypher.append("[");
                    List propertyValueList = (List)v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append(v).append(",");
                }
            }
        });
    }
}

