/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.deploy.DeployResp;
import com.digiwin.athena.km_deployer_service.povo.CommonParadigmDeployDto;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ParadigmDeployService {
    private static final Logger log = LoggerFactory.getLogger(ParadigmDeployService.class);
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Autowired
    DmcService dmcService;
    @Autowired
    MongoCrudService mongoCrudService;

    public DeployResp publishApplication(CommonParadigmDeployDto request) throws IOException {
        HashMap<String, String> params;
        log.info("Route==>ParadigmDeployService method=publishApplication:{}", (Object)JSON.toJSONString((Object)request));
        DeployResp response = new DeployResp();
        if (null == request.getEnv()) {
            return DeployResp.failed((Integer)1, (String)"deployId is null");
        }
        if (null == request.getTenantId()) {
            return DeployResp.failed((Integer)1, (String)"sourceId is null");
        }
        if (null == request.getFileId()) {
            return DeployResp.failed((Integer)1, (String)"appId is null");
        }
        if (null == request.getToken()) {
            return DeployResp.failed((Integer)1, (String)"type is null");
        }
        ApplicationData appData = this.parseFile(request.getFileId());
        if (null == appData || CollectionUtil.isEmpty((Collection)appData.getCyphers()) && CollectionUtil.isEmpty((Collection)appData.getMongoData())) {
            return DeployResp.failed((Integer)1, (String)"\u6ca1\u6709\u4efb\u4f55\u53d1\u5e03\u7684\u6570\u636e");
        }
        for (ApplicationMongoData item : appData.getMongoData()) {
            if (!"paradigm".equals(item.getCol())) continue;
            params = new HashMap<String, String>();
            params.put("application", "commonParadigm");
            this.dataProcess(item, params, "1.0");
        }
        for (ApplicationMongoData item : appData.getMongoData()) {
            if (!"paradigm".equals(item.getCol())) continue;
            params = new HashMap();
            params.put("application", "commonParadigm");
            this.dataProcess(item, params, "2.0");
        }
        return response;
    }

    private void dataProcess(ApplicationMongoData item, Map<String, Object> params, String version) {
        item.getDocs().forEach(document -> {
            document.remove((Object)"_id");
            document.put("version", (Object)version);
            Object docTenantId = document.get((Object)"tenantId");
            if (StringUtils.isEmpty((Object)docTenantId) || "SYSTEM".equals(docTenantId)) {
                document.put("tenantId", (Object)"SYSTEM");
            }
        });
        log.info("Route==>ParadigmDeployService delete version:{},params:{}", (Object)version, params);
        CrudReq crudReq = new CrudReq();
        params.put("version", version);
        crudReq.setParams(params);
        crudReq.setDbName(item.getDb());
        crudReq.setColName(item.getCol());
        this.mongoCrudService.delete(crudReq);
        log.info("Route==>ParadigmDeployService add: mongo\u63d2\u5165 {} {} {}\u6761\u8bb0\u5f55,version:{}", new Object[]{item.getDb(), item.getCol(), item.getDocs().size(), version});
        this.mongoCrudService.insert(item);
    }

    public ApplicationData parseFile(String fileId) throws IOException {
        ApplicationData data = new ApplicationData();
        String appDir = "commonParadigm";
        String applicationCompileZipPath = this.compileZipPath + File.separator + appDir + File.separator;
        String applicationCompileDataPath = this.compileDataPath + File.separator + appDir + File.separator;
        String compileDataZipPath = applicationCompileZipPath + appDir + ".zip";
        InputStream inputStream = this.dmcService.download(fileId);
        FileUtil.writeFromStream((InputStream)inputStream, (String)compileDataZipPath);
        File compileDataDirector = new File(applicationCompileDataPath);
        FileUtil.del((File)compileDataDirector);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationCompileDataPath);
        File[] compileDataFiles = compileDataDirector.listFiles();
        if (null == compileDataFiles) {
            return data;
        }
        for (File file : compileDataFiles) {
            File[] parentDirs;
            String parentFilename = file.getName();
            if (!"mongo".equals(parentFilename) || (parentDirs = file.listFiles()) == null) continue;
            for (File parentDir : parentDirs) {
                String filename = parentDir.getName();
                if (this.isDb(filename)) {
                    File[] dirs = parentDir.listFiles();
                    if (dirs == null) continue;
                    for (File col : dirs) {
                        String colName = col.getName();
                        if (!this.isCol(col)) continue;
                        ApplicationMongoData mongoData = new ApplicationMongoData();
                        mongoData.setDb(filename);
                        mongoData.setCol(colName);
                        File[] files = col.listFiles();
                        if (files == null) continue;
                        for (File file1 : files) {
                            if (!file1.getName().endsWith("json")) continue;
                            List lines = FileUtil.readLines((File)file1, (String)"UTF-8");
                            lines.forEach(line -> {
                                Document document = Document.parse((String)line);
                                mongoData.getDocs().add(document);
                            });
                        }
                        data.getMongoData().add(mongoData);
                    }
                    continue;
                }
                log.info("Route==>ParadigmDeployService method=parseFile ignore file " + filename);
            }
        }
        FileUtil.del((String)compileDataZipPath);
        FileUtil.del((String)applicationCompileDataPath);
        return data;
    }

    private boolean isCol(File file) {
        return file.isDirectory();
    }

    private boolean isDb(String name) {
        List<String> dbs = Arrays.asList("knowledgegraphSystem", "datamap", "preset", "tagSystem", "deliveryDesigner");
        return dbs.contains(name);
    }
}

