/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ToolService {
    private static final Logger log = LoggerFactory.getLogger(ToolService.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    private Neo4jCrudService neo4jCrudService;
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    private Driver driver;

    public Map<String, Object> copyEntity() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("tenantEntity");
        List tenantInDb = this.mongoCrudService.query(req1);
        List tenantIdInDb = tenantInDb.stream().map(document -> (String)document.get((Object)"tenantId")).collect(Collectors.toList());
        ApplicationMongoData insertReq1 = new ApplicationMongoData();
        insertReq1.setDb(Constant.db_kg_sys);
        insertReq1.setCol("tenantEntity");
        String cql = "match (te:TenantEntity) return  te.tenantId as tenantId,te.tenantName as tenantName,te.version as version,te.customerServiceCode as customerServiceCode";
        List tenantEntities = this.neo4jCrudService.queryByDriver(cql, new HashMap());
        tenantEntities.forEach(t -> {
            String tenantId = MapUtil.getStr((Map)t, (Object)"tenantId");
            if (!tenantIdInDb.contains(tenantId)) {
                insertReq1.getDocs().add(new Document(t));
                tenantIdInDb.add(tenantId);
            }
        });
        this.insert(insertReq1);
        result.put("tenantEntity", insertReq1.getDocs().size());
        CrudReq req2 = new CrudReq();
        req2.setDbName(Constant.db_kg_sys);
        req2.setColName("tenantAppRelation");
        List tenantAppRelationsInDb = this.mongoCrudService.query(req2);
        List tenantIdAppInDb2 = tenantAppRelationsInDb.stream().map(document -> document.get((Object)"tenantId") + ":" + document.get((Object)"appCode")).collect(Collectors.toList());
        ApplicationMongoData insertReq2 = new ApplicationMongoData();
        insertReq2.setDb(Constant.db_kg_sys);
        insertReq2.setCol("tenantAppRelation");
        String cql2 = "match (te:TenantEntity)-[:USE]->(app:AppEntity) return te.tenantId as tenantId,app.code as appCode";
        List maps2 = this.neo4jCrudService.queryByDriver(cql2, new HashMap());
        maps2.forEach(map -> {
            String tenantApp = map.get("tenantId") + ":" + map.get("appCode");
            if (!tenantIdAppInDb2.contains(tenantApp)) {
                insertReq2.getDocs().add(new Document(map));
                tenantIdAppInDb2.add(tenantApp);
            }
        });
        this.insert(insertReq2);
        result.put("tenantAppRelation", insertReq2.getDocs().size());
        return result;
    }

    private List<String> notContain(List<String> all, List<String> sub) {
        ArrayList<String> notcontain = new ArrayList<String>();
        for (String str : all) {
            if (sub.contains(str)) continue;
            notcontain.add(str);
        }
        return notcontain;
    }

    private void insert(ApplicationMongoData data) {
        int batchSize = 1000;
        Lists.partition((List)data.getDocs(), (int)batchSize).forEach(docs -> {
            try {
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(data.getDb()).getCollection(data.getCol()).insertMany(docs);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u63d2\u5165\u5931\u8d25 insert error", (Throwable)e);
                for (Document doc : docs) {
                    try {
                        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(data.getDb()).getCollection(data.getCol()).insertOne((Object)doc);
                    }
                    catch (Exception e2) {
                        log.error("\u5355\u4e2a\u63d2\u5165\u5931\u8d25 insert error, doc: {}", (Object)doc, (Object)e2);
                    }
                }
            }
        });
    }

    public void updateSubType() {
        String db = Constant.db_kg_sys;
        String table = "applicationRelation";
        HashMap<String, String> patternSubTypeMap = new HashMap<String, String>();
        patternSubTypeMap.put("DATA_ENTRY", "base_entry");
        patternSubTypeMap.put("STATEMENT", "statement");
        HashMap<String, List> patternCodes = new HashMap<String, List>();
        String cypher = "match(a:Activity) return distinct a.code as code,a.pattern as pattern";
        List it = this.neo4jCrudService.queryByDriver(cypher, new HashMap());
        it.forEach(cp -> {
            String code = (String)cp.get("code");
            String pattern = (String)cp.get("pattern");
            ArrayList<String> codes = (ArrayList<String>)patternCodes.get(pattern);
            if (null == codes) {
                codes = new ArrayList<String>();
                patternCodes.put(pattern, codes);
            }
            codes.add(code);
        });
        patternCodes.forEach((k, v) -> {
            HashMap<String, Object> param1 = new HashMap<String, Object>();
            param1.put("type", "activity");
            param1.put("code", v);
            Bson q1 = MongoCrudService.buildBson(param1);
            String subType = (String)patternSubTypeMap.get(k);
            if (null == subType) {
                subType = k;
            }
            this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(table).updateMany(q1, Updates.set((String)"subType", (Object)subType));
        });
        HashMap<String, String> param3 = new HashMap<String, String>();
        param3.put("type", "activity");
        param3.put("subType", null);
        Bson q3 = MongoCrudService.buildBson(param3);
        this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(table).updateMany(q3, Updates.set((String)"subType", (Object)"activity"));
    }

    public Map<String, Object> copyActivity() {
        log.info("\u5f00\u59cb copy activity-----------------");
        HashMap<String, Object> result = new HashMap<String, Object>();
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("activityConfigsBasic");
        List activityConfigsBasic = this.mongoCrudService.query(req1);
        List codeSourceIdVersions = activityConfigsBasic.stream().map(document -> document.get((Object)"code") + "," + document.get((Object)"sourceId") + "," + document.get((Object)"version")).collect(Collectors.toList());
        result.put("mongo_count", codeSourceIdVersions.size());
        String cypher = "match(activity:Activity) where activity.version in ['1.0','2.0'] return activity ";
        List activityMaps = new Neo4jManager(this.driver).ExecuteQueryToMap(cypher, new HashMap());
        result.put("neo4j_count", activityMaps.size());
        ArrayList<Map> deduplicatedList = new ArrayList<Map>(activityMaps.stream().map(map -> ToolService.convertToNestedMap((Map)((Map)map.get("activity")))).collect(Collectors.toMap(map -> String.join((CharSequence)",", (String)map.get("code"), (String)map.get("sourceId"), (String)map.get("version")), map -> map, (existing, replacement) -> existing)).values());
        result.put("neo4j_deduplicated_count", deduplicatedList.size());
        AtomicInteger insertCount = new AtomicInteger();
        ApplicationMongoData insertReq1 = new ApplicationMongoData();
        insertReq1.setDb(Constant.db_kg_sys);
        insertReq1.setCol("activityConfigsBasic");
        List codeDependOnGroundEndList = this.mongoCrudService.find(Constant.db_kg_sys, "activityConfigs", (Bson)new Document(), (Bson)new Document("code", (Object)1).append("dependOnGroundEnd", (Object)1).append("authorityPrefix", (Object)1).append("_id", (Object)0), Map.class);
        Map<String, List> codeDependOnGroundEndMap = codeDependOnGroundEndList.stream().filter(map -> map.get("code") != null).collect(Collectors.groupingBy(map -> (String)map.get("code"), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().map(m -> (Boolean)m.get("dependOnGroundEnd")).filter(Objects::nonNull).collect(Collectors.toList()))));
        Map<String, List> authorityPrefixMap = codeDependOnGroundEndList.stream().filter(map -> map.get("code") != null).collect(Collectors.groupingBy(map -> (String)map.get("code"), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().map(m -> (String)m.get("authorityPrefix")).filter(Objects::nonNull).collect(Collectors.toList()))));
        deduplicatedList.forEach(map -> {
            String codeSourceIdVersion = String.join((CharSequence)",", (String)map.get("code"), (String)map.get("sourceId"), (String)map.get("version"));
            if (!codeSourceIdVersions.contains(codeSourceIdVersion)) {
                if (codeDependOnGroundEndMap.containsKey((String)map.get("code")) && !CollectionUtils.isEmpty((Collection)((Collection)codeDependOnGroundEndMap.get((String)map.get("code"))))) {
                    map.put("dependOnGroundEnd", ((List)codeDependOnGroundEndMap.get((String)map.get("code"))).get(0));
                }
                if (authorityPrefixMap.containsKey((String)map.get("code")) && !CollectionUtils.isEmpty((Collection)((Collection)authorityPrefixMap.get((String)map.get("code"))))) {
                    map.put("authorityPrefix", ((List)authorityPrefixMap.get((String)map.get("code"))).get(0));
                }
                insertReq1.getDocs().add(new Document(map));
                codeSourceIdVersions.add(codeSourceIdVersion);
                insertCount.getAndIncrement();
            }
        });
        this.insert(insertReq1);
        result.put("insertCount", insertCount);
        log.info("copy activity \u7ed3\u675f------------------");
        return result;
    }

    public List<Map<String, Object>> getActivity() {
        List codeDependOnGroundEndList = this.mongoCrudService.find(Constant.db_kg_sys, "activityConfigs", (Bson)new Document(), (Bson)new Document("code", (Object)1).append("dependOnGroundEnd", (Object)1).append("_id", (Object)0), Map.class);
        Map codeDependOnGroundEndMap = codeDependOnGroundEndList.stream().filter(map -> map.get("code") != null).collect(Collectors.groupingBy(map -> (String)map.get("code"), Collectors.mapping(map -> (Boolean)map.get("dependOnGroundEnd"), Collectors.toSet())));
        String cypher = "match(activity:Activity) where activity.version in ['1.0','2.0'] return activity ";
        List re = new Neo4jManager(this.driver).ExecuteQueryToMap(cypher, new HashMap());
        ArrayList<Map<String, Object>> deduplicatedList = new ArrayList<Map<String, Object>>(re.stream().map(map -> (Map)map.get("activity")).collect(Collectors.toMap(map -> String.join((CharSequence)",", (String)map.get("code"), (String)map.get("sourceId"), (String)map.get("version")), map -> map, (existing, replacement) -> existing)).values());
        return deduplicatedList;
    }

    public static void main(String[] args) {
        HashMap<String, String> flatMap = new HashMap<String, String>();
        flatMap.put("_id", "111");
        flatMap.put("code", "code");
        flatMap.put("lang.name.zh_CN", "api\u4f5c\u4e1a\u5458");
        flatMap.put("lang.name.zh_US", "api\u4f5c\u4e1a\u5458");
        flatMap.put("expectedDuration", "{'dueDateType':0,'type':'MINUTE','value':0}");
        Map nestedMap = ToolService.convertToNestedMap(flatMap);
        System.out.println(nestedMap);
    }

    public static Map<String, Object> convertToNestedMap(Map<String, Object> flatMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : flatMap.entrySet()) {
            String key = entry.getKey();
            if ("_id".equals(key)) continue;
            Object value = entry.getValue();
            if (key.contains(".")) {
                String[] keys = key.split("\\.");
                Map<String, Object> currentMap = result;
                for (int i = 0; i < keys.length - 1; ++i) {
                    currentMap.putIfAbsent(keys[i], new HashMap());
                    currentMap = (Map)currentMap.get(keys[i]);
                }
                currentMap.put(keys[keys.length - 1], value);
                continue;
            }
            if (ToolService.isJsonStyle((Object)value)) {
                Object jsonValue = ToolService.parseJsonStyleString((String)((String)value));
                result.put(key, jsonValue);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private static boolean isJsonStyle(Object value) {
        if (value instanceof String) {
            String valueString = (String)value;
            return valueString.startsWith("{") && valueString.endsWith("}") || valueString.startsWith("[") && valueString.endsWith("]");
        }
        return false;
    }

    private static Object parseJsonStyleString(String value) {
        String jsonCompatibleString = value.replace("'", "\"");
        try {
            if (value.startsWith("{") && value.endsWith("}")) {
                return new ObjectMapper().readValue(jsonCompatibleString, Map.class);
            }
            if (value.startsWith("[") && value.endsWith("]")) {
                return new ObjectMapper().readValue(jsonCompatibleString, List.class);
            }
            return new ObjectMapper().readValue(jsonCompatibleString, Object.class);
        }
        catch (JsonProcessingException e) {
            log.error("\u89e3\u6790JSON\u6837\u5f0f\u5b57\u7b26\u4e32\u5931\u8d25, value: {}", (Object)value, (Object)e);
            return value;
        }
    }
}

