/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.dmc.impl;

import cn.hutool.core.io.FileUtil;
import com.digiwin.athena.km_deployer_service.config.dmc.DMCConfig;
import com.digiwin.athena.km_deployer_service.domain.dmc.FileInfo;
import com.digiwin.athena.km_deployer_service.domain.dmc.MidWareResponse;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.CacheService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    private static final Logger log = LoggerFactory.getLogger(DmcServiceImpl.class);
    @Autowired
    @Qualifier(value="dmcRestTemplate")
    RestTemplate dmcRestTemplate;
    @Autowired
    private DMCConfig dmcConfig;
    @Autowired
    private CacheService cacheService;

    public String refreshToken() {
        String appToken = this.dmcConfig.getAppToken();
        String dmcUrl = this.dmcConfig.getUrl();
        String url = dmcUrl + "/api/dmc/v1/auth/login";
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.set("digi-middleware-auth-app", appToken);
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("username", this.dmcConfig.getUserName());
        reqMap.put("pwdhash", this.dmcConfig.getPassword());
        HttpEntity httpEntity = new HttpEntity(reqMap, (MultiValueMap)header);
        ResponseEntity resMap = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        System.out.println(resMap.getBody());
        String token = (String)((Map)resMap.getBody()).get("userToken");
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BusinessException("Failed to obtain token");
        }
        this.cacheService.set("dmcToken", (Object)token, 3600L);
        return token;
    }

    public String getToken() {
        String token = this.cacheService.get("dmcToken");
        if (null == token) {
            token = this.refreshToken();
        }
        return token;
    }

    public String upload(File file, String contentType, FileInfo fileInfo) {
        String appToken = this.dmcConfig.getAppToken();
        String dmcUrl = this.dmcConfig.getUrl();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        header.add("digi-middleware-auth-user", this.getToken());
        header.add("digi-middleware-auth-app", appToken);
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)contentType));
        fileHeader.setContentDispositionFormData("file", file.getName());
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        try {
            HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(FileUtil.readBytes((File)file)), (MultiValueMap)fileHeader);
            HttpEntity fileInfoEntity = new HttpEntity((Object)fileInfo, (MultiValueMap)fileInfoHeader);
            multiValueMap.add((Object)"file", (Object)fileEntity);
            multiValueMap.add((Object)"fileInfo", (Object)fileInfoEntity);
            String url = dmcUrl + "/api/dmc/v2/file/Athena/upload";
            HttpEntity httpEntity = new HttpEntity((Object)multiValueMap, (MultiValueMap)header);
            ResponseEntity postForEntity = this.dmcRestTemplate.postForEntity(url, (Object)httpEntity, MidWareResponse.class, new Object[0]);
            MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
            if (midWareResponse.getSuccess().booleanValue()) {
                return (String)((Map)midWareResponse.getData()).get("id");
            }
            log.error("\u8c03\u7528\u4e0a\u4f20api\u5931\u8d25");
            throw new BusinessException("Failed to call the upload API");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new BusinessException("", (Throwable)e);
        }
    }

    public InputStream download(String fileId) {
        String token = this.getToken();
        String dmcUrl = this.dmcConfig.getUrl();
        String appToken = this.dmcConfig.getAppToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", appToken);
        String url = dmcUrl + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/download/" + fileId;
        ResponseEntity restRes = this.dmcRestTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }

    public InputStream downloadByUrl(String shareUrl) {
        HttpHeaders headers = new HttpHeaders();
        ResponseEntity restRes = this.dmcRestTemplate.exchange(shareUrl, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), byte[].class, new Object[0]);
        return new ByteArrayInputStream((byte[])restRes.getBody());
    }
}

