/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km;

import com.alibaba.fastjson.JSON;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CacheService {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    public void set(String key, String value, Long exp) {
        String ckey = "km:deploy:" + key;
        this.stringRedisTemplate.opsForValue().set((Object)ckey, (Object)value);
        this.stringRedisTemplate.expire((Object)ckey, exp.longValue(), TimeUnit.SECONDS);
    }

    public String get(String key) {
        String ckey = "km:deploy:" + key;
        return (String)this.stringRedisTemplate.opsForValue().get((Object)ckey);
    }

    public String toJson(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean || object instanceof String) {
            return String.valueOf(object);
        }
        return JSON.toJSONString((Object)object);
    }

    public <T> T get(String partition, String key, Class<T> clazz) {
        key = partition + ":" + key;
        return (T)this.get(key, clazz);
    }

    public <T> T get(String key, Class<T> clazz) {
        Object obj = this.stringRedisTemplate.opsForValue().get((Object)key);
        return (T)(obj == null ? null : this.fromJson(String.valueOf(obj), clazz));
    }

    public void set(String partition, String key, Object value) {
        key = partition + ":" + key;
        this.set(key, value, 0L);
    }

    public void set(String key, Object value, long expire) {
        if (expire > 0L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)this.toJson(value), expire);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)this.toJson(value));
        }
    }

    public void delete(String partition, String key) {
        key = partition + ":" + key;
        this.delete(key);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    private <T> T fromJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }
}

