/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.handler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.km.EventCacheEntity;
import com.digiwin.athena.km_deployer_service.domain.km.KmEventParam;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.KmPublishRepo;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.service.km.handler.AbstractKmDeployEventHandler;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class MonitorRuleKmDeployEventHandler
extends AbstractKmDeployEventHandler {
    private static final Logger log = LoggerFactory.getLogger(MonitorRuleKmDeployEventHandler.class);
    private static final String DEFAULT_VERSION = "1.0";
    @Resource
    private MongoCrudService mongoCrudService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private Neo4jCrudService neo4jCrudService;
    @Value(value="${module.km.domain}/restful/service/knowledgegraph/")
    private String knowledgeGraphUrl;
    @Resource
    KmPublishRepo kmPublishRepo;
    private static final List<String> EXCLUDE_FIELDS = Arrays.asList("_id", "id", "version", "compileVersion", "oldNodeId", "publishTime");

    public String handlerComponentType() {
        return "monitorRule";
    }

    public void handleBeforePublish(KmEventParam param) {
        Map monitorRulesHashData = this.getMonitorRulesHashData(param, null, null, null);
        ArrayList<EventCacheEntity> monitorChangeCacheEntities = new ArrayList<EventCacheEntity>();
        for (Map.Entry entry : monitorRulesHashData.entrySet()) {
            EventCacheEntity monitorChangeCacheEntity = new EventCacheEntity().setEventId(param.getEventId()).setObjectCode((String)entry.getKey()).setObjectType("monitorRule").setHash((Integer)entry.getValue());
            monitorChangeCacheEntities.add(monitorChangeCacheEntity);
        }
        ApplicationMongoData insertRequest = new ApplicationMongoData();
        insertRequest.setDb(Constant.db_kg_sys);
        insertRequest.setCol("kmEventDeployCache");
        List documents = monitorChangeCacheEntities.stream().map(e -> Document.parse((String)JSON.toJSONString((Object)e))).collect(Collectors.toList());
        insertRequest.setDocs(documents);
        this.mongoCrudService.insert(insertRequest);
    }

    public void handleAfterPublish(KmEventParam param) {
        this.compareAndPush(param, 1);
        this.updateEventStatus(param.getEventId(), 2);
    }

    public void handleBeforeSwitch(KmEventParam param) {
    }

    public void handleAfterSwitch(KmEventParam param) {
        this.compareAndPush(param, 2);
    }

    private void compareAndPush(KmEventParam param, int status) {
        ArrayList events = new ArrayList();
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"appId", (Object)param.getAppCode()), Filters.eq((String)"status", (Object)status)});
        Bson sort = Sorts.descending((String[])new String[]{"updateTime"});
        FindIterable docs = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(Constant.db_kg_sys).getCollection("kmDeployEvent").find(filter).sort(sort).limit(1);
        docs.forEach(events::add);
        if (CollectionUtil.isEmpty(events)) {
            log.warn("\u672a\u627e\u5230\u53d1\u7248\u4e8b\u4ef6");
            return;
        }
        String eventId = ((Document)events.get(0)).getString((Object)"eventId");
        param.setEventId(eventId);
        ArrayList spacialMonitorRuleCodes = new ArrayList();
        ArrayList directPushMonitorRuleCodes = new ArrayList();
        HashMap newMonitorRule = new HashMap();
        Map monitorRulesHashData = this.getMonitorRulesHashData(param, spacialMonitorRuleCodes, directPushMonitorRuleCodes, newMonitorRule);
        CrudReq req = new CrudReq();
        req.setDbName(Constant.db_kg_sys);
        req.setColName("kmEventDeployCache");
        req.setParams(new HashMap());
        req.getParams().put("eventId", eventId);
        req.getParams().put("objectType", "monitorRule");
        List monitorChangeCacheEntities = this.mongoCrudService.query(req);
        Set deletedMonitorRuleCodes = monitorChangeCacheEntities.stream().map(e -> MapUtil.getStr((Map)e, (Object)"objectCode")).filter(key -> !monitorRulesHashData.containsKey(key)).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(deletedMonitorRuleCodes)) {
            log.info("\u68c0\u6d4b\u5230\u88ab\u5220\u9664\u7684\u4fa6\u6d4bcode: {}", (Object)JSON.toJSONString(deletedMonitorRuleCodes));
            List ruleTenants = this.getTenantMonitorRules(deletedMonitorRuleCodes, Integer.valueOf(1));
            for (Document ruleTenant2 : ruleTenants) {
                JSONObject config = new JSONObject();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("eocCompanyId", (Object)"");
                config.fluentPut("tenantId", (Object)ruleTenant2.getString((Object)"tenantId")).fluentPut("monitorRuleId", (Object)ruleTenant2.getString((Object)"monitorRuleId")).fluentPut("eocMap", ruleTenant2.get((Object)"eocMap") == null ? jSONObject : ruleTenant2.get((Object)"eocMap"));
                this.deleteMonitorRules(config);
            }
        }
        Map<String, Map> monitorChangeCacheEntityMap = monitorChangeCacheEntities.stream().collect(Collectors.toMap(o -> MapUtil.getStr((Map)o, (Object)"objectCode"), o -> o));
        HashSet pushMonitorRuleCodes = new HashSet();
        HashSet newMonitorRuleCodes = new HashSet();
        for (Map.Entry entry : monitorRulesHashData.entrySet()) {
            Map monitorChangeCacheEntity = monitorChangeCacheEntityMap.get(entry.getKey());
            if (Objects.isNull(monitorChangeCacheEntity) && (spacialMonitorRuleCodes.contains(entry.getKey()) || directPushMonitorRuleCodes.contains(entry.getKey()))) {
                newMonitorRuleCodes.add(entry.getKey());
                continue;
            }
            if (directPushMonitorRuleCodes.contains(entry.getKey())) {
                pushMonitorRuleCodes.add(entry.getKey());
                continue;
            }
            if (((Integer)entry.getValue()).equals(MapUtil.getInt((Map)monitorChangeCacheEntity, (Object)"hash"))) continue;
            pushMonitorRuleCodes.add(entry.getKey());
        }
        if (CollectionUtil.isNotEmpty(newMonitorRuleCodes)) {
            log.info("\u68c0\u6d4b\u5230\u65b0\u589e\u7684\u4fa6\u6d4bcode: {}", (Object)JSON.toJSONString(newMonitorRuleCodes));
            Set useAppTenants = this.kmPublishRepo.findUseAppTenantsWithOutVersion(param.getAppCode());
            if (CollectionUtil.isNotEmpty((Collection)useAppTenants)) {
                List list = this.getTenantMonitorRules(newMonitorRuleCodes, null);
                ArrayList<Document> documents = new ArrayList<Document>();
                for (String tenantId : useAppTenants) {
                    for (String code : newMonitorRuleCodes) {
                        boolean b = list.stream().anyMatch(ruleTenant -> ruleTenant.getString((Object)"monitorRuleId").equals(code) && ruleTenant.getString((Object)"tenantId").equals(tenantId));
                        if (b) continue;
                        Map ruleData = (Map)newMonitorRule.get(code);
                        Document d = new Document();
                        d.put("monitorRuleId", (Object)code);
                        d.put("tenantId", (Object)tenantId);
                        d.put("status", (Object)1);
                        d.put("productName", (Object)(ruleData.containsKey("productName") ? MapUtil.getStr((Map)ruleData, (Object)"productName") : param.getAppCode()));
                        d.put("configId", (Object)RandomUtil.randomStringUpper((int)33));
                        if (ruleData.containsKey("standardPollingRule")) {
                            d.put("standardPollingRule", JSONObject.parse((String)MapUtil.getStr((Map)ruleData, (Object)"standardPollingRule")));
                        }
                        if (ruleData.containsKey("standardPollingRules")) {
                            d.put("standardPollingRules", JSONArray.parse((String)MapUtil.getStr((Map)ruleData, (Object)"standardPollingRule")));
                        }
                        if (ruleData.containsKey("eocMap")) {
                            d.put("eocMap", ruleData.get("eocMap"));
                        }
                        documents.add(d);
                    }
                }
                for (Document document : documents) {
                    this.startMonitorRules(document);
                }
            }
        }
        log.info("\u68c0\u6d4b\u5230\u53d1\u751f\u53d8\u52a8\u7684\u4fa6\u6d4bcode: {}", (Object)JSON.toJSONString(pushMonitorRuleCodes));
        this.pushModifyEvent(pushMonitorRuleCodes, param.getVersion());
    }

    private List<Document> getTenantMonitorRules(Set<String> monitorRulesCodes, Integer status) {
        CrudReq ruleTenantQuery = new CrudReq();
        ruleTenantQuery.setDbName(Constant.db_kg);
        ruleTenantQuery.setColName("monitorRuleTenantConfig");
        ruleTenantQuery.setParams(new HashMap());
        ruleTenantQuery.getParams().put("monitorRuleId", new ArrayList<String>(monitorRulesCodes));
        if (status != null) {
            ruleTenantQuery.getParams().put("status", status);
        }
        return this.mongoCrudService.query(ruleTenantQuery);
    }

    private void startMonitorRules(Document document) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("config", (Object)document);
        this.requestKg("MonitorRuleConfig", paramJson, Method.PUT);
    }

    private void pushModifyEvent(Set<String> pushMonitorRuleCodes, String version) {
        if (CollectionUtil.isEmpty(pushMonitorRuleCodes)) {
            return;
        }
        JSONObject noticeInfo = new JSONObject();
        noticeInfo.fluentPut("ruleIds", pushMonitorRuleCodes).fluentPut("version", (Object)version).fluentPut("limitedTenantIdList", Collections.emptyList()).fluentPut("excludedTenantIdList", Collections.emptyList()).fluentPut("productChangeInfo", Collections.emptyMap());
        JSONObject paramJson = new JSONObject();
        paramJson.put("noticeInfo", (Object)noticeInfo);
        this.requestKg("MonitorRuleConfig/noticeWhenMonitorRuleConfigChange", paramJson, Method.POST);
    }

    private void deleteMonitorRules(JSONObject paramJson) {
        JSONObject param = new JSONObject();
        param.put("config", (Object)paramJson);
        this.requestKg("MonitorRuleConfig", param, Method.DELETE);
    }

    private void updateEventStatus(String eventId, int status) {
        CrudReq crudReq = new CrudReq();
        crudReq.setDbName(Constant.db_kg_sys);
        crudReq.setColName("kmDeployEvent");
        crudReq.setParams(new HashMap());
        crudReq.getParams().put("eventId", eventId);
        crudReq.setData(new HashMap());
        crudReq.getData().put("status", status);
        crudReq.getData().put("updateTime", System.currentTimeMillis());
        this.mongoCrudService.update(crudReq);
    }

    private Map<String, Integer> getMonitorRulesHashData(KmEventParam param, List<String> spacialMonitorRuleCodes, List<String> directPushMonitorRuleCodes, Map<String, Map<String, Object>> newMonitorRule) {
        CrudReq req = new CrudReq();
        req.setDbName(Constant.db_kg_sys);
        req.setColName("applicationRelation");
        req.setParams(new HashMap());
        req.getParams().put("version", DEFAULT_VERSION);
        req.getParams().put("appCode", param.getAppCode());
        req.getParams().put("type", "monitorRule");
        List applicationRelations = this.mongoCrudService.query(req);
        if (CollectionUtil.isEmpty((Collection)applicationRelations)) {
            return Collections.emptyMap();
        }
        List monitorCodes = applicationRelations.stream().map(e -> MapUtil.getStr((Map)e, (Object)"code")).collect(Collectors.toList());
        CrudReq monitorRuleProductConfigReq = new CrudReq();
        monitorRuleProductConfigReq.setDbName(Constant.db_kg_sys);
        monitorRuleProductConfigReq.setColName("monitorRuleProductConfig");
        monitorRuleProductConfigReq.setParams(new HashMap());
        monitorRuleProductConfigReq.getParams().put("version", DEFAULT_VERSION);
        monitorRuleProductConfigReq.getParams().put("application", param.getAppCode());
        monitorRuleProductConfigReq.getParams().put("monitorRuleId", monitorCodes);
        List monitorRuleProductConfigs = this.mongoCrudService.query(monitorRuleProductConfigReq);
        HashMap monitorRuleProductConfigMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)monitorRuleProductConfigs)) {
            Map<Object, String> mergedMap = monitorRuleProductConfigs.stream().collect(Collectors.groupingBy(rule -> MapUtil.getStr((Map)rule, (Object)"monitorRuleId"), Collectors.mapping(rule -> MapUtil.getStr((Map)rule, (Object)"productName"), Collectors.joining(","))));
            HashMap resultMap = new HashMap();
            mergedMap.forEach((key, value) -> {
                Document originalRule = monitorRuleProductConfigs.stream().filter(rule -> rule.get((Object)"monitorRuleId").equals(key)).findFirst().orElse(null);
                if (originalRule != null) {
                    Object[] split = value.split(",");
                    Arrays.sort(split);
                    String mergedProductName = String.join((CharSequence)",", (CharSequence[])split);
                    originalRule.put("productName", (Object)mergedProductName);
                    resultMap.put((String)key, originalRule);
                }
            });
            monitorRuleProductConfigMap.putAll(resultMap);
        }
        HashMap<String, Object> monitorParam = new HashMap<String, Object>();
        monitorParam.put("athena_namespace", param.getAppCode());
        monitorParam.put("version", DEFAULT_VERSION);
        monitorParam.put("code", monitorCodes);
        List monitorRules = this.neo4jCrudService.query("MonitorRule", monitorParam);
        Map<Object, Object> monitorRuleMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)monitorRules)) {
            monitorRuleMap = monitorRules.stream().collect(Collectors.toMap(e -> MapUtil.getStr((Map)e, (Object)"code"), e -> e));
        }
        HashMap<String, Integer> minotorRuleHashMap = new HashMap<String, Integer>();
        for (String code : monitorCodes) {
            Map monitorRule;
            Hashtable map = new Hashtable();
            Document monitorRuleProductConfig = (Document)monitorRuleProductConfigMap.get(code);
            if (MapUtil.isNotEmpty((Map)monitorRuleProductConfig)) {
                map.putAll(monitorRuleProductConfig);
            }
            if (!Objects.isNull(monitorRule = (Map)monitorRuleMap.get(code))) {
                map.putAll(monitorRule);
            }
            if (!MapUtil.isNotEmpty(map)) continue;
            EXCLUDE_FIELDS.forEach(map::remove);
            int hash = HashUtil.apHash((String)JSON.toJSONString(map));
            minotorRuleHashMap.put(code, hash);
            if (spacialMonitorRuleCodes != null && "workflow".equals(MapUtil.getStr(map, (Object)"actionType"))) {
                spacialMonitorRuleCodes.add(code);
                newMonitorRule.put(code, map);
            }
            if (directPushMonitorRuleCodes != null && (map.get("inclusionTenant") != null || "individualCase".equals(MapUtil.getStr(map, (Object)"athena_publishType")))) {
                directPushMonitorRuleCodes.add(code);
            }
            log.info("{}\u4fa6\u6d4b\u6570\u636e\uff1a{}", (Object)code, (Object)JSON.toJSONString(map));
        }
        return minotorRuleHashMap;
    }

    public void requestKg(String serviceName, JSONObject paramJson, Method method) {
        String url = this.knowledgeGraphUrl + serviceName;
        try {
            String response = HttpUtil.createRequest((Method)method, (String)url).body(paramJson.toJSONString()).execute().body();
            log.info("\u8bf7\u6c42kg\u6210\u529f:{}", (Object)response);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42kg\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }
}

