/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Application2CommonRelation;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.domain.neo4j.FromNode;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Relation;
import com.digiwin.athena.km_deployer_service.domain.neo4j.ToNode;
import com.digiwin.athena.km_deployer_service.povo.ApiDataFieldMetadataDTO;
import com.digiwin.athena.km_deployer_service.povo.ApiDataMetadataDTO;
import com.digiwin.athena.km_deployer_service.povo.ApiMetadataDataDTO;
import com.digiwin.athena.km_deployer_service.povo.Application2CommonRelationParam;
import com.digiwin.athena.km_deployer_service.povo.UpdateVersionParam;
import com.digiwin.athena.km_deployer_service.service.km.CommonDataService;
import com.digiwin.athena.km_deployer_service.service.km.MdcService;
import com.digiwin.athena.km_deployer_service.util.MongoHelper;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class CommonDataServiceImpl
implements CommonDataService {
    private static final Logger log = LoggerFactory.getLogger(CommonDataServiceImpl.class);
    @Autowired
    private Driver driver1;
    @Autowired(required=false)
    @Qualifier(value="domain2Driver")
    private Driver driver2;
    @Autowired
    private MongoHelper mongoHelper;
    @Autowired
    private MdcService mdcService;

    public List<Relation> findApplication2CommonRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(commonNode) as commonNodeLabels,properties(commonNode) as commonNodeProperties";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        return this.getRelationInCqlResult(cql, param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    public List<Relation> findApp2OtherAppRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(otherAppNode{version:$otherAppVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and otherAppNode.nameSpace in $applicationList return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(otherAppNode) as commonNodeLabels,properties(otherAppNode) as commonNodeProperties";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("otherAppVersion", commonVersion);
        return this.getRelationInCqlResult(cql, param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    public static void main(String[] args) {
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(commonNode) as commonNodeLabels,properties(commonNode) as commonNodeProperties";
        String cql2 = "match (applicationNode{version:$applicationVersion})-[relation]->(otherAppNode{version:$otherAppVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and otherAppNode.nameSpace in $applicationList return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(otherAppNode) as commonNodeLabels,properties(otherAppNode) as commonNodeProperties";
        System.out.println(cql);
        System.out.println(cql2);
    }

    public List<Relation> findSpecialApp2OtherCommonAppRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        List commonAppCodeList = this.getCommonAppCode(Boolean.valueOf(true));
        String cql2 = "match (applicationNode{version:$applicationVersion})-[relation]->(otherAppNode{version:$otherAppVersion}) where (applicationNode.athena_namespace in $applicationList or applicationNode.nameSpace in $applicationList) and otherAppNode.nameSpace in $commonAppCodeList return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(otherAppNode) as commonNodeLabels,properties(otherAppNode) as commonNodeProperties";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("otherAppVersion", commonVersion);
        param.put("commonAppCodeList", commonAppCodeList);
        return this.getRelationInCqlResult(cql2, param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    private List<String> getCommonAppCode(Boolean addEspCommonOrNot) {
        String cql1 = "match (m:AppEntity{commonApp:true}) return m.code as code";
        List commonAppCodeRes = new Neo4jManager(this.driver1).ExecuteQuery(cql1, new HashMap());
        List<String> commonAppCodeList = commonAppCodeRes.stream().map(cac -> String.valueOf(cac.get("code"))).collect(Collectors.toList());
        if (addEspCommonOrNot.booleanValue()) {
            commonAppCodeList.add("espCommon");
        }
        return commonAppCodeList;
    }

    public List<Relation> findSpecialApplication2CommonRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (applicationNode.athena_namespace in $applicationList or applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(commonNode) as commonNodeLabels,properties(commonNode) as commonNodeProperties";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        return this.getRelationInCqlResult(cql, param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    private List<Relation> getRelationInCqlResult(String cql, Map<String, Object> param, JSONObject neo4jNodeKeyJson, String applicationVersion, String commonVersion) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        List queryResult = new Neo4jManager(this.driver1).ExecuteQuery(cql, param);
        List application2CommonRelationList = queryResult.stream().map(map -> (Application2CommonRelation)JSON.parseObject((String)JSON.toJSONString((Object)map), Application2CommonRelation.class)).collect(Collectors.toList());
        for (Application2CommonRelation application2CommonRelation : application2CommonRelationList) {
            List applicationNodeLabels = application2CommonRelation.getApplicationNodeLabels();
            JSONObject applicationNodeProperties = application2CommonRelation.getApplicationNodeProperties();
            String relationType = application2CommonRelation.getRelationType();
            List commonNodeLabels = application2CommonRelation.getCommonNodeLabels();
            JSONObject commonNodeProperties = application2CommonRelation.getCommonNodeProperties();
            FromNode fromNode = new FromNode();
            String applicationNodeLabel = (String)applicationNodeLabels.get(0);
            fromNode.setLabel(applicationNodeLabel).setPrimaryKey(applicationNodeProperties.get((Object)neo4jNodeKeyJson.getString(applicationNodeLabel))).setApplication(applicationNodeProperties.getString("athena_namespace")).setVersion(applicationVersion);
            ToNode toNode = new ToNode();
            String commonNodeLabel = (String)commonNodeLabels.get(0);
            toNode.setType(relationType).setLabel(commonNodeLabel).setApplication(commonNodeProperties.getString("athena_namespace")).setPrimaryKey(commonNodeProperties.get((Object)neo4jNodeKeyJson.getString(commonNodeLabel))).setVersion(commonVersion);
            Relation relation = new Relation().setFromNode(fromNode).setToNode(toNode);
            relations.add(relation);
        }
        return relations;
    }

    public void updateVersion(UpdateVersionParam updateVersionParam) {
        List cqlList = this.getUpdateCommonDataVersionCql(updateVersionParam);
        Neo4jMultipleUtil.executeCqlTrans((List)cqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public List<Cql> getUpdateVersionCqlList(UpdateVersionParam updateVersionParam) {
        List cqlList = this.getUpdateCommonDataVersionCql(updateVersionParam);
        return cqlList;
    }

    private List<Cql> getUpdateCommonDataVersionCql(UpdateVersionParam updateVersionParam) {
        String oldVersion = updateVersionParam.getOldVersion();
        String newVersion = updateVersionParam.getNewVersion();
        List applicationList = updateVersionParam.getApplicationList();
        List publishDbMongoData = updateVersionParam.getPublishDbMongoData();
        List upperCaseApplicationList = applicationList.stream().map(application -> application.toUpperCase()).collect(Collectors.toList());
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)oldVersion), Filters.in((String)"application", upperCaseApplicationList)});
        Bson deleteFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"version", (Object)newVersion), Filters.in((String)"application", upperCaseApplicationList)});
        Document update = new Document("$set", (Object)new Document().append("version", (Object)newVersion));
        this.mongoHelper.deleteAndUpdate(publishDbMongoData, filter, deleteFilter, (Bson)update);
        ArrayList<Cql> cqlList = new ArrayList<Cql>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("oldVersion", oldVersion);
        param.put("newVersion", newVersion);
        param.put("applicationList", applicationList);
        Cql updateCql = new Cql();
        updateCql.setCql("match (node) where node.version = $oldVersion and node.nameSpace in $applicationList set node.version=$newVersion");
        updateCql.setParams(param);
        Cql deleteCql = new Cql();
        deleteCql.setCql("match (node) where node.version = $newVersion and node.nameSpace in $applicationList detach delete node");
        deleteCql.setParams(param);
        cqlList.add(deleteCql);
        cqlList.add(updateCql);
        return cqlList;
    }

    public void deleteApplication2CommonRelations(Application2CommonRelationParam application2CommonRelationParam) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        List applicationList = application2CommonRelationParam.getApplicationList();
        String applicationVersion = application2CommonRelationParam.getApplicationVersion();
        String commonVersion = application2CommonRelationParam.getCommonVersion();
        List tenantIdList = application2CommonRelationParam.getTenantIdList();
        String cql1 = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] delete relation";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        param.put("tenantIdList", tenantIdList);
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void deleteSpecialApplication2CommonRelations(Application2CommonRelationParam application2CommonRelationParam) {
        ArrayList<Cql> executeCqlList = new ArrayList<Cql>();
        List applicationList = application2CommonRelationParam.getApplicationList();
        String applicationVersion = application2CommonRelationParam.getApplicationVersion();
        String commonVersion = application2CommonRelationParam.getCommonVersion();
        List tenantIdList = application2CommonRelationParam.getTenantIdList();
        String cql1 = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (applicationNode.athena_namespace in $applicationList or applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] delete relation";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        param.put("tenantIdList", tenantIdList);
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(executeCqlList, (Driver[])new Driver[]{this.driver1, this.driver2});
    }

    public void syncEspMetaData(String deployVersion) {
        List espApiList = this.mdcService.getEspApiList();
        espApiList.forEach(espApi -> {
            StringBuffer stringBuffer;
            ApiMetadataDataDTO espApiMetadata;
            String apiName = espApi.getName();
            String espApiLastUpdateTime = espApi.getLast_update_time();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("deployVersion", deployVersion);
            param.put("apiName", apiName);
            List queryResult = new Neo4jManager(this.driver1).ExecuteQuery("match (action:EspAction{version:$deployVersion}) where action.tenantId is null and action.serviceName=$apiName return action.request_parameters as request_parameters,action.response_object as response_object,action.lastUpdateTime as lastUpdateTime", param);
            if (!ObjectUtils.isEmpty((Object)queryResult)) {
                Object lastUpdateTime = ((Map)queryResult.get(0)).get("lastUpdateTime");
                if (espApi.getLast_update_time().equals(lastUpdateTime)) {
                    return;
                }
            }
            if ((espApiMetadata = this.mdcService.getEspApiMetadata(apiName)) == null) {
                return;
            }
            String apiVersion = espApiMetadata.getApi_version();
            String remark_cn = espApiMetadata.getRemark().getZh_CN();
            String remark_tw = espApiMetadata.getRemark().getZh_TW();
            String desc_cn = espApiMetadata.getDescription().getZh_CN();
            String desc_tw = espApiMetadata.getDescription().getZh_TW();
            String url = espApiMetadata.getUrl() == null ? "" : espApiMetadata.getUrl();
            String invokeType = espApiMetadata.getType();
            boolean idempotency = espApiMetadata.getIdempotency();
            String actionId = "esp_" + apiName;
            ApiDataMetadataDTO dataMetadata = espApiMetadata.getData_metadata();
            List fieldsOfParameter = new ArrayList();
            if (dataMetadata.getRequest().getBody().getField() != null && ((ApiDataFieldMetadataDTO)dataMetadata.getRequest().getBody().getField().get(0)).getField() != null) {
                fieldsOfParameter = ((ApiDataFieldMetadataDTO)dataMetadata.getRequest().getBody().getField().get(0)).getField();
            }
            ArrayList<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<ApiDataFieldMetadataDTO>();
            for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
                if (fieldOfParameter.getData_name().equals("enterprise_no") || fieldOfParameter.getData_name().equals("site_no") || fieldOfParameter.getData_name().equals("call_id")) continue;
                fieldRequestObjects.add(fieldOfParameter);
            }
            if (!ObjectUtils.isEmpty((Object)queryResult)) {
                List request_parameters = JSONArray.parseArray((String)String.valueOf(((Map)queryResult.get(0)).get("request_parameters")), ApiDataFieldMetadataDTO.class);
                this.putEnumKey(fieldRequestObjects, request_parameters);
            }
            String request_str = JSON.toJSONString(fieldRequestObjects, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
            List fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
            ApiDataFieldMetadataDTO fieldReponseObject = null;
            for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
                if (!fieldOfResponse.getData_name().equals("parameter")) continue;
                fieldReponseObject = fieldOfResponse;
                break;
            }
            String response_str = "";
            if (fieldReponseObject != null && fieldReponseObject.getField().size() > 0) {
                Optional<ApiDataFieldMetadataDTO> findObject = fieldReponseObject.getField().stream().filter(field -> "object".equals(field.getData_type())).findFirst();
                if (findObject.isPresent()) {
                    ApiDataFieldMetadataDTO response_object;
                    ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = findObject.get();
                    if (!ObjectUtils.isEmpty((Object)queryResult) && (response_object = (ApiDataFieldMetadataDTO)JSONObject.parseObject((String)String.valueOf(((Map)queryResult.get(0)).get("response_object")), ApiDataFieldMetadataDTO.class)) != null) {
                        this.putEnumKey(apiDataFieldMetadataDTO, response_object);
                    }
                    response_str = JSON.toJSONString((Object)apiDataFieldMetadataDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                } else {
                    response_str = JSON.toJSONString(fieldReponseObject.getField().get(0), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                }
            }
            if (ObjectUtils.isEmpty((Object)queryResult)) {
                log.info("\u521b\u5efa\uff1a{}", (Object)actionId);
                stringBuffer = new StringBuffer();
                stringBuffer.append("Create (action:Action:EspAction {");
                stringBuffer.append("actionId:'");
                stringBuffer.append(actionId);
                stringBuffer.append("', url:'");
                stringBuffer.append(url);
                stringBuffer.append("', serviceName:'");
                stringBuffer.append(apiName);
                stringBuffer.append("', serviceVersion:'");
                stringBuffer.append(apiVersion);
                stringBuffer.append("', actionName:'");
                stringBuffer.append(desc_cn);
                stringBuffer.append("', actionName_tw:'");
                stringBuffer.append(desc_tw);
                stringBuffer.append("', desc:'");
                stringBuffer.append(remark_cn);
                stringBuffer.append("', desc_tw:'");
                stringBuffer.append(remark_tw);
                stringBuffer.append("', request_parameters:'");
                stringBuffer.append(request_str);
                stringBuffer.append("', response_object:'");
                stringBuffer.append(response_str);
                stringBuffer.append("', invokeType:'");
                stringBuffer.append(invokeType);
                stringBuffer.append("', lastUpdateTime:'");
                stringBuffer.append(espApiLastUpdateTime);
                stringBuffer.append("', idempotency:");
                stringBuffer.append(idempotency);
                stringBuffer.append(", version:'");
                stringBuffer.append(deployVersion);
                stringBuffer.append("', nameSpace:'");
                stringBuffer.append("espCommon");
                stringBuffer.append("'})");
                Neo4jMultipleUtil.executeCql((String)StringEscapeUtils.escapeJava((String)stringBuffer.toString()), (Driver[])new Driver[]{this.driver1, this.driver2});
            } else {
                log.info("\u66f4\u65b0\uff1a{}", (Object)actionId);
                stringBuffer = new StringBuffer();
                stringBuffer.append("Match (action:Action:EspAction {");
                stringBuffer.append("actionId:'");
                stringBuffer.append(actionId);
                stringBuffer.append("'})  where action.tenantId is null set action.url='");
                stringBuffer.append(url);
                stringBuffer.append("', action.serviceName='");
                stringBuffer.append(apiName);
                stringBuffer.append("', action.serviceVersion='");
                stringBuffer.append(apiVersion);
                stringBuffer.append("', action.actionName='");
                stringBuffer.append(desc_cn);
                stringBuffer.append("', action.actionName_tw='");
                stringBuffer.append(desc_tw);
                stringBuffer.append("', action.desc='");
                stringBuffer.append(remark_cn);
                stringBuffer.append("', action.desc_tw='");
                stringBuffer.append(remark_tw);
                stringBuffer.append("', action.request_parameters='");
                stringBuffer.append(request_str);
                stringBuffer.append("', action.response_object='");
                stringBuffer.append(response_str);
                stringBuffer.append("', action.invokeType='");
                stringBuffer.append(invokeType);
                stringBuffer.append("', action.lastUpdateTime='");
                stringBuffer.append(espApiLastUpdateTime);
                stringBuffer.append("', action.idempotency=");
                stringBuffer.append(idempotency);
                stringBuffer.append(", action.version='");
                stringBuffer.append(deployVersion);
                stringBuffer.append("', action.nameSpace='");
                stringBuffer.append("espCommon");
                stringBuffer.append("'");
                Neo4jMultipleUtil.executeCql((String)StringEscapeUtils.escapeJava((String)stringBuffer.toString()), (Driver[])new Driver[]{this.driver1, this.driver2});
            }
        });
    }

    private void putEnumKey(ApiDataFieldMetadataDTO toApiDataFieldMeta, ApiDataFieldMetadataDTO fromApiDataFieldMeta) {
        if (toApiDataFieldMeta.getData_name().equals(fromApiDataFieldMeta.getData_name())) {
            if ("object".equals(toApiDataFieldMeta.getData_type()) && "object".equals(fromApiDataFieldMeta.getData_type())) {
                List toApiSubDataFieldMeta = toApiDataFieldMeta.getField();
                List fromApiSubDataFieldMeta = fromApiDataFieldMeta.getField();
                this.putEnumKey(toApiSubDataFieldMeta, fromApiSubDataFieldMeta);
            } else {
                toApiDataFieldMeta.setEnum_key(fromApiDataFieldMeta.getEnum_key());
            }
        }
    }

    private void putEnumKey(List<ApiDataFieldMetadataDTO> toApiDataFieldMetas, List<ApiDataFieldMetadataDTO> fromApiDataFieldMetas) {
        toApiDataFieldMetas.forEach(toApiDataFieldMetadata -> {
            Optional<ApiDataFieldMetadataDTO> fromApiDataFieldMeta = fromApiDataFieldMetas.stream().filter(fromApiDataFieldMetadata -> fromApiDataFieldMetadata.getData_name().equals(toApiDataFieldMetadata.getData_name())).findFirst();
            if (fromApiDataFieldMeta.isPresent()) {
                this.putEnumKey(toApiDataFieldMetadata, fromApiDataFieldMeta.get());
            }
        });
    }
}

