/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.km.CleanMongoParam;
import com.digiwin.athena.km_deployer_service.domain.km.CleanNeo4jParam;
import com.digiwin.athena.km_deployer_service.domain.km.KmDeployEvent;
import com.digiwin.athena.km_deployer_service.domain.km.KmDeployLog;
import com.digiwin.athena.km_deployer_service.domain.km.KmEventParam;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.KmPublishRepo;
import com.digiwin.athena.km_deployer_service.povo.Application2CommonRelationParam;
import com.digiwin.athena.km_deployer_service.povo.CreateApplicationRelationParam;
import com.digiwin.athena.km_deployer_service.povo.DeployRequest;
import com.digiwin.athena.km_deployer_service.povo.DeployResponse;
import com.digiwin.athena.km_deployer_service.povo.EspActionEnumkeyModule;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.ActionService;
import com.digiwin.athena.km_deployer_service.service.km.ApplicationService;
import com.digiwin.athena.km_deployer_service.service.km.CommonDataService;
import com.digiwin.athena.km_deployer_service.service.km.IPublishService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.service.km.handler.KmDeployEventHandler;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import com.digiwin.athena.km_deployer_service.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;

@Service
public class PublishServiceImpl
implements IPublishService {
    private static final Logger log = LoggerFactory.getLogger(PublishServiceImpl.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    Neo4jCrudService neo4jCrudService;
    @Autowired
    RedisLockRegistry redisLockRegistry;
    @Autowired
    DmcService dmcService;
    @Value(value="${compile.zipPath}")
    private String compileZipPath;
    @Value(value="${compile.dataPath}")
    private String compileDataPath;
    @Autowired
    KmPublishRepo kmPublishRepo;
    @Autowired
    HelpService helpService;
    @Autowired
    CommonDataService commonDataService;
    @Autowired
    ApplicationService applicationService;
    @Autowired
    ActionService actionService;
    @Autowired
    List<KmDeployEventHandler> eventHandlers;

    public void test01() {
        this.rebuildAppAndTenantRelation("tuo1", "1.0", Arrays.asList("tuo1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployResponse publishApplication(DeployRequest request) {
        DeployResponse response = new DeployResponse();
        System.out.println("\u5f00\u59cb\u53d1\u7248\uff1a" + request.getAppId());
        KmDeployEvent event = this.createEvent(request);
        response.setEventId(event.getId());
        DeployContext context = new DeployContext();
        context.setDeployId(event.getDeployId());
        context.setEventId(event.getEventId());
        context.setAppId(request.getAppId());
        HelpService.setDeployContext((DeployContext)context);
        try {
            EspActionEnumkeyModule module;
            ApplicationData appData = this.parseFile(request.getAppId(), request.getFileId());
            appData.setDeployId(event.getDeployId());
            this.mongoTemplate.save((Object)appData);
            this.publish(request, appData);
            if ("common".equals(request.getAppId()) && null != appData.getEnumKeyMappingModule() && null != (module = (EspActionEnumkeyModule)JSON.parseObject((String)appData.getEnumKeyMappingModule(), EspActionEnumkeyModule.class)) && null != module.getEnumKeyMapping()) {
                this.actionService.updateEspActionEnumKey(module.getEnumKeyMapping());
            }
            event.setStatus(Integer.valueOf(2));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.setCode(Integer.valueOf(-1));
            response.setMsg(e.getMessage());
            event.setStatus(Integer.valueOf(3));
            event.setMsg(e.getMessage());
        }
        finally {
            this.updateEvent(event);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployResponse switchApplication(DeployRequest request) {
        DeployResponse response = new DeployResponse();
        System.out.println("\u5f00\u59cb\u5207\u7248" + request.getAppId());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)request.getAppId()).and("status").is((Object)2));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"updateTime"}));
        KmDeployEvent event = (KmDeployEvent)this.mongoTemplate.findOne(query, KmDeployEvent.class);
        if (null == event) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("\u672a\u627e\u5230\u4e0a\u6b21\u53d1\u7248\u6210\u529f\u7684\u8bb0\u5f55\uff0c\u8bf7\u5148\u53d1\u7248\uff01");
            return response;
        }
        ApplicationData appData = (ApplicationData)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"deployId").is((Object)event.getDeployId())), ApplicationData.class);
        if (null == appData) {
            response.setCode(Integer.valueOf(-1));
            response.setMsg("\u672a\u627e\u5230\u4e0a\u6b21\u53d1\u7248\u6210\u529f\u7684\u5e94\u7528\uff0c\u8bf7\u5148\u53d1\u7248\uff01");
            return response;
        }
        if (null == request.getEventId()) {
            request.setEventId(HelpService.uuid());
        }
        DeployContext context = new DeployContext();
        context.setDeployId(event.getDeployId());
        context.setEventId(request.getEventId());
        context.setAppId(request.getAppId());
        HelpService.setDeployContext((DeployContext)context);
        event.setSwitchEventId(request.getEventId());
        event.setStatus(Integer.valueOf(4));
        this.updateEvent(event);
        try {
            this.publish(request, appData);
            if (Boolean.TRUE.equals(request.getUpdateEspVersion())) {
                this.actionService.incrementSwitchEspAction(request.getEventId());
            }
            event.setStatus(Integer.valueOf(5));
        }
        catch (Exception e) {
            event.setStatus(Integer.valueOf(6));
            event.setMsg(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.updateEvent(event);
        }
        return response;
    }

    public List<KmDeployLog> deployLogs(DeployRequest request) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"eventId").is((Object)request.getEventId()));
        if (null != request.getStartTime()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createTime").gt((Object)request.getStartTime()));
        }
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createTime"}));
        List logs = this.mongoTemplate.find(query, KmDeployLog.class);
        return logs;
    }

    public void handleEvent(KmEventParam param) {
        log.info("\u53d1\u5e03\u4e8b\u4ef6\u5f00\u59cb\uff0cparams\uff1a{}", (Object)param);
        Optional<KmDeployEventHandler> first = this.eventHandlers.stream().filter(handler -> handler.handlerComponentType().equals(param.getObjectType())).findFirst();
        if (!first.isPresent()) {
            return;
        }
        KmDeployEventHandler kmDeployEventHandler = first.get();
        if ("publish".equals(param.getType())) {
            if ("begin".equals(param.getTimeOn())) {
                KmDeployEvent event = this.createEvent(param);
                param.setEventId(event.getEventId());
                kmDeployEventHandler.handleBeforePublish(param);
            } else if ("end".equals(param.getTimeOn())) {
                kmDeployEventHandler.handleAfterPublish(param);
            }
        } else if ("switch".equals(param.getType())) {
            if ("begin".equals(param.getTimeOn())) {
                kmDeployEventHandler.handleBeforeSwitch(param);
            } else if ("end".equals(param.getTimeOn())) {
                kmDeployEventHandler.handleAfterSwitch(param);
            }
        }
    }

    public void publish(DeployRequest request, ApplicationData appData) {
        Application2CommonRelationParam findApplication2CommonParam;
        String appId = request.getAppId();
        String version = request.getVersion();
        List tenantIds = request.getTenantIds();
        List relations = new ArrayList();
        if ("common".equals(request.getAppId())) {
            if (null != request.getNeo4jNodeKeyJson()) {
                findApplication2CommonParam = new Application2CommonRelationParam().setTenantIdList(tenantIds).setApplicationList((List)ListUtil.toList((Object[])new String[]{"common", "espCommon"})).setNeo4jNodeKeyJson(request.getNeo4jNodeKeyJson()).setApplicationVersion(version).setCommonVersion(version);
                relations = this.commonDataService.findApplication2CommonRelations(findApplication2CommonParam);
            }
        } else {
            findApplication2CommonParam = new Application2CommonRelationParam().setTenantIdList(tenantIds).setApplicationList((List)ListUtil.toList((Object[])new String[]{appId})).setApplicationVersion(version).setCommonVersion(version);
            relations = this.commonDataService.findSpecialApp2OtherCommonAppRelations(findApplication2CommonParam);
        }
        this.checkAppAndTenant(request);
        this.helpService.logDetail("create", "\u5f00\u59cb\u6e05\u7406\u6570\u636e", 10);
        this.cleanAppData(appId, "3.0", appData);
        this.helpService.logDetail("create", "\u5f00\u59cb\u63d2\u5165\u6570\u636e", 12);
        this.processApplicationData(appData);
        Set useAppTenantIds = this.kmPublishRepo.findUseAppTenants(appId, version);
        ArrayList allTenants = new ArrayList();
        allTenants.addAll(useAppTenantIds);
        allTenants.addAll(tenantIds);
        this.helpService.logDetail("remove", "\u5f00\u59cb\u5220\u9664\u8001\u7248\u672c\u6570\u636e", 40);
        this.cleanAppData(appId, version, appData);
        this.helpService.logDetail("update", "\u5f00\u59cb\u66f4\u65b0\u53d1\u7248\u6570\u636e\u7248\u672c", 50);
        this.neo4jCrudService.updateVersion(appId, "3.0", version);
        for (ApplicationMongoData mongoDatum : appData.getMongoData()) {
            this.mongoCrudService.updateVersion(mongoDatum, appId, "3.0", version);
        }
        this.helpService.logDetail("link", "\u5f00\u59cb\u66f4\u65b0\u53d1\u7248\u6570\u636e\u7248\u672c", 60);
        this.createRelation(appId, version, allTenants);
        this.rebuildAppAndTenantRelation(request.getAppId(), request.getVersion(), allTenants);
        this.helpService.logDetail("update", "\u5f00\u59cb\u66f4\u65b0\u53d1\u7248\u6570\u636e\u7248\u672c", 90);
        this.neo4jCrudService.updateTenantVersion(tenantIds, version);
        if ("common".equals(request.getAppId()) && null != request.getNeo4jNodeKeyJson()) {
            CreateApplicationRelationParam createApplicationRelationParam = new CreateApplicationRelationParam().setRelationList(relations).setNeo4jNodeKeyJson(request.getNeo4jNodeKeyJson()).setCommonVersion(version).setApplicationVersion(version);
            this.applicationService.createApplication2CommonRelation(createApplicationRelationParam);
        }
        this.helpService.logDetail("end", "\u6570\u636e\u66f4\u65b0\u5b8c\u6210", 100);
    }

    @Deprecated
    public void createRelation(String appId, String version, List<String> tenantIds) {
        HashMap<String, List<String>> param1 = new HashMap<String, List<String>>();
        param1.put("tenantId", tenantIds);
        HashMap<String, String> param2 = new HashMap<String, String>();
        param2.put("athena_namespace", appId);
        param2.put("version", version);
        this.helpService.logDetail("link", "\u5f00\u59cb\u521b\u5efa\u5173\u8054\u5230Task", 60);
        this.neo4jCrudService.createRelation("TenantEntity", param1, "Task", param2, "TASK");
        this.helpService.logDetail("link", "\u5f00\u59cb\u521b\u5efa\u5173\u8054\u5230Activity", 65);
        this.neo4jCrudService.createRelation("TenantEntity", param1, "Activity", param2, "ACTIVITY");
        this.helpService.logDetail("link", "\u5f00\u59cb\u521b\u5efa\u5173\u8054\u5230Action", 70);
        this.neo4jCrudService.createRelation("TenantEntity", param1, "Action", param2, "ACTION");
        this.helpService.logDetail("link", "\u5f00\u59cb\u521b\u5efa\u5173\u8054\u5230MonitorRule", 75);
        this.neo4jCrudService.createRelation("TenantEntity", param1, "MonitorRule", param2, "USE");
    }

    private void checkAppAndTenant(DeployRequest request) {
        if (!"common".equals(request.getAppId())) {
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("code", request.getAppId());
            map3.put("version", request.getVersion());
            List app = this.neo4jCrudService.query("AppEntity", map3);
            if (app.isEmpty()) {
                this.helpService.logDetail("createApp", "\u6b63\u5728\u521b\u5efa\u5e94\u7528", 1);
                this.createApplication(request.getAppId(), request.getAppName(), request.getVersion());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)request.getTenantIds())) {
            this.helpService.logDetail("createTenant", "\u6b63\u5728\u521b\u5efa\u79df\u6237", 2);
            ArrayList oldTenantIds = new ArrayList();
            List tenants = this.neo4jCrudService.query("TenantEntity", (Map)MapUtil.of((Object)"tenantId", (Object)request.getTenantIds()));
            tenants.forEach(t -> {
                try {
                    String tenantId = (String)t.get("tenantId");
                    oldTenantIds.add(tenantId);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
            List newTenantIds = CollectionUtil.subtractToList((Collection)request.getTenantIds(), oldTenantIds);
            for (String newTenantId : newTenantIds) {
                this.createTenant(newTenantId, newTenantId, request.getVersion());
            }
        }
    }

    private void rebuildAppAndTenantRelation(String appId, String version, List<String> tenantIds) {
        if ("common".equals(appId)) {
            return;
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("appId", appId);
        map2.put("tenantIds", tenantIds);
        String cyhper = "match(a:TenantEntity)-[r:USE]->(b:AppEntity) where a.tenantId in $tenantIds and b.code=$appId  delete r";
        this.neo4jCrudService.executeCypher(cyhper, map2);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("code", appId);
        map3.put("version", version);
        this.neo4jCrudService.createRelation("TenantEntity", (Map)MapUtil.of((Object)"tenantId", tenantIds), "AppEntity", map3, "USE");
    }

    public void cleanAppData(String appId, String version, ApplicationData appData) {
        this.helpService.logDetail("remove", "\u5f00\u59cb\u5220\u9664\u8001\u7248\u672cneo4j", 40);
        CleanNeo4jParam cleanNeo4jParam = new CleanNeo4jParam();
        cleanNeo4jParam.setApplication(appId);
        cleanNeo4jParam.setDeployVersion(version);
        this.neo4jCrudService.cleanNeo4jData(cleanNeo4jParam);
        this.helpService.logDetail("remove", "\u5f00\u59cb\u5220\u9664\u8001\u7248\u672cmongo", 45);
        CleanMongoParam cleanMongoParam = new CleanMongoParam();
        cleanMongoParam.setApplication(appId);
        cleanMongoParam.setDeployVersion(version);
        HashMap collectionInfo = new HashMap();
        appData.getMongoData().forEach(mongodata -> {
            ArrayList<String> cols = (ArrayList<String>)collectionInfo.get(mongodata.getDb());
            if (null == cols) {
                cols = new ArrayList<String>();
                collectionInfo.put(mongodata.getDb(), cols);
            }
            cols.add(mongodata.getCol());
        });
        cleanMongoParam.setCollectionInfo(collectionInfo);
        this.mongoCrudService.cleanMongoData(cleanMongoParam);
    }

    private KmDeployEvent createEvent(DeployRequest request) {
        KmDeployEvent event = new KmDeployEvent();
        event.setEventId(request.getEventId());
        event.setAppId(request.getAppId());
        event.setStatus(Integer.valueOf(1));
        event.setCreateTime(new Date());
        event.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        event.setPercent(Integer.valueOf(0));
        event.setRequest(request);
        if (null == event.getDeployId()) {
            event.setDeployId(HelpService.uuid());
        }
        if (null == event.getEventId()) {
            event.setEventId(HelpService.uuid());
        }
        this.mongoTemplate.save((Object)event);
        return event;
    }

    private KmDeployEvent createEvent(KmEventParam param) {
        KmDeployEvent event = new KmDeployEvent();
        event.setDeployId(HelpService.uuid());
        if (null == param.getEventId()) {
            event.setEventId(HelpService.uuid());
        }
        event.setAppId(param.getAppCode());
        event.setStatus(Integer.valueOf(1));
        event.setCreateTime(new Date());
        event.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        event.setPercent(Integer.valueOf(0));
        ApplicationMongoData insertRequest = new ApplicationMongoData();
        insertRequest.setDb(Constant.db_kg_sys);
        insertRequest.setCol("kmDeployEvent");
        Document document = Document.parse((String)JSON.toJSONString((Object)event));
        insertRequest.setDocs(Collections.singletonList(document));
        this.mongoCrudService.insert(insertRequest);
        return event;
    }

    private void updateEvent(KmDeployEvent event) {
        event.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.mongoTemplate.save((Object)event);
    }

    public void createApplication(String appCode, String appName, String version) {
        String name = appName == null ? appCode : appName;
        String cql = "create(app:AppEntity{code:$code,athena_namespace:$code,name:$name,version:$version})";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", appCode);
        map.put("name", name);
        map.put("version", version);
        this.neo4jCrudService.executeCypher(cql, map);
    }

    public void createTenant(String tenantId, String tenantName, String version) {
        String name = tenantName == null ? tenantId : tenantName;
        String cql = "create(app:TenantEntity{tenantId:$tenantId,name:$name,version:$version})";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantId", tenantId);
        map.put("name", name);
        map.put("version", version);
        this.neo4jCrudService.executeCypher(cql, map);
    }

    public ApplicationData parseFile(String application, String fileId) throws IOException {
        this.helpService.logDetail("parseFile", "\u5f00\u59cb\u4e0b\u8f7d\u6587\u6863\u5185\u5bb9" + fileId, 5);
        ApplicationData data = new ApplicationData();
        String appDir = application;
        if (null == appDir) {
            appDir = Utils.uid();
        }
        String applicationCompileZipPath = this.compileZipPath + File.separator + appDir + File.separator;
        String applicationCompileDataPath = this.compileDataPath + File.separator + appDir + File.separator;
        String compileDataZipPath = applicationCompileZipPath + appDir + ".zip";
        InputStream inputStream = this.dmcService.download(fileId);
        FileUtil.writeFromStream((InputStream)inputStream, (String)compileDataZipPath);
        ZipUtil.unzip((String)compileDataZipPath, (String)applicationCompileDataPath);
        File compileDataDirector = new File(applicationCompileDataPath);
        File[] compileDataFiles = compileDataDirector.listFiles();
        if (null == compileDataFiles) {
            return data;
        }
        this.helpService.logDetail("parseFile", "\u5f00\u59cb\u89e3\u6790\u5185\u5bb9" + fileId, 8);
        for (File file : compileDataFiles) {
            File[] files;
            String filename = file.getName();
            if ("cypher".equals(filename)) {
                files = file.listFiles();
                if (files == null) continue;
                for (File file1 : files) {
                    if (!file1.getName().endsWith("json")) continue;
                    List lines = FileUtil.readLines((File)file1, (String)"UTF-8").stream().map(line -> line.replaceAll("\\{athena_version}", "3.0")).collect(Collectors.toList());
                    data.getCyphers().addAll(lines);
                }
                continue;
            }
            if ("designer".equals(filename)) {
                files = file.listFiles();
                if (files == null) continue;
                for (File file1 : files) {
                    String content;
                    File[] files2;
                    if (!"espActionEnumKey".equals(file1.getName()) || (files2 = file1.listFiles()) == null || files2.length == 0 || StringUtils.isEmpty((CharSequence)(content = FileUtil.readString((File)files2[0], (String)"UTF-8")))) continue;
                    data.setEnumKeyMappingModule(content);
                }
                continue;
            }
            if (this.isDb(filename)) {
                File[] dirs = file.listFiles();
                if (dirs == null) continue;
                for (File col : dirs) {
                    String colName = col.getName();
                    if (!this.isCol(col)) continue;
                    ApplicationMongoData mongoData = new ApplicationMongoData();
                    mongoData.setDb(filename);
                    mongoData.setCol(colName);
                    File[] files2 = col.listFiles();
                    if (files2 == null) continue;
                    for (File file1 : files2) {
                        if (!file1.getName().endsWith("json")) continue;
                        List lines = FileUtil.readLines((File)file1, (String)"UTF-8");
                        lines.forEach(line -> {
                            Document document = Document.parse((String)line);
                            document.remove((Object)"_id");
                            document.remove((Object)"isMigrate");
                            document.put("version", (Object)"3.0");
                            if (null != application) {
                                document.put("athena_namespace", (Object)application);
                                document.put("application", (Object)application);
                            }
                            mongoData.getDocs().add(document);
                        });
                    }
                    data.getMongoData().add(mongoData);
                }
                continue;
            }
            log.info("ignore file " + filename);
        }
        this.helpService.logDetail("parseFile", "\u5b8c\u6210\u89e3\u6790\u5185\u5bb9" + fileId, 10);
        return data;
    }

    public void processApplicationData(ApplicationData data) {
        this.helpService.logDetail("create", "\u5f00\u59cb\u6267\u884ccypher,\u6761\u6570" + data.getCyphers().size());
        this.neo4jCrudService.executeCyphers(data.getCyphers(), new HashMap());
        this.helpService.logDetail("create", "\u5f00\u59cb\u6267\u884cmongo\u6570\u636e\u63d2\u5165");
        for (ApplicationMongoData item : data.getMongoData()) {
            this.helpService.logDetail("create", "\u5f00\u59cb\u63d2\u5165\u8868 " + item.getDb() + "." + item.getCol());
            this.mongoCrudService.insert(item);
        }
    }

    private boolean isDb(String name) {
        List<String> dbs = Arrays.asList("knowledgegraphSystem", "datamap", "preset", "tagSystem");
        return dbs.contains(name);
    }

    private boolean isCol(File file) {
        return file.isDirectory();
    }
}

