/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.servermap;

import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class ServerMapInfoAppender {
    private final MongoCrudService mongoCrudService;
    private final Neo4jCrudService neo4jCrudService;

    public void addAppNameAndEspName(List<EspServiceMapDto> dto) {
        if (dto.isEmpty()) {
            return;
        }
        HashMap<String, String> appCodeToName = new HashMap<String, String>();
        HashMap<String, String> espToName = new HashMap<String, String>();
        for (EspServiceMapDto espServiceMapDto : dto) {
            if (!espServiceMapDto.getAppCode().isEmpty()) {
                appCodeToName.put(espServiceMapDto.getAppCode(), "");
            }
            espToName.put(espServiceMapDto.getEspServiceId(), "");
        }
        List documents = this.mongoCrudService.find("knowledgegraphSystem", "application", Filters.in((String)"code", appCodeToName.keySet()), Projections.include((String[])new String[]{"code", "name"}), Document.class);
        for (Document doc : documents) {
            appCodeToName.put(doc.getString((Object)"code"), doc.getString((Object)"name"));
        }
        for (EspServiceMapDto each : dto) {
            each.setAppName(appCodeToName.getOrDefault(each.getAppCode(), ""));
        }
        HashMap hashMap = new HashMap();
        hashMap.put("actionId", espToName.keySet());
        List actions = this.neo4jCrudService.query("Action", hashMap);
        for (Map action : actions) {
            espToName.put(action.get("actionId").toString(), action.getOrDefault("actionName", "").toString());
        }
        for (EspServiceMapDto each : dto) {
            each.setEspServiceName(espToName.getOrDefault(each.getEspServiceId(), ""));
        }
    }

    public ServerMapInfoAppender(MongoCrudService mongoCrudService, Neo4jCrudService neo4jCrudService) {
        this.mongoCrudService = mongoCrudService;
        this.neo4jCrudService = neo4jCrudService;
    }
}

