/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.service.km.servermap;

import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.service.km.servermap.EspExtractUtil;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapInfoAppender;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

public class ServerMapNeo4jAnalyzer
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(ServerMapNeo4jAnalyzer.class);
    private final String label;
    private final String name;
    private final Neo4jCrudService neo4jCrudService;
    private final MongoTemplate mongoTemplate;
    private final ServerMapInfoAppender serverMapInfoAppender;
    private final int neo4jBatchSize;
    private final int mongoBatchSize;
    private final List<EspServiceMapDto> toInsert = new ArrayList();
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Void call() {
        long start = System.currentTimeMillis();
        this.neo4jCrudService.processLargeQuery(this.label, Collections.emptyMap(), this.neo4jBatchSize, (arg_0, arg_1) -> this.processBatch(arg_0, arg_1));
        log.info("processLargeQuery from neo4j label: {} cost: {}", (Object)this.label, (Object)(System.currentTimeMillis() - start));
        return null;
    }

    private void processBatch(List<Map<String, Object>> batch, boolean isLastBatch) {
        for (Map<String, Object> map : batch) {
            String s = this.objectMapper.writeValueAsString(map);
            List espStrings = EspExtractUtil.extractEspStrings((String)s);
            for (String esp : espStrings) {
                EspServiceMapDto espServiceMapDto = new EspServiceMapDto();
                espServiceMapDto.setKey(UUID.randomUUID().toString());
                espServiceMapDto.setType(this.label);
                espServiceMapDto.setName(this.name);
                espServiceMapDto.setAppCode(map.getOrDefault("athena_namespace", "").toString());
                espServiceMapDto.setEspServiceId(esp);
                espServiceMapDto.setCreateTime(LocalDateTime.now());
                espServiceMapDto.setFlag(Integer.valueOf(0));
                this.toInsert.add(espServiceMapDto);
            }
        }
        if (this.toInsert.size() >= this.mongoBatchSize || isLastBatch) {
            this.serverMapInfoAppender.addAppNameAndEspName(this.toInsert);
            this.saveToMongo(this.toInsert);
            this.toInsert.clear();
        }
    }

    private void saveToMongo(List<EspServiceMapDto> dto) {
        if (dto.isEmpty()) {
            return;
        }
        this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, EspServiceMapDto.class).insert(dto).execute();
    }

    public ServerMapNeo4jAnalyzer(String label, String name, Neo4jCrudService neo4jCrudService, MongoTemplate mongoTemplate, ServerMapInfoAppender serverMapInfoAppender, int neo4jBatchSize, int mongoBatchSize) {
        this.label = label;
        this.name = name;
        this.neo4jCrudService = neo4jCrudService;
        this.mongoTemplate = mongoTemplate;
        this.serverMapInfoAppender = serverMapInfoAppender;
        this.neo4jBatchSize = neo4jBatchSize;
        this.mongoBatchSize = mongoBatchSize;
    }
}

